

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetClientListForMigrationAssistant.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetClientListForMigrationAssistant <<<'

IF EXISTS (select * from sysobjects where name='GetClientListForMigrationAssistant')
	drop procedure GetClientListForMigrationAssistant
IF EXISTS (select * from GxQscripts where name='GetClientListForMigrationAssistant')
	delete from GxQscripts where name = 'GetClientListForMigrationAssistant'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientListForMigrationAssistant')
	delete from GXDBVersions where aliasname = 'GetClientListForMigrationAssistant'
GO
print '... Creating Procedure: GetClientListForMigrationAssistant'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetClientListForMigrationAssistant
  @i_xmlText XML
AS
  DECLARE @o_ErrorCode integer=0
  DECLARE @o_ErrorString NVARCHAR(1024)
  DECLARE @o_xmlText XML
SET NOCOUNT OFF
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @i_userId 	INT
	DECLARE @selectedApptype TABLE( TYPE INT NOT NULL);
	SET     @o_ErrorCode  = 0
	SET     @o_xmlText    = '<App_GetClientListForMigrationAssistantResp />'
	SET     @i_userId   = ISNULL((SELECT ref.value('@userId','int')
									FROM @i_xmlText.nodes('App_GetClientListForMigrationAssistantReq/userEntity') R ( ref )), 0)
	IF @i_userId = 0
	BEGIN
		SET @o_ErrorCode   = 1
		SET @o_ErrorString = 'User ID not found'
		GOTO EXIT_PROC
	END
	INSERT INTO @selectedApptype
	SELECT type
	FROM APP_iDAType
	WHERE name LIKE 'Windows%% file system'
	SET @o_xmlText =
	(
		SELECT
		(
				SELECT DISTINCT C.id '@clientId', C.name '@clientName'
				FROM APP_Client C
				JOIN APP_Application A
				ON C.id = A.clientId
				JOIN APP_SubClientProp S
				ON A.id = S.componentNameId
				JOIN  @selectedApptype I
				ON I.type = A.appTypeId
				WHERE  C.id > 2 AND C.status & 0x1030 /*CV_STATUS_HIDDEN + CV_STATUS_DUMMY and CV_STATUS_PERSONAL_WKSTN*/ = 0x1000 AND (S.attrName = 'sys:last full jobId' OR s.attrName = 'sys:last full' )
				AND
				dbo.IsClientOwner(C.id,@i_userId) = 1
				FOR XML PATH('clientEntity'), TYPE
		 )
		 FOR XML PATH(''), ROOT('App_GetClientListForMigrationAssistantResp'), TYPE
	)
	EXIT_PROC:
    IF @o_ErrorCode > 0
    BEGIN
        SET @o_xmlText =
        (
            SELECT @o_ErrorCode '@errorCode',
                    @o_ErrorString '@errorMessage'
            FOR XML PATH ('error'), ROOT('App_GetClientListForMigrationAssistantResp')
        )
    END
    SELECT @o_xmlText
END
SET NOCOUNT ON
GO

IF EXISTS (select * from GxQscripts where name = 'GetClientListForMigrationAssistant')
	delete from GxQscripts where name = 'GetClientListForMigrationAssistant'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientListForMigrationAssistant')
	delete from GXDBVersions where aliasname = 'GetClientListForMigrationAssistant'
GO

insert into GXDBVersions values(2, 'GetClientListForMigrationAssistant',  '00000000000000000000', 'GetClientListForMigrationAssistant', '00000000000000000000')
GO

