

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetClientExtendedProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetClientExtendedProperties')
BEGIN
	print '>>> Drop Stored Procedure: GetClientExtendedProperties <<<'
	drop procedure GetClientExtendedProperties
END
IF EXISTS (select * from GxQscripts where name='GetClientExtendedProperties')
	delete from GxQscripts where name = 'GetClientExtendedProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientExtendedProperties')
	delete from GXDBVersions where aliasname = 'GetClientExtendedProperties'
GO
print '... Creating Procedure: GetClientExtendedProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetClientExtendedProperties
  @i_entity XML ,
  @o_header XML OUTPUT ,
  @o_data XML OUTPUT
AS
-- GEnerates in header file
  DECLARE @header XML
  DECLARE @data XML
BEGIN
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @clientId INT
	DECLARE @localeId INT
	SELECT
		@clientId = ISNULL(ref.value('@clientId', 'INT') , 0),
		@localeId = ISNULL(ref.value('../@localeId', 'INT'), 0)
	FROM @i_entity.nodes ('App_ExtendedSummaryReq/entity') R(ref)
	DECLARE @entityHeaderTable TABLE (
		value	NVARCHAR(256),
		type	NVARCHAR(32),
		name	NVARCHAR(256)
	)
	 INSERT @entityHeaderTable VALUES('//Client/@name','string', 'Name')
		 ,('//Client/@entityPropId','int', 'Id')
		 ,('//Client/@encryption','string',(SELECT CASE WHEN (@localeId > 0 AND 0 > 0) THEN dbo.fn_EvFormatEventMsgText(0,@localeId,0,0,0) ELSE 'Encryption' END))
		 ,('//Client/@storagepolicy','string',(SELECT CASE WHEN (@localeId > 0 AND 0 > 0) THEN dbo.fn_EvFormatEventMsgText(0,@localeId,0,0,0) ELSE 'Storage Policy' END))
		 ,('//Client/@onetouch','string',(SELECT CASE WHEN (@localeId > 0 AND 0 > 0) THEN dbo.fn_EvFormatEventMsgText(0,@localeId,0,0,0) ELSE 'OneTouch Enabled' END))
		 ,('//Client/@osstatus','string',(SELECT CASE WHEN (@localeId > 0 AND 0 > 0) THEN dbo.fn_EvFormatEventMsgText(0,@localeId,0,0,0) ELSE 'OS Status' END))
		 ,('//Client/@clientGroups','string',(SELECT CASE WHEN (@localeId > 0 AND 0 > 0) THEN dbo.fn_EvFormatEventMsgText(0,@localeId,0,0,0) ELSE 'ClientGroup Membership' END))
		 ,('//Client/@owners','string',(SELECT CASE WHEN (@localeId > 0 AND 0 > 0) THEN dbo.fn_EvFormatEventMsgText(0,@localeId,0,0,0) ELSE 'Client Owners' END))
		 ,('//Client/@agents','string',(SELECT CASE WHEN (@localeId > 0 AND 0 > 0) THEN dbo.fn_EvFormatEventMsgText(0,@localeId,0,0,0) ELSE 'Installed Agents' END))
		 ,('//Client/@snapenabled','string',(SELECT CASE WHEN (@localeId > 0 AND 0 > 0) THEN dbo.fn_EvFormatEventMsgText(0,@localeId,0,0,0) ELSE 'Snap Enabled' END))
		 ,('//Client/@daysOffline','integer',(SELECT CASE WHEN (@localeId > 0 AND 0 > 0) THEN dbo.fn_EvFormatEventMsgText(0,@localeId,0,0,0) ELSE 'Days offline' END))
		 ,('//Client/@daysSinceClientCreated','integer',(SELECT CASE WHEN (@localeId > 0 AND 0 > 0) THEN dbo.fn_EvFormatEventMsgText(0,@localeId,0,0,0) ELSE 'Days since client created' END))
		 ,('//Client/@daysSinceLastBkpClient','integer',(SELECT CASE WHEN (@localeId > 0 AND 0 > 0) THEN dbo.fn_EvFormatEventMsgText(0,@localeId,0,0,0) ELSE 'Days since last successfull backup for client' END))
		 ,('//Client/@ClientActsAsProxy','integer',(SELECT CASE WHEN (@localeId > 0 AND 0 > 0) THEN dbo.fn_EvFormatEventMsgText(0,@localeId,0,0,0) ELSE 'Client acts as network proxy' END))
		 ,('//Client/@backupEnabledForClient','integer',(SELECT CASE WHEN (@localeId > 0 AND 0 > 0) THEN dbo.fn_EvFormatEventMsgText(0,@localeId,0,0,0) ELSE 'Backup activity enabled' END))
		 ,('//Client/@restoreEnabledForClient','integer',(SELECT CASE WHEN (@localeId > 0 AND 0 > 0) THEN dbo.fn_EvFormatEventMsgText(0,@localeId,0,0,0) ELSE 'Restore activity enabled' END))
		 ,('//Client/@clientOnlineDays','integer',(SELECT CASE WHEN (@localeId > 0 AND 0 > 0) THEN dbo.fn_EvFormatEventMsgText(0,@localeId,0,0,0) ELSE 'Client online (days)' END))
		 ,('//Client/@clientOwnerIsInactiveADUser','integer',(SELECT CASE WHEN (@localeId > 0 AND 0 > 0) THEN dbo.fn_EvFormatEventMsgText(0,@localeId,0,0,0) ELSE 'Inactive AD user as client owner' END))
		 ,('//Client/@clientExcludedFromSLAReport','integer',(SELECT CASE WHEN (@localeId > 0 AND 0 > 0) THEN dbo.fn_EvFormatEventMsgText(0,@localeId,0,0,0) ELSE 'Client excluded from SLA report' END))
		 ,('//Client/@csHostname', 'string', 'Commserver Hostname')
		 ,('//Client/@displayname', 'string', 'Display name')
	SET @o_header = (
			SELECT [value] AS '@value',
				[type] AS '@type',
				[name] AS '@name'
			FROM @entityHeaderTable
			FOR XML PATH('query'),
				ROOT('header')
			)
	IF OBJECT_ID('tempdb.dbo.#entityValueTable') IS NOT null
		DROP TABLE #entityValueTable
	CREATE TABLE #entityValueTable  (
		name NVARCHAR(255),
		entityPropId INT PRIMARY KEY,
		ENCRYPTION NVARCHAR(6) NULL,
		storagepolicy NVARCHAR(max) NULL,
		onetouch NVARCHAR(6) NULL,
		osstatus NVARCHAR(100) NULL,
		clientGroups NVARCHAR(max) NULL,
		owners NVARCHAR(max) NULL,
		agents NVARCHAR(max) NULL,
		snapenabled NVARCHAR(6) NULL,
		daysOffline INT NULL,
		daysSinceClientCreated INT NULL,
		daysSinceLastBkpClient INT NULL,
		ClientActsAsProxy INT NULL,
		backupEnabledForClient INT NULL,
		restoreEnabledForClient INT NULL,
		clientOnlineDays INT NULL,
		clientOwnerIsInactiveADUser INT NULL,
		clientExcludedFromSLAReport INT NULL,
		csHostname NVARCHAR(255),
		displayname NVARCHAR(255)
	)
	DECLARE @Yes NVARCHAR(6) = 'Yes'
	DECLARE @No NVARCHAR(6) = 'No'
	DECLARE @now INT = dbo.getUnixTime(GETUTCDATE())
	IF OBJECT_ID('tempdb.dbo.#spList') IS NOT null
		DROP TABLE #spList
	CREATE TABLE #spList (
		clientId	INT,
		name		NVARCHAR(144),
		PRIMARY KEY (clientId, name)
	)
	--CREATE CLUSTERED INDEX spList_idx ON #spList (clientId)
	INSERT INTO #spList
		SELECT DISTINCT
			a.clientId,
			sp.name
		FROM archGroup sp
			INNER JOIN APP_Application a ON
				sp.id <> 1
				AND sp.id IN (a.dataArchGrpID, a.logArchGrpID)
	IF OBJECT_ID('tempdb.dbo.#userList') IS NOT null
		DROP TABLE #userList
	CREATE TABLE #userList (
		clientId	INT,
		login		NVARCHAR(255),
		PRIMARY KEY (clientId, login)
	)
	--CREATE CLUSTERED INDEX userList_idx ON #userList (clientId)
	INSERT INTO #userList
		SELECT --DISTINCT
			o.clientId,
			u.login
		FROM sec_getClientOwnersExpandUG o
			INNER JOIN UMUsers u ON
				u.id = o.userId
	-- decrease performance
	--IF OBJECT_ID('tempdb.dbo.#groupList') IS NOT null
	--	DROP TABLE #groupList
	--CREATE TABLE #groupList (
	--	clientId	INT,
	--	name		NVARCHAR(512),
	--	PRIMARY KEY (clientId, name)
	--)
	----CREATE CLUSTERED INDEX groupList_idx ON #groupList (clientId)
	--INSERT INTO #groupList
	--	SELECT --DISTINCT
	--		cga.clientId,
	--		cg.name
	--	FROM APP_ClientGroupAssoc cga
	--		INNER JOIN APP_ClientGroup cg ON
	--			cga.clientGroupId = cg.id
	-- decrease performance
	--IF OBJECT_ID('tempdb.dbo.#clientApps') IS NOT null
	--	DROP TABLE #clientApps
	--CREATE TABLE #clientApps (
	--	clientId		INT,
	--	display_name	VARCHAR(128),
	--	PRIMARY KEY (clientId, display_name)
	--)
	----CREATE CLUSTERED INDEX clientApps_idx ON #clientApps (clientId)
	--INSERT INTO #clientApps
	--	SELECT DISTINCT
	--		a.clientId,
	--		m.display_name
	--	FROM APP_Application a
	--		INNER JOIN simAppTypeLicTypeMap m ON
	--			m.appTypeId = a.appTypeId
	--	WHERE
	--		a.appTypeId < 1000
	;WITH
	clientApps AS (
		SELECT DISTINCT
			a.clientId,
			m.display_name
		FROM APP_Application a
			INNER JOIN simAppTypeLicTypeMap m ON
				m.appTypeId = a.appTypeId
		WHERE
			a.appTypeId < 1000
	),
	groupList AS (
		SELECT --DISTINCT
			cga.clientId,
			cg.name
		FROM APP_ClientGroupAssoc cga
			INNER JOIN APP_ClientGroup cg ON
				cga.clientGroupId = cg.id
	)--,
	--userList AS (
	--	SELECT --DISTINCT
	--		o.clientId,
	--		u.login
	--	FROM sec_getClientOwnersExpandUG o
	--		INNER JOIN UMUsers u ON
	--			u.id = o.userId
	--),
	--spList AS (
	--	SELECT DISTINCT
	--		a.clientId,
	--		sp.name
	--	FROM archGroup sp
	--		INNER JOIN APP_Application a ON
	--			sp.id <> 1
	--			AND sp.id IN (a.dataArchGrpID, a.logArchGrpID)
	--)
	INSERT INTO #entityValueTable(
		entityPropId,
		name,
		encryption,
		onetouch,
		osstatus,
		clientOnlineDays,
		daysOffline,
		daysSinceClientCreated,
		daysSinceLastBkpClient,
		snapenabled,
		ClientActsAsProxy,
		backupEnabledForClient,
		restoreEnabledForClient,
		clientOwnerIsInactiveADUser,
		clientExcludedFromSLAReport,
		agents,
		clientGroups,
		owners,
		storagepolicy,
		csHostname,
		displayname
	)
		SELECT DISTINCT
			c.id,
			c.name,
			CASE
				WHEN enc.id IS NOT NULL THEN @Yes
				ELSE @No
			END encryption,
			CASE
				WHEN oneTouch.clientId IS NOT NULL THEN @Yes		--CV_STATUS_SYSTEM_RECOVERY
				ELSE @No
			END onetouch,
			CASE
				WHEN bsetid.attrVal IS NULL OR nbsetid.attrVal IS NULL THEN ''
				WHEN bsetid.attrVal <> nbsetid.attrVal AND bsetid.attrVal <> '0' AND nbsetid.attrVal <> '0' THEN 'Upgraded, Needs reinstall.'
				ELSE ''
			END osstatus,
			CASE
				WHEN ctcOn.lastOnlineTime IS NULL THEN -1
				WHEN ctcOn.lastOnlineTime > 0 THEN ((@now - ctcOn.lastOnlineTime) / 86400)
				ELSE 0
			END clientOnlineDays,
			CASE
				WHEN ctcOff.lastOfflineTime IS NULL THEN -1
				WHEN ctcOff.lastOfflineTime > 0 THEN ((@now - ctcOff.lastOfflineTime) / 86400)
				ELSE 0
			END daysOffline,
			CASE
				WHEN c.refTime = 0 THEN ((@now - dbo.GetUnixTime((SELECT MIN(OpTime) FROM simInstalledPackagesHistory iph WHERE iph.ClientId = c.id))) / 86400)
				ELSE ((@now - c.refTime) / 86400)
			END daysSinceClientCreated,
			CASE
				WHEN dayBkup.servStartDate IS NULL OR dayBkup.servStartDate = 0 THEN 2147483647
				ELSE ((@now - dayBkup.servStartDate) / 86400)
			END daysSinceLastBkpClient,
			CASE
				WHEN snap.attrVal IS NOT NULL AND snap.attrVal = '1' THEN @Yes
				ELSE @No
			END snapenabled,
			CASE
				WHEN proxy.clientId IS NOT NULL THEN 1
				ELSE 0
			END ClientActsAsProxy,
			CASE
				WHEN bkupAct.clientId IS NOT NULL THEN 1
				ELSE 0
			END backupEnabledForClient,
			CASE
				WHEN rstAct.clientId IS NOT NULL THEN 1
				ELSE 0
			END restoreEnabledForClient,
			CASE
				WHEN inactiveADO.clientId IS NOT NULL THEN 0
				ELSE 1
			END clientOwnerIsInactiveADUser,
			CASE
				WHEN sla.id IS NOT NULL THEN 1
				ELSE 0
			END clientExcludedFromSLAReport,
			CASE
				WHEN applist.clientId IS NULL THEN ''
				ELSE applist.apps
			END agents,
			CASE
				WHEN grplist.clientId IS NULL THEN ''
				ELSE grplist.grps
			END clientGroups,
			CASE
				WHEN lgnlist.clientId IS NULL THEN ''
				ELSE lgnlist.lgns
			END owners,
			CASE
				WHEN splist.clientId IS NULL THEN ''
				ELSE splist.sps
			END storagepolicy,
			c.csHostName,
			c.displayName
		FROM APP_client c
			LEFT OUTER JOIN (
				SELECT DISTINCT
					a.clientId
				FROM APP_Application a
				WHERE
					(a.subclientStatus & 256) = 256
			) oneTouch ON
				oneTouch.clientId = c.id
			LEFT OUTER JOIN APP_ClientProp enc ON
				enc.componentNameId = c.id
				AND enc.modified = 0
				--AND enc.cs_attrName = CHECKSUM(N'Encrypt: encryption')
				AND enc.attrName = N'Encrypt: encryption'
			LEFT OUTER JOIN APP_ClientProp bsetid ON
				bsetid.componentNameId = c.id
				AND bsetid.modified = 0
				--AND bsetid.cs_attrName = CHECKSUM(N'Binary Set ID')
				AND bsetid.attrName = N'Binary Set ID'
			LEFT OUTER JOIN APP_ClientProp nbsetid ON
				nbsetid.componentNameId = c.id
				AND nbsetid.modified = 0
				--AND nbsetid.cs_attrName = CHECKSUM(N'New Binary Set ID')
				AND nbsetid.attrName = N'New Binary Set ID'
			LEFT OUTER JOIN (
				SELECT
					ctc.ToClientId clientId,
					MAX(ctc.lastOnlineTime) lastOnlineTime
				FROM CCRClientToClient ctc
				WHERE
					ctc.FromClientId = 2
					AND ctc.serviceType = 0
					AND ctc.lastOfflineTime < ctc.lastOnlineTime
				GROUP BY
					ctc.ToClientId
			) ctcOn ON
				ctcOn.clientId = c.id
			LEFT OUTER JOIN (
				SELECT
					ctc.ToClientId clientId,
					MAX(ctc.lastOfflineTime) lastOfflineTime
				FROM CCRClientToClient ctc
				WHERE
					ctc.FromClientId = 2
					AND ctc.serviceType = 0
					AND ctc.lastOfflineTime > ctc.lastOnlineTime
				GROUP BY
					ctc.ToClientId
			) ctcOff ON
				ctcOff.clientId = c.id
			LEFT OUTER JOIN (
				SELECT
					a.clientId,
					MAX(bs.servStartDate) servStartDate
				FROM APP_Application a
					INNER JOIN JMBkpStats bs ON
						bs.appId = a.id
						AND bs.status IN (1, 3)     -- JMSUCCESS, PARTIALSUCCESS
				GROUP BY a.clientId
			) dayBkup ON
				dayBkup.clientId = c.id
			LEFT OUTER JOIN APP_ClientProp snap ON
				snap.componentNameId = c.id
				AND snap.modified = 0
				--AND snap.cs_attrName = CHECKSUM(N'Snap Backups Enabled')
				AND snap.attrName = N'Snap Backups Enabled'
			LEFT OUTER JOIN (
				SELECT
					fo.clientId
				FROM APP_FirewallOptions fo
				WHERE
					fo.isDMZ = 1
				UNION
				SELECT
					cga.clientId
				FROM APP_ClientGroupAssoc cga
					INNER JOIN APP_FirewallOptions fo ON
fo.clientGroupId = cga.clientGroupId AND (fo.flag & 4 <> 4)
				WHERE
					fo.isDMZ = 1
			) proxy ON
				proxy.clientId = c.id
			LEFT OUTER JOIN (
				SELECT DISTINCT
					ja.clientId
				FROM JMJobAction ja
				WHERE
					ja.appType = 0
					AND ja.opType = 4
					AND (ja.action & 2) = 2
			) bkupAct ON
				bkupAct.clientId = c.id
			LEFT OUTER JOIN (
				SELECT DISTINCT
					ja.clientId
				FROM JMJobAction ja
				WHERE
					ja.appType = 0
					AND ja.opType = 5
					AND (ja.action & 2) = 2
			) rstAct ON
				rstAct.clientId = c.id
			LEFT OUTER JOIN (
				SELECT  -- has active client owners
					o.entityId clientId
				FROM UMOwners o
				WHERE
					o.entitytype = 3
					AND o.isUSer = 1
					AND o.userOrGroupId IN (SELECT u.id FROM UMusers u WHERE (u.flags & 4) = 0 OR u.umdsPRoviderID = 0)
				UNION
				(
					SELECT  -- all clients except those identified below
						c.id clientId
					FROM APP_Client c
					EXCEPT
					SELECT  -- has inactive client owners
						o.entityId
					FROM UMOwners o
					WHERE
						o.entitytype = 3
						AND o.isUSer = 1
						AND o.userOrGroupId IN (SELECT u.id FROM UMusers  u WHERE (u.flags & 4) <> 0 AND u.umdsPRoviderID <> 0)
				)
			) inactiveADO ON
				inactiveADO.clientId = c.id
			LEFT OUTER JOIN APP_ClientProp sla ON
				sla.componentNameId = c.id
				AND sla.modified = 0
				--AND sla.cs_attrName = CHECKSUM(N'Exclude From SLA')
				AND sla.attrName = N'Exclude From SLA'
				AND sla.attrVal = '1'
			LEFT OUTER JOIN (
				SELECT
					ca.clientId,
					STUFF((
							SELECT ', ' + l.display_name
							FROM clientApps l
							WHERE l.clientId = ca.clientId
							FOR XML PATH(''), TYPE
						).value('.', 'VARCHAR(MAX)'), 1, 2, '') apps
				FROM clientApps ca
				GROUP BY ca.clientId
			) applist ON
				applist.clientId = c.id
			LEFT OUTER JOIN (
				SELECT
					gl.clientId,
					STUFF((
							SELECT '; ' + l.name
							FROM groupList l
							WHERE l.clientId = gl.clientId
							FOR XML PATH(''), TYPE
						).value('.', 'VARCHAR(MAX)'), 1, 2, '') grps
				FROM groupList gl
				GROUP BY gl.clientId
			) grplist ON
				grplist.clientId = c.id
			LEFT OUTER JOIN (
				SELECT
					ul.clientId,
					STUFF((
							SELECT ',' + l.login
							FROM #userList l
							WHERE l.clientId = ul.clientId
							FOR XML PATH(''), TYPE
						).value('.', 'VARCHAR(MAX)'), 1, 1, '') lgns
				FROM #userList ul
				GROUP BY ul.clientId
			) lgnlist ON
				lgnlist.clientId = c.id
			LEFT OUTER JOIN (
				SELECT
					sl.clientId,
					STUFF((
							SELECT ',' + l.name
							FROM #spList l
							WHERE l.clientId = sl.clientId
							FOR XML PATH(''), TYPE
						).value('.', 'VARCHAR(MAX)'), 1, 1, '') sps
				FROM #spList sl
				GROUP BY sl.clientId
			) splist ON
				splist.clientId = c.id
		WHERE c.id <> 1
	SET @o_data = (
		SELECT NAME AS '@name',
			entityPropId AS '@entityPropId',
			ENCRYPTION AS '@encryption',
			storagepolicy AS '@storagepolicy',
			onetouch AS '@onetouch',
			osstatus AS '@osstatus',
			clientGroups AS '@clientGroups',
			owners AS '@owners',
			agents AS '@agents',
			snapenabled AS '@snapenabled',
			daysOffline AS '@daysOffline',
			daysSinceClientCreated AS '@daysSinceClientCreated',
			daysSinceLastBkpClient AS '@daysSinceLastBkpClient',
			ClientActsAsProxy AS '@ClientActsAsProxy',
			backupEnabledForClient AS '@backupEnabledForClient',
			restoreEnabledForClient AS '@restoreEnabledForClient',
			clientOnlineDays AS '@clientOnlineDays',
			clientOwnerIsInactiveADUser AS '@clientOwnerIsInactiveADUser',
			clientExcludedFromSLAReport AS '@clientExcludedFromSLAReport',
			csHostname AS '@csHostname',
			displayname AS '@displayname'
		FROM #entityValueTable
		FOR XML PATH('Client'),
			ROOT('data')
		)
	 SELECT @o_header header, @o_data data
END
GO

IF EXISTS (select * from GxQscripts where name = 'GetClientExtendedProperties')
	delete from GxQscripts where name = 'GetClientExtendedProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientExtendedProperties')
	delete from GXDBVersions where aliasname = 'GetClientExtendedProperties'
GO

insert into GXDBVersions values(2, 'GetClientExtendedProperties',  '00000000000000000000', 'GetClientExtendedProperties', '00000000000000000000')
GO

