

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetClientBuildAndReleaseInfo.sp] ---------- 

--  +========================================================================+
--  | Stored Proc:  GetClientBuildAndReleaseInfo
--  | SP to get build and release info of all clients
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetClientBuildAndReleaseInfo <<<'

IF EXISTS (select * from sysobjects where name='GetClientBuildAndReleaseInfo')
	drop procedure GetClientBuildAndReleaseInfo
IF EXISTS (select * from GxQscripts where name='GetClientBuildAndReleaseInfo')
	delete from GxQscripts where name = 'GetClientBuildAndReleaseInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientBuildAndReleaseInfo')
	delete from GXDBVersions where aliasname = 'GetClientBuildAndReleaseInfo'
GO
print '... Creating Procedure: GetClientBuildAndReleaseInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetClientBuildAndReleaseInfo
  @clientId_in integer
AS
  DECLARE @ClientId_out integer;
  DECLARE @releaseId_out integer;
  DECLARE @buildStr_out nvarchar(1024);
SET NOCOUNT ON
IF object_id('tempdb.dbo.#Client') is not null
					DROP TABLE #Client
CREATE	TABLE #Client (id INT, releaseId INT)
IF(@clientId_in <> 0)
BEGIN
INSERT	INTO #Client
  SELECT Id,ReleaseId FROM APP_Client WHERE Id=@clientId_in
END
ELSE
BEGIN
-- Fetch ALL clients that have any galaxy package installed on them. Dont
-- care about their status.
INSERT	INTO #Client
SELECT Id,ReleaseId FROM APP_Client WHERE  (specialClientFlags & 0x2) <> 0x2
 -- SELECT Id,ReleaseId FROM APP_Client WHERE  status = 0
 -- OR ( (status & 0x2) = 0x2 and (specialClientFlags & 0x2) <> 0x2)
-- CHANGE: Dont delete CS virtual node from this list.
DELETE FROM #Client
WHERE id <> 2 AND Id IN
(SELECT CLP.componentNameId FROM App_ClientProp as CLP, #Client AS CL WHERE
CLP.componentNameId=CL.Id AND CLP.attrName='Virtual Client' AND CLP.attrVal='1')
END
DELETE FROM #Client
WHERE id <> 2 AND Id NOT IN (SELECT DISTINCT clientId from simInstalledPackages)
SELECT  C.id,C.releaseId,UPPER(AP.attrVal) FROM  #Client AS C, APP_ClientProp as AP
WHERE C.id=AP.componentNameId AND AP.attrName='Galaxy Build'
DROP TABLE #Client
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetClientBuildAndReleaseInfo')
	delete from GxQscripts where name = 'GetClientBuildAndReleaseInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientBuildAndReleaseInfo')
	delete from GXDBVersions where aliasname = 'GetClientBuildAndReleaseInfo'
GO

insert into GXDBVersions values(2, 'GetClientBuildAndReleaseInfo',  '00000000000000000000', 'GetClientBuildAndReleaseInfo', '00000000000000000000')
GO

