

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetClientAppTypeMapForAlert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--        procedure to get a list of client-apptype map
--		  this procedure returns virtual discovered clients with apptype 'virtual server'
-- ----------------------------------------------------------------------*/
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetClientAppTypeMapForAlert <<<'

IF EXISTS (select * from sysobjects where name='GetClientAppTypeMapForAlert')
	drop procedure GetClientAppTypeMapForAlert
IF EXISTS (select * from GxQscripts where name='GetClientAppTypeMapForAlert')
	delete from GxQscripts where name = 'GetClientAppTypeMapForAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientAppTypeMapForAlert')
	delete from GXDBVersions where aliasname = 'GetClientAppTypeMapForAlert'
GO
print '... Creating Procedure: GetClientAppTypeMapForAlert'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetClientAppTypeMapForAlert
  @dummyxml XML
-- Input
AS
SELECT
	(SELECT agents.clientId as '@clientId',
       agents.appTypeId as '@applicationId'
	   FROM APP_Client as clients with (nolock),
	   APP_IDAName as agents with (nolock)
	   where clients.id = agents.clientId
	   FOR  XML PATH('agents'),TYPE),
	(SELECT clientProp.componentNameId as '@clientId',
106  as '@applicationId'
	   FROM App_ClientProp as clientProp with (nolock)
	   WHERE clientProp.attrName = 'Virtual Server Discovered Clients'
	   and attrVal = 1 and modified = 0
	   FOR XML PATH ('agents'),TYPE)
	   FOR XML PATH('EVGui_GetClientAppTypeMapForAlertResp'),TYPE
-- The XML output string will look like:
--
-- <EVGui_GetClientAppTypeMapForAlertResp>
--    <agents clientId="2" applicationId="42" />
--    <agents clientId="2" applicationId="107" />
--    <agents clientId="4" applicationId="84" />
-- </EVGui_GetClientAppTypeMapForAlertResp>
GO

IF EXISTS (select * from GxQscripts where name = 'GetClientAppTypeMapForAlert')
	delete from GxQscripts where name = 'GetClientAppTypeMapForAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientAppTypeMapForAlert')
	delete from GXDBVersions where aliasname = 'GetClientAppTypeMapForAlert'
GO

insert into GXDBVersions values(2, 'GetClientAppTypeMapForAlert',  '00000000000000000000', 'GetClientAppTypeMapForAlert', '00000000000000000000')
GO

