

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetCBTEnabledAppIdList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetCBTEnabledAppIdList.sp,v $ $Id: GetCBTEnabledAppIdList.sp,v 1.1.2.1 2020/06/19 01:42:30 hkapadia Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						SP: "GetCBTEnabledAppIdList"							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetCBTEnabledAppIdList')
BEGIN
	print '>>> Drop Stored Procedure: GetCBTEnabledAppIdList <<<'
	drop procedure GetCBTEnabledAppIdList
END
IF EXISTS (select * from GxQscripts where name='GetCBTEnabledAppIdList')
	delete from GxQscripts where name = 'GetCBTEnabledAppIdList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetCBTEnabledAppIdList')
	delete from GXDBVersions where aliasname = 'GetCBTEnabledAppIdList'
GO
print '... Creating Procedure: GetCBTEnabledAppIdList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetCBTEnabledAppIdList
-- ----------------------------------------------------------------------
-- This SP returns list of subclients with CBT enabled
-- ----------------------------------------------------------------------
AS
  DECLARE @o_appId INTEGER
SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @checkSumCBT 	INTEGER
	SET 		@checkSumCBT 	= CHECKSUM(N'Change Tracking on VM')
	IF OBJECT_ID('tempdb.dbo.#tmpCBTEnabledAppId') IS NOT NULL DROP TABLE #tmpCBTEnabledAppId
	CREATE	TABLE #tmpCBTEnabledAppId(
			appId					INTEGER
			)
	CREATE CLUSTERED INDEX Idx_tmpCBTEnabledAppId_1 ON #tmpCBTEnabledAppId(appId)
	INSERT INTO #tmpCBTEnabledAppId
	SELECT DISTINCT APP.id
	FROM APP_Application APP WITH (NOLOCK), APP_InstanceProp I WITH (NOLOCK)
	WHERE APP.instance = I.componentNameId
	AND		I.attrName = 'Virtual Server Instance Type'
	AND		I.attrVal IN (N'601', N'402', N'301')
	AND		I.modified = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	IF EXISTS (SELECT 1 FROM #tmpCBTEnabledAppId)
	BEGIN
		--Remove the subclients where CBT is disabled; if property does not exists then consider CBT as enabled
		DELETE T
		FROM #tmpCBTEnabledAppId T, APP_SubclientProp S WITH (NOLOCK)
		WHERE T.appId = S.componentNameId
		AND		S.attrName = N'Change Tracking on VM'
		AND		S.cs_attrName = @checkSumCBT
		AND		S.attrVal = 0
		AND		S.modified = 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get list of VM subclients if the corresponding parent subclient is CBT enabled
		INSERT INTO #tmpCBTEnabledAppId
		SELECT DISTINCT JDL.childAppId
		FROM JMJobDataLink JDL WITH (NOLOCK), #tmpCBTEnabledAppId T
		WHERE JDL.parentAppId = T.appId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	CX_EXIT:
		IF @errorCode != 0
		BEGIN
			SELECT -1
		END
		ELSE
		BEGIN
			SELECT DISTINCT appId
			FROM #tmpCBTEnabledAppId
		END
	IF OBJECT_ID('tempdb.dbo.#tmpCBTEnabledAppId') IS NOT NULL DROP TABLE #tmpCBTEnabledAppId
	RETURN @errorCode;
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetCBTEnabledAppIdList')
	delete from GxQscripts where name = 'GetCBTEnabledAppIdList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetCBTEnabledAppIdList')
	delete from GXDBVersions where aliasname = 'GetCBTEnabledAppIdList'
GO

insert into GXDBVersions values(2, 'GetCBTEnabledAppIdList',  '00010001000200010000', 'GetCBTEnabledAppIdList', '00010001000200010000')
GO

