

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetBrowseIndexingPath.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetBrowseIndexingPath.sp,v $ $Id: GetBrowseIndexingPath.sp,v 1.11.88.2 2018/08/08 21:41:33 ksundaram Exp $";
-- =============================================
-- Author:		Ashish Gupta
-- Creation date: 02/11/2009
-- Description:	returns the mailboxes matching the given mailbox
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetBrowseIndexingPath <<<'

IF EXISTS (select * from sysobjects where name='GetBrowseIndexingPath')
	drop procedure GetBrowseIndexingPath
IF EXISTS (select * from GxQscripts where name='GetBrowseIndexingPath')
	delete from GxQscripts where name = 'GetBrowseIndexingPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetBrowseIndexingPath')
	delete from GXDBVersions where aliasname = 'GetBrowseIndexingPath'
GO
print '... Creating Procedure: GetBrowseIndexingPath'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetBrowseIndexingPath
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @i_newExchFormarGuid varchar(50) = ''
AS
SET NOCOUNT ON
DECLARE @BrowseReqType int
DECLARE @nsfFileOrGUID nvarchar(1024)
DECLARE @clientName nvarchar(1024)
DECLARE @errorCode integer
DECLARE @mailBoxName nvarchar(1024)
DECLARE @endTime int
DECLARE @simOSType NVARCHAR(255)
DECLARE @backupSetId	INT = 0
IF object_id('tempdb.dbo.#mailBox') IS NOT null
	DROP TABLE #mailBox
SET @errorCode = 0;
SET @BrowseReqType = 2
create table  #mailBox
 (
    mailBoxId		int	NOT null,
    backupSetId	int NOT null,
    fromTime		integer,
    endTime		integer,
    mailbox		nvarchar(512),
    mailboxGUID	nvarchar(1024),
  )
SET @BrowseReqType = ISNULL((select ref.value('@BrowseReqType','int')
								from @i_xmlText.nodes('DM2ContentIndexing_GetBrowseIndexingPathReq') R(ref)),2)
if @BrowseReqType = 2 -- CIBrowseReqType::DONOTHING
BEGIN
		set @errorCode = 1;
		goto ERROR_EXIT
END
SET @nsfFileOrGUID = ISNULL(( SELECT ref.value('@nsfFileOrGUID', 'varchar(1024)')
							FROM @i_xmlText.nodes('DM2ContentIndexing_GetBrowseIndexingPathReq') R ( ref ) ),
						N'')
SET @clientName = ISNULL(( SELECT ref.value('@clientName', 'varchar(1024)')
							FROM @i_xmlText.nodes('DM2ContentIndexing_GetBrowseIndexingPathReq') R ( ref ) ),
						N'')
IF @nsfFileOrGUID = N''
BEGIN
	set @errorCode = 1;
	goto ERROR_EXIT
END
SET @endTime =  dbo.GetUnixTime(GETDATE())
if @BrowseReqType = 0 -- CIBrowseReqType::LOTUSNOTES
BEGIN
SET @simOSType = ISNULL((SELECT type FROM simOperatingSystem WHERE id =
(SELECT TOP 1 simOperatingSystemId FROM APP_Client WHERE name = @clientName)),N'')
	IF LOWER(@simOSType) = 'windows'
		SET @nsfFileOrGUID =  REPLACE(@nsfFileOrGUID, CHAR(0x2F),CHAR(0x5C))
	IF LOWER(@simOSType) = 'unix'
		SET @nsfFileOrGUID =  REPLACE(@nsfFileOrGUID, CHAR(0x5C),CHAR(0x2F))
		SET @nsfFileOrGUID = '%' + @nsfFileOrGUID + '%'
	select TAG = 1,
	Parent = null,
	[DM2ContentIndexing_GetBrowseIndexingPathResp!1!contentIndexingPath] = (select TOP 1 REPLACE(REPLACE(filename, CHAR(0x15), 'CV0X15'), CHAR(0x12), 'CV0X12')
		from app_scfilterfile where filename like @nsfFileOrGUID AND modified = 0 AND
		componentNameId in (
			select A.id from app_application AS A inner join App_InstanceName AS I ON I.id = A.instance where A.apptypeid in (90)
			AND A.clientId in ( select id from app_client where name=@clientName)) order by created desc ),
		 [DM2ContentIndexing_GetBrowseIndexingPathResp!1!ClientID] = (select id from app_client where name=@clientName )
		for xml explicit
END
else if @BrowseReqType = 1 -- CIBrowseReqType::EXCHANGE
BEGIN
		set @mailBoxName = (select TOP(1) attrName from APP_SubClientProp where id in (
							select componentId from APP_ComponentProp
							WHERE componentType = 7 -- 'CV_COMPONENT_TYPE_EXMB'
							AND PropertyTypeId = 1103 -- 'CV_COMPONENT_TYPE_EXMB'
							AND modified = 0
							AND (stringVal = @nsfFileOrGUID OR
								(LEN(ISNULL(@i_newExchFormarGuid,''))> 0 AND stringVal = @i_newExchFormarGuid))) ORDER BY created desc)
		insert into #mailBox
		exec AppGetExchangeMailboxHistory @mailBoxName,0,0,@endTime;
		/*
			Get the backupSetId based on the following criteria
				- from the input mailboxhistory list, fetch the latest backupSetID whose endTime =0 with latest fromTime
				- If nothing found, order by endTime desc and get the top 1 backupSetId
		*/
		SET @backupSetId = ISNULL((select TOP(1) backupSetId from #mailBox as t where t.endTime = 0 order by fromTime desc) , 0)
		IF ISNULL(@backupSetId,0) = 0
		BEGIN
			SET @backupSetId =  ISNULL((select TOP(1) backupSetId from #mailBox order by endTime desc) , 0)
		END
select 1   as   TAG,
	null as  Parent,
		(select REPLACE(REPLACE(@mailBoxName, CHAR(0x15), 'CV0X15'), CHAR(0x12), 'CV0X12'))
		[DM2ContentIndexing_GetBrowseIndexingPathResp!1!contentIndexingPath],
		(select TOP(1) clientid from APP_Application where backupset =  @backupSetId)
		as [DM2ContentIndexing_GetBrowseIndexingPathResp!1!ClientID]
		 for xml explicit
END
ERROR_EXIT:
	  DROP TABLE #mailBox
      IF @errorCode <> 0
      	BEGIN
      		SELECT	1				as TAG,
					0					as Parent,
					NULL					as [DM2ContentIndexing_GetBrowseIndexingPathResp!1!contentIndexingPath]
					 for xml explicit
      	END
GO
GO

IF EXISTS (select * from GxQscripts where name = 'GetBrowseIndexingPath')
	delete from GxQscripts where name = 'GetBrowseIndexingPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetBrowseIndexingPath')
	delete from GXDBVersions where aliasname = 'GetBrowseIndexingPath'
GO

insert into GXDBVersions values(2, 'GetBrowseIndexingPath',  '00010011008800020000', 'GetBrowseIndexingPath', '00010011008800020000')
GO

