

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetBlockReplicationInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetBlockReplicationInfo.sp,v $ $Id: GetBlockReplicationInfo.sp,v 1.1.4.29.6.2 2021/02/12 01:43:04 stelagamsetti Exp $";
--	+===================================================================+
--	|  					  GetBlockReplicationInfo						|
--	|		 Procedure to get Block Replication information				|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetBlockReplicationInfo')
BEGIN
	print '>>> Drop Stored Procedure: GetBlockReplicationInfo <<<'
	drop procedure GetBlockReplicationInfo
END
IF EXISTS (select * from GxQscripts where name='GetBlockReplicationInfo')
	delete from GxQscripts where name = 'GetBlockReplicationInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetBlockReplicationInfo')
	delete from GXDBVersions where aliasname = 'GetBlockReplicationInfo'
GO
print '... Creating Procedure: GetBlockReplicationInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetBlockReplicationInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString			XML
	DECLARE @subclientId            INT = ISNULL (( SELECT ref.value('@subclientId', 'INT')
											           FROM @i_xmlString.nodes ('BlockReplication_GetBlockReplicationInfoReq/siteInfo/entity') R(ref)), 0)
	DECLARE @backupSetId			INT = ISNULL (( SELECT ref.value('@backupsetId', 'INT')
													   FROM @i_xmlString.nodes ('BlockReplication_GetBlockReplicationInfoReq/siteInfo/entity') R(ref)), 0)
	DECLARE @localeId_in			INT = ISNULL (( SELECT ref.value('@localeID', 'INT')
											           FROM @i_xmlString.nodes ('BlockReplication_GetBlockReplicationInfoReq') R(ref)), 0)
	DECLARE @pairId					INT = ISNULL (( SELECT ref.value('@id', 'INT')
											           FROM @i_xmlString.nodes ('BlockReplication_GetBlockReplicationInfoReq/siteInfo') R(ref)), 0)
	DECLARE @userId					INT = ISNULL (( SELECT ref.value('@userId', 'INT')
														FROM @i_xmlString.nodes ('BlockReplication_GetBlockReplicationInfoReq/siteInfo/processinginstructioninfo/user') R(ref)), 0)
	IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL
		DROP TABLE #getObjectsTable
	CREATE TABLE #getObjectsTable (entityId INT, permissionId INT)
	IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
		DROP TABLE #permissionIdTable
	CREATE TABLE #permissionIdTable (permissionId INT)
	INSERT INTO #permissionIdTable
	(permissionId)
VALUES (31), (3), (20), (22)
EXEC sec_getObjectsWithPermissionsV2 @userId, 3, 0
    IF object_id('tempdb.dbo.#blrReplicationInfoTable') IS NOT null DROP TABLE #blrReplicationInfoTable
	CREATE TABLE #blrReplicationInfoTable
			(id INT,
			 subclientId INT,
			 destClientId INT,
			 headClientId INT,
			 tailClientId INT,
			 srcGuid NVARCHAR(MAX),
			 dstGuid NVARCHAR(MAX),
			 srcName NVARCHAR(MAX),
			 dstName NVARCHAR(MAX),
			 statusCode INT,
			 eventMessage NVARCHAR(MAX),
			 eventId INT,
			 lagTime INT,
			 rpStoreId INT,
			 testBootStatusCode INT,
			 testBootEventMessage NVARCHAR(MAX),
			 permBootStatusCode INT,
			 permBootEventMessage NVARCHAR(MAX),
			 flags INT,
			 pendingStatusCode INT,
			 testBootTaskStr NVARCHAR(MAX) NULL,
			 permanentBootTaskStr NVARCHAR(MAX) NULL,
			 statsList XML,
			 repGroup XML)
	IF object_id('tempdb.dbo.#blrSubclientInfoTable') IS NOT null DROP TABLE #blrSubclientInfoTable
	CREATE TABLE #blrSubclientInfoTable
			(id INT,
			 clientId INT,
			 backupSet INT,
			 instance INT,
			 name NVARCHAR(MAX))
	-- pair properties table
	IF  object_id('tempdb.dbo.#blrReplicationInfoPropTable') is not null DROP TABLE #blrReplicationInfoPropTable
	-- event message table
	IF object_id('tempdb.dbo.#blrEventMsgTable') IS NOT null DROP TABLE #blrEventMsgTable
	CREATE TABLE #blrEventMsgTable
			(eventId INT,
			 eventMessage NVARCHAR(MAX))
	-- blr boot information table
	IF object_id('tempdb.dbo.#blrBootInfoTable') IS NOT null DROP TABLE #blrBootInfoTable
	CREATE TABLE #blrBootInfoTable
			(bootType INT,
			 pairId INT,
			 statusCode INT,
			 eventId INT,
			 eventMessage NVARCHAR(MAX))
	-- RP Store information
	IF object_id('tempdb.dbo.#blrRPInfoTable') IS NOT null DROP TABLE #blrRPInfoTable
	CREATE TABLE #blrRPInfoTable
			(id INT,
			name NVARCHAR(MAX))
	-- if pair is present fetch information only for it.
	IF @pairId > 0
	BEGIN
		INSERT #blrReplicationInfoTable (id, subclientId, destClientId, headClientId, tailClientId, srcGuid, dstGuid, srcName, dstName, statusCode, eventMessage, eventId, lagTime, rpStoreId, flags, pendingStatusCode)
			SELECT DISTINCT BLR.id, BLR.subClientId, BLR.dstClientId, BLR.headClientId, BLR.tailClientId, BLR.srcGuid, BLR.dstGuid, BLR.srcName,
				BLR.dstName, BLR.statusCode,'', BLR.eventId , BLR.lagTime, BLR.rpStoreId, BLR.flags, BLR.pendingStatusCode FROM BlrPair BLR WITH (NOLOCK)
				INNER JOIN #getObjectsTable cl on cl.entityId IN (SELECT DISTINCT clientId FROM App_Application (NOLOCK)
                                                                  WHERE id = BLR.subclientId
                                                                  UNION
                                                                  SELECT componentNameId FROM App_ClientProp (NOLOCK)
                                                                  WHERE attrName = 'Virtual Machine Instance UUID' AND modified = 0 AND attrVal = BLR.srcGuid)
				WHERE BLR.id = @pairId
	END
	-- if backupset is provided and subclient is not provided
	-- return all rows of subclients belonging to this backupset
	ELSE IF @backupSetId > 0 AND @subClientId = 0
	BEGIN
		INSERT #blrReplicationInfoTable (id, subclientId, destClientId, headClientId, tailClientId, srcGuid, dstGuid, srcName, dstName, statusCode, eventMessage, eventId, lagTime, rpStoreId, flags, pendingStatusCode)
			SELECT DISTINCT BLR.id, BLR.subClientId, BLR.dstClientId, BLR.headClientId, BLR.tailClientId, BLR.srcGuid, BLR.dstGuid, BLR.srcName,
				BLR.dstName, BLR.statusCode, '', BLR.eventId, BLR.lagTime, BLR.rpStoreId, BLR.flags, BLR.pendingStatusCode FROM BlrPair BLR WITH (NOLOCK)
					INNER JOIN #getObjectsTable cl on cl.entityId IN (SELECT DISTINCT clientId FROM App_Application (NOLOCK)
                                                                      WHERE id = BLR.subclientId
                                                                      UNION
                                                                      SELECT componentNameId FROM App_ClientProp (NOLOCK)
                                                                      WHERE attrName = 'Virtual Machine Instance UUID' AND modified = 0 AND attrVal = BLR.srcGuid)
					where BLR.subClientId in (select APP.id from APP_Application APP WITH (NOLOCK) where backupSet = @backupSetId)
	END
	ELSE
	BEGIN
		-- if subclient id is not mentioned, return all entities
		-- if subclient id is mentioned, return entities part of the subclient
		INSERT #blrReplicationInfoTable (id, subclientId, destClientId, headClientId, tailClientId, srcGuid, dstGuid, srcName, dstName, statusCode, eventId, eventMessage, lagTime, rpStoreId, flags, pendingStatusCode)
			SELECT DISTINCT BLR.id, BLR.subClientId, BLR.dstClientId, BLR.headClientId, BLR.tailClientId, BLR.srcGuid, BLR.dstGuid, BLR.srcName,
				BLR.dstName, BLR.statusCode, BLR.eventId, '', BLR.lagTime, BLR.rpStoreId, BLR.flags, BLR.pendingStatusCode FROM BlrPair BLR WITH (NOLOCK)
					INNER JOIN #getObjectsTable cl on cl.entityId IN (SELECT DISTINCT clientId FROM App_Application (NOLOCK)
                                                                      WHERE id = BLR.subclientId
                                                                      UNION
                                                                      SELECT componentNameId FROM App_ClientProp (NOLOCK)
                                                                      WHERE attrName = 'Virtual Machine Instance UUID' AND modified = 0 AND attrVal = BLR.srcGuid)
					where BLR.subClientId = @subClientId OR @subClientId = 0
	END
	-- Populate the blr properties table
	SELECT  pairId,
			ISNULL([recoveryMode],N'1') as recoveryMode,
		    ISNULL([ccrpInterval],N'0') as ccrpInterval,
			ISNULL([acrpInterval],N'0') as acrpInterval,
			ISNULL([maxRpInterval],N'0') as maxRpInterval,
			ISNULL([rpMergeDelay],N'0') as rpMergeDelay,
			ISNULL([rpRetention],N'0') as rpRetention,
			ISNULL([maxRpStoreOfflineTime],N'0') as maxRpStoreOfflineTime,
			ISNULL([useOffPeakSchedule],N'0') as useOffPeakSchedule,
			ISNULL([origPairID],N'0') as origPairID
			INTO    #blrReplicationInfoPropTable
	FROM
	(
		    SELECT pairId, propertyName, propertyValue
			    FROM BlrPairProperties (NOLOCK)
				WHERE modified = 0
	)   AS  blrProps
	PIVOT
	(
        MAX(propertyValue)
        FOR propertyName IN
        (
			[recoveryMode],
            [ccrpInterval],
            [acrpInterval],
            [maxRpInterval],
            [rpMergeDelay],
            [rpRetention],
            [maxRpStoreOfflineTime],
			[useOffPeakSchedule],
			[origPairID]
		)
	) AS pvt
    -- populate the BLR boot table
	-- We need to get latest testboot and perm boot information
	-- Latest test boot status
	INSERT INTO #blrBootInfoTable (bootType, pairId, statusCode, eventId)
		SELECT b.bootType, b.pairId, statusCode, eventId FROM blrBootVM b (NOLOCK),
		   (SELECT pairId, bootType, max(Id) as latest
 				FROM BlrBootVM (NOLOCK) group by pairId, bootType) blrTemp
 				WHERE blrTemp.latest = b.id
	--Overwrite the correct event IDs from the the associated hidden pair
	--When origPairId is non-zero, we need to take the event(if set) from the hidden pair
	UPDATE	R
	SET	eventId = R2.eventId
	FROM	#blrReplicationInfoTable R
		INNER JOIN #blrReplicationInfoPropTable Prop
			ON	R.id = Prop.origPairId AND Prop.origPairId <> '0'
		INNER JOIN #blrReplicationInfoTable R2
			ON	R2.id = Prop.pairId AND R2.eventId <> 0
	UPDATE	B
	SET	eventId = B2.eventId
	FROM	#blrBootInfoTable B
		INNER JOIN #blrReplicationInfoPropTable Prop
			ON	B.pairId = Prop.origPairId AND Prop.origPairId <> '0'
		INNER JOIN #blrBootInfoTable B2
			ON	B2.pairId = Prop.pairId AND B2.eventId <> 0
	-- populate unique message ids for BLR
	INSERT #blrEventMsgTable (eventId)
						(SELECT eventId FROM #blrReplicationInfoTable
						UNION
						SELECT eventId FROM #blrBootInfoTable)
	-- Populate the unique error strings
	UPDATE #blrEventMsgTable SET eventMessage = (SELECT TOP 1 Message FROM EvLocaleMsgs evLocal (NOLOCK) WHERE evLocal.LocaleID = @localeId_in AND evLocal.MessageID=eventId)
	-- update the string into info and boot tables
	UPDATE #blrBootInfoTable SET eventMessage = ( SELECT TOP 1 event.eventMessage FROM #blrEventMsgTable event WHERE #blrBootInfoTable.eventId=event.eventId)
	UPDATE #blrReplicationInfoTable SET eventMessage = ( SELECT TOP 1 event.eventMessage FROM #blrEventMsgTable event WHERE #blrReplicationInfoTable.eventId=event.eventId)
	-- Populate the message into the per
	UPDATE #blrReplicationInfoTable SET testBootStatusCode=TB.statusCode, testBootEventMessage = TB.eventMessage FROM #blrBootInfoTable TB WHERE TB.pairId = #blrReplicationInfoTable.id AND TB.bootType = 1
	UPDATE #blrReplicationInfoTable SET permBootStatusCode=TB.statusCode, permBootEventMessage = TB.eventMessage FROM #blrBootInfoTable TB WHERE TB.pairId = #blrReplicationInfoTable.id AND TB.bootType = 2
	--Populate subclient temp table to reduce query on app_application
	INSERT #blrSubclientInfoTable(id, clientId, backupSet, instance, name)
	SELECT sc.id, sc.clientId, sc.backupSet, sc.instance, sc.subclientName
	FROM app_application SC (NOLOCK) WHERE sc.id IN (SELECT tbl.subclientId FROM #blrReplicationInfoTable tbl)
	-- Populate RP Store name information to reduce queries from MM tables
	INSERT #blrRPInfoTable (id, name)
	SELECT RP.RPStoreId, RP.RPStoreName
	FROM MMRPStoreConfig RP (NOLOCK) WHERE RPStoreId IN (SELECT tbl.rpStoreId FROM #blrReplicationInfoTable tbl)
	-- Endpoint information
	IF object_id('tempdb.dbo.#blrFSInfoTbl') IS NOT null DROP TABLE #blrFSInfoTbl
	CREATE TABLE #blrFSInfoTbl (subclientId INT, srcEndPointType INT, destEndpointType INT)
	INSERT INTO #blrFSInfoTbl
	SELECT	DISTINCT subclientId, srcType, dstType
	FROM	BlrPair P
		INNER JOIN #blrSubclientInfoTable SC
			ON P.subClientId = SC.id
	IF object_id('tempdb.dbo.#blrFSVolPairs') IS NOT null DROP TABLE #blrFSVolPairs
	CREATE TABLE #blrFSVolPairs (subclientId INT, srcVol NVARCHAR(512), srcVolGuid NVARCHAR(64), destVol NVARCHAR(512), destVolGuid NVARCHAR(64))
	INSERT INTO #blrFSVolPairs
	SELECT	SC.id, D.srcPath, D.srcGuid, D.dstPath, D.dstGuid
	FROM	#blrSubclientInfoTable SC
		INNER JOIN BlrPair P
			ON SC.id = P.subclientId
		INNER JOIN BlrDisk D
			ON P.id = D.pairId
	UPDATE #blrReplicationInfoTable
	SET permanentBootTaskStr = (SELECT
									( SELECT TM_Task.taskId AS '@taskId',
                                            TM_Task.taskName AS '@taskName',
                                            TM_Task.taskType AS '@taskType',
                                            ( SELECT  --TaskFlags
                                                        TM_Task.disabled AS '@disabled',
                                                        TM_Task.uninstalled AS '@uninstalled',
                                                        TM_Task.isEZOperation AS '@isEZOperation',
														CASE TM_Task.flags&32
														WHEN 32 THEN 1
														ELSE 0
														END '@forDDB',
CASE WHEN TM_Task.flags & 0x40 <> 0 THEN 1
														ELSE 0
														END AS '@isEdgeDrive',
CASE WHEN TM_Task.flags & 0x4 <> 0 THEN 1
														ELSE 0
														END AS '@isSystem'
                                            FOR
                                              XML PATH('taskFlags'),
                                                  TYPE
                                            ),
											(SELECT
												TM_Task.taskId AS '@taskId',
												TM_Task.taskName AS '@taskName'
											FOR XML PATH ('task'),TYPE
											)
											FOR XML PATH('task'),TYPE),
									( SELECT		--SUBTASKINFO
                                            ( SELECT		--SUBTASK
                                                        TM_Subtask.subTaskId AS '@subTaskId',
                                                        TM_Subtask.subTaskType AS '@subTaskType',
                                                        TM_Subtask.operationType AS '@operationType',
                                                        TM_Subtask.flags AS '@flags' ,
                                                        TM_Subtask.subTaskOrder AS '@subTaskOrder',
                                                        TM_Subtask.subTaskName AS '@subTaskName',
														( SELECT		--SUBTASK
																	TM_Subtask.subTaskId AS '@subtaskId',
																	TM_Subtask.subTaskName AS '@subtaskName'
														FOR XML PATH('subTask'),TYPE
														)
                                            FOR XML PATH('subTask'),TYPE )
										FOR XML PATH('subTasks'),TYPE )
                         FOR XML PATH('taskInfo') 	)
	FROM #blrReplicationInfoTable blrReplicationInfoTable
	INNER JOIN TM_Subtask (NOLOCK) ON TM_Subtask.operationType = 4047 --BLR_OPERATION
	INNER JOIN TM_Task (NOLOCK) ON TM_Subtask.TaskID = TM_Task.taskID AND TM_Task.deleted = 0
	AND TM_Task.TaskType IN (2,4) --- schedule/schedule policy. Test boot and permanent boot info are shown for immediate job requests.
	INNER JOIN TM_SubtaskOptions (NOLOCK) ON TM_Subtask.subtaskID = TM_SubtaskOptions.subTaskId AND TM_SubtaskOptions.optionId =737962015 -- BLOCKLEVELOPERATION_OPERATIONS
	AND CAST(TM_SubtaskOptions.value as XML).value('(operations/vmBootInfo/@blrPairId)[1]','INT') = blrReplicationInfoTable.ID
	AND CAST(TM_SubtaskOptions.value as XML).value('(operations/@opType)[1]','INT') = 4 -- Permanent boot enum BLRVMOperationType
	UPDATE #blrReplicationInfoTable
	SET testBootTaskStr = (SELECT
									( SELECT TM_Task.taskId AS '@taskId',
                                            TM_Task.taskName AS '@taskName',
                                            TM_Task.taskType AS '@taskType',
                                            ( SELECT  --TaskFlags
                                                        TM_Task.disabled AS '@disabled',
                                                        TM_Task.uninstalled AS '@uninstalled',
                                                        TM_Task.isEZOperation AS '@isEZOperation',
														CASE TM_Task.flags&32
														WHEN 32 THEN 1
														ELSE 0
														END '@forDDB',
CASE WHEN TM_Task.flags & 0x40 <> 0 THEN 1
														ELSE 0
														END AS '@isEdgeDrive',
CASE WHEN TM_Task.flags & 0x4 <> 0 THEN 1
														ELSE 0
														END AS '@isSystem'
                                            FOR
                                              XML PATH('taskFlags'),
                                                  TYPE
                                            ),
											(SELECT
												TM_Task.taskId AS '@taskId',
												TM_Task.taskName AS '@taskName'
											FOR XML PATH ('task'),TYPE
											)
											FOR XML PATH('task'),TYPE),
									( SELECT		--SUBTASKINFO
                                            ( SELECT		--SUBTASK
                                                        TM_Subtask.subTaskId AS '@subTaskId',
                                                        TM_Subtask.subTaskType AS '@subTaskType',
                                                        TM_Subtask.operationType AS '@operationType',
                                                        TM_Subtask.flags AS '@flags' ,
                                                        TM_Subtask.subTaskOrder AS '@subTaskOrder',
                                                        TM_Subtask.subTaskName AS '@subTaskName',
														( SELECT		--SUBTASK
																	TM_Subtask.subTaskId AS '@subtaskId',
																	TM_Subtask.subTaskName AS '@subtaskName'
														FOR XML PATH('subTask'),TYPE
														)
                                            FOR XML PATH('subTask'),TYPE )
										FOR XML PATH('subTasks'),TYPE )
                         FOR XML PATH('taskInfo') 	)
	FROM #blrReplicationInfoTable blrReplicationInfoTable
	INNER JOIN TM_Subtask (NOLOCK) ON TM_Subtask.operationType = 4047 --BLR_OPERATION
	INNER JOIN TM_Task (NOLOCK) ON TM_Subtask.TaskID = TM_Task.taskID AND TM_Task.deleted = 0
	AND TM_Task.TaskType IN (2,4) --- schedule/schedule policy. Test boot and permanent boot info are shown for immediate job requests.
	INNER JOIN TM_SubtaskOptions (NOLOCK) ON TM_Subtask.subtaskID = TM_SubtaskOptions.subTaskId AND TM_SubtaskOptions.optionId =737962015 -- BLOCKLEVELOPERATION_OPERATIONS
	AND CAST(TM_SubtaskOptions.value as XML).value('(operations/vmBootInfo/@blrPairId)[1]','INT') = blrReplicationInfoTable.ID
	AND CAST(TM_SubtaskOptions.value as XML).value('(operations/@opType)[1]','INT') = 1 -- Test boot enum BLRVMOperationType
	--ReplicationGroup
	UPDATE #blrReplicationInfoTable
	SET repGroup = (SELECT
						(SELECT ISNULL(REP.id,0) AS '@replicationGroupId', ISNULL(REP.name, '') AS '@replicationGroupName' FOR XML PATH('replicationGroup'), TYPE)
					)
	FROM #blrReplicationInfoTable blrReplicationInfoTable
	LEFT JOIN App_ReplicationGroupAssociation REPASSOC on blrReplicationInfoTable.id = REPASSOC.blrpairId
	LEFT JOIN App_ReplicationGroup REP on REP.id = REPASSOC.componentNameId
	-- summary
	declare @totalPairs int
	declare @livePairs int
	declare @granularPairs int
	declare @applPairs int
	declare @lagPairs int
	select @totalPairs = count(id),
		   @livePairs = sum(case when prop.recoveryMode = 1 then 1 else 0 end),
		   @granularPairs = sum(case when prop.recoveryMode = 4 then 1 else 0 end),
		   @applPairs = sum(case when prop.recoveryMode =4 and prop.acrpInterval >0 then 1 else 0 end),
		   @lagPairs = sum(case when statuscode !=6 and lagTime >0 then 1 else 0 end)
	from #blrReplicationInfoTable tbl
	LEFT OUTER JOIN #blrReplicationInfoPropTable prop on prop.pairId = tbl.id
	WHERE prop.origPairID = '0'
	DECLARE @summary xml
	set @summary = ( select @totalPairs as '@totalPairs',
						   @granularPairs as '@totalGranularPairs',
						   @livePairs as '@totalLivePairs',
						   @applPairs as '@totalAppConsistentPairs',
						   @lagPairs as '@totalPairsWithLag',
						   (select statusCode as '@status',
							      totalPairs as '@totalCount'
						   from
								(   select statusCode, count(*) as totalPairs
									from #blrReplicationInfoTable
									group by statusCode
								) T
						   for xml path('syncSummary'), Type)
						   for xml path('summary')
					)
	IF (EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = 'HistoryDB') AND OBJECT_ID('HistoryDB..BlrPairStats') IS NOT NULL)
	BEGIN
		UPDATE #blrReplicationInfoTable
		SET statsList = (
			SELECT
				TOP 1
				id '@id',
				repDataDeltaActual / ([timeStamp] - LAG([timeStamp]) OVER(ORDER BY id)) AS '@repDataDeltaActual',
				repDataDeltaComp / ([timeStamp] - LAG([timeStamp]) OVER(ORDER BY id)) AS '@repDataDeltaComp',
				ioDelta / ([timeStamp] - LAG([timeStamp]) OVER(ORDER BY id)) AS '@ioDelta',
				repSetSize '@repSetSize',
				sizeInRpStore '@sizeInRpStore',
				retention '@retention',
				iopsDelta '@iopsDelta',
				timeStamp 'timeStamp/@time'
			FROM
				HistoryDB..BlrPairStats
			WHERE
				pairId = #blrReplicationInfoTable.id
			ORDER BY
				timeStamp DESC
			FOR XML PATH('statsList')
			)
	END
	-- FORM the XML RESPONSE
	SET @o_xmlString =
	(
		    select (SELECT	tbl.id '@id',
					sc.clientId '@srcClientId',
					tbl.destClientId '@destClientId',
					tbl.headClientId '@headClientId',
					tbl.tailClientId '@tailClientId',
					tbl.srcGuid '@sourceGuid',
					tbl.dstGuid '@destinationGuid',
					tbl.srcName '@sourceName',
					tbl.dstName '@destinationName',
					tbl.statusCode '@status',
					tbl.eventMessage '@eventMessage',
					tbl.lagTime '@lagTime',
					tbl.flags '@flags',
					tbl.pendingStatusCode '@pendingStatusCode',
					tbl.testBootStatusCode   '@testBootStatus', -- Latest test boot status
					tbl.testBootEventMessage '@testBootStatusMessage', -- Latest test boot status message
					tbl.permBootStatusCode   '@permanentBootStatus', -- Latest perm boot status
					tbl.permBootEventMessage '@permanentBootStatusMessage', -- Latest perm boot status message
					fsInfo.srcEndPointType	'@srcEndPointType',
					fsInfo.destEndPointType	'@destEndPointType',
					permanentBootTaskStr '@permanentBootTaskInfoXml',
					testBootTaskStr '@testBootTaskInfoXml',
					tbl.subclientId 'entity/@subclientId',
					sc.name 'entity/@subclientName',
					sc.instance 'entity/@instanceId',
					sc.backupSet 'entity/@backupsetId',
					sc.clientId 'entity/@clientId',
					-- recovery type
					prop.recoveryMode 'blrRecoveryOpts/@recoveryType',
					-- snap retention (These values will be eventually removed)
					0 'blrRecoveryOpts/snap/@snapRetentionTime',
					0 'blrRecoveryOpts/snap/@snapInterval',
					0 'blrRecoveryOpts/snap/@bCrpSnaps',
					-- granular recovery details (These values will be eventually removed)
					0 'blrRecoveryOpts/granular/@snapRetentionTime',
					0 'blrRecoveryOpts/granular/@rpInterval',
					0 'blrRecoveryOpts/granular/@crpInterval',
					0 'blrRecoveryOpts/granular/@bUseCrps',
					0 'blrRecoveryOpts/granular/@rpRetentionTime',
					tbl.rpStoreId 'blrRecoveryOpts/granular/@rpStoreId',
					rpInfo.name 'blrRecoveryOpts/granular/@rpStoreName',			 -- RP store name
					-- granularV2 recovery details
					prop.ccrpInterval 'blrRecoveryOpts/granularV2/@ccrpInterval',
					prop.acrpInterval 'blrRecoveryOpts/granularV2/@acrpInterval',
					prop.maxRpInterval 'blrRecoveryOpts/granularV2/@maxRpInterval',
					prop.rpMergeDelay 'blrRecoveryOpts/granularV2/@rpMergeDelay',
					prop.rpRetention 'blrRecoveryOpts/granularV2/@rpRetention',
					prop.maxRpStoreOfflineTime 'blrRecoveryOpts/granularV2/@maxRpStoreOfflineTime',
					prop.useOffPeakSchedule 'blrRecoveryOpts/granularV2/@useOffPeakSchedule',
					tbl.rpStoreId 'blrRecoveryOpts/granularV2/@rpStoreId',
					rpInfo.name 'blrRecoveryOpts/granularV2/@rpStoreName',			 -- RP store name
					(SELECT V.srcVol AS '@sourceVolume',
							V.srcVolGuid AS '@sourceVolumeGUID',
							V.destVol AS '@destVolume',
							V.destVolGuid AS '@destVolumeGUID'
					FROM	#blrFSVolPairs V
						WHERE V.subclientId = sc.id
					FOR XML PATH('srcDestVolumeMap'), TYPE),
					statsList.query('.'),
					tbl.repGroup.query('.')
			FROM #blrReplicationInfoTable tbl
					INNER JOIN #blrSubclientInfoTable sc on sc.id = tbl.subclientId
					LEFT OUTER JOIN #blrReplicationInfoPropTable prop on prop.pairId = tbl.id
					LEFT OUTER JOIN #blrRPInfoTable rpInfo on rpInfo.id = tbl.rpStoreId
					LEFT OUTER JOIN #blrFSInfoTbl fsInfo ON  tbl.subclientId = fsInfo.subclientId
			WHERE prop.origPairID = '0'
			FOR XML PATH('siteInfo'), TYPE),
			@summary
            FOR XML PATH('BlockReplication_GetBlockReplicationInfoResp')
    )
	IF @o_xmlString IS NULL
		SET @o_xmlString = '<BlockReplication_GetBlockReplicationInfoResp/>'
	IF OBJECT_ID('tempdb.dbo.#GetBlockReplicationInfoExtXmlTbl') IS NOT NULL
		INSERT INTO #GetBlockReplicationInfoExtXmlTbl(continuous)
			SELECT @o_xmlString
    ELSE
		SELECT @o_xmlString as o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetBlockReplicationInfo')
	delete from GxQscripts where name = 'GetBlockReplicationInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetBlockReplicationInfo')
	delete from GXDBVersions where aliasname = 'GetBlockReplicationInfo'
GO

insert into GXDBVersions values(2, 'GetBlockReplicationInfo',  'v1.1.4.29.6.2', 'GetBlockReplicationInfo', 'v1.1.4.29.6.2')
GO

