

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetBlockReplicationBootInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  			GetBlockReplicationBootInfo  						|
--	|		 Procedure to get Block Replication boot information	|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetBlockReplicationBootInfo <<<'

IF EXISTS (select * from sysobjects where name='GetBlockReplicationBootInfo')
	drop procedure GetBlockReplicationBootInfo
IF EXISTS (select * from GxQscripts where name='GetBlockReplicationBootInfo')
	delete from GxQscripts where name = 'GetBlockReplicationBootInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetBlockReplicationBootInfo')
	delete from GXDBVersions where aliasname = 'GetBlockReplicationBootInfo'
GO
print '... Creating Procedure: GetBlockReplicationBootInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetBlockReplicationBootInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString			XML
	DECLARE @pairId                 INT = ISNULL (( SELECT ref.value('@pairId', 'INT')
											           FROM @i_xmlString.nodes ('BlockReplication_GetBlockReplicationBootInfoReq') R(ref)), 0)
	DECLARE @getLatest              INT = ISNULL (( SELECT ref.value('@getLatest', 'INT')
											           FROM @i_xmlString.nodes ('BlockReplication_GetBlockReplicationBootInfoReq') R(ref)), 0)
	DECLARE @bootType              INT = ISNULL (( SELECT ref.value('@bootType', 'INT')
											           FROM @i_xmlString.nodes ('BlockReplication_GetBlockReplicationBootInfoReq') R(ref)), 0)
	DECLARE @localeId_in			INT = ISNULL (( SELECT ref.value('@localeID', 'INT')
											           FROM @i_xmlString.nodes ('BlockReplication_GetBlockReplicationBootInfoReq') R(ref)), 0)
	-- Boot info table
	IF object_id('tempdb.dbo.#bootInfoTable') IS NOT null DROP TABLE #bootInfoTable
	CREATE TABLE #bootInfoTable
			(id INT,
			 pairId INT,
			 uuid NVARCHAR(MAX),
			 name NVARCHAR(MAX),
			 creationTime bigint,
			 bestBefore bigint,
			 status INT,
		     statusMessage NVARCHAR(MAX),
			 eventId INT,
			 eventMessage NVARCHAR(MAX) DEFAULT '',
			 bootType INT)
	-- event message table
	IF object_id('tempdb.dbo.#blrEventMsgTable') IS NOT null DROP TABLE #blrEventMsgTable
	CREATE TABLE #blrEventMsgTable
			(eventId INT,
			 eventMessage NVARCHAR(MAX) DEFAULT '')
	-- if getlatest is ON, return only the latest row
	IF @getLatest > 0
	BEGIN
			INSERT #bootInfoTable (id, pairId, uuid, name, creationTime, bestBefore, status, statusMessage, eventId, bootType)
				SELECT TOP 1 BLR.id, BLR.pairId, BLR.uuid, BLR.name, BLR.creationTime, BLR.bestBefore, BLR.statusCode, BLR.statusMessage, BLR.eventId, BLR.bootType
					FROM BlrBootVM BLR WITH (NOLOCK) where (BLR.bootType = @bootType) AND (BLR.pairId = @pairId OR @pairId = 0) ORDER BY BLR.id DESC
	END
	ELSE
	BEGIN
			INSERT #bootInfoTable (id, pairId, uuid, name, creationTime, bestBefore, status, statusMessage, eventId, bootType)
				SELECT BLR.id, BLR.pairId, BLR.uuid, BLR.name, BLR.creationTime, BLR.bestBefore, BLR.statusCode, BLR.statusMessage, BLR.eventId, BLR.bootType
					FROM BlrBootVM BLR WITH (NOLOCK) where (BLR.bootType = @bootType) AND (BLR.pairId = @pairId OR @pairId = 0) ORDER BY BLR.id DESC
	END
	-- Populate the message into the table
	INSERT #blrEventMsgTable (eventId) (SELECT DISTINCT eventId FROM #bootInfoTable)
	UPDATE #blrEventMsgTable SET eventMessage = (SELECT TOP 1 Message FROM EvLocaleMsgs evLocal (NOLOCK) WHERE evLocal.LocaleID = @localeId_in AND evLocal.MessageID=eventId)
	-- Update the event message into the table
	UPDATE #bootInfoTable SET eventMessage=TB.eventMessage FROM #blrEventMsgTable TB WHERE TB.eventId = #bootInfoTable.eventId
	-- prepare the result XML
	SET @o_xmlString =
	(
		    SELECT tbl.id '@id',
				   tbl.pairId '@pairId',
				   tbl.uuid '@uuid',
				   tbl.name '@name',
				   tbl.creationTime '@creationTime',
				   tbl.bestBefore '@bestBefore',
				   tbl.status '@status',
				   tbl.statusMessage '@statusMessage',
				   tbl.bootType '@bootType',
				   tbl.eventMessage '@eventMessage'
			FROM #bootInfoTable tbl
			FOR XML PATH('siteInfo'),
            ROOT('BlockReplication_GetBlockReplicationBootInfoResp')
    )
	IF @o_xmlString IS NULL
		SET @o_xmlString = '<BlockReplication_GetBlockReplicationBootInfoResp/>'
	SELECT @o_xmlString  as o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetBlockReplicationBootInfo')
	delete from GxQscripts where name = 'GetBlockReplicationBootInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetBlockReplicationBootInfo')
	delete from GXDBVersions where aliasname = 'GetBlockReplicationBootInfo'
GO

insert into GXDBVersions values(2, 'GetBlockReplicationBootInfo',  '00000000000000000000', 'GetBlockReplicationBootInfo', '00000000000000000000')
GO

