

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetBaseLineStatus.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetBaseLineStatus.sp,v $ $Id: GetBaseLineStatus.sp,v 1.7.276.2 2020/05/06 16:15:49 xsui Exp $";
--  +========================================================================+
--  | Stored Proc:  GetBaseLineStatus()
--  |
--  | Description: Get base line status for a given client
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetBaseLineStatus')
BEGIN
	print '>>> Drop Stored Procedure: GetBaseLineStatus <<<'
	drop procedure GetBaseLineStatus
END
IF EXISTS (select * from GxQscripts where name='GetBaseLineStatus')
	delete from GxQscripts where name = 'GetBaseLineStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetBaseLineStatus')
	delete from GXDBVersions where aliasname = 'GetBaseLineStatus'
GO
print '... Creating Procedure: GetBaseLineStatus'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetBaseLineStatus
  @inclientId INTEGER,
  @simpkgId INTEGER
AS
  DECLARE @o_baselineStatus INTEGER;
IF @simpkgId = 0
BEGIN
	set @o_baselineStatus = ISNULL((select dbo.simGetBaseline(sum(distinct BaseLine)) from simInstalledPackages where clientId = @inclientId), 8)
	set @o_baselineStatus =
		(case	when (@o_baselineStatus & 8) > 0 then 8		-- N/A
			when (@o_baselineStatus & 16) > 0 then 16		-- Diag
			when (@o_baselineStatus & 2) > 0 then 2		-- Behind
			when EXISTS (select * from simInstalledPackages where clientId=@inclientId and BaseLine=0) then 0		-- Unknown
			when (@o_baselineStatus & 4) > 0 then 4		-- Ahead
			when (@o_baselineStatus & 1) > 0 then 1		-- Uptodate
			else 0 end)
END
ELSE
	set @o_baselineStatus = ISNULL((select TOP 1 BaseLine from simInstalledPackages where clientId = @inclientId and simPackageID = @simpkgId), 8)
SELECT @o_baselineStatus
GO

IF EXISTS (select * from GxQscripts where name = 'GetBaseLineStatus')
	delete from GxQscripts where name = 'GetBaseLineStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetBaseLineStatus')
	delete from GXDBVersions where aliasname = 'GetBaseLineStatus'
GO

insert into GXDBVersions values(2, 'GetBaseLineStatus',  '00010007027600020000', 'GetBaseLineStatus', '00010007027600020000')
GO

