

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetBackupSetExtendedProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetBackupSetExtendedProperties <<<'

IF EXISTS (select * from sysobjects where name='GetBackupSetExtendedProperties')
	drop procedure GetBackupSetExtendedProperties
IF EXISTS (select * from GxQscripts where name='GetBackupSetExtendedProperties')
	delete from GxQscripts where name = 'GetBackupSetExtendedProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetBackupSetExtendedProperties')
	delete from GXDBVersions where aliasname = 'GetBackupSetExtendedProperties'
GO
print '... Creating Procedure: GetBackupSetExtendedProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetBackupSetExtendedProperties
  @i_entity XML ,
  @o_header XML OUTPUT ,
  @o_data XML OUTPUT
AS
-- GEnerates in header file
  DECLARE @header XML
  DECLARE @data XML
BEGIN
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @clientId INT
	DECLARE @appTypeId INT
	DECLARE @instanceId INT
	DECLARE @localeId INT
	SELECT
		@clientId = ISNULL(ref.value('@clientId', 'INT') , 0),
		@appTypeId = ISNULL(ref.value('@applicationId', 'INT'), 0),
		@instanceId = ISNULL(ref.value('@instanceId', 'INT'), 0),
		@localeId = ISNULL(ref.value('../@localeId', 'INT'), 0)
	FROM @i_entity.nodes ('App_ExtendedSummaryReq/entity') R(ref)
	DECLARE @entityHeaderTable TABLE (
		value	NVARCHAR(256),
		type	NVARCHAR(32),
		name	NVARCHAR(256)
	)
	INSERT @entityHeaderTable VALUES
		 ('//BackupSet/@name', 'string', 'Name')
		,('//BackupSet/@entityPropId', 'int', 'Id')
	SET @o_header = (
			SELECT [value] AS '@value',
				[type] AS '@type',
				[name] AS '@name'
			FROM @entityHeaderTable
			FOR XML PATH('query'),
				ROOT('header')
			)
	IF OBJECT_ID('tempdb.dbo.#entityValueTable') IS NOT null
		DROP TABLE #entityValueTable
	CREATE TABLE #entityValueTable  (
		name			NVARCHAR(255),
		entityPropId	INT PRIMARY KEY
	)
	INSERT INTO #entityValueTable (
		entityPropId,
		name
	)
	SELECT
		id,
		name
	FROM APP_BackupSetName
	WHERE id IN (
			SELECT backupSet
			FROM APP_Application
			WHERE clientId = @clientId
				AND appTypeId = @appTypeId
				AND instance = @instanceId
		)
	SET @o_data = (
			SELECT name AS '@name',
				entityPropId AS '@entityPropId'
			FROM  #entityValueTable
			FOR XML PATH('BackupSet'),
				ROOT('data')
			)
	SELECT @o_header header, @o_data data
END
GO

IF EXISTS (select * from GxQscripts where name = 'GetBackupSetExtendedProperties')
	delete from GxQscripts where name = 'GetBackupSetExtendedProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetBackupSetExtendedProperties')
	delete from GXDBVersions where aliasname = 'GetBackupSetExtendedProperties'
GO

insert into GXDBVersions values(2, 'GetBackupSetExtendedProperties',  '00000000000000000000', 'GetBackupSetExtendedProperties', '00000000000000000000')
GO

