

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetAutoScaleOptions.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "GetDataCenterList"
--	|	This Procedure is used to get the list of available data centers
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetAutoScaleOptions')
BEGIN
	print '>>> Drop Stored Procedure: GetAutoScaleOptions <<<'
	drop procedure GetAutoScaleOptions
END
IF EXISTS (select * from GxQscripts where name='GetAutoScaleOptions')
	delete from GxQscripts where name = 'GetAutoScaleOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetAutoScaleOptions')
	delete from GXDBVersions where aliasname = 'GetAutoScaleOptions'
GO
print '... Creating Procedure: GetAutoScaleOptions'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetAutoScaleOptions
-- Input arguments
  @request XML
AS
  DECLARE @o_xml XML
BEGIN TRY
--set @request = '<Ida_GetAutoScaleConfigInfoReq subclientId="218" />'
declare @errorCode   int = 0
declare @errorString  nvarchar(1024)
declare @subclientId INT
select @subclientId = isnull(@request.value('/Ida_GetAutoScaleConfigInfoReq[1]/@subclientId', 'int'),0)
if @subclientId = 0
BEGIN
	SET @errorCode = 1
    SET @errorString = 'Subclient id is not provided in the request'
    GOTO ERROR_EXIT
END
declare @planId INT = NULL
select @planId = CAST(SP.attrval AS int)
from APP_Application A INNER JOIN APP_SubClientProp SP ON SP.attrName = 'Associated plan' AND SP.modified = 0 AND A.id = SP.componentNameId
where A.id = @subclientId
declare @rpoInMin INT = NULL
declare @backupCopyRpoInMin INT = NULL
DECLARE @i_subtaskId INT -- subtaskid of backup schedule.
DECLARE @clientTimeZone nvarchar(max)
DECLARE @freqTypeFromPattern INT , @freqIntervalFromPattern INT
set @clientTimeZone = dbo.getclienttimezone(2)
if(@planId IS NOT NULL)
begin
    -- fetch the rpo in mins based on continuous, or daily/weekly/monthly schedules
	select @i_subtaskId = subTaskId from TM_SubTask
where taskId=dbo.AppPlanGetEntityValueV2(@planId, 'Schedule policy',  default)
			and (flags&65536)>0 -- get subtask of backup schedule
	SELECT @freqIntervalFromPattern = P.freq_interval, @freqTypeFromPattern = P.freq_type
	FROM TM_PatternAssoc (NOLOCK) PA JOIN TM_Pattern (NOLOCK) P ON P.patternId = PA.patternId AND PA.subTaskId = @i_subtaskId
	IF isnull(@freqTypeFromPattern,0) = 4096 -- continuous.. its in hours.. you can retain earlier logic
	BEGIN
SELECT @rpoInMin = ISNULL(dbo.AppPlanGetEntityValueV2(@planId ,'RPO In Minutes', default), 0)
	END
	ELSE
	BEGIN
		   -- need to retrieve from runtime tables
		  select  @rpoInMin = datediff(mi, GETUTCDATE() , dbo.ClientLocalToUTCTime( RTA.nextRunTime,2))
		   FROM TM_RunTime RT WITH (NOLOCK)
		   INNER JOIN TM_PatternAssoc PA WITH (NOLOCK) ON RT.patternId = PA.patternId
		   INNER JOIN TM_PATTERN P WITH (NOLOCK) ON P.patternId = PA.patternId AND PA.subTaskId = @i_subtaskId
		   INNER JOIN TM_RunTimeAssoc RTA WITH (NOLOCK) on RTA.runtimeId=RT.runtimeId
		   WHERE RTA.processed = 0
		   AND RTA.timezoneNames = @clientTimeZone
	END
	SELECT @backupCopyRpoInMin = (freq_interval) FROM TM_Pattern P
	INNER JOIN TM_PatternAssoc PA ON P.patternId = PA.patternId
	INNER JOIN TM_Subtask ST ON PA.subTaskId = ST.subTaskId
	INNER JOIN TM_Task T ON ST.taskId = T.taskId AND T.disabled = 0 AND T.deleted = 0
	LEFT JOIN TM_AssocEntity AE ON AE.taskId = T.taskId
WHERE AE.policyId = ISNULL(dbo.AppPlanGetEntityValueV2(@planId, 'Storage policy',  default), 0)
	AND ST.operationType = 4028/*SNAP_TO_TAPE*/ AND ST.deleted = 0
end
if ISNULL(@rpoInMin,0) = 0
	set	@rpoInMin = 1440 -- setting default value to 24 hours.
if ISNULL(@backupCopyRpoInMin,0) = 0
	set	@backupCopyRpoInMin = 1440 -- setting default value to 24 hours.
---- vmSize and throughput calculation ---
IF object_id('tempdb.dbo.#AutoScaleStats') IS NOT NULL
    DROP TABLE #AutoScaleStats
CREATE TABLE #AutoScaleStats
(
	jobId	int,
	vmClientId int,
	agentName nvarchar(1024),
	vmGuid	nvarchar(1024),
	vmBackupStartTime int,
	vmBackupEndTime int,
	vmSize BIGINT,
	vmThroughPutGBPerHour int
)
insert into #AutoScaleStats (jobId, vmClientId)
select P.jobId, VMclientId
from APP_vmProp P inner join JMBkpStats B on P.jobId = B.jobId
where B.appId = @subclientId and B.status = 1 -- only succuessful backup jobs
and B.opType != 59 -- skip snap backup jobs
group by P.jobId, P.VMclientId
update #AutoScaleStats
set agentName = (SELECT attrVal	FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.vmClientId = A.vmClientId AND attrName = 'vmAgent'),
vmGuid = (SELECT attrVal	FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.vmClientId = A.vmClientId AND attrName = 'vmGUID'),
vmBackupStartTime = (SELECT attrVal	FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.vmClientId = A.vmClientId AND attrName = 'vmBackupStartTime'),
vmBackupEndTime = (SELECT attrVal	FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.vmClientId = A.vmClientId AND attrName = 'vmBackupEndTime'),
vmSize = (SELECT attrVal FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.vmClientId = A.vmClientId AND attrName = 'vmUsedSpace')
from #AutoScaleStats V
delete from #AutoScaleStats where vmBackupStartTime = vmBackupEndTime
delete from #AutoScaleStats where vmsize =0
update #AutoScaleStats
set vmThroughPutGBPerHour = vmSize / 1024/1024/1024 / ((vmBackupEndTime - vmBackupStartTime) / 60.0 / 60.0)
declare @avgThrouputGBPerHour INT = NULL
declare @avgVmSizeGB INT = NULL
select @avgThrouputGBPerHour = avg(V.vmThroughPutGBPerHour) from #AutoScaleStats V
select @avgVmSizeGB = avg(V.vmSize)/1024/1024/1024 from #AutoScaleStats V
DECLARE @instanceId INT
select TOP 1 @instanceId = instance from APP_Application where id = @subclientId and appTypeId = 106
--Check Admin account
declare @adminInstanceId INT = 0
select @adminInstanceId = cast (attrVal as int) from APP_InstanceProp where componentNameId = @instanceId and attrName = 'Amazon Admin Instance Id' and modified = 0
if isNull(@adminInstanceId,0) > 0
begin
	set @instanceId = @adminInstanceId
end
--Check Instance Type for AvgThroughput of Azure RM
DECLARE @instanceType INT = NULL
SELECT @instanceType = attrVal from APP_InstanceProp where componentNameId = @instanceId and attrName = 'Virtual Server Instance Type'
--SET default average throughput
if(isnull(@avgThrouputGBPerHour,0) =0 )
begin
IF(@instanceType = 402)
BEGIN
	set @avgThrouputGBPerHour = 100 --setting default throughput 100 GB/hr for Azure RM
END
else
begin
declare @AutoScaleOptions xml
select @AutoScaleOptions = cast(value as XML)  from GXGlobalParam where name = 'AutoScaleOptions' and modified =0
	select @avgThrouputGBPerHour = @AutoScaleOptions.value('(AutoScaleOptions/Amazon/DataThroughputGBPerHour)[1]', 'INT')
	if ISNULL(@avgThrouputGBPerHour,0) = 0
		set	@avgThrouputGBPerHour = 30 -- setting default value to 30 GB/hr
end
end
--set default vm size
if(@avgVmSizeGB is NULL)
	set @avgVmSizeGB = 100 -- setting default vm size to 100 GB
DECLARE @vmAllocPolicyId INT
declare @policyMaxAgentLimitPerRegion INT
declare @clientGroupId int
-- Max Agent limit
select  @vmAllocPolicyId  = cast (attrVal as int) FROM APP_InstanceProp WHERE componentNameId= @instanceId AND attrName='Auto Scale Policy'
select @policyMaxAgentLimitPerRegion =  ISNULL(c.value('(scaleOption/scaleOutParam/@maxVMthreshold)[1]', 'INT'),0),
	   @clientGroupId = ISNULL(c.value('(associatedClientGroup/@clientGroupId)[1]', 'INT'),0)
from App_VmAllocationPolicy P
CROSS APPLY P.vxml.nodes ('policy') T(c)
where P.id = @vmAllocPolicyId and alive = 1
	--Fetch running autoProxy jobs in the same region, os and virtualization client
	 IF object_id('tempdb.dbo.#regionAutoProxyList') IS NOT null DROP TABLE #regionAutoProxyList
		create table #regionAutoProxyList(
                                region         nvarchar(256),
								proxyCount	   int,
								runningJobs    int
								)
	insert into #regionAutoProxyList
	select CP1.attrval,  count(*),0
		from APP_ClientProp CP1
		INNER JOIN APP_ClientProp CP2 on CP1.componentNameId = CP2.componentNameId
		INNER JOIN APP_ClientProp CP3 on CP1.componentNameId = CP3.componentNameId
		INNER JOIN APP_Client C on CP1.componentNameId = C.id
		and CP1.attrName = 'VSA DataCenter Name'
		and CP2.attrName = 'Auto Proxy Client' and CP2.attrVal = 1
		and CP3.attrName = 'Virtual Machine Instance ID' and CP3.attrVal = @instanceId
		inner join app_clientgroupassoc cga
		on cga.clientGroupId = @clientGroupId
		and cga.clientId = cp1.componentNameId
		group by Cp1.ATTRVAL
	--Fetch running autoProxy jobs in the same region, os and virtualization client
	 IF object_id('tempdb.dbo.#runningAutoProxyJobs') IS NOT null DROP TABLE #runningAutoProxyJobs
		create table #runningAutoProxyJobs(
                                jobId		   int,
                                jobOptionsXml  xml,
                                region         nvarchar(256),
                                osType         int,
								virtualizationClientId int,
								instanceId int
								)
	insert into #runningAutoProxyJobs (jobId,jobOptionsXml)
	select JI.jobId, (CAST(T1.value as xml))
	from JMJobInfo JI INNER JOIN JMAdminJobInfoTable JA ON JI.jobId = JA.jobId AND JI.opType = 85
INNER JOIN TM_JobOptions T1 on T1.jobId = JI.jobId AND T1.optionId = 30050685
INNER JOIN TM_JobOptions T2 on T2.jobId = JI.jobId AND T2.optionId = 1815939405 AND ISNULL(CAST(T2.value as INT),0) = 49
	 update #runningAutoProxyJobs
	 set region = C.value('vmLocation[1]/@dataCenterName', 'nvarchar(1024)'),
	 osType = C.value('@osType','int'),
	 virtualizationClientId = C.value('vmLocation[1]/virtualizationClient[1]/@clientId','int')
	 from #runningAutoProxyJobs A
	 cross apply A.jobOptionsXml.nodes('virtualMachineOption[1]/vmInfo[1]') T(C)
	 --Replace any tenantAdmin clients with admin account
	 update #runningAutoProxyJobs
	 set virtualizationClientId = isNull((SELECT TOP 1 clientId FROM APP_Application WITH(NOLOCK) WHERE instance = cast (IP.attrVal as int) AND appTypeId = 106),J.virtualizationClientId)
	 from #runningAutoProxyJobs J
	 inner join APP_Application A on A.appTypeId = 106 and A.clientId = J.virtualizationClientId and A.subclientStatus & 8 > 0
	 inner  join APP_InstanceProp IP on IP.componentNameId = A.instance and attrName = 'Amazon Admin Instance Id' and IP.modified = 0
	 update #runningAutoProxyJobs
	 set instanceId = instance
	 from app_application where clientid = virtualizationClientId and subclientStatus & 8 > 0
	 and apptypeId = 106
	 delete #runningAutoProxyJobs where instanceId != @instanceId
	 update RAP
	 set runningJobs = T.jobs
	 	 from #regionAutoProxyList RAP
		 inner join
	 (select region, count(jobid) as jobs
	 from #runningAutoProxyJobs
	 group by region ) T
	 ON RAP.region = T.region
	 insert into #regionAutoProxyList
	 select region , 0, count(*)
	 from #runningAutoProxyJobs
	 where  not exists ( select 1 from #regionAutoProxyList PL where PL.region = region )
	 group by region
 	 --inserting configured regions from the autoscale settings even though there is no runningproxy/existingagent available
	 insert into #regionAutoProxyList
	 select ISNULL(c.value('@regionName', 'nvarchar(256)'),'') , 0, 0
		from App_VmAllocationPolicy P
		CROSS APPLY P.vxml.nodes ('policy/scaleOption/scaleOutParam/regionSpecificInfo') T(c)
		where P.id = @vmAllocPolicyId and alive = 1 and not exists ( select 1 from #regionAutoProxyList PL where PL.region = ISNULL(c.value('@regionName', 'nvarchar(256)'),'') )
SET @o_xml = (SELECT @rpoInMin AS '@rpoInMin',
					@backupCopyRpoInMin AS '@backupCopyRpoInMin',
					@avgThrouputGBPerHour AS '@dataThroughputGBPerHour',
					@policyMaxAgentLimitPerRegion AS '@policyMaxAgentLimitPerRegion',
					@avgVmSizeGB AS '@averageVmSizeGB',
						( select P.region as '@region',
						         P.proxyCount as '@existingAgents',
								 (select jobid as 'text()'
								  from #runningAutoProxyJobs J
								  where J.region = P.region
								  for xml path ('activeJob'), TYPE
								 )
								 from #regionAutoProxyList P
								 for xml path ('regionAgentInfo'), TYPE
						)
                            FOR XML PATH('Ida_AutoScaleConfigInfoResp'), TYPE)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @errorCode = ERROR_NUMBER()
SET @errorString = ERROR_MESSAGE()
END CATCH
ERROR_EXIT:
IF @errorCode <> 0
BEGIN
	SET @o_xml = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
                            FOR XML PATH('Ida_GenericResp'), TYPE)
END
select @o_xml as 'o_xml'
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'GetAutoScaleOptions')
	delete from GxQscripts where name = 'GetAutoScaleOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetAutoScaleOptions')
	delete from GXDBVersions where aliasname = 'GetAutoScaleOptions'
GO

insert into GXDBVersions values(2, 'GetAutoScaleOptions',  '00000000000000000000', 'GetAutoScaleOptions', '00000000000000000000')
GO

