

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetAssociatedEntities.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetAssociatedEntities.sp,v $ $Id: GetAssociatedEntities.sp,v 1.43.46.17.14.1 2021/03/04 22:19:16 mnatarajan Exp $";
--  +========================================================================+
--  | Stored Precedure: List all entities to the mentioned level in the hierarchy.
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetAssociatedEntities')
BEGIN
	print '>>> Drop Stored Procedure: GetAssociatedEntities <<<'
	drop procedure GetAssociatedEntities
END
IF EXISTS (select * from GxQscripts where name='GetAssociatedEntities')
	delete from GxQscripts where name = 'GetAssociatedEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetAssociatedEntities')
	delete from GXDBVersions where aliasname = 'GetAssociatedEntities'
GO
print '... Creating Procedure: GetAssociatedEntities'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetAssociatedEntities
  @inputxml XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @outputCorrectEntities nvarchar(max)
declare @outputEntities nvarchar(max)
declare @errorEntities nvarchar(max)
declare @i_localeId int
DECLARE @level integer
DECLARE @noOfEntities integer
DECLARE @userId int
DECLARE @localeId int
DECLARE @allAssociations int
DECLARE @commcellParam int
DECLARE @status int
DECLARE @isNestedCall int
DECLARE @adminUserFlags int
DECLARE @adminUserId int
set @adminUserFlags = 0x040
SET @adminUserId = (SELECT TOP 1 UMUsers.id FROM UMUsers WHERE ((UMUsers.flags & @adminUserFlags) <> 0) and enabled =1)
if @adminUserId is null
begin
	set @adminUserId = 1
end
set @commcellParam = 2
set @outputCorrectEntities = ''
set @errorEntities = ''
SET @i_localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS Agent
      FROM    @inputXml.nodes('App_GetAssociatedEntities/processinginstructioninfo/locale') R ( ref )),0)
set @isNestedCall = ISNULL((SELECT  ref.value('@isNestedCall', 'int') AS Agent
      FROM    @inputXml.nodes('App_GetAssociatedEntities/processinginstructioninfo') R ( ref )),0)
SET @level = ISNULL (( SELECT ref.value('@expandLevel', 'INTEGER')
	  FROM @inputxml.nodes('App_GetAssociatedEntities') R(ref)), 3)
SET @noOfEntities = ISNULL((SELECT  ref.value('@noOfEntities', 'int') AS Agent
      FROM    @inputXml.nodes('App_GetAssociatedEntities') R ( ref )),0)
-- Incorporating security for GetStarted here. By default admin so that other modules dont get affected now.
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS Agent
                         FROM    @inputXml.nodes('App_GetAssociatedEntities/processinginstructioninfo/user') R ( ref )),@adminUserId)
SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS Agent
                         FROM    @inputXml.nodes('App_GetAssociatedEntities/processinginstructioninfo/locale') R ( ref )),0)
-- All status to be selected by default. No filter. 0 to indicate that
SET @status = ISNULL((SELECT  ref.value('@status', 'int') AS Agent
						FROM    @inputXml.nodes('App_GetAssociatedEntities') R ( ref )),0)
SET @allAssociations = 0
IF OBJECT_ID('tempdb.dbo.#getNonIdaObjects') IS NOT NULL
	DROP TABLE #getNonIdaObjects
CREATE TABLE #getNonIdaObjects (entityId INT)
IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
	DROP TABLE #getIdaObjects
CREATE TABLE #getIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
-- If the level is 1, then COMMCELL entity is to be returned. No security check needed for retrieving Commcell Name
if @level=1
begin
	select @inputxml = IsNull((select aliasName as 'entity/@commCellName',
		1 as 'entity/@_type_'
		from APP_CommCell
		where id=2
		for xml path('response'),root('App_GenericResponse')),'<App_GenericResponse/>')
	-- If this call is coming from another SP like getStarted, result shld be returned in output parameter
	-- rather than via select. So that it doesnt interfere with outer query results
	if @isNestedCall = 0
	begin
		select @inputxml
	end
	return
end
if @level=10 OR @level=11
begin
	declare @mediaAgentIds table
	(
		mediaAgentId int
	)
	Insert into @mediaAgentIds
	SELECT  ref.value('@mediaAgentId', 'int') AS Agent
	FROM    @inputxml.nodes('App_GetAssociatedEntities/entity') R ( ref )
	-- If the level is 10,_ALL_MEDIAAGENTS_ then add all mediaAgents to the array.
if @level=10
	begin
		Insert into @mediaAgentIds
		select clientId from MMHost
	end
	if @noOfEntities=0
	begin
		select @noOfEntities = Count(*) from @mediaAgentIds
	end
EXEC sec_getNonIdaObjectsForThisUser @userId,11,0,'#getNonIdaObjects'
EXEC sec_getIdaObjectsForUser @userID,3,0,1,'#getIdaObjects'
	select @inputxml = IsNull((
		SELECT distinct top (@noOfEntities) mh.clientid as 'entity/@mediaAgentId',
11 as 'entity/@_type_',
		cl.name as 'entity/@mediaAgentName',
		cl.modified as 'entity/@modifiedTime' -- this tag is not present in GenericEntity. Its mainly selected for OrderBy.
		FROM  MMHost as mh WITH (NOLOCK) inner join APP_Client as cl WITH (NOLOCK)
		on  mh.clientid = cl.id
		-- and mh.MmHostEnabled = 1 -- We want only enabled media agents
		where mh.clientid > 1 and
		cl.id not in (select APP_VMToPMMap.PMClientId from APP_VMToPMMap where APP_VMToPMMap.VMClientId = 2)
		and mh.ClientId in
		(
			select mediaAgentId from @mediaAgentIds
		)
		-- Now return only mediaAgents which are accessibile. Either we shld check for media agent
		-- accessibility or client accessibility.
		and mh.clientID IN
		(
			SELECT Sec.entityId FROM #getNonIdaObjects Sec
			UNION
			SELECT Sec1.clientId FROM #getIdaObjects Sec1
		)
		order by cl.modified desc
		for XML PATH('response'), root('App_GenericResponse')),'<App_GenericResponse/>')
	-- If this call is coming from another SP like getStarted, result shld be returned in output parameter
	-- rather than via select. So that it doesnt interfere with outer query results
	if @isNestedCall = 0
	begin
		select @inputxml
	end
	return
end
if @level=34 OR @level=35
begin
	--select * from  @inputRequestList
	declare @taskReqXml xml
	set @taskReqXml ='<TMMsg_GetTaskListReq><filter policy="1"/></TMMsg_GetTaskListReq>'
	exec dbo.TM_GetPolicyTaskList @userId,@i_localeId,@taskReqXml output
	declare @taskIds table
	(
		taskId int
	)
if @level=35
	begin
		Insert into @taskIds
		SELECT  ref.value('@schedulePolicyId', 'int') AS Agent
		FROM    @inputxml.nodes('App_GetAssociatedEntities/entity') R ( ref )
	end
else if @level=34
	begin
		Insert into @taskIds
		SELECT  taskId
		FROM    TM_Task
	end
	if @noOfEntities=0
	begin
		select @noOfEntities = Count(*) from TM_Task
	end
	declare @taskRespEntries table
	(
		taskId int
	)
	declare @taskRespXml xml
	set @taskRespXml = @taskReqXml
	Insert into @taskRespEntries
	SELECT  ref.value('@taskId', 'int') AS Agent
		FROM    @taskRespXml.nodes('/TMMsg_GetTaskListResp/taskDetail/task') R ( ref )
	select @inputxml = IsNull((select top (@noOfEntities) taskId as 'entity/@schedulePolicyId',
35 as 'entity/@_type_',
	taskName as 'entity/@schedulePolicyName',
	modified as 'entity/@modifiedTime' -- this tag is not present in GenericEntity. Its mainly selected for OrderBy.
	from TM_Task
	where [TM_Task].[deleted] = 0
    AND [TM_Task].[invalid] = 0
    AND [TM_Task].[uninstalled] = 0
    AND [TM_Task].[taskType] = 4
	and taskId in
	(
		select T.taskId from @taskIds T
	)
	and taskId in
	(
		select T.taskId from @taskRespEntries T
	)
	and taskName != 'System Created for DDB subclients'
	and taskId not in (
	-- We dont want content store Task Ids here. Temporarily we will do it here.. We will parameterise it soon
	SELECT  TFIL.taskId
          FROM      TM_AssocFilter AS TFIL WITH (NOLOCK),
          APP_iDAType as AIT
          WHERE     TFIL.filter_type = 2
          AND AIT.name='Content Store'
		  AND TFIL.filter_value = AIT.type
	)
	order by TM_Task.modified desc
	for xml path('response'),root('App_GenericResponse')),'<App_GenericResponse/>')
	-- If this call is coming from another SP like getStarted, result shld be returned in output parameter
	-- rather than via select. So that it doesnt interfere with outer query results
	if @isNestedCall = 0
	begin
		select @inputxml
	end
	return
end
if @level=8 OR @level=9
begin
	declare @libraryIds table
	(
		libraryId int
	)
	declare @libraryMAAssociation table
	(
		libraryId int,
		MAId	  int
	)
	IF OBJECT_ID('tempdb.dbo.#MAsWithManageCapability') IS NOT NULL
		DROP TABLE #MAsWithManageCapability
	CREATE TABLE #MAsWithManageCapability (entityID INT)
	IF OBJECT_ID('tempdb.dbo.#ClientsWithManageCapability') IS NOT NULL
		DROP TABLE #ClientsWithManageCapability
	CREATE TABLE #ClientsWithManageCapability (clientId INT, appTypeId INT, instanceID INT, backupsetID INT, subclientID INT)
EXEC sec_getNonIdaObjectsForThisUser @userId,9,0,'#getNonIdaObjects'
EXEC sec_getNonIdaObjectsForThisUser @userId,11,2,'#MAsWithManageCapability'
EXEC sec_getIdaObjectsForUser @userId,3,2,0,'#ClientsWithManageCapability'
if @level=9
	begin
		Insert into @libraryIds
		SELECT  ref.value('@libraryId', 'int') AS Agent
		FROM    @inputxml.nodes('App_GetAssociatedEntities/entity') R ( ref )
	end
else if @level=8
	begin
		Insert into @libraryIds
		SELECT  LibraryId
		FROM    MMLibrary
	end
	Insert into @libraryMAAssociation
	select LibraryId,ClientId from MMLibraryController as LC
	where LibraryId in
	(
		select * from @libraryIds
	)
	if @noOfEntities=0
	begin
		select @noOfEntities = Count(*) from @libraryIds
	end
	select @inputxml = IsNull((select top (@noOfEntities) LibraryId as 'entity/@libraryId',
9 as 'entity/@_type_',
		AliasName as 'entity/@libraryName'
		from MMLibrary
		where --LibraryEnabled=1 and
		LibraryId in
		(
			select libraryId from @libraryIds
		)
		and LibraryId > 0
			-- Now return only libraries which are accessibile. Check for capability at library level or
			-- canManageMediaAgent shld be true for one of its mediaagents
		and (
			exists (SELECT 1 FROM #getNonIdaObjects Sec WHERE Sec.entityID = MMLibrary.LibraryId
			)
			 OR MMLibrary.LibraryId in
			(
				select libraryId from @libraryMAAssociation
				where MAId in
				(
					select VisMA.entityID from #MAsWithManageCapability VisMA
					union
					select VisCl.clientId from #ClientsWithManageCapability VisCl
				)
			)
		)
		order by MMLibrary.LibraryId desc
		for xml path('response'),root('App_GenericResponse')),'<App_GenericResponse/>')
	-- If this call is coming from another SP like getStarted, result shld be returned in output parameter
	-- rather than via select. So that it doesnt interfere with outer query results
	if @isNestedCall = 0
	begin
		select @inputxml
	end
	DROP TABLE #MAsWithManageCapability
	DROP TABLE #ClientsWithManageCapability
	return
end
if @level=16 OR @level=17
begin
	declare @storagePolicyIds table
	(
		storagePolicyId int
	)
if @level=17
	begin
		Insert into @storagePolicyIds
		SELECT  ref.value('@storagePolicyId', 'int') AS Agent
		FROM    @inputxml.nodes('App_GetAssociatedEntities/entity') R ( ref )
	end
else if @level=16
	begin
		Insert into @storagePolicyIds
		SELECT  id
		from archGroup
		where id!=1
	end
	if @noOfEntities=0
	begin
		select @noOfEntities = Count(*) from @storagePolicyIds
	end
EXEC sec_getNonIdaObjectsForThisUser @userId,17,0,'#getNonIdaObjects'
	--CVA_SP_FREEZE_ASSOCIATION_FLAG to check whether storage policy is disabled or not.
	select @inputxml =  IsNull((select top (@noOfEntities) AG.id as 'entity/@storagePolicyId',
17 as 'entity/@_type_',
	AG.name as 'entity/@storagePolicyName',
	AGC.name as 'entity/@copyName'
	from archGroup AG WITH (NOLOCK)
	left join archGroupCopy AGC WITH (NOLOCK) on
	AG.defaultCopy = AGC.id
	where (AG.flags & 64)=0
	and AG.type!=2	-- Currently we dont want DR storage policies.
	and AG.type!=4  -- We dont want analytics policy also
	and AG.id in
	(
		select storagePolicyId from @storagePolicyIds
	)
	and ( AG.id in
			(
				select entityID FROM #getNonIdaObjects sec
			)
	)
	order by AG.id desc
	for xml path('response'),root('App_GenericResponse')),'<App_GenericResponse/>')
	-- If this call is coming from another SP like getStarted, result shld be returned in output parameter
	-- rather than via select. So that it doesnt interfere with outer query results
	if @isNestedCall = 0
	begin
		select @inputxml
	end
	return
end
-- No security check for subclient policies displayed. The security check is for subclient (of the policy).
if @level=43 OR @level=65
begin
	declare @subclientPolicyIds table
	(
		subclientPolicyId int
	)
if @level=65
	begin
		Insert into @subclientPolicyIds
			SELECT  ref.value('@subclientPolicyId', 'int') AS Agent
			FROM    @inputxml.nodes('App_GetAssociatedEntities/entity') R ( ref )
	end
	else
	begin
		Insert into @subclientPolicyIds
		select componentNameId
		from APP_BackupSetProp WITH (NOLOCK)
		where attrName='Associated subclient Policy Ida Type'
		and modified=0
	end
	if @noOfEntities=0
	begin
		select @noOfEntities = Count(*) from @subclientPolicyIds
	end
EXEC sec_getIdaObjectsForUser @userID,6,0,1,'#getIdaObjects'
	delete @subclientPolicyIds
	where
		subclientPolicyId not in (select backupsetID
								  from #getIdaObjects
								  where
										clientID = 2 and apptypeId = 1030)
	select @inputxml =  IsNull((select top (@noOfEntities) id as 'entity/@subclientPolicyId',
65 as 'entity/@_type_',
	name as 'entity/@subclientPolicyName',
	modified as 'entity/@modifiedTime' -- this tag is not present in GenericEntity. Its mainly selected for OrderBy.
	from APP_BackupSetName	WITH (NOLOCK)
	where id in
	(
		select subclientPolicyId from @subclientPolicyIds
	)
	and (status & 128)>0
	order by modified desc
	for xml path('response'),root('App_GenericResponse')),'<App_GenericResponse/>')
	-- If this call is coming from another SP like getStarted, result shld be returned in output parameter
	-- rather than via select. So that it doesnt interfere with outer query results
	if @isNestedCall = 0
	begin
		select @inputxml
	end
	return
end
if @level=112
begin
	DECLARE @filteredUMDSProviders TABLE ( id   INT, domainName nvarchar(max) )
	if (dbo.isNewSecurity() = 0)
	BEGIN
		declare @isHideEnabledAD int
		declare @canManageAllUsers int
		set @isHideEnabledAD = 1
		exec sec_isHideEnabled @userId,0,@isHideEnabledAD output
		if @isHideEnabledAD=1
		begin
			set @canManageAllUsers = 0
			exec sec_canManageAllUsers @userId,@canManageAllUsers output
			if @canManageAllUsers=0
			begin
				select @inputxml = '<App_GenericResponse/>'
				-- If this call is coming from another SP like getStarted, result shld be returned in output parameter
				-- rather than via select. So that it doesnt interfere with outer query results
				if @isNestedCall = 0
				begin
					select @inputxml
				end
				return
			end
		end
		--now do filtering based on the capabilities of user
		DECLARE @tempProviderId INT
		declare @tempProviderName nvarchar(max)
		DECLARE @canSeeProvider INT
		DECLARE providerCursor CURSOR
		FOR SELECT [id],domainName FROM UMDSProviders
		OPEN providerCursor
		FETCH providerCursor INTO @tempProviderId,@tempProviderName
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @canSeeProvider = 0
			EXEC sec_canSeeOrManageNameServer  @userId, @tempProviderId, 1, 0, 0, @canSeeProvider OUTPUT
			IF @canSeeProvider = 1
			BEGIN
				INSERT INTO @filteredUMDSProviders VALUES (@tempProviderId,@tempProviderName)
			END
			FETCH providerCursor INTO @tempProviderId,@tempProviderName
		END
		CLOSE providerCursor
		DEALLOCATE providerCursor
	end
	ELSE
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#GetAssociatedEntitiesNameServersTbl') IS NOT NULL
			DROP TABLE #GetAssociatedEntitiesNameServersTbl
		CREATE TABLE #GetAssociatedEntitiesNameServersTbl (nameServersId INT)
		EXEC sec_getNameServersForThisUser '#GetAssociatedEntitiesNameServersTbl', @userId, 0
		INSERT INTO @filteredUMDSProviders(id)
			SELECT DISTINCT nameServersId
			FROM #GetAssociatedEntitiesNameServersTbl
		IF OBJECT_ID('tempdb.dbo.#GetAssociatedEntitiesNameServersTbl') IS NOT NULL
			DROP TABLE #GetAssociatedEntitiesNameServersTbl
		UPDATE Tbl
		SET Tbl.domainName = Provider.domainName
		FROM @filteredUMDSProviders Tbl INNER JOIN UMDSProviders Provider
		ON Tbl.id = Provider.id
	END
	select @inputxml = IsNull((select top (@noOfEntities) t.id as 'entity/@activeDirectoryId',
	t.domainName as 'entity/@activeDirectoryName'
	from @filteredUMDSProviders	t
	where t.id > 0
	for xml path('response'),root('App_GenericResponse')),'<App_GenericResponse/>')
	-- If this call is coming from another SP like getStarted, result shld be returned in output parameter
	-- rather than via select. So that it doesnt interfere with outer query results
	if @isNestedCall = 0
	begin
		select @inputxml
	end
	return
end
if @level=107
begin
	set @inputXml = (select @userId '@userId',
		@isNestedCall 'processinginstructioninfo/@isNestedCall'
		 for xml path('EVGui_MMSMGetArrayListReq'))
	exec dbo.MM_SMXMLGetArrays @inputXml output
	select @inputxml = IsNull((
		select ArrayId as 'entity/@scratchPoolId',
		ArrayName as 'entity/@scratchPoolName',
		VendorName as 'entity/@libraryName' -- Using other attributes from genericentity
		--since ArrayVolumeEntity is not part of genericentity
		 from
		(
			select top (@noOfEntities) ref.value('arrayName[1]/@id', 'int') AS ArrayId,
			ref.value('arrayName[1]/@name', 'nvarchar(max)') AS ArrayName,
			ref.value('vendor[1]/@name', 'nvarchar(max)') AS VendorName
			FROM    @inputxml.nodes('EVGui_MMSMGetArrayListResp/arrayList') R ( ref )
		) t
		where ArrayId != 0
	for xml path('response'),root('App_GenericResponse')),'<App_GenericResponse/>')
	-- If this call is coming from another SP like getStarted, result shld be returned in output parameter
	-- rather than via select. So that it doesnt interfere with outer query results
	if @isNestedCall = 0
	begin
		select @inputxml
	end
	return
end
DECLARE @returnAppNameInsteadOfAppDisplayName INT = 0
SELECT @returnAppNameInsteadOfAppDisplayName = CONVERT(INT,Value) FROM GxGlobalParam WITH (NOLOCK)
WHERE name='bUseAppNameForAgentName' AND modified = 0
create table #inEntity
(
		commcellId integer ,
		clientId integer ,
		appType integer ,
		instanceId integer ,
		backupsetId integer ,
		subclientId integer ,
		clientgroupId integer,
		appGroupId integer,
		excludeEntity integer,
		getDeconfigured integer,
		getDeleted integer,
		clientName nvarchar(max),
		appName	nvarchar(max),
		instanceName nvarchar(max),
		backupSetName nvarchar(max),
		clientGroupName	nvarchar(max),
		appGroupName nvarchar(max),
		errorString nvarchar(max),
		errorCode bigint,
		entityName nvarchar(max)
)
-- The basic rules for filtering out entities are as follows:
-- 1) By Default all clients including Deconfigured clients,IDAs, backupsets and subclients are returned
-- 2) By default all entries of 1000 apptype id is not returned
-- 3) HAVING INCLUDE / EXCLUDE IN ENTITY FLAGS IS NOT MEANGINGFULL
-- INTEPRETING THEM AS BELOW
-- excludeEntity - true (excludeEntity dummy/hidden)
-- getDeconfigured - true (include deconfigured - by Default) false(excludeEntity deconfigured)
-- getDeleted - true(include getDeleted ) false(excludeEntity getDeleted - by Default)
SET @i_localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS Agent
      FROM    @inputXml.nodes('App_GetAssociatedEntities/processinginstructioninfo/locale') R ( ref )),0)
insert into #inEntity
SELECT
ISNULL(Tbl.Col.value('@commCellId', 'int'),2) ,
ISNULL(Tbl.Col.value('@clientId', 'int'),0),
ISNULL(Tbl.Col.value('@applicationId', 'int'),0) ,
ISNULL(Tbl.Col.value('@instanceId', 'int'),0),
ISNULL(Tbl.Col.value('@backupsetId', 'int'),0),
ISNULL(Tbl.Col.value('@subclientId', 'int'),0),
ISNULL(Tbl.Col.value('@clientGroupId', 'int'),0),
ISNULL(Tbl.Col.value('@appGroupId', 'int'),0), -- App GroupId
ISNULL(Tbl.Col.value('(flags/@exclude)[1]', 'int'),1),
ISNULL(Tbl.Col.value('(flags/@disabled)[1]', 'int'),1),
ISNULL(Tbl.Col.value('(flags/@deleted)[1]', 'int'),0),
ISNULL(Tbl.Col.value('@clientName', 'nvarchar(max)'),''),
ISNULL(Tbl.Col.value('@appName', 'nvarchar(max)'),''),
ISNULL(Tbl.Col.value('@instanceName', 'nvarchar(max)'),''),
ISNULL(Tbl.Col.value('@backupsetName', 'nvarchar(max)'),''),
ISNULL(Tbl.Col.value('@clientGroupName', 'nvarchar(max)'),''),
ISNULL(Tbl.Col.value('@appGroupName', 'nvarchar(max)'),''),
'', -- As errorString
0, -- As errorCode
'' -- As entityname
FROM @inputXml.nodes('/App_GetAssociatedEntities/entity') as Tbl(Col)
DECLARE @COUNT INTEGER
if (@level=27)
begin
	Insert into #inEntity
	select 2,0,0,0,0,0,id,0,1,1,0,'','','','','','','', 0, '' -- As entityname
	from APP_ClientGroup WITH (NOLOCK)
set @level = 3
	--select * from #inEntity
end
else if (@level=2)
begin
	Insert into #inEntity
	select 2,id,0,0,0,0,0,0,1,1,0,'','','','','','','', 0, ''
	from APP_Client WITH (NOLOCK)
	where id!=1
	--select * from #inEntity
end
SELECT @COUNT = COUNT(*)
FROM #inEntity
IF @COUNT > 0
BEGIN
	DECLARE @entitycur CURSOR
	DECLARE @commcellId integer
	DECLARE @clientGroupId integer
	DECLARE @clientId integer
	DECLARE @applicationId integer
	DECLARE @applicationGroupId integer
	DECLARE @instanceId integer
	DECLARE @backupsetId integer
	DECLARE @subclientId integer
	DECLARE @excludeEntity integer
	DECLARE @getDeconfigured integer
	DECLARE @getDeleted integer
	-- Adding client name, ida name, instance , backupset and subclient name to this table.
	-- So that these names can be retrieved by single join for each level rather than joining all tables and retrieving names at all levels.
	create table #tempTable
	(
		clientId integer,
		appType integer,
		instanceId integer,
		backupsetId integer,
		subclientId integer,
		excludeEntity integer,
		getDeconfigured integer,
		getDeleted integer,
		errorString NVARCHAR(max) DEFAULT '',
		errorCode BIGINT DEFAULT 0,
		clientName nvarchar(max) null,
		appName nvarchar(max) null,
		instanceName nvarchar(max) null,
		backupsetName nvarchar(max) null,
		subclientName nvarchar(max) null,
		clientDisplayName nvarchar(max) null
	)
	CREATE CLUSTERED INDEX tempTable_clientId_idx ON #tempTable (clientId)
	CREATE NONCLUSTERED INDEX tempTable_appType_idx ON #tempTable (appType)
	-- First Insert all wrong values into the #tempTable and remove them from #inEntity table
	-- so that we dont query for them.
	-- Now update the errorcode in #tempTable
	-- This has to be done at all levels.
	UPDATE temp
SET ErrorCode = (1862 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
	entityName = clientName
	FROM #inEntity temp
	LEFT JOIN APP_Client c ON temp.clientId = c.id
	WHERE (clientId = 0 AND len(clientName)>0) OR (clientId <> 0 and c.id is null)
	-- This has to be done at all levels.
	update temp
SET ErrorCode = (1861 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
	entityName = clientGroupName
	FROM #inEntity temp
	LEFT JOIN APP_ClientGroup cg ON cg.id=temp.clientgroupId
	WHERE ((clientgroupId = 0 AND len(clientGroupName)>0) OR  (clientgroupId <> 0 and cg.id is null))
	AND ErrorCode=0
	-- This has to be done at all levels.
	-- This is specifically done since user can request for all clients specifying clientGroup and appType
	-- So to make it simpler we make it at all levels
	update temp
SET ErrorCode = (1860 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
	entityName = appName
	FROM #inEntity temp
	LEFT JOIN APP_iDAType ida ON ida.type=temp.appType
	WHERE ((appType = 0 AND len(appName)>0) OR (appType<>0 and IDA.type IS NULL))
	AND ErrorCode=0
	-- We set the error Code only when we havent set it already
	update #inEntity
set ErrorCode = (1863 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
	entityName = instanceName
	FROM #inEntity temp
	LEFT JOIN APP_InstanceName i on i.id=temp.instanceId
		WHERE ((instanceId = 0 AND len(instanceName)>0) OR (instanceId<> 0 and i.id IS NULL))
and @level>= 5
	and ErrorCode=0
	UPDATE #inEntity
SET ErrorCode = (1859 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
	entityName = backupSetName
	FROM #inEntity temp
	LEFT JOIN APP_BackupSetName b ON b.id=temp.backupsetId
	WHERE ((backupsetId = 0 AND len(backupSetName)>0) OR (backupsetId<>0 and b.id IS NULL))
AND @level>= 6
	AND ErrorCode=0
	UPDATE #inEntity
SET ErrorCode = (1774 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
	entityName = subclientName
	FROM #inEntity temp
	LEFT JOIN APP_Application a ON a.id=temp.subclientId
	WHERE ((subclientId = 0 AND len(subclientName)>0) OR (subclientId<>0 and a.id IS NULL))
	AND @level>= 7
	-- Now also update the error string based on the locale.
	update #inEntity
	set errorString = EvLocaleMsgs.Message
	from EvLocaleMsgs
	where EvLocaleMsgs.MessageId = ErrorCode
	AND [localeId] = @i_localeId
	-- Now replace the parameter with the entity name
	update #inEntity
	set errorString = replace(errorString,'^1%s',entityName)
	from EvLocaleMsgs
	Insert into #tempTable(clientId,appType,instanceId,backupsetId,subclientId,excludeEntity,getDeconfigured ,getDeleted ,errorString,errorCode)
	select clientId,appType,instanceId,backupsetId,subclientId,excludeEntity,getDeconfigured,getDeleted,errorString, errorCode
	from #inEntity
	where errorCode>0
	-- Delete these entries from #inEntity Table now
	delete from #inEntity
	where errorCode>0
	-- THE SP EXPECTS ALL HIGHER HIERARCHY TO BE FILLED.
	INSERT INTO #tempTable (
			clientId,
			appType,
			instanceId,
			backupsetId,
			subclientId,
			excludeEntity,
			getDeconfigured,
			getDeleted--,
			--errorString,
			--errorCode
			)
		SELECT a.clientId,
			a.appTypeId,
			a.instance,
			a.backupSet,
			a.id,
			CASE
				WHEN subclientName = 'Do Not Backup'
					THEN 0
				ELSE e.excludeEntity
				END,
			e.getDeconfigured,
			e.getDeleted--,
			--'',
			--0
		FROM app_application a WITH (NOLOCK)
			INNER JOIN #inEntity e ON
				a.clientId = e.clientId
				AND a.appTypeId = e.appType
				AND (
					a.instance = e.instanceId
					OR e.instanceId = 0
					)
				AND (
					a.backupSet = e.backupsetId
					OR e.backupsetId = 0
					)
				AND a.id = e.subclientId
		WHERE
			e.clientId <> 0
			AND e.appType <> 0
			AND e.subclientId <> 0
		UNION
		SELECT a.clientId,
			a.appTypeId,
			a.instance,
			a.backupSet,
			a.id,
			e.excludeEntity,
			e.getDeconfigured,
			e.getDeleted--,
			--'',
			--0
		FROM app_application a WITH (NOLOCK)
			INNER JOIN #inEntity e ON
				a.clientId = e.clientId
				AND a.appTypeId = e.appType
				AND a.instance = e.instanceId
				AND a.backupSet = e.backupsetId
		WHERE
			e.clientId <> 0
			AND e.appType <> 0
			AND e.instanceId <> 0
			AND e.backupsetId <> 0
		UNION
		SELECT a.clientId,
			a.appTypeId,
			a.instance,
			a.backupSet,
			a.id,
			e.excludeEntity,
			e.getDeconfigured,
			e.getDeleted--,
			--'',
			--0
		FROM app_application a WITH (NOLOCK)
			INNER JOIN #inEntity e ON
				--	a.origCCId= e.commcellId and
				a.clientId = e.clientId
				AND a.appTypeId = e.appType
				AND a.instance = e.instanceId
		WHERE
			e.clientId <> 0
			AND e.appType <> 0
			AND e.instanceId <> 0
			AND e.backupsetId = 0
		UNION
		SELECT a.clientId,
			a.appTypeId,
			a.instance,
			a.backupSet,
			a.id,
			e.excludeEntity,
			e.getDeconfigured,
			e.getDeleted--,
			--'',
			--0
		FROM app_application a WITH (NOLOCK)
			INNER JOIN #inEntity e ON
				-- a.origCCId= e.commcellId and
				a.clientId = e.clientId
				AND a.appTypeId = e.appType
				AND a.backupSet = e.backupsetId
		WHERE
			e.clientId <> 0
			AND e.appType <> 0
			AND e.backupsetId <> 0
			AND e.instanceId = 0
		UNION
		SELECT C.id,
			ai.appTypeId,
			sc.instance,
			sc.backupSet,
			sc.id,
			e.excludeEntity,
			e.getDeconfigured,
			e.getDeleted--,
			--'',
			--0
		FROM APP_Client C WITH (NOLOCK)
			LEFT JOIN APP_IDAName ai WITH (NOLOCK) ON
				ai.clientId = c.id
			LEFT JOIN APP_Application sc WITH (NOLOCK) ON
				ai.appTypeId = sc.appTypeId
				AND sc.clientId = c.id
			LEFT JOIN APP_ClientGroupAssoc cga WITH (NOLOCK) ON
					C.Id = cga.clientId
			LEFT JOIN dbo.App_AppTypeGroupAssoc atga WITH (NOLOCK) ON
				atga.appTypeId = ai.AppTypeId, #inEntity e
		WHERE -- C.origCCId= e.commcellId AND
			e.backupsetId = 0
			AND e.instanceId = 0
			AND (
				e.appType <> 0
				OR e.clientId <> 0
				OR e.clientGroupId <> 0
				OR e.appGroupId <> 0
				)
			AND (
				C.id = e.clientId
				OR e.clientId = 0
				)
			AND (
				cga.clientGroupId = e.clientGroupId
				OR e.clientGroupId = 0
				)
			AND (
				ai.appTypeId = e.appType
				OR e.appType = 0
				)
			AND (
				atga.appGroupId = e.appGroupId
				OR e.appGroupId = 0
				)
		UNION
		SELECT a.clientId,
			a.appTypeId,
			a.instance,
			a.backupSet,
			a.id,
			e.excludeEntity,
			e.getDeconfigured,
			e.getDeleted--,
			--'',
			--0
		FROM app_application a WITH (NOLOCK)
			INNER JOIN APP_Client C WITH (NOLOCK) ON
				C.id = A.clientId
			INNER JOIN #inEntity e ON
				a.backupSet = e.backupsetId
		WHERE
			e.clientId = 0
			AND e.appType = 0
			AND e.backupsetId <> 0
			AND e.instanceId = 0
		UNION
		SELECT a.clientId,
			a.appTypeId,
			a.instance,
			a.backupSet,
			a.id,
			e.excludeEntity,
			e.getDeconfigured,
			e.getDeleted--,
			--'',
			--0
		FROM app_application a WITH (NOLOCK)
			INNER JOIN APP_Client C WITH (NOLOCK) ON
				C.id = A.clientId
			INNER JOIN #inEntity e ON
				a.instance = e.instanceId
		WHERE
			e.clientId = 0
			AND e.appType = 0
			AND e.backupsetId = 0
			AND e.instanceId <> 0
		UNION
		SELECT a.clientId,
			a.appTypeId,
			a.instance,
			a.backupSet,
			a.id,
			CASE
				WHEN a.subclientName = 'Do Not Backup'
					THEN 0
				ELSE e.excludeEntity
				END,
			e.getDeconfigured,
			e.getDeleted--,
			--'',
			--0
		FROM app_application a WITH (NOLOCK)
			INNER JOIN APP_Client c WITH (NOLOCK) ON
				a.clientId = c.id
			INNER JOIN #inEntity e ON
				a.id = e.subclientId
		WHERE
			e.clientId = 0
			AND e.appType = 0
			AND e.backupsetId = 0
			AND e.instanceId = 0
			AND e.subclientId <> 0
	OPTION (MAXDOP 2)		-- SQL Server throwing to many CPU Cores at this query due to the UNIONs.
							-- Customer TR with MAXDOP set to 8, SQL assigned all 8 to query for ~100-120ms elapse time and ~90-100ms CPU time.
							-- Set MAXDOP 2 ~100-120ms elapse time but ~110-120ms CPU Time - really no differences but freed up 6 CPUs for other uses!
	SET @count = @@ROWCOUNT
	-- Now we delete entries from #tempTable
	-- depending on filter options.
	--	CLIENT_ENTITY = 3,
	--	APPTYPE_ENTITY = 4,
	--	INSTANCE_ENTITY = 5,
	--	BACKUPSET_ENTITY = 6,
	--	SUBCLIENT_ENTITY = 7,
	-- AEB - another deletion for errorCode > 0?  no new or updated rows with errorCode set have added since last delete operation?
	--DELETE
	--FROM #tempTable
	--WHERE errorCode > 0
	-- AEB - set count to @@ROWCOUNT above
	--SET @count = (
	--		SELECT Count(*)
	--		FROM #tempTable
	--		)
	if (@noOfEntities=0)
	begin
		set @noOfEntities = @count
	end
	if(@count <> 0)
	BEGIN
if @level >= 2
	begin
		update T
		set clientName = C.name, clientDisplayName = C.displayName
		from #tempTable T inner join App_client C WITH (NOLOCK)
		on c.id = T.clientid
	end
if @level = 3 OR @level = 2
	begin
EXEC sec_getIdaObjectsForUser @userId,3,0,1,'#getIdaObjects'
			SET @outputCorrectEntities = (select DISTINCT Top (@noOfEntities) C.id as 'entity/@clientId',
3 as 'entity/@_type_',
			T.clientName as 'entity/@clientName',
			C.displayName as 'entity/@displayName',
			C.modified as 'entity/@modifiedTime' -- this tag is not present in GenericEntity. Its mainly selected for OrderBy.
			,C.GUID  as 'entity/@clientGUID'
			from #tempTable T, APP_Client C WITH (NOLOCK),#getIdaObjects AEWC
			where C.id = T.clientId
and NOT (T.getDeconfigured =0 AND (C.status & 0x00002) <> 0)
			ANd (AEWC.clientId = C.id)
			AND (@status = 0 OR ((@status & C.status)>0))
			order by C.modified desc
			FOR XML PATH('response'))
	end
if @level >= 4
	begin
		UPDATE T
		SET appName = CASE WHEN @returnAppNameInsteadOfAppDisplayName>0 THEN IdaName.name ELSE IdaName.displayName END
		FROM #tempTable T INNER JOIN App_IdaType IdaName WITH (NOLOCK)
		on IdaName.type = T.appType
	end
if @level = 4
	begin
EXEC sec_getIdaObjectsForUser @userId,4,0,1,'#getIdaObjects'
				  SET @outputCorrectEntities = (select DISTINCT Top (@noOfEntities) T.clientId as 'entity/@clientId',
				  T.clientName as 'entity/@clientName',
				  T.clientDisplayName as 'entity/@displayName',
				  @level as 'entity/@_type_',
				  IdaName.appTypeId as 'entity/@applicationId',
				  T.appName as 'entity/@appName',
				  IdaName.id as 'entity/@appGroupId' -- appGroupId used for avoiding exception in GUI. Not to be used. Select done mainly for Order by Clause
				  from #tempTable T
				  inner join APP_IDAName IdaName WITH (NOLOCK)
				  on IdaName.clientId = T.clientId
				  and IdaName.appTypeId = T.appType , #getIdaObjects AEWC
				  where
NOT ((IdaName.status& 0x00002)<> 0 and T.getDeconfigured = 0)	--	CV_STATUS_UNINSTALLED
AND NOT ((IdaName.status& 0x00010) <> 0 and T.excludeEntity =1) --CV_STATUS_DUMMY
AND NOT ((IdaName.status& 0x00020) <> 0 and T.excludeEntity =1) --CV_STATUS_HIDDEN
				  AND (
					(
						AEWC.clientId = T.clientId and (AEWC.appTypeId = IdaName.appTypeId)
					)
				  )
				  Order by IdaName.id desc
				  FOR XML PATH('response'))
	end
if @level >= 5
	begin
		update T
		set instanceName = dbo.EncodeInvalidXMLChar(InstName.name)
		from #tempTable T inner join App_InstanceName InstName WITH (NOLOCK)
		on InstName.id = T.instanceId
	end
if @level = 5
	begin
EXEC sec_getIdaObjectsForUser @userId,5,0,1,'#getIdaObjects'
			  SET @outputCorrectEntities = (select DISTINCT Top (@noOfEntities) T.clientID as 'entity/@clientId',
			  T.clientName as 'entity/@clientName',
			  T.clientDisplayName as 'entity/@displayName',
			  @level as 'entity/@_type_',
			  T.appType as 'entity/@applicationId',
			  T.appName as 'entity/@appName',
			  Inst.id as 'entity/@instanceId',
			  Inst.modified as 'entity/@modifiedTime', -- this tag is not present in GenericEntity. Its mainly selected for OrderBy.
			  T.InstanceName as 'entity/@instanceName'
			  ,Inst.guid as 'entity/@instanceGUID'
			  from #tempTable T inner join
			  APP_InstanceName Inst WITH (NOLOCK)
			  on Inst.id = T.instanceId,#getIdaObjects AEWC
			  where
NOT ((Inst.status& 0x00002)<> 0 and T.getDeconfigured = 0)	--	CV_STATUS_UNINSTALLED
AND NOT ((Inst.status& 0x00010) <> 0 and T.excludeEntity =1) --CV_STATUS_DUMMY
AND NOT ((Inst.status& 0x00020) <> 0 and T.excludeEntity =1) --CV_STATUS_HIDDEN
			  AND (
					(
						AEWC.clientId = T.clientId
						and (AEWC.appTypeId = T.apptype)
						and (AEWC.instanceId = T.Instanceid)
					)
				  )
			  order by Inst.modified desc
			  FOR XML PATH('response'))
	end
if @level >= 6
	begin
		update T
		set backupsetName = bkpSet.name
		from #tempTable T inner join App_BackupsetName bkpSet WITH (NOLOCK)
		on bkpSet.id = T.backupsetId
	end
if @level = 6
	begin
EXEC sec_getIdaObjectsForUser @userId,6,0,1,'#getIdaObjects'
		  SET @outputCorrectEntities = (select DISTINCT Top (@noOfEntities) T.clientId as 'entity/@clientId',
		  T.clientName as 'entity/@clientName',
		  T.clientDisplayName as 'entity/@displayName',
		  @level as 'entity/@_type_',
		  T.appType as 'entity/@applicationId',
		  T.appName as 'entity/@appName',
		  T.instanceId as 'entity/@instanceId',
		  T.InstanceName as 'entity/@instanceName',
		  BK.id as 'entity/@backupsetId',
		  BK.name as 'entity/@backupsetName',
		  BK.modified as 'entity/@modifiedTime' -- this tag is not present in GenericEntity. Its mainly selected for OrderBy.
		  ,BK.guid	 as  'entity/@backupsetGUID'
		  from #tempTable T
		  inner join APP_BackupSetName BK WITH (NOLOCK) on BK.id = T.backupsetId	,#getIdaObjects AEWC
where NOT ((BK.status& 0x00002)<> 0 and T.getDeconfigured = 0)	--	CV_STATUS_UNINSTALLED
AND NOT ((BK.status& 0x00010) <> 0 and T.excludeEntity =1) --CV_STATUS_DUMMY
AND NOT ((BK.status& 0x00020) <> 0 and T.excludeEntity =1) --CV_STATUS_HIDDEN
		  AND (
				(
					AEWC.clientId = T.clientid and (AEWC.appTypeId = T.Apptype)
					and (AEWC.instanceId = T.Instanceid)
					and (AEWC.backupsetId = BK.id)
				)
			  )
		  order by BK.modified desc
		  FOR XML PATH('response'))
	end
if @level >= 7
	begin
		update T
		set subclientName = sc.subclientName
		from #tempTable T inner join App_Application sc WITH (NOLOCK)
		on sc.id = T.subclientId
	end
if @level = 7
	begin
EXEC sec_getIdaObjectsForUser @userId,7,0,1,'#getIdaObjects'
			-- Scale Performance gain by creating and indexing data instead of performing inline subquery below
			IF OBJECT_ID('TempDb..#SCInnerTbl') IS NOT NULL
				DROP TABLE #SCInnerTbl
			CREATE TABLE #SCInnerTbl (
				id			INT,
				clientId	INT,
				PRIMARY KEY(clientId, id)
			)
			INSERT INTO #SCInnerTbl (id, clientId)
				SELECT
					ScInner.id,
					AEWC.clientId
				FROM APP_Application SCInner WITH (NOLOCK)
					INNER JOIN #getIdaObjects AEWC ON
						(AEWC.appTypeId = SCInner.apptypeId)
						and (AEWC.instanceId = SCInner.Instance)
						and (AEWC.backupsetId = SCInner.Backupset)
						and (AEWC.subclientId = SCInner.id)
			  SET @outputCorrectEntities = (select DISTINCT Top (@noOfEntities)
				  T.clientId as 'entity/@clientId',
				  T.clientName as 'entity/@clientName',
				  T.clientDisplayName as 'entity/@displayName',
				  T.appType as 'entity/@applicationId',
				  T.appname as 'entity/@appName',
				  T.Instanceid as 'entity/@instanceId',
				   @level as 'entity/@_type_',
				  T.InstanceName as 'entity/@instanceName',
				  T.backupsetId as 'entity/@backupsetId',
				  T.backupsetName as 'entity/@backupsetName',
				  SC.id as 'entity/@subclientId',
				  SC.subclientName as 'entity/@subclientName',
				  SC.dataArchGrpID AS 'entity/@storagePolicyId',
				  Sc.modified as 'entity/@modifiedTime' -- this tag is not present in GenericEntity. Its mainly selected for OrderBy.
				  ,sc.guid	 as  'entity/@subclientGUID'
			  from #tempTable T
			  inner join APP_Application SC WITH (NOLOCK) on
				Sc.id = T.subclientId
			  where sc.appTypeId!=1000
AND NOT ((SC.subclientStatus & 0x00002)<> 0 and T.getDeconfigured = 0)	--	CV_STATUS_UNINSTALLED
AND NOT ((SC.subclientStatus & 0x00010) <> 0 and T.excludeEntity =1) --CV_STATUS_DUMMY
AND NOT ((SC.subclientStatus & 0x00020) <> 0 and T.excludeEntity =1) --CV_STATUS_HIDDEN
AND NOT ((SC.subclientStatus & 0x00004) <> 0  and T.getDeleted = 0) -- CV_STATUS_DELETED
				  AND Sc.Id in (
							SELECT id FROM #SCInnerTbl s WHERE s.clientId = T.clientId
					)
				  Order by SC.modified desc
				  FOR XML PATH('response'))
		end
	END
DECLARE @noPermissionError INT = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	--check if the user has rights on entity, if not give an error
		UPDATE temp
		SET ErrorCode = @noPermissionError,
		entityName = clientName
		FROM #inEntity temp
		WHERE  ErrorCode=0 and clientGroupId=0
		AND NOT EXISTS (SELECT TOP 1 1 FROM #getIdaObjects a WHERE
		  (a.clientId=temp.clientId OR a.clientId=0 OR temp.clientId=0)
			AND (a.appTypeId=temp.appType OR a.appTypeId=0 OR temp.appType=0)
			AND (a.instanceId=temp.instanceId OR a.instanceId=0 or temp.instanceId=0)
			AND (a.backupsetId=temp.backupsetId OR a.backupsetId=0 or temp.backupsetId=0)
			AND (a.subClientId=temp.subclientId OR a.subClientId=0 or temp.subclientId=0)
			AND (temp.clientId > 0 OR temp.appType > 0 OR temp.instanceId > 0 OR temp.backupsetId >0 OR temp.subclientId>0))
AND (@level<=3 OR EXISTS (SELECT 1 from APP_APPLICATION A WHERE (A.clientId=temp.clientId OR temp.clientId=0) -- REST API only gives subclientId/BackupsetId/InstanceId for GET Request
			AND (a.appTypeId=temp.appType OR a.appTypeId=0 OR temp.appType=0)
			AND (a.instance=temp.instanceId OR a.instance=0 or temp.instanceId=0)
			AND (a.backupset=temp.backupsetId OR a.backupset=0 or temp.backupsetId=0)
			AND (a.id=temp.subclientId OR a.id=0 or temp.subclientId=0)
			)
		)
	--for request having client groups
	IF EXISTS(SELECT 1 FROM #inEntity WHERE clientgroupId>0)
	BEGIN
		IF OBJECT_ID ('tempdb.dbo.#visibleClientGroups') IS NOT NULL
			DROP TABLE #visibleClientGroups
		CREATE TABLE #visibleClientGroups  (entityId INT)
		EXEC sec_getNonIdaObjectsForThisUser  @userId,
28,           -- CLIENT_GROUP_ENTITY
                                          0,
                                          '#visibleClientGroups'
		UPDATE INENTITY  SET  errorcode= @noPermissionError
		FROM #inEntity inentity
		LEFT JOIN #visibleClientGroups vis ON vis.entityId=inentity.clientgroupId
		WHERE clientgroupId>0 AND errorcode = 0 AND  vis.entityId is null
	END
	-- Now also update the error string based on the locale.
	update #inEntity
	set errorString = EvLocaleMsgs.Message
	from EvLocaleMsgs
	where (errorString is null or errorString = '' ) and EvLocaleMsgs.MessageId = ErrorCode
	AND [localeId] = @i_localeId
		SET @errorEntities = (select DISTINCT T.errorString as '@errorString',
		T.errorCode as '@errorCode',
		T.clientId as 'entity/@clientId',
		T.appType as 'entity/@applicationId',
		T.instanceId as 'entity/@instanceId',
		T.backupsetId as 'entity/@backupsetId'
		from #inEntity T
		where errorCode>0
		FOR XML PATH('response'))
	drop table #tempTable
END
drop table #inEntity
DROP TABLE #getNonIdaObjects
DROP TABLE #getIdaObjects
IF OBJECT_ID ('tempdb.dbo.#visibleClientGroups') IS NOT NULL
			DROP TABLE #visibleClientGroups
set @outputEntities = IsNull(@outputCorrectEntities,'') + IsNull(@errorEntities,'')
set @inputxml = @outputEntities
set @inputxml = ( select @inputxml for xml path(''),root('App_GenericResponse'))
-- If this call is coming from another SP like getStarted, result shld be returned in output parameter
-- rather than via select. So that it doesnt interfere with outer query results
if @isNestedCall = 0
begin
	select @inputxml
end
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetAssociatedEntities')
	delete from GxQscripts where name = 'GetAssociatedEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetAssociatedEntities')
	delete from GXDBVersions where aliasname = 'GetAssociatedEntities'
GO

insert into GXDBVersions values(2, 'GetAssociatedEntities',  'v1.43.46.17.14.1', 'GetAssociatedEntities', 'v1.43.46.17.14.1')
GO

