

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetAssociatedAndQualifiedClientsForUA.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetAssociatedAndQualifiedClientsForUA.sp,v $ $Id: GetAssociatedAndQualifiedClientsForUA.sp,v 1.3.66.2 2018/03/22 03:13:59 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  GetAssociatedAndQualifiedClientsForUA()
--  |
--  | Description: Returns GetClientListForUARsp. Qualified and associated client list.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetAssociatedAndQualifiedClientsForUA <<<'

IF EXISTS (select * from sysobjects where name='GetAssociatedAndQualifiedClientsForUA')
	drop procedure GetAssociatedAndQualifiedClientsForUA
IF EXISTS (select * from GxQscripts where name='GetAssociatedAndQualifiedClientsForUA')
	delete from GxQscripts where name = 'GetAssociatedAndQualifiedClientsForUA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetAssociatedAndQualifiedClientsForUA')
	delete from GXDBVersions where aliasname = 'GetAssociatedAndQualifiedClientsForUA'
GO
print '... Creating Procedure: GetAssociatedAndQualifiedClientsForUA'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetAssociatedAndQualifiedClientsForUA
  @i_userId integer,
  @inClientId integer
AS
  DECLARE @xmlText XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
IF object_id('tempdb.dbo.#AU_AssociatedClients') IS NOT null DROP TABLE #AU_AssociatedClients
IF object_id('tempdb.dbo.#AU_QualifiedClients') IS NOT null DROP TABLE #AU_QualifiedClients
CREATE  TABLE #AU_AssociatedClients
(
	id INTEGER,
	type INTEGER,
	name VARCHAR(255)
)
CREATE  TABLE #AU_QualifiedClients
(
	id INTEGER,
	type INTEGER,
	name VARCHAR(255)
)
DECLARE @uaClientID INTEGER
DECLARE @uareleaseId INTEGER
DECLARE @uaId INTEGER
-- get the ua id, ua release id
-- client id of cache is passed. just fetch the release id from tables
SET @uaClientID = @inClientId
select @uareleaseId=releaseId from APP_Client where id=@uaClientID
-- get the remote cache if
SET @uaId = 0 -- default value
select @uaId=id from PatchUpdateAgentInfo where clientId=@uaClientID
-- if ua id is 0, it could be a new client getting configured as remote cache
-- So, we need not look for associated clients
-- find the associated clients with this remote cache
IF (@uaId <> 0 )
BEGIN
	INSERT INTO #AU_AssociatedClients SELECT componentNameId, 0, (SELECT name FROM APP_Client WHERE id=componentNameId)  from app_clientprop where attrName like 'UPDATE CACHE AGENT ID' and attrVal like @uaId and modified =0
	INSERT INTO #AU_AssociatedClients SELECT componentId, 1, (select name from APP_ClientGroup where id=componentId)  from  APP_ComponentProp WHERE componentType=8 AND propertyTypeId =1300 AND longVal =@uaId
END
-- find the qualified clients which can be associated to this remote cache
INSERT INTO #AU_QualifiedClients select id,0,name from APP_Client WHERE id != 1 AND id != 2 AND id NOT IN (select PMClientId from APP_VMToPMMap where VMClientId=2)
			AND (releaseId != 12 OR @uareleaseId != 13) AND (releaseId <= @uareleaseId) AND status != 2
INSERT INTO #AU_QualifiedClients
select id,1,name from app_clientgroup where status & 0x00002 != 0x00002 AND
status & 0x0400 != 0x0400 AND
status & 0x1000 != 0x1000
-- visibility check
if (@i_userId <> 0)
BEGIN
	IF object_id('tempdb.dbo.#QualifiedClientsTmp') is not null DROP TABLE #QualifiedClientsTmp
create table  #QualifiedClientsTmp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
 	EXEC sec_getUserObjects @i_userId, 2009, 0, '#QualifiedClientsTmp'
	delete #AU_QualifiedClients
	WHERE type=0 and NOT EXISTS (SELECT * FROM #QualifiedClientsTmp WHERE clientId=id OR (clientId=0 and clientGroupId=0))
	delete #AU_QualifiedClients
	WHERE type=1 and NOT EXISTS (SELECT * FROM #QualifiedClientsTmp WHERE clientGroupId=id OR (clientId=0 and clientGroupId=0))
	DROP TABLE #QualifiedClientsTmp
END
	SET @xmlText = (SELECT
		(SELECT id as '@id', type as '@type', name as '@name' FROM #AU_AssociatedClients
		 FOR XML PATH('associatedList'), TYPE),
		 (SELECT id as '@id', type as '@type', name as '@name' FROM #AU_QualifiedClients
		 FOR XML PATH('qualifiedList'), TYPE)
		  FOR XML PATH('EVGui_GetClientListForUARsp'))
DROP TABLE #AU_QualifiedClients
DROP TABLE #AU_AssociatedClients
SELECT @xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetAssociatedAndQualifiedClientsForUA')
	delete from GxQscripts where name = 'GetAssociatedAndQualifiedClientsForUA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetAssociatedAndQualifiedClientsForUA')
	delete from GXDBVersions where aliasname = 'GetAssociatedAndQualifiedClientsForUA'
GO

insert into GXDBVersions values(2, 'GetAssociatedAndQualifiedClientsForUA',  '00010003006600020000', 'GetAssociatedAndQualifiedClientsForUA', '00010003006600020000')
GO

