

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetArraysForDiscovery.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: GetArraysForDiscovery
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetArraysForDiscovery')
BEGIN
	print '>>> Drop Stored Procedure: GetArraysForDiscovery <<<'
	drop procedure GetArraysForDiscovery
END
IF EXISTS (select * from GxQscripts where name='GetArraysForDiscovery')
	delete from GxQscripts where name = 'GetArraysForDiscovery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetArraysForDiscovery')
	delete from GXDBVersions where aliasname = 'GetArraysForDiscovery'
GO
print '... Creating Procedure: GetArraysForDiscovery'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetArraysForDiscovery
AS
SET NOCOUNT ON
DECLARE @tblArray TABLE (ControlHostId INT,
						 ClientId INT,
						 SMArrayId NVARCHAR(1024),
						 SMVendorId INT,
						 SMHostName NVARCHAR(1024),
						 SMHostUserName VARCHAR(255),
						 SMHostPassword VARCHAR(255),
						 SMArrayController VARCHAR(255),
						 SMArrayControllerClientId INT,
						 phyArray VARCHAR(255),
						 FilerType INT,
						 PhysicalFiler INT,
						 credAssocId INT)
INSERT INTO @tblArray
SELECT SMControlHost.ControlHostId,
	   SMControlHost.ClientId,
	   SMControlHost.SMArrayId,
	   0,
	   SMControlHost.SMHostName,
	   SMControlHost.SMHostUserName,
	   SMControlHost.SMHostPassword,
	   '',
	   0,
	   '',
	   SMControlHost.SMHostFlags,
	   0,
	   SMControlHost.CredentialId
FROM SMControlHost WHERE (SnapVendorName = 'NetApp' OR SnapVendorName = 'Dell EMC VNX / Celerra') and ControlHostId > 0 AND SMControlHost.SMHostFlags <> 1
UPDATE A
SET PhysicalFiler = C.PMClientId
FROM @tblArray A INNER JOIN SMControlHost B ON A.controlhostid = B.ControlHostId
INNER JOIN  APP_VMToPMMap C ON B.ClientId = C.VMClientId
UPDATE @tblArray
SET phyArray = A.SMArrayId, SMHostUserName = A.SMHostUserName, SMHostPassword = A.SMHostPassword, credAssocId = A.CredentialId
FROM SMControlHost A WHERE A.ClientId = [@tblArray].PhysicalFiler
UPDATE @tblArray
SET SMArrayControllerClientId = A.MMHostId
FROM SMArrayController A				--do a host enabled check...MMHost.enabled
WHERE [@tblArray].controlhostid = A.ArrayNum
UPDATE @tblArray
SET SMArrayController = APP_Client.name
FROM APP_Client
WHERE APP_Client.id = [@tblArray].SMArrayControllerClientId
UPDATE @tblArray
SET SMArrayController = (SELECT name FROM APP_Client WHERE id = 2), SMArrayControllerClientId = 2
FROM APP_Client
WHERE [@tblArray].SMArrayControllerClientId = 0
UPDATE @tblArray
SET phyArray = [@tblArray].SMArrayId
WHERE [@tblArray].phyArray = ''
UPDATE @tblArray
SET SMVendorId = C.Id
FROM @tblArray A INNER JOIN SMControlHost B ON A.controlhostid = B.ControlHostId
INNER JOIN  SMVendor C ON B.SnapVendorName = C.Name
UPDATE @tblArray
set SMHostName = SMArrayId
WHERE SMHostName = ''
--update credentials if credentials are stored in credential manager
BEGIN
	IF OBJECT_ID('tempdb.dbo.#AssocToCMCredentials') IS NOT NULL DROP TABLE #AssocToCMCredentials
	CREATE TABLE #AssocToCMCredentials (
	assocId 			INTEGER,
	credentialId 		INTEGER,
	userName			nvarchar(MAX) default '',
	password			nvarchar(MAX) default '',
	credentialInfoXml   xml default '',
	flags				int default 0,
	recordType			int default 0
	)
	INSERT INTO #AssocToCMCredentials (assocId, credentialId)
		SELECT DISTINCT InArray.credAssocId, 0
		FROM @tblArray InArray
		WHERE InArray.credAssocId > 0
	exec AppGetAssocToCMCredentialsList
	UPDATE InArray
	SET	InArray.SMHostUserName = Creds.userName, InArray.SMHostPassword = Creds.password
	FROM @tblArray InArray
		INNER JOIN #AssocToCMCredentials Creds ON Creds.assocId = InArray.credAssocId
	IF OBJECT_ID('tempdb.dbo.#AssocToCMCredentials') IS NOT NULL DROP TABLE #AssocToCMCredentials
END
SELECT *
FROM (
   SELECT ControlHostId, ClientId, SMArrayId, SMVendorId, SMHostName, SMHostUserName, SMHostPassword, SMArrayController,SMArrayControllerClientId, phyArray,FilerType, PhysicalFiler,
          row_number() OVER (PARTITION BY SMHostName ORDER BY ControlHostid ASC) AS row_number
   FROM @tblArray
   ) AS ROWS
WHERE row_number = 1

IF EXISTS (select * from GxQscripts where name = 'GetArraysForDiscovery')
	delete from GxQscripts where name = 'GetArraysForDiscovery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetArraysForDiscovery')
	delete from GXDBVersions where aliasname = 'GetArraysForDiscovery'
GO

insert into GXDBVersions values(2, 'GetArraysForDiscovery',  '00000000000000000000', 'GetArraysForDiscovery', '00000000000000000000')
GO

