

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetArchiveFilesToSkipRefCopy.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  GetArchiveFilesToSkipRefCopy()
--  | Description:  Expects comma separated list of Sub Client IDs.
--  | 				if MMConfig PRUNE_CI_DATA_WHEN_JOBS_AGE_ON_CI_SOURCE_COPY is set to 1, then returns List of Archive File IDs which have copy only on tape for given sub clients
--  |
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetArchiveFilesToSkipRefCopy.sp,v $ $Id: GetArchiveFilesToSkipRefCopy.sp,v 1.1.6.2 2018/12/11 02:42:33 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetArchiveFilesToSkipRefCopy')
BEGIN
	print '>>> Drop Stored Procedure: GetArchiveFilesToSkipRefCopy <<<'
	drop procedure GetArchiveFilesToSkipRefCopy
END
IF EXISTS (select * from GxQscripts where name='GetArchiveFilesToSkipRefCopy')
	delete from GxQscripts where name = 'GetArchiveFilesToSkipRefCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetArchiveFilesToSkipRefCopy')
	delete from GXDBVersions where aliasname = 'GetArchiveFilesToSkipRefCopy'
GO
print '... Creating Procedure: GetArchiveFilesToSkipRefCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetArchiveFilesToSkipRefCopy
  @SubClientIDList VARCHAR(max)
AS
BEGIN
	CREATE TABLE #tmpSubClientIDList (Id INT not null)
	--
	-- capture input subclientIDs into temp table
	--
	INSERT INTO #tmpSubClientIDList (Id)
	SELECT _ID AS Id FROM dbo.SplitIDs(@SubClientIDList)
	--
	-- Return the one's which have copy only on tape..
	--
	IF EXISTS (SELECT value FROM MMConfigs WITH (NOLOCK) WHERE name = 'PRUNE_CI_DATA_WHEN_JOBS_AGE_ON_CI_SOURCE_COPY' AND value = 1)
	BEGIN
		SELECT T.Id ArchFileId
		FROM ArchFile T WITH(NOLOCK)
		JOIN #tmpSubClientIDList I ON T.AppId = I.Id
WHERE EXISTS (SELECT TOP 1 ac.archCopyId FROM ArchFileCopy AS AC WITH(NOLOCK) WHERE AC.MediaType >= 1 AND AC.MediaType <= 9000 AND AC.ArchFileId = T.Id)
AND NOT EXISTS (SELECT TOP 1 ac.archCopyId FROM ArchFileCopy AS AC WITH(NOLOCK) WHERE AC.MediaType > 9000 AND AC.ArchFileId = T.Id)
		ORDER BY T.Id
	END
	ELSE
	BEGIN
		SELECT 0 AS ArchFileID WHERE 1 = 2
	END
END

IF EXISTS (select * from GxQscripts where name = 'GetArchiveFilesToSkipRefCopy')
	delete from GxQscripts where name = 'GetArchiveFilesToSkipRefCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetArchiveFilesToSkipRefCopy')
	delete from GXDBVersions where aliasname = 'GetArchiveFilesToSkipRefCopy'
GO

insert into GXDBVersions values(2, 'GetArchiveFilesToSkipRefCopy',  '00010001000600020000', 'GetArchiveFilesToSkipRefCopy', '00010001000600020000')
GO

