

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetArchFileListForJob.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  GetArchFileListForJob.sp                            		  */
/*                                                                            */
/*  Description :  Return archive files for a job					          */
/*																			  */
/*  Author      :  Praveen Kumar Krishnan                                     */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetArchFileListForJob.sp,v $ $Id: GetArchFileListForJob.sp,v 1.1.66.3 2019/07/26 06:30:11 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetArchFileListForJob')
BEGIN
	print '>>> Drop Stored Procedure: GetArchFileListForJob <<<'
	drop procedure GetArchFileListForJob
END
IF EXISTS (select * from GxQscripts where name='GetArchFileListForJob')
	delete from GxQscripts where name = 'GetArchFileListForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetArchFileListForJob')
	delete from GXDBVersions where aliasname = 'GetArchFileListForJob'
GO
print '... Creating Procedure: GetArchFileListForJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetArchFileListForJob
  @i_jobId integer,
  @i_commcellId integer,
  @i_options integer,
  @i_fileTypes varchar(64)
AS
  DECLARE @r_archFileId integer;
  DECLARE @r_commcellId integer;
  DECLARE @r_archGroupId integer;
  DECLARE @r_afName NVARCHAR(2048);
  DECLARE @r_appId integer;
  DECLARE @r_fileType integer;
  DECLARE @r_createTime integer;
  DECLARE @r_chunkCloseTime integer;
  DECLARE @r_backupLevel integer;
  DECLARE @r_AFFlags integer;
  DECLARE @r_CSVersion integer;
DECLARE @dynamicQuery nvarchar(max)
DECLARE @paramDefinition nvarchar(max)
DECLARE @priorTo80Time int = 0
SELECT @priorTo80Time = dbo.GetUnixTime(MIN(createTimeUTC))
FROM LicUsageHistory WITH(NOLOCK)
WHERE CId IN ( select clientId from APP_Platform WITH(NOLOCK) where platformType=1) AND optype = 'Install' AND appType not in (71, 10, 26)
AND ReleaseId >= 13
SET @dynamicQuery =  'SELECT AF.id, AF.commcellId, AF.archGroupId, AF.name, AF.appId, AF.fileType, AF.cTime, MAX(ISNULL(AC.createTime, 0)), AF.backupLevel, AF.flags,
					  CASE WHEN AF.flags & 64 > 0 AND AF.contentIndexTime < @priorTo80Time THEN 0 ELSE 1 END
					  FROM ArchFile AF WITH(NOLOCK) INNER JOIN ArchFileCopy AFC WITH(NOLOCK)
					  ON AF.id = AFC.archFileId AND AF.commcellId = AFC.commcellId
					  INNER JOIN ArchGroup AG WITH(NOLOCK) ON AG.id = AF.archGroupId
					  LEFT OUTER JOIN ArchChunkMapping ACM WITH(NOLOCK) ON AF.id = ACM.archFileId AND AF.commcellId = ACM.commcellId AND (ACM.archCopyId = AG.defaultCopy OR ACM.archCopyId = AG.defaultSnapCopy)
					  LEFT OUTER JOIN ArchChunk AC WITH(NOLOCK) ON AC.id = ACM.archChunkId AND AC.commcellId = ACM.chunkCommcellId
					  WHERE AF.jobId = @i_jobId AND AF.commcellId = @i_commcellId'
IF(LEN(@i_fileTypes) > 0)
	SET @dynamicQuery = @dynamicQuery + ' AND AF.fileType IN (' + @i_fileTypes + ')'
SET @dynamicQuery = @dynamicQuery + ' AND ((@i_options & 1 = 0) OR AFC.physicalSize > 0) AND AF.isValid = 1 AND AFC.isValid = 1'
SET @dynamicQuery = @dynamicQuery + ' GROUP BY AF.id, AF.commcellId, AF.archGroupId, AF.name, AF.appId, AF.fileType, AF.cTime, AF.backupLevel, AF.flags, AF.contentIndexTime'
SET @dynamicQuery = @dynamicQuery + ' ORDER BY AF.id'
SET @paramDefinition = '@priorTo80Time int, @i_jobId int, @i_commcellId int, @i_options int'
EXECUTE sp_Executesql @dynamicQuery, @paramDefinition, @priorTo80Time, @i_jobId, @i_commcellId, @i_options
GO

IF EXISTS (select * from GxQscripts where name = 'GetArchFileListForJob')
	delete from GxQscripts where name = 'GetArchFileListForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetArchFileListForJob')
	delete from GXDBVersions where aliasname = 'GetArchFileListForJob'
GO

insert into GXDBVersions values(2, 'GetArchFileListForJob',  '00010001006600030000', 'GetArchFileListForJob', '00010001006600030000')
GO

