

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetArchFileInfoByAppId.sp] ---------- 

--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetArchFileInfoByAppId.sp,v $ $Id: GetArchFileInfoByAppId.sp,v 1.1.2.2 2020/09/19 04:38:30 prasanthm Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE: "GetArchFileInfoByAppId"                             |
--  |                                                                       |
--  | Execute the System stored procedure to fcheck the job and later job   |
--  | indexed                                                               |
--  +-----------------------------------------------------------------------+
/*
Input XML format
<MediaManager_GetArchFileByAppIdReq appId="9" lastArchFileReceived="2" >
</MediaManager_GetArchFileByAppIdReq>
Output XML format
<MediaManager_GetArchFileByAppIdResp errorCode="0" errorString="0" isLastBatch="1">
  <ArchFileList appId="66" jobId="9165" commcellId="2" archFileId="990658" fileType="1" backupLevel="1" />
  <ArchFileList appId="66" jobId="9165" commcellId="2" archFileId="990659" fileType="7" backupLevel="1" />
  <ArchFileList appId="66" jobId="9165" commcellId="2" archFileId="990660" fileType="6" backupLevel="1" />
</MediaManager_GetArchFileByAppIdResp>
*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetArchFileInfoByAppId')
BEGIN
	print '>>> Drop Stored Procedure: GetArchFileInfoByAppId <<<'
	drop procedure GetArchFileInfoByAppId
END
IF EXISTS (select * from GxQscripts where name='GetArchFileInfoByAppId')
	delete from GxQscripts where name = 'GetArchFileInfoByAppId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetArchFileInfoByAppId')
	delete from GXDBVersions where aliasname = 'GetArchFileInfoByAppId'
GO
print '... Creating Procedure: GetArchFileInfoByAppId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetArchFileInfoByAppId
  @i_XML XML OUTPUT
AS
DECLARE @appId INTEGER
DECLARE @lastArchFileReceived INTEGER
IF @i_XML.exist('/MediaManager_GetArchFileByAppIdReq') = 1
BEGIN
    SELECT @appId = T.item.value('@appId','INT'), @lastArchFileReceived = T.item.value('@lastArchFileReceived','INT')
            FROM @i_XML.nodes('/MediaManager_GetArchFileByAppIdReq') T(item)
END
DECLARE @recutDays INTEGER = 0
DECLARE @recutTime INTEGER = 0
DECLARE @isLastBatch INTEGER = 0
DECLARE @batchSize INTEGER = 1000
DECLARE @errorCode INTEGER  = 0
DECLARE @errorString VARCHAR(MAX) = ''
select @batchSize = value from MMConfigs where name = 'MMS2_CONFIG_MAX_ARCH_FILE_RETURN_BATCH_COUNT'
select @recutDays = value from MMConfigs where name = 'DA_CONFIG_EDGEDRIVE_NEW_AF_CREATE_INTERVAL_IN_DAYS_DEFAULT'
SELECT @recutTime =  dbo.GetUnixTime(GetUTCDate()) - (@recutDays * 24 * 60 * 60)
IF OBJECT_ID('tempdb..#ArchFileInfo') IS NOT NULL DROP TABLE #ArchFileInfo
CREATE TABLE #ArchFileInfo(archFileId INT PRIMARY KEY,commCellId INT, appId INT, fileType INT, jobId INT, backupLevel INT)
INSERT INTO #ArchFileInfo
select id, commCellId, appId, fileType, jobId, backupLevel from archFile where appId = @appId and cTime < @recutTime and id > @lastArchFileReceived
order by id
DELETE TMP
FROM #ArchFileInfo TMP
INNER JOIN JMJobInfo JM WITH (NOLOCK) ON JM.jobId = TMP.jobId AND JM.commCellId = TMP.commCellId
IF (SELECT count(*) FROM #ArchFileInfo) <= @batchSize
BEGIN
	SET @isLastBatch = 1
END
SET @i_XML =
    (
		SELECT @errorCode AS '@errorCode',
		@errorCode AS '@errorString',
		@isLastBatch AS '@isLastBatch',
        (SELECT TOP(@batchSize)
				appId AS '@appId',
                jobId AS '@jobId',
                commcellId AS '@commcellId',
                ArchFileId AS '@archFileId',
                fileType AS '@fileType',
				backupLevel AS '@backupLevel'
        FROM    #ArchFileInfo ORDER BY archFileId
        FOR XML PATH ('ArchFileList'), TYPE)
		FOR XML PATH ('MediaManager_GetArchFileByAppIdResp'), TYPE
    )
IF OBJECT_ID('tempdb..#ArchFileInfo') IS NOT NULL DROP TABLE #ArchFileInfo
GO

IF EXISTS (select * from GxQscripts where name = 'GetArchFileInfoByAppId')
	delete from GxQscripts where name = 'GetArchFileInfoByAppId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetArchFileInfoByAppId')
	delete from GXDBVersions where aliasname = 'GetArchFileInfoByAppId'
GO

insert into GXDBVersions values(2, 'GetArchFileInfoByAppId',  '00010001000200020000', 'GetArchFileInfoByAppId', '00010001000200020000')
GO

