

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetAppTypeGroups.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetAppTypeGroups.sp,v $ $Id: GetAppTypeGroups.sp,v 1.19.186.4 2020/12/29 11:27:06 nuppu Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetAppTypeGroups')
BEGIN
	print '>>> Drop Stored Procedure: GetAppTypeGroups <<<'
	drop procedure GetAppTypeGroups
END
IF EXISTS (select * from GxQscripts where name='GetAppTypeGroups')
	delete from GxQscripts where name = 'GetAppTypeGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetAppTypeGroups')
	delete from GXDBVersions where aliasname = 'GetAppTypeGroups'
GO
print '... Creating Procedure: GetAppTypeGroups'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetAppTypeGroups
  @capabilityReqd bigint,
  @locale_in integer,
  @userId integer
AS
SET NOCOUNT ON
BEGIN
DECLARE @xmlText XML
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#entitiesWithCapability') IS NOT null
   DROP TABLE #entitiesWithCapability
EXEC sec_updateUserCredentials @userId
create table  #entitiesWithCapability ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
DECLARE @drInstanceID INTEGER
SET @drInstanceID  =  ISNULL((SELECT TOP 1 instance FROM APP_Application
WHERE appTypeId= 1000),1)
DECLARE @clientList TABLE
    (
      [localClientId] INT NOT null,
	  [clientName] NVARCHAR(510),
	  [clientStatus] INT,
	  [appTypeId] INT,
	  [iDAName] VARCHAR(128),
	  [osGroup] VARCHAR(255),
	  [app] VARCHAR(255),
	  [appGroup] VARCHAR(255),
      [markedForDelete] INT,
      [pseudoRAC] INT,
      [dcInstalled] INT,
      [pseudoDpf] INT,
      [isVirtual] INT,
      [isPreConfigured] INT,
      [noValidIdasPresent] INT,
      [bkpActivityEnabled] INT,
      [rstActivityEnabled] INT,
      [ciActivityEnabled] INT
    )
EXEC sec_getUserObjects @userId, 0, 0, '#entitiesWithCapability'
INSERT INTO  @clientList
    SELECT DISTINCT APP_IDAName.clientId ,APP_Client.[name], APP_Client.status, APP_IDAName.appTypeId, app_idaType.displayName,
       app_AppTypeGroups.OsGroup, app_AppTypeGroups.App, app_AppTypeGroups.AppGroup, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    FROM     APP_IDAName
       JOIN  APP_Client  on APP_IDAName.clientId = APP_Client.id
       --JOIN  simAppTypeLicTypeMap on simAppTypeLicTypeMap.appTypeId = APP_IDAName.appTypeId
       JOIN  app_AppTypeGroups on APP_IDAName.appTypeId = app_AppTypeGroups.AppTypeId
	   JOIN  app_idaType on app_idaType.Type = APP_IDAName.appTypeId
       --LEFT OUTER JOIN LicUsage LU ON APP_Client.id = LU.cid AND APP_IDAName.appTypeId = LU.AppType
       JOIN  #entitiesWithCapability sec on
            ( (((capabilities & @capabilityReqd )<>0 ) OR (@capabilityReqd =0))
              AND ((	APP_IDAName.clientId = sec.clientId AND
					(sec.appTypeId=0 OR sec.appTypeId=APP_IDAName.apptypeId)
				) OR (
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
			)
    WHERE    APP_IDAName.status <> 0x0001 --AND LU.LicType in ( simAppTypeLicTypeMap.simLicAppType, 1115)
	--Hide Office365 and Azure Ad clients\Agents in Java Gui
	DELETE C FROM @clientList C
	JOIN APP_ClientProp  (nolock) A ON A.componentNameId = C.localClientId
	WHERE (A.attrname = 'Office 365 Pseudo Client' OR A.attrname = 'Azure AD Pseudo Client') AND A.attrval = '1' AND A.modified = 0
   update @clientList set markedForDelete
      = (select attrVal from APP_ClientProp where componentNameId=[localClientId] and attrName='platformdeleted 4' and modified =0)
   update @clientList set pseudoRAC
      = (select [status] from APP_Client where Id = [localClientId] ) & 0x0040
   update @clientList set dcInstalled
      = (select attrVal from APP_ClientProp where componentnameid = [localClientId] and attrName = 'Data Classification Installed on Client' and modified =0)
   update @clientList set pseudoDpf
      = (select [status] from APP_Client where Id = [localClientId] ) & 0x0200
   update @clientList set isVirtual
      = (select attrVal from APP_ClientProp where componentNameId = [localClientId] and attrName='Virtual client'  and modified =0)
   update @clientList set isPreConfigured
      = (select [status] from APP_Client where Id = [localClientId] ) & 0x4000
   -- check if unlicensed iDAs Present
   update @clientList set noValidIdasPresent = 1
        WHERE NOT EXISTS (select id from licUsage WHERE optype = 'Install' AND Cid = [localClientId] AND InstallFlag = 0 AND AppType < 1000 )
   UPDATE @clientList SET noValidIdasPresent = 0
		WHERE EXISTS(SELECT id FROM APP_Application WHERE clientId = [localClientId] AND apptypeId IN (80, 103)) -- pseudo clients
   update @clientList set bkpActivityEnabled
      =(select J.action from JMJobAction as J where [clientId] = [localClientId] AND appType=0 AND mediaAgentId=1 AND opType=4 AND instanceID = @drInstanceID)
   update @clientList set rstActivityEnabled
      =(select J.action from JMJobAction as J where [clientId] = [localClientId] AND appType=0 AND mediaAgentId=1 AND opType=5 AND instanceID = @drInstanceID)
   update @clientList set ciActivityEnabled
      =ISNULL((select J.action from JMJobAction as J where [clientId] = [localClientId] AND appType=0 AND mediaAgentId=1 AND opType=57 AND instanceID = @drInstanceID), 1)
----------------------------
--CONSTRUCT THE XML---------
----------------------------
SET @xmlText =
(
    SELECT
      localClientId AS "@clientId", clientName AS "@clientName",
	 appTypeId AS "@appTypeId",
         iDAName AS "@iDAName", osGroup AS "@osGroup", app AS "@app", appGroup AS "@appGroup",
         markedForDelete AS "@markedForDelete",
         pseudoRAC AS "@pseudoRAC",
         dcInstalled AS "@DCInstalled",
         pseudoDpf AS "@pseudoDpf",
         isVirtual AS "@isVirtual",
         isPreConfigured AS "@isPreConfigured",
         noValidIdasPresent AS "@noValidIdasPresent",
         bkpActivityEnabled AS "@bkpActivityEnabled",
         rstActivityEnabled AS "@rstActivityEnabled",
         ciActivityEnabled AS "@ciActivityEnabled"
    FROM @clientList
    ORDER BY appGroup, app, osGroup, clientName
       FOR XML  PATH('clients'), ROOT('EVGui_GetClientsListPerAgentTypeResp')
)
IF OBJECT_ID('tempdb.dbo.#entitiesWithCapability') IS NOT null
    DROP TABLE #entitiesWithCapability
SELECT @xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'GetAppTypeGroups')
	delete from GxQscripts where name = 'GetAppTypeGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetAppTypeGroups')
	delete from GXDBVersions where aliasname = 'GetAppTypeGroups'
GO

insert into GXDBVersions values(2, 'GetAppTypeGroups',  '00010019018600040000', 'GetAppTypeGroups', '00010019018600040000')
GO

