

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetAnomalyClientSummaryList.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetAnomalyClientSummaryList.sp,v $ $Id: GetAnomalyClientSummaryList.sp,v 1.1.2.2 2020/08/18 21:05:15 pgadhave Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetAnomalyClientSummaryList')
BEGIN
	print '>>> Drop Stored Procedure: GetAnomalyClientSummaryList <<<'
	drop procedure GetAnomalyClientSummaryList
END
IF EXISTS (select * from GxQscripts where name='GetAnomalyClientSummaryList')
	delete from GxQscripts where name = 'GetAnomalyClientSummaryList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetAnomalyClientSummaryList')
	delete from GXDBVersions where aliasname = 'GetAnomalyClientSummaryList'
GO
print '... Creating Procedure: GetAnomalyClientSummaryList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetAnomalyClientSummaryList
  @i_xml XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
BEGIN
    DECLARE @o_xml XML
    DECLARE @i_userID INT = 0
    SELECT @i_userId = ISNULL(ref.value('@userId', 'INT'), 0)
                FROM @i_xml.nodes('Api_AnomalyClientListReq') R ( ref )
	IF OBJECT_ID('tempdb.dbo.#temp') IS NOT NULL
        DROP TABLE #temp
    CREATE TABLE #temp (name NVARCHAR(100), val INT, clientid INT, clientName NVARCHAR(MAX), detected INT, location NVARCHAR(MAX), displayName NVARCHAR(MAX), isVMeSupported NVARCHAR(10))
    IF OBJECT_ID('tempdb.dbo.#ClientsWithManageCapability') IS NOT NULL
        DROP TABLE #ClientsWithManageCapability
    CREATE TABLE #ClientsWithManageCapability (clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT)
    EXEC sec_getIdaObjectsForUser @i_userId, 3, 2, 0, '#ClientsWithManageCapability'
    INSERT INTO #temp (name, val, clientId, detected)
        SELECT attrName, attrVal, componentNameId, created
        FROM APP_ClientProp
        WHERE attrName IN (N'Anomaly Flag', N'Anomaly created Files', N'Anomaly renamed Files', N'Anomaly modified Files', N'Anomaly deleted Files')
        AND componentNameId IN (SELECT DISTINCT componentNameId
            FROM APP_ClientProp CProp
            INNER JOIN #ClientsWithManageCapability C
            ON CProp.componentNameId = C.clientId
            WHERE CProp.attrName = 'Anomaly Flag'
            AND CProp.attrVal > 0
            AND CProp.modified = 0)
        AND modified = 0
    IF OBJECT_ID('tempdb.dbo.#ClientsWithManageCapability') IS NOT NULL
        DROP TABLE #ClientsWithManageCapability
    IF OBJECT_ID('tempdb.dbo.VirtualizeMeClients') IS NOT NULL
        DROP TABLE #VirtualizeMeClients
    CREATE TABLE #VirtualizeMeClients (clientid INT, clientName NVARCHAR(MAX))
    INSERT INTO #VirtualizeMeClients (clientid, clientName)
    SELECT t.clientid, t.clientName FROM #temp t
    -- Remove any virtual clients
    DELETE #VirtualizeMeClients
    FROM #VirtualizeMeClients
    LEFT JOIN APP_ClientProp CP
    ON #VirtualizeMeClients.clientId = CP.componentNameId
    WHERE CP.attrName = 'Virtual Client'
    AND CP.attrVal = 1
    AND CP.modified = 0
    -- Remove OPEN VMS and IBMi clients
    DELETE #VirtualizeMeClients
    FROM #VirtualizeMeClients
    WHERE #VirtualizeMeClients.clientid IN (SELECT CLientId
    FROM simInstalledPackages WHERE simPackageID IN (49, 118))
    -- Remove clients that do not have FS advanced package
    DELETE #VirtualizeMeClients
    FROM #VirtualizeMeClients
    WHERE #VirtualizeMeClients.clientid NOT IN (SELECT CLientId
    FROM simInstalledPackages WHERE simPackageID IN (702, 1101))
    -- Remove distrubuted apps clients
    DELETE #VirtualizeMeClients
    FROM #VirtualizeMeClients VMe
    INNER JOIN APP_IDAName IDA WITH (NOLOCK)
    ON IDA.clientId = VMe.clientid
    WHERE IDA.appTypeId = 64
    UPDATE T
    SET T.isVMeSupported = 'false'
    FROM #temp T
    UPDATE T
    SET T.isVMESupported = 'true'
    FROM #temp T
    LEFT JOIN #VirtualizeMeClients VMe
    ON T.clientId = VMe.clientid
    WHERE VMe.clientId IS NOT NULL
    IF OBJECT_ID('tempdb.dbo.VirtualizeMeClients') IS NOT NULL
        DROP TABLE #VirtualizeMeClients
    UPDATE T
    SET T.clientName = C.name,
    T.displayName = C.displayName
    FROM #temp T, APP_Client C
    WHERE T.clientid = C.id
    UPDATE T
    SET T.location = P.attrVal
    FROM #temp T, APP_ClientProp P
    WHERE T.clientId = P.componentNameId
    AND P.attrName like 'Client Geo Location'
    AND P.modified = 0
    IF OBJECT_ID('tempdb.dbo.#tt') IS NOT NULL
        DROP TABLE #tt
    CREATE TABLE #tt (clientId INT, clientName varchar(100), displayName varchar(100), anomalyType INT, createCount INT, renameCount INT, deleteCount INT, modCount INT, refTime INT, location NVARCHAR(MAX), isVMeSupported NVARCHAR(10))
    INSERT INTO #tt (clientId, ClientName, displayName, anomalyType, createCount, renameCount, deleteCount, modCount)
    SELECT * FROM (SELECT clientId, clientName, displayName, name, val FROM #temp) src
    PIVOT (AVG(val)
            FOR name IN ([Anomaly Flag], [Anomaly created Files], [Anomaly renamed Files], [Anomaly deleted Files], [Anomaly modified Files])
            ) piv1
    UPDATE #tt
    SET refTime = T2.detected
    FROM #tt T
    INNER JOIN
    (SELECT clientName, MAX(detected) detected
        FROM #temp GROUP BY clientName) T2
    ON T.ClientName = T2.clientName
    UPDATE #tt
    SET location = T2.location,
    isVMeSupported = T2.isVMeSupported
    FROM #tt T
    INNER JOIN
    (SELECT clientName, location, isVMeSupported
        FROM #temp ) T2
    ON T.clientName = T2.clientName
    SET @o_xml =
    (SELECT refTime AS "@refTime",
        deleteCount AS "@deleteCount",
        createCount AS "@createCount",
        modCount AS "@modCount",
        renameCount AS "@renameCount",
		anomalyType AS "@anomalyType",
		location AS "@location",
        isVMeSupported AS "@isVMeSupported",
        clientId AS "client/@clientId",
        clientName AS "client/@clientName",
        displayName AS "client/@displayName",
        S.id as "osInfo/osInfo/@osId",
        S.Type as "osInfo/osInfo/@Type",
        S.SubType as "osInfo/osInfo/@SubType",
        dbo.GetClientOSName(clientId, NULL) AS "osInfo/osInfo/OsDisplayInfo/@OSName",
        dbo.GetClientHardwareName(clientId, NULL) AS "osInfo/osInfo/OsDisplayInfo/@ProcessorType"
    FROM #tt,
        simOperatingSystem as S
        WHERE S.id = (SELECT simOperatingSystemId FROM APP_Client WHERE id = clientId)
    FOR XML PATH('anomalyClients'), ROOT('APP_AnomalyClientList'))
	IF OBJECT_ID('tempdb.dbo.#temp') IS NOT NULL
        DROP TABLE #temp
	IF OBJECT_ID('tempdb.dbo.#tt') IS NOT NULL
        DROP TABLE #tt
	IF OBJECT_ID('tempdb.dbo.#ClientsWithManageCapability') IS NOT NULL
        DROP TABLE #ClientsWithManageCapability
    SELECT @o_xml
END

IF EXISTS (select * from GxQscripts where name = 'GetAnomalyClientSummaryList')
	delete from GxQscripts where name = 'GetAnomalyClientSummaryList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetAnomalyClientSummaryList')
	delete from GXDBVersions where aliasname = 'GetAnomalyClientSummaryList'
GO

insert into GXDBVersions values(2, 'GetAnomalyClientSummaryList',  '00010001000200020000', 'GetAnomalyClientSummaryList', '00010001000200020000')
GO

