

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetAlertCriteriaForOfflineClients.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetAlertCriteriaForOfflineClients.sp,v $ $Id: GetAlertCriteriaForOfflineClients.sp,v 1.1.2.5 2019/05/15 22:00:55 prakash Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   GetAlertCriteriaForOfflineClients   - Get the alert criteria for offline clients alert configuration
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetAlertCriteriaForOfflineClients')
BEGIN
	print '>>> Drop Stored Procedure: GetAlertCriteriaForOfflineClients <<<'
	drop procedure GetAlertCriteriaForOfflineClients
END
IF EXISTS (select * from GxQscripts where name='GetAlertCriteriaForOfflineClients')
	delete from GxQscripts where name = 'GetAlertCriteriaForOfflineClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetAlertCriteriaForOfflineClients')
	delete from GXDBVersions where aliasname = 'GetAlertCriteriaForOfflineClients'
GO
print '... Creating Procedure: GetAlertCriteriaForOfflineClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetAlertCriteriaForOfflineClients
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS                         ---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @xmlOutput XML
IF object_id('tempdb.dbo.#notifList') IS NOT NULL
BEGIN
	DROP TABLE #notifList
END
CREATE TABLE #notifList (
   NTnotificationId		integer NOT NULL,
   criteria             integer NOT NULL,
   delayTimeSeconds		integer NOT NULL,
   persistTimeSeconds	integer NOT NULL,
   escalationlevel		integer NOT NULL,
   offlinetime          integer NOT NULL
)
INSERT INTO #notifList
SELECT NTSelCriteria.ruleId, availCriteriaid, delayTimeSeconds, persistTimeSeconds, esclationLevel, T.value AS OfflineTime
FROM NTSelCriteria
INNER JOIN
(
	   SELECT DISTINCT NTSelCriteria.ruleId,NTSelCriteriaParams.value
	   FROM NTSelCriteria
	   INNER JOIN NTnotificationRule ON NTSelCriteria.ruleId = NTnotificationRule.id
	   AND NTnotificationRule.revision = 1
	   AND (NTnotificationRule.status & 2) = 0 -- NT_STATUS_DISABLED
AND NTNotificationRule.alertTypeId = 10
AND NTSelCriteria.availCriteriaid = 103
	   INNER JOIN NTSelCriteriaParams ON NTSelCriteriaParams.selCriteriaid = NTSelCriteria.id
) T
ON t.ruleId = NTSelCriteria.ruleId
and NTSelCriteria.availCriteriaid = 103
IF object_id('tempdb.dbo.#notifClientList') IS NOT NULL
BEGIN
	DROP TABLE #notifClientList
END
CREATE TABLE #notifClientList
(
	   NTNotificationID integer,
	   clientID 		integer
)
INSERT INTO #notifClientList
SELECT id, R.ref.value('@clientId','int')
FROM NTnotificationRule
INNER JOIN #notifList notifList ON notifList.NTnotificationId = NTnotificationRule.id
CROSS APPLY NTnotificationRule.xmlEntityList.nodes('CVGui_CommCellTreeNode/associations') R(ref)
WHERE R.ref.value('@clientId','int') > 0
UNION
SELECT NTnotificationRule.id, APP_Client.id
FROM NTnotificationRule
INNER JOIN #notifList notifList ON notifList.NTnotificationId = NTnotificationRule.id
CROSS APPLY NTnotificationRule.xmlEntityList.nodes('CVGui_CommCellTreeNode/associations') R(ref)
CROSS JOIN APP_Client
WHERE ISNULL(R.ref.value('(flags/@exclude)[1]','int'),0)=0 AND R.ref.value('@_type_','int')=2
UNION
SELECT id, APP_ClientGroupAssoc.clientId
FROM NTnotificationRule
INNER JOIN #notifList notifList ON notifList.NTnotificationId = NTnotificationRule.id
CROSS APPLY NTnotificationRule.xmlEntityList.nodes('CVGui_CommCellTreeNode/associations') R(ref)
INNER JOIN APP_ClientGroupAssoc ON APP_ClientGroupAssoc.clientGroupId = R.ref.value('@clientGroupId','int')
EXCEPT
(
   SELECT id, R.ref.value('@clientId','int')
   FROM NTnotificationRule
   INNER JOIN #notifList notifList ON notifList.NTnotificationId = NTnotificationRule.id
   CROSS APPLY NTnotificationRule.xmlEntityList.nodes('CVGui_CommCellTreeNode/associations') R(ref)
   WHERE ISNULL(R.ref.value('(flags/@exclude)[1]','int'),0)=1
   AND R.ref.value('@applicationId','int')=0
   UNION
   SELECT id, APP_ClientGroupAssoc.clientId
   FROM NTnotificationRule
   INNER JOIN #notifList notifList ON notifList.NTnotificationId = NTnotificationRule.id
   CROSS APPLY NTnotificationRule.xmlEntityList.nodes('CVGui_CommCellTreeNode/associations') R(ref)
   INNER JOIN APP_ClientGroupAssoc ON APP_ClientGroupAssoc.clientGroupId = R.ref.value('@clientGroupId','int')
   WHERE ISNULL(R.ref.value('(flags/@exclude)[1]','int'),0)=1
)
--Remove clients where install update job is running
DELETE notifClientList FROM #notifClientList notifClientList
INNER JOIN JMQinetixUpdateStatus JUPDATE WITH (NOLOCK)
ON notifClientList.clientID = JUPDATE.clientId
INNER JOIN PatchClientStatus PCS
ON PCS.jobStatus = JUPDATE.status
AND PCS.category NOT IN (1,3,4)
INNER JOIN JMAdminJobInfoTable JINFO -- only committed rows
ON JINFO.jobId = JUPDATE.jobId AND JUPDATE.commCellId = JINFO.commCellId
WHERE JINFO.commCellId = 2 -- DEFAULT_COMMCELL_ID
AND JINFO.opType in (35,67,68)	--PATCHUPDATE, INSTALLCLIENT, UNINSTALLCLIENT
-- For clients we need to identify their proxies also
IF object_id('tempdb.dbo.#tmpClient') IS NOT NULL drop table #tmpClient
create table #tmpClient
    (   ClientId        integer,
        subclientId     integer,
        INSTANCE        integer,
        appTypeId       integer
    )
INSERT INTO #tmpClient
SELECT DISTINCT clientID,0,0,0 FROM  #notifClientList
IF object_id('tempdb.dbo.#tmpClientProxyPairs') IS NOT NULL drop table #tmpClientProxyPairs
create table #tmpClientProxyPairs(ClientId      integer,
                        instanceId          integer,
                        proxyClientId           integer,
                        ClientAppType               integer,
                        isIndexServer               integer DEFAULT 0,  --0 meaning proxyclient, 1 meaning index server
                        iscloudindexServer  integer DEFAULT 0,    -- 1 meaning cloud index server
                        cloudindexServer    integer DEFAULT 0,
                        isproxyclientGroup  integer DEFAULT 0 , -- 1 meaning client Group
                        clientGroup         integer DEFAULT 0,
                        subclientId         integer DEFAULT 0
                        )
IF exists (select * from #tmpClient)
    EXEC APPGetProxyClientInfo '#tmpClient','#tmpClientProxyPairs',1
SET @xmlOutput = (
SELECT T.clientID 'client/@clientId',
       (
              SELECT T.criteria '@criteriaType',T.offlinetime '@frequency', T.isCriteriaMet '@isCriteriaMet'
              FOR XML PATH('criteria'),TYPE
       ),
	   (
			SELECT DISTINCT proxyClientId '@clientId'  FROM #tmpClientProxyPairs tmpClientProxyPairs
			WHERE tmpClientProxyPairs.ClientID =  T.clientID
			AND tmpClientProxyPairs.ClientID>0
			FOR XML PATH('physicalClients'),TYPE
	   )
FROM
(
	SELECT notifClientList.clientID,notifList.criteria criteria, MIN(notifList.delayTimeSeconds) delayTimeSeconds, MIN(notifList.offlinetime) offlinetime,
		CASE WHEN MAX(NTDclntAgentMAConfig.eventId) IS NOT NULL AND MAX(NTDclntAgentMAConfig.eventId)>0 THEN 1
		ELSE 0
		END isCriteriaMet
	FROM #notifClientList notifClientList
	INNER JOIN #notifList notifList
	ON notifList.NTnotificationId = notifClientList.NTNotificationID
LEFT JOIN NTDetectedAlerts ON NTDetectedAlerts.alertType=10 AND NTDetectedAlerts.criteria=103 AND (NTDetectedAlerts.processStat & 2)>0
	LEFT JOIN NTDclntAgentMAConfig ON NTDclntAgentMAConfig.eventId = NTDetectedAlerts.eventId AND NTDclntAgentMAConfig.clientId = notifClientList.clientID
	GROUP BY notifClientList.clientID,notifList.criteria
) T
FOR XML PATH('alertInfoForClients'),root('CVGui_GetAlertCriteriaForServiceOfflineResp')
)
IF @xmlOutput IS NULL
BEGIN
	set @xmlOutput = '<CVGui_GetAlertCriteriaForServiceOfflineResp/>'
END
select @xmlOutput
DROP TABLE #notifList
DROP TABLE #notifClientList
IF object_id('tempdb.dbo.#tmpClient') IS NOT NULL drop table #tmpClient
IF object_id('tempdb.dbo.#tmpClientProxyPairs') IS NOT NULL drop table #tmpClientProxyPairs
GO

IF EXISTS (select * from GxQscripts where name = 'GetAlertCriteriaForOfflineClients')
	delete from GxQscripts where name = 'GetAlertCriteriaForOfflineClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetAlertCriteriaForOfflineClients')
	delete from GXDBVersions where aliasname = 'GetAlertCriteriaForOfflineClients'
GO

insert into GXDBVersions values(2, 'GetAlertCriteriaForOfflineClients',  '00010001000200050000', 'GetAlertCriteriaForOfflineClients', '00010001000200050000')
GO

