

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetAggregatedFsNodeActivity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--  Copyright (c) CommVault Systems
--  All Rights Reserved
--
--  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems
--  The copyright notice above does not evidence any
--  actual or intended publication of such source code.
--
--  File name   : GetAggregatedFsNodeActivity.sp
--	Author		: Arpit Rathi
--
--  Description : This SP is to get clients file & folder aggregated anomaly activity
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetAggregatedFsNodeActivity.sp,v $ $Id: GetAggregatedFsNodeActivity.sp,v 1.1.2.6.6.1 2021/01/22 20:51:05 pgadhave Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetAggregatedFsNodeActivity')
BEGIN
	print '>>> Drop Stored Procedure: GetAggregatedFsNodeActivity <<<'
	drop procedure GetAggregatedFsNodeActivity
END
IF EXISTS (select * from GxQscripts where name='GetAggregatedFsNodeActivity')
	delete from GxQscripts where name = 'GetAggregatedFsNodeActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetAggregatedFsNodeActivity')
	delete from GXDBVersions where aliasname = 'GetAggregatedFsNodeActivity'
GO
print '... Creating Procedure: GetAggregatedFsNodeActivity'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetAggregatedFsNodeActivity
  @userId INTEGER,
  @inputXml XML,
  @outputXml XML OUTPUT
AS
BEGIN TRY
	DECLARE @errorCode INT = 0
	DECLARE @errorMsg NVARCHAR(MAX) = ''
	IF OBJECT_ID('tempdb.dbo.#ClientsWithManageCapability') IS NOT NULL
	DROP TABLE #ClientsWithManageCapability
	CREATE TABLE #ClientsWithManageCapability (clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT)
EXEC sec_getIdaObjectsForUser @userId, 3, 2, 0, '#ClientsWithManageCapability'
	--Request processing
	DECLARE @timeFrame INT = ISNULL((SELECT ref.value('@timeFrame','INTEGER') AS data
					  FROM @inputXml.nodes('/Api_GetAnomalyInfoReq') R(ref)),1);
	DECLARE @aggregateHour INT = ISNULL((SELECT ref.value('@aggregateHour','INTEGER') AS data
						  FROM @inputXml.nodes('/Api_GetAnomalyInfoReq') R(ref)),2);
	DECLARE @filter INT = ISNULL((SELECT ref.value('@filter','INTEGER') AS data
                    FROM @inputXml.nodes('Api_GetAnomalyInfoReq') R(ref)),0);
	DECLARE @clientTbl Table(clientId INT);
	INSERT INTO @clientTbl(clientId)
		 SELECT ISNULL(ClientTbl.id.value('@clientId','INT'),0)
		 FROM @inputXml.nodes('Api_GetAnomalyInfoReq/clients') AS ClientTbl(id)
	-- Remove clients with no managment permission
	DELETE client
	FROM @clientTbl client
	LEFT JOIN #ClientsWithManageCapability C
	ON C.clientId = client.clientId
	WHERE client.clientId IS NULL
	-- If no input client list, error out.
	IF NOT EXISTS(SELECT 1 FROM @clientTbl)
	BEGIN
		SET @errorCode  = 1
		SET @errorMsg = 'User does not have required capability to view details'
		GOTO ERROR_EXIT
	END
	DECLARE @nDataPoints INT = ((@timeFrame * 24) / @aggregateHour);
	DECLARE @activityInfoDataTable TABLE(clientId INT, activityInfo XML)
	INSERT into @activityInfoDataTable
		SELECT TOP 1 ctb.clientId, historyTbl.activityInfo
		FROM @clientTbl as ctb
		INNER JOIN HistoryDB.dbo.FsNodeActivityData as historyTbl ON ctb.clientId=historyTbl.clientId
		ORDER BY created DESC;
	--Request processing done
	DECLARE @isBackupAnomaly INT = ISNULL((SELECT X.isBackupAnomaly
				FROM @activityInfoDataTable T
				cross apply
				(SELECT T.c.value('@isBackupAnomaly', 'INT') AS isBackupAnomaly
					FROM activityInfo.nodes('/Api_AnomalyHistoryRecord') T (c))
					X),
				0);
	DECLARE @clientId INT = ISNULL((SELECT ref.value('@clientId','INT') AS data
                    FROM @inputXml.nodes('Api_GetAnomalyInfoReq/clients') R(ref)), 0);
	DECLARE @isFSAdvanvedPackageInstalled INT = ISNULL((SELECT TOP 1 1 FROM simInstalledPackages
				WHERE ClientId = @clientId
				AND simPackageID IN (702, 1101)),
			0);
	DECLARE @isOpenVMSIBMiClient INT = ISNULL((SELECT TOP 1 1 FROM simInstalledPackages
				WHERE ClientId = @clientId
				AND simPackageID IN (49, 118)),
			0);
	DECLARE @isVirtualClient INT = ISNULL((SELECT 1 FROM APP_ClientProp CP
				WHERE CP.componentNameId = @clientId
				AND CP.attrName = 'Virtual Client'
				AND CP.attrVal = 1
				AND CP.modified = 0),
			0);
	DECLARE @isDistributedIDA INT = ISNULL ((SELECT 1 FROM APP_IDAName
				WHERE clientId = @clientId
				AND appTypeId = 64),
			0);
	DECLARE @isVMeSupported NVARCHAR(MAX) = 'false';
	IF @isFSAdvanvedPackageInstalled = 1 AND @isOpenVMSIBMiClient = 0 ANd @isVirtualClient = 0 ANd @isDistributedIDA = 0
	BEGIN
		SET @isVMeSupported = 'true';
	END
	-- Anomaly records
	DECLARE @activityInfoInputTable TABLE(clientId INT, appType INT, anomalyType INT, createCount INT, deleteCount INT, modCount INT, renameCount INT, refTime INT, jobId INT, hourDifference INT);
	INSERT INTO @activityInfoInputTable
	select
		T.clientId,
		X.[appType],
		X.[anomalyType],
		X.[createCount],
		X.[deletecount],
		X.[modCount],
		X.[renameCount],
		X.[refTime],
		X.[jobId],
		0
	from @activityInfoDataTable T
	cross apply (
	SELECT
			   T.c.value('@appType', 'INT') AS [appType],
			   T.c.value('@anomalyType', 'INT') AS [anomalyType],
			   T.c.value('@createCount', 'INT') AS [createCount],
			   T.c.value('@deleteCount', 'INT') AS [deleteCount],
			   T.c.value('@modCount', 'INT') AS [modCount],
			   T.c.value('@renameCount', 'INT') AS [renameCount],
			   T.c.value('@refTime', 'INT') AS [refTime],
			   T.c.value('@jobId', 'INT') AS [jobId]
	FROM activityInfo.nodes('/Api_AnomalyHistoryRecord/anomalyRecords') T (c)
	) X;
	-- Folder list info
	DECLARE @activityInfoInputFolderTable TABLE(clientId INT, folderPath NVARCHAR(MAX), createCount INT, deleteCount INT, modCount INT, renameCount INT, refTime INT, jobId INT);
	INSERT INTO @activityInfoInputFolderTable
	select
		T.clientId,
		X.[folderPath],
		X.[createCount],
		X.[deletecount],
		X.[modCount],
		X.[renameCount],
		X.[refTime],
		X.[jobId]
	from @activityInfoDataTable T
	cross apply (
	SELECT
			   T.c.value('@folderPath', 'NVARCHAR(MAX)') AS [folderPath],
			   T.c.value('@createCount', 'INT') AS [createCount],
			   T.c.value('@deleteCount', 'INT') AS [deleteCount],
			   T.c.value('@modCount', 'INT') AS [modCount],
			   T.c.value('@renameCount', 'INT') AS [renameCount],
			   T.c.value('@refTime', 'INT') AS [refTime],
			   T.c.value('@jobId', 'INT') AS [jobId]
	FROM activityInfo.nodes('/Api_AnomalyHistoryRecord/folderInfoList') T (c)
	) X;
	DECLARE @aggregatedActivityInfo TABLE(clientId INT, appType INT, anomalyType INT, createCount INT, deleteCount INT, modCount INT, renameCount INT, refTime INT, jobId INT, hourDifference INT)
	DECLARE @aggregatedActivityFolderInfo TABLE(clientId INT, folderPath NVARCHAR(MAX), createCount INT, deleteCount INT, modCount INT, renameCount INT, refTime INT, jobId INT);
	IF @isBackupAnomaly = 0
	BEGIN
		--Deleting unwanted rows based on input params
		DECLARE @anomalyTime INT = ISNULL((SELECT max(refTime) FROM @activityInfoInputTable), dbo.GEtUnixTime(GetUTCdate()))
		DELETE FROM @activityInfoInputTable WHERE ((@anomalyTime - refTime) / 3600) >= (@timeFrame * 24)
		UPDATE @activityInfoInputTable SET hourDifference = ((@anomalyTime - refTime) / 3600)
		--Aggregation query
		INSERT INTO @aggregatedActivityInfo
		SELECT clientId, max(appType) appType, max(anomalyType), sum(createCount) createCount, sum(deleteCount) deleteCount, sum(modCount) modCount,
			   sum(renameCount) renameCount, max(refTime) refTime, max(jobId) jobId, floor(hourDifference/@aggregateHour) hourDifference
		FROM @activityInfoInputTable GROUP BY clientId, floor(hourDifference/@aggregateHour);
		--Deleting unwanted rows which are more than a day old from anomaly time
		DELETE FROM @activityInfoInputFolderTable WHERE ((@anomalyTime - refTime) / 3600) >= 24
		--Aggregation query
		INSERT INTO @aggregatedActivityFolderInfo
		SELECT clientId, folderPath, sum(createCount) createCount, sum(deleteCount) deleteCount, sum(modCount) modCount,
				sum(renameCount) renameCount, max(refTime) refTime, max(jobId) jobId
		FROM @activityInfoInputFolderTable GROUP BY clientId, folderPath ORDER BY clientId;
	END
	ELSE
	BEGIN
		DECLARE @anomalyJobId INT = ISNULL((SELECT max(jobId) FROM @activityInfoInputTable), 0);
		INSERT INTO @aggregatedActivityInfo
		SELECT clientId, appType, anomalyType, createCount, deleteCount, modCount,
				renameCount, refTime, jobId, hourDifference
		FROM @activityInfoInputTable;
		INSERT INTO @aggregatedActivityFolderInfo
		SELECT clientId, folderPath, createCount, deleteCount, modCount,
				renameCount, refTime, jobId
		FROM @activityInfoInputFolderTable
		WHERE jobId = @anomalyJobId;
	END
	IF @filter > 0
	BEGIN
		SET @outputXml = ISNULL((SELECT clientTbl.clientId as 'client/@clientId',
							(SELECT name FROM APP_Client where id = clientTbl.clientId) AS 'client/@clientName',
							(SELECT displayName FROM APP_Client where id = clientTbl.clientId) AS 'client/@displayName',
							dbo.GetClientOSName(clientTbl.clientId, NULL) AS 'osInfo/osInfo/OsDisplayInfo/@OSName',
							dbo.GetClientHardwareName(clientTbl.clientId, NULL) AS 'osInfo/osInfo/OsDisplayInfo/@ProcessorType',
							(SELECT
								@isBackupAnomaly as '@isBackupAnomaly',
								CASE
								WHEN @filter = 2 THEN
								(SELECT
									tb2.folderPath as '@folderPath',
									tb2.createCount as '@createCount',
									tb2.deleteCount as '@deleteCount',
									tb2.modCount as '@modCount',
									tb2.refTime as '@refTime',
									tb2.renameCount as '@renameCount',
									tb2.jobId as '@jobId'
									FROM @aggregatedActivityFolderInfo as tb2 WHERE tb2.clientId=clientTbl.clientId FOR XML PATH('folderInfoList'), TYPE)
								WHEN @filter = 1 THEN
								(SELECT
									tb2.appType as '@appType',
									tb2.anomalyType as '@anomalyType',
									tb2.createCount as '@createCount',
									tb2.deleteCount as '@deleteCount',
									tb2.modCount as '@modCount',
									tb2.refTime as '@refTime',
									tb2.renameCount as '@renameCount',
									tb2.jobId as '@jobId',
									@isVMeSUpported as '@isVMeSupported'
									FROM @aggregatedActivityInfo as tb2 WHERE tb2.clientId = clientTbl.clientId FOR XML PATH('anomalyRecords'), TYPE)
								END
							FOR XML PATH('anomalyRecord'), ROOT('anomalyRecordList'), TYPE)
						FROM @activityInfoDataTable as clientTbl FOR XML PATH('clientInfo'), ROOT('Api_AnomalyInfoResp'), TYPE), '<Api_AnomalyInforesp/>')
	END
	ELSE
	BEGIN
		SET @outputXml = ISNULL((SELECT clientTbl.clientId as 'client/@clientId',
							(SELECT name FROM APP_Client where id = clientTbl.clientId) AS 'client/@clientName',
							(SELECT displayName FROM APP_Client where id = clientTbl.clientId) AS 'client/@displayName',
							dbo.GetClientOSName(clientTbl.clientId, NULL) AS 'osInfo/osInfo/OsDisplayInfo/@OSName',
							dbo.GetClientHardwareName(clientTbl.clientId, NULL) AS 'osInfo/osInfo/OsDisplayInfo/@ProcessorType',
							(SELECT
								@isBackupAnomaly as '@isBackupAnomaly',
								(SELECT
									tb2.folderPath as '@folderPath',
									tb2.createCount as '@createCount',
									tb2.deleteCount as '@deleteCount',
									tb2.modCount as '@modCount',
									tb2.refTime as '@refTime',
									tb2.renameCount as '@renameCount',
									tb2.jobId as '@jobId'
									FROM @aggregatedActivityFolderInfo as tb2 WHERE tb2.clientId=clientTbl.clientId FOR XML PATH('folderInfoList'), TYPE),
								(SELECT
									tb2.appType as '@appType',
									tb2.anomalyType as '@anomalyType',
									tb2.createCount as '@createCount',
									tb2.deleteCount as '@deleteCount',
									tb2.modCount as '@modCount',
									tb2.refTime as '@refTime',
									tb2.renameCount as '@renameCount',
									tb2.jobId as '@jobId',
									@isVMeSUpported as '@isVMeSupported'
									FROM @aggregatedActivityInfo as tb2 WHERE tb2.clientId = clientTbl.clientId FOR XML PATH('anomalyRecords'), TYPE)
							FOR XML PATH('anomalyRecord'), ROOT('anomalyRecordList'), TYPE)
						FROM @activityInfoDataTable as clientTbl FOR XML PATH('clientInfo'), ROOT('Api_AnomalyInfoResp'), TYPE), '<Api_AnomalyInforesp/>')
	END
ERROR_EXIT:
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorMsg = ERROR_MESSAGE()
END CATCH
IF @errorCode <> 0
BEGIN
	SET @outputXml = (SELECT @errorCode AS '@errorCode' , @errorMsg AS '@errorMessage'
					FOR XML PATH('error'),ROOT('Api_AnomalyInfoResp'))
END
SELECT @outputXml
GO

IF EXISTS (select * from GxQscripts where name = 'GetAggregatedFsNodeActivity')
	delete from GxQscripts where name = 'GetAggregatedFsNodeActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetAggregatedFsNodeActivity')
	delete from GXDBVersions where aliasname = 'GetAggregatedFsNodeActivity'
GO

insert into GXDBVersions values(2, 'GetAggregatedFsNodeActivity',  'v1.1.2.6.6.1', 'GetAggregatedFsNodeActivity', 'v1.1.2.6.6.1')
GO

