

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetAdminConsoleGSuiteClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- -----------------------------------------------------------------------
--  +====================================================================+
--  |   GetAdminConsoleGSuiteClients									 |
--  |   Procedure to get GSuite clients for GSuite solution landing page |
--  +====================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetAdminConsoleGSuiteClients')
BEGIN
	print '>>> Drop Stored Procedure: GetAdminConsoleGSuiteClients <<<'
	drop procedure GetAdminConsoleGSuiteClients
END
IF EXISTS (select * from GxQscripts where name='GetAdminConsoleGSuiteClients')
	delete from GxQscripts where name = 'GetAdminConsoleGSuiteClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetAdminConsoleGSuiteClients')
	delete from GXDBVersions where aliasname = 'GetAdminConsoleGSuiteClients'
GO
print '... Creating Procedure: GetAdminConsoleGSuiteClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetAdminConsoleGSuiteClients
  @i_userId INT,
  @o_xmlString XML OUTPUT
AS
SET NOCOUNT ON;
BEGIN
	DECLARE @errorCode INT = 0
    DECLARE @errorString NVARCHAR(1024) = ''
    IF OBJECT_ID('tempdb.dbo.#tempGSuiteClients') IS NOT NULL
        DROP TABLE #tempGSuiteClients
    CREATE TABLE #tempGSuiteClients
    (
        clientId INT,
        clientName NVARCHAR(255),
        displayName NVARCHAR(255),
        hostName NVARCHAR(255),
        clientGUID NVARCHAR(255),
        instanceType INT,
        isDeletedClient INT DEFAULT 0,
        planId INT,
        planName NVARCHAR(255),
        userCount BIGINT DEFAULT 0,
        lastArchiveJobRanTime INT DEFAULT 0,
        applicationSize BIGINT DEFAULT 0,
        lastJobId INT DEFAULT 0,
        commcellID INT DEFAULT 0,
        lastJobStatus INT DEFAULT 0,
        lastJobEndTime INT DEFAULT 0,
        lastJobFailureReasonIds NVARCHAR(512) DEFAULT ''
    )
	CREATE CLUSTERED INDEX #Idx1_tempGSuiteClients_clientId ON #tempGSuiteClients(clientId)
    /*Security*/
    IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
		DROP TABLE #getIdaObjects
	CREATE TABLE #getIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
EXEC sec_getIdaObjectsForUser @i_userId, 7, 0 , 0,'#getIdaObjects', 0,'2, 20, 22, 13, 141, 25, 12, 253, 1, 16, 107'
	BEGIN TRY
        /*Client Id and InstanceType*/
        INSERT INTO #tempGSuiteClients (clientId, instanceType)
        (
            SELECT app.clientId, iprop.attrVal FROM APP_Application(NOLOCK) app
            INNER JOIN APP_InstanceProp(NOLOCK) iprop ON app.instance = iprop.componentNameId
            INNER JOIN APP_Client client(NOLOCK) ON app.clientId = client.id
WHERE app.appTypeId = 134 AND iprop.attrName = 'Cloud Apps Instance Type'
            AND iprop.attrVal IN (1/*Google Mail*/, 2/*Google Drive*/)
            AND (app.id IN (SELECT DISTINCT subclientId FROM #getIdaObjects))
            GROUP BY app.clientId, iprop.attrVal
        )
        UPDATE #tempGSuiteClients
        SET clientName = C.clientName, displayName = C.displayName, hostName = C.hostName, clientGUID = C.clientGUID
        FROM (
            SELECT client.id AS clientId, client.name AS clientName, client.displayName AS displayName, client.net_hostname as hostName, client.GUID as clientGUID FROM APP_Client(NOLOCK) client
            INNER JOIN #tempGSuiteClients ON #tempGSuiteClients.clientId = client.id
            ) C WHERE #tempGSuiteClients.clientId = C.clientId
        /*Plan*/
        UPDATE #tempGSuiteClients
        SET planId = ISNULL(P.planId, 0), planName = ISNULL(P.planName, '')
        FROM(
            SELECT temp.clientId AS clientId, p.id AS planId, p.name AS planName FROM #tempGSuiteClients temp
            INNER JOIN APP_Application(NOLOCK) app ON temp.clientId = app.clientId
            INNER JOIN APP_BackupSetProp(NOLOCK) bprop ON app.backupSet = bprop.componentNameId
            INNER JOIN App_Plan(NOLOCK) p ON bprop.attrVal = p.id
            WHERE bprop.attrName = 'Associated Plan' AND bprop.modified = 0
            GROUP BY temp.clientId, p.id, p.name
            ) P WHERE #tempGSuiteClients.clientId = P.clientId
        /*Is deleted client*/
        UPDATE #tempGSuiteClients
        SET isDeletedClient = ISNULL(D.isDeleted, 0)
        FROM (
            SELECT temp.clientId AS clientId, cprop.attrVal AS isDeleted FROM #tempGSuiteClients temp
            INNER JOIN APP_ClientProp(NOLOCK) cprop ON temp.clientId = cprop.componentNameId
            WHERE cprop.attrName = 'PlatformDeleted 4'
            ) D WHERE #tempGSuiteClients.clientId = D.clientId
        /*User count*/
        UPDATE #tempGSuiteClients
        SET userCount = U.userCount
        FROM(
            SELECT app.clientId, COUNT(DISTINCT attrName) AS userCount FROM #tempGSuiteClients temp
            INNER JOIN APP_Application(NOLOCK) app ON temp.clientId = app.clientId
            INNER JOIN APP_SubClientProp(NOLOCK) sprop ON app.id = sprop.componentNameId
            WHERE sprop.modified = 0 AND sprop.attrType = 134
            AND app.subclientStatus & 0x02 != 0x02 /*UNINSTALLED*/ AND app.subclientStatus & 0x04 != 0x04 /*DELETED*/ AND app.subclientStatus & 0x00020 != 0x00020 /*HIDDEN*/
            GROUP BY app.clientId
            ) U WHERE #tempGSuiteClients.clientId = U.clientId
        /*Last archive job ran time and Application size*/
        UPDATE #tempGSuiteClients
        SET lastArchiveJobRanTime = J.lastArchiveJonRanTime, applicationSize = J.appSize
        FROM(
            SELECT app.clientId AS cliendId, ISNULL(MAX(stat.servEndDate), 0) AS lastArchiveJonRanTime, SUM(stat.totalUncompBytes) AS appSize FROM #tempGSuiteClients temp
            INNER JOIN APP_Application(NOLOCK) app ON temp.clientId  = app.clientId
            INNER JOIN JMBkpStats(NOLOCK) stat ON app.id = stat.appId
            WHERE stat.status in (1/*JMSUCCESS*/, 3/*PARTIALSUCCESS*/, 14/*JMSUCCESSWITHWARNINGS*/)
            AND app.subclientStatus & 0x02 != 0x02 /*UNINSTALLED*/ AND app.subclientStatus & 0x04 != 0x04 /*DELETED*/ AND app.subclientStatus & 0x00020 != 0x00020 /*HIDDEN*/
            GROUP BY app.clientId
            ) J WHERE #tempGSuiteClients.clientId = J.cliendId
        /*Last backup job info*/
        UPDATE #tempGSuiteClients
        SET lastJobId = L.jobId, commcellID = L.commCellId, lastJobStatus = L.status, lastJobEndTime = L.servEndDate, lastJobFailureReasonIds = L.failureReason
        FROM
        (
            SELECT clientId, stat.jobId, commCellId, status, servEndDate, failureReason FROM
            (SELECT app.clientId, MAX(stat.jobId) AS jobId FROM #tempGSuiteClients temp
            INNER JOIN APP_Application(NOLOCK) app ON temp.clientId = app.clientId
            INNER JOIN JMBkpStats(NOLOCK) stat ON app.id = stat.appId
            WHERE app.subclientStatus & 0x02 != 0x02 /*UNINSTALLED*/ AND app.subclientStatus & 0x04 != 0x04 /*DELETED*/ AND app.subclientStatus & 0x00020 != 0x00020 /*HIDDEN*/
            GROUP BY app.clientId) J
            INNER JOIN JMBkpStats(NOLOCK) stat ON stat.jobId = J.jobId
        ) L WHERE #tempGSuiteClients.clientId = L.clientId
        SET @o_xmlString = (SELECT (SELECT
                                instanceType AS "@instanceType",
                                userCount AS "@userCount",
                                lastArchiveJobRanTime AS "@lastArchiveJobRanTime",
                                isDeletedClient AS "@isDeletedClient",
                                applicationSize AS "@applicationSize",
                                (SELECT (SELECT
                                    clientId AS "@clientId",
                                    clientName AS "@clientName",
                                    clientGUID AS "@clientGUID",
                                    displayName AS "@displayName",
                                    hostName AS "@hostName"
                                FOR XML PATH('client'), TYPE)),
                                (SELECT (SELECT
                                    planId AS "@planId",
                                    planName AS "@planName"
                                FOR XML PATH('plan'), TYPE)),
                                (SELECT (SELECT
                                    lastJobId AS "@jobID",
                                    commcellID AS "@commCellID",
                                    lastJobStatus AS "@status",
                                    lastJobEndTime AS "@endTime",
                                    lastJobFailureReasonIds AS "@failureReasonIds",
                                    dbo.JMGetLocalizedMessageFunc(0, lastJobFailureReasonIds) AS "@failureReasonMessageEnglish"
                                FOR XML PATH('lastBackupJobInfo'), TYPE))
                            FROM #tempGSuiteClients
                            FOR XML PATH('gsuiteClients'), TYPE)
                            FOR XML PATH('App_AdminConsoleGSuiteClientsResp'))
    END TRY
    BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
    END CATCH
    ERROR_EXIT:
        IF @errorCode <> 0
            SET @o_xmlString = (SELECT ISNULL(@errorCode,0) AS '@errorCode', ISNULL(@errorString,'')
                                        AS '@errorMessage' FOR XML PATH('App_AdminConsoleGSuiteClientsResp'))
    IF OBJECT_ID('tempdb.dbo.#tempGSuiteClients') IS NOT NULL
        DROP TABLE #tempGSuiteClients
    IF OBJECT_ID('tempdb.dbo.#tempBackupSetSecurityObjects') IS NOT NULL
        DROP TABLE #tempBackupSetSecurityObjects
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetAdminConsoleGSuiteClients')
	delete from GxQscripts where name = 'GetAdminConsoleGSuiteClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetAdminConsoleGSuiteClients')
	delete from GXDBVersions where aliasname = 'GetAdminConsoleGSuiteClients'
GO

insert into GXDBVersions values(2, 'GetAdminConsoleGSuiteClients',  '00000000000000000000', 'GetAdminConsoleGSuiteClients', '00000000000000000000')
GO

