

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GenTableTruncateSqlScripts.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GenTableTruncateSqlScripts.sp,v $ $Id: GenTableTruncateSqlScripts.sp,v 1.1.2.2 2018/03/20 00:44:51 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GenTableTruncateSqlScripts <<<'

IF EXISTS (select * from sysobjects where name='GenTableTruncateSqlScripts')
	drop procedure GenTableTruncateSqlScripts
IF EXISTS (select * from GxQscripts where name='GenTableTruncateSqlScripts')
	delete from GxQscripts where name = 'GenTableTruncateSqlScripts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GenTableTruncateSqlScripts')
	delete from GXDBVersions where aliasname = 'GenTableTruncateSqlScripts'
GO
print '... Creating Procedure: GenTableTruncateSqlScripts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GenTableTruncateSqlScripts
  @tblName NVARCHAR(128)
AS
-- Cursor Output
  DECLARE @o_type INTEGER
  DECLARE @o_tableObjectId INTEGER
  DECLARE @o_refObjectId INTEGER
  DECLARE @o_tableName NVARCHAR(128)
  DECLARE @o_refName NVARCHAR(128)
  DECLARE @o_script NVARCHAR(MAX)
BEGIN
	SET NOCOUNT ON
	DECLARE @tblOId		INT = OBJECT_ID(@tblName)
--	Format of output table:
--		IF OBJECT_ID('tempdb.dbo.#Scripts') IS NOT NULL
--			DROP TABLE #Scripts
--		CREATE TABLE #Scripts
--		(
--			type			INT,		-- 0 drop FK, 1 create FK, 2 drop View, 3 create view
--			tableObjectId	INT,
--			refObjectId		INT,
--			tableName		NVARCHAR(128),
--			refName			NVARCHAR(128),
--			script			NVARCHAR(MAX),
--
--			PRIMARY KEY (type, tableObjectId, refObjectId)
--		);
	SELECT
		0 type,
		@tblOId tableObjectId,
		fk.object_id refObjectId,
		@tblName tableName,
		fk.name refName,
		N'ALTER TABLE ' + QUOTENAME(s.name) + '.' + QUOTENAME(t.name) + ' DROP CONSTRAINT ' + QUOTENAME(fk.name) + ';' script
	FROM
		sys.foreign_keys AS fk
		INNER JOIN sys.tables AS t ON
			fk.parent_object_id = t.[object_id]
			AND fk.referenced_object_id = @tblOId
		INNER JOIN sys.schemas AS s ON
			t.schema_id = s.schema_id
	UNION ALL
	SELECT
		1,
		@tblOId,
		fk.object_id,
		@tblName,
		fk.name,
		N'ALTER TABLE ' + QUOTENAME(s.name) + '.' + QUOTENAME(ct.name) + ' ADD CONSTRAINT ' + QUOTENAME(fk.name) + ' FOREIGN KEY ('
			+ STUFF(
					(
						SELECT
							',' + QUOTENAME(c.name)		-- get each individual column
						FROM sys.columns AS c
							INNER JOIN sys.foreign_key_columns AS fkc ON
								fkc.parent_column_id = c.column_id
								AND fkc.parent_object_id = c.object_id
						WHERE
							fkc.constraint_object_id = fk.object_id
						ORDER BY fkc.constraint_column_id
						FOR XML PATH(N''), TYPE
					).value(N'.[1]', N'NVARCHAR(MAX)'), 1, 1, N''
				)
			  + ') REFERENCES ' + QUOTENAME(rs.name) + '.' + QUOTENAME(rt.name)
			  + '(' + STUFF(
							(
								SELECT
									',' + QUOTENAME(c.name)		-- get each individual referenced column
								FROM sys.columns AS c
									INNER JOIN sys.foreign_key_columns AS fkc ON
										fkc.referenced_column_id = c.column_id
										AND fkc.referenced_object_id = c.object_id
								WHERE fkc.constraint_object_id = fk.object_id
								ORDER BY fkc.constraint_column_id
								FOR XML PATH(N''), TYPE
							).value(N'.[1]', N'nvarchar(max)'), 1, 1, N''
				) + ');'
	FROM
		sys.foreign_keys AS fk
		INNER JOIN sys.tables AS rt ON
			fk.referenced_object_id = rt.object_id
			AND fk.referenced_object_id = @tblOId
		INNER JOIN sys.schemas AS rs ON
			rt.schema_id = rs.schema_id
		INNER JOIN sys.tables AS ct ON
			fk.parent_object_id = ct.object_id
		INNER JOIN sys.schemas AS s ON
			ct.schema_id = s.schema_id
	WHERE
		rt.is_ms_shipped = 0
		AND ct.is_ms_shipped = 0
	UNION ALL
	SELECT
		2,
		@tblOId,
		t.viewObjectId,
		@tblName,
		t.viewName,
		N'DROP VIEW ' + QUOTENAME(t.schemaName) + '.' + QUOTENAME(t.viewName) + N';'
	FROM
		(SELECT DISTINCT
			s.name schemaName,
			o.name viewName,
			o.object_id viewObjectId
		FROM
			sys.sql_expression_dependencies sed
			INNER JOIN sys.objects o ON
				sed.referencing_id = o.object_id
				AND o.type_desc = 'VIEW'
				AND sed.is_schema_bound_reference = 1
			INNER JOIN sys.schemas AS s ON
				o.schema_id = s.schema_id
		WHERE
			sed.referenced_id = @tblOId) t
	UNION ALL
	SELECT
		3,
		@tblOId,
		t.viewObjectId,
		@tblName,
		t.viewName,
		m.definition
	FROM
		(SELECT DISTINCT
			s.name schemaName,
			o.name viewName,
			o.object_id viewObjectId
		FROM
			sys.sql_expression_dependencies sed
			INNER JOIN sys.objects o ON
				sed.referencing_id = o.object_id
				AND sed.is_schema_bound_reference = 1
				AND o.type_desc = 'VIEW'
			INNER JOIN sys.schemas AS s ON
				o.schema_id = s.schema_id
		WHERE
			sed.referenced_id = @tblOId) t
		INNER JOIN sys.sql_modules m ON
			m.object_id = t.viewObjectId
END
GO

IF EXISTS (select * from GxQscripts where name = 'GenTableTruncateSqlScripts')
	delete from GxQscripts where name = 'GenTableTruncateSqlScripts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GenTableTruncateSqlScripts')
	delete from GXDBVersions where aliasname = 'GenTableTruncateSqlScripts'
GO

insert into GXDBVersions values(2, 'GenTableTruncateSqlScripts',  '00010001000200020000', 'GenTableTruncateSqlScripts', '00010001000200020000')
GO

