

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/FtpServicePackInfoUpdateOps.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/FtpServicePackInfoUpdateOps.sp,v $ $Id: FtpServicePackInfoUpdateOps.sp,v 1.3.54.6 2020/07/10 22:28:28 kgao Exp $";
--  +========================================================================+
--  | Stored Proc:  FtpServicePackInfoUpdateOps()
--  |
--  | Description: Returns the SPNames that are valid for the given release for user to select in download software .
--		Operation 1 - insert
--		Operation 2 - truncate
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='FtpServicePackInfoUpdateOps')
BEGIN
	print '>>> Drop Stored Procedure: FtpServicePackInfoUpdateOps <<<'
	drop procedure FtpServicePackInfoUpdateOps
END
IF EXISTS (select * from GxQscripts where name='FtpServicePackInfoUpdateOps')
	delete from GxQscripts where name = 'FtpServicePackInfoUpdateOps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FtpServicePackInfoUpdateOps')
	delete from GXDBVersions where aliasname = 'FtpServicePackInfoUpdateOps'
GO
print '... Creating Procedure: FtpServicePackInfoUpdateOps'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure FtpServicePackInfoUpdateOps
  @i_operationType int,
  @SPName varchar(32),
  @SPMajor integer,
  @SPMinor integer,
  @ReleaseStr varchar(32),
  @BuildIdString varchar(32),
  @Timestamp integer,
  @bIsDVDPresent integer,
  @DVDName varchar(32),
  @bShowInGUI integer,
  @FriendlyName varchar(256),
  @TransactionId integer,
  @RevisionId integer
AS
  DECLARE @rupdateCount integer;
SET NOCOUNT ON
BEGIN
	 IF @i_operationType = 1
     BEGIN
		DECLARE @releaseId INT
		DECLARE @buildNum INT
		SELECT @releaseId = id FROM simAllGalaxyRel where Release = SUBSTRING(@ReleaseStr, 1, CHARINDEX('.', @ReleaseStr) -1) OR Release like SUBSTRING(@ReleaseStr, 1, CHARINDEX('.', @ReleaseStr) -1) + '%'
		SET @buildNum = CONVERT(INT, SUBSTRING(@BuildIdString, PATINDEX('%[0-9]%', @BuildIdString), LEN(@BuildIdString) - PATINDEX('%[0-9]%', @BuildIdString) + 1 ))
		IF EXISTS (SELECT * FROM PatchSPVersion
					WHERE SPName = @SPName AND
						SPMajor = @SPMajor AND
						SPMinor = @SPMinor AND
						ReleaseStr = @ReleaseStr AND
						BuildIdString = @BuildIdString AND
						TransactionId = @TransactionId AND
						RevisionId = @RevisionId)
		BEGIN
			UPDATE PatchSPVersion
			SET Timestamp = @Timestamp,
				bIsDVDPresent = @bIsDVDPresent,
				DVDName = @DVDName,
				bShowInGUI = @bShowInGUI,
				FriendlyName = @FriendlyName,
				Release = @releaseId,
				Build = @buildNum
			WHERE SPName = @SPName AND
				SPMajor = @SPMajor AND
				SPMinor = @SPMinor AND
				ReleaseStr = @ReleaseStr AND
				BuildIdString = @BuildIdString AND
				TransactionId = @TransactionId AND
				RevisionId = @RevisionId
		END
		ELSE
		BEGIN
			IF EXISTS(SELECT 1 FROM PatchSPVersion WHERE
				Release = @releaseId AND
				Build = @buildNum AND
				SPMajor = @SPMajor AND
				SPMinor = @SPMinor AND
				TransactionId = @TransactionId AND
				RevisionId = @RevisionId)
			BEGIN
				UPDATE PatchSPVersion
				SET Timestamp = @Timestamp,
					bIsDVDPresent = @bIsDVDPresent,
					DVDName = @DVDName,
					bShowInGUI = @bShowInGUI,
					FriendlyName = @FriendlyName,
					ReleaseStr = @ReleaseStr,
					BuildIdString = @BuildIdString,
					SPName = @SPName
				WHERE Release = @releaseId AND
					Build = @buildNum AND
					SPMajor = @SPMajor AND
					SPMinor = @SPMinor AND
					TransactionId = @TransactionId AND
					RevisionId = @RevisionId
			END
			ELSE
			BEGIN
				INSERT INTO PatchSPVersion (SPName, SPMajor, SPMinor, Release, ReleaseStr, Build, BuildIdString, Timestamp, bIsDVDPresent, DVDName, bShowInGUI, FriendlyName, TransactionId, RevisionId, nCacheFlags, nLTSFlag, nBootstrapperDelayDays, nGUIDownloadDelayDays)
				VALUES(@SPName,@SPMajor, @SPMinor, @releaseId, @ReleaseStr, @buildNum, @BuildIdString, @Timestamp, @bIsDVDPresent, @DVDName, @bShowInGUI, @FriendlyName, @TransactionId, @RevisionId, 0, 0, 0, 0);
			END
		END
	 END
	 IF @i_operationType = 2
     BEGIN
		-- DO NOT TRUNCATE, INSTEAD SET INVALID FLAGS
		--EXEC SQLUtilTruncateTable 'PatchSPVersion';
		UPDATE PatchSPVersion
		SET bIsDVDPresent = 0,
			bShowInGUI = 0,
			nLTSFlag = 0
	 END
END
select @@rowcount
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'FtpServicePackInfoUpdateOps')
	delete from GxQscripts where name = 'FtpServicePackInfoUpdateOps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FtpServicePackInfoUpdateOps')
	delete from GXDBVersions where aliasname = 'FtpServicePackInfoUpdateOps'
GO

insert into GXDBVersions values(2, 'FtpServicePackInfoUpdateOps',  '00010003005400060000', 'FtpServicePackInfoUpdateOps', '00010003005400060000')
GO

