

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/FtpServicePackInfoSelectOps.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/FtpServicePackInfoSelectOps.sp,v $ $Id: FtpServicePackInfoSelectOps.sp,v 1.5.68.8 2020/07/10 22:29:07 kgao Exp $";
--  +========================================================================+
--  | Stored Proc:  FtpServicePackInfoSelectOps()
--  |
--  | Description: Returns the rows which satisfies the conditions specified in following operation types.
--		Operation 1 - Get the row with highest servicepack name uploaded before given time for given release
--		Operation 2 - get the row with servicepack name same as in case 1 but returns only major servicepack
--		Operation 3 - Get the row with DVD name which is recut with input servicepack or lesser than that
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='FtpServicePackInfoSelectOps')
BEGIN
	print '>>> Drop Stored Procedure: FtpServicePackInfoSelectOps <<<'
	drop procedure FtpServicePackInfoSelectOps
END
IF EXISTS (select * from GxQscripts where name='FtpServicePackInfoSelectOps')
	delete from GxQscripts where name = 'FtpServicePackInfoSelectOps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FtpServicePackInfoSelectOps')
	delete from GXDBVersions where aliasname = 'FtpServicePackInfoSelectOps'
GO
print '... Creating Procedure: FtpServicePackInfoSelectOps'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure FtpServicePackInfoSelectOps
  @i_operationType int,
  @i_Release varchar(32),
  @i_SPMajor integer,
  @i_SPMinor integer,
  @i_AddtionalDelayDays INTEGER
AS
  DECLARE @SPName varchar(32)
  DECLARE @SPMajor integer
  DECLARE @SPMinor integer
  DECLARE @ReleaseStr varchar(32)
  DECLARE @BuildIdString varchar(32)
  DECLARE @Timestamp integer
  DECLARE @bIsDVDPresent integer
  DECLARE @DVDName varchar(32)
  DECLARE @bShowInGUI integer
  DECLARE @FriendlyName varchar(256)
  DECLARE @TransactionId integer 
  DECLARE @RevisionId integer
BEGIN
	 DECLARE  @currentUTCTime DATETIME = GETUTCDATE()
IF @i_operationType = 1
     BEGIN
		SELECT TOP 1 S1.SPName, S1.SPMajor, S1.SPMinor, S1.ReleaseStr, S1.BuildIdString, S1.Timestamp, S1.bIsDVDPresent, S1.DVDName, S1.bShowInGUI, S1.FriendlyName, ISNULL(S2.TransactionId, 0) AS TransactionId, ISNULL(S2.RevisionId, 0) AS RevisionId
		FROM PatchSPVersion S1 WITH(NOLOCK) LEFT JOIN PatchSPVersion S2 WITH(NOLOCK) ON S1.Release = S2.Release AND S1.Build = S2.Build AND S1.SPMajor = S2.SPMajor AND S1.SPMinor = S2.SPMinor
WHERE dbo.GetUnixTime(DATEADD(dd, -(S2.nGUIDownloadDelayDays + @i_AddtionalDelayDays), @currentUTCTime)) > S2.Timestamp AND S1.ReleaseStr = @i_Release AND S1.bIsDVDPresent = 1 AND S2.nCacheFlags = 0x1 AND S2.nGUIDownloadDelayDays >= 0
		ORDER BY S1.SPMajor DESC, S1.SPMinor DESC, ISNULL(S2.TransactionId, 0) DESC, ISNULL(S2.RevisionId, 0) DESC
	 END
	 IF @i_operationType = 2
     BEGIN
		SELECT TOP 1 S1.SPName, S1.SPMajor, S1.SPMinor, S1.ReleaseStr, S1.BuildIdString, S1.Timestamp, S1.bIsDVDPresent, S1.DVDName, S1.bShowInGUI, S1.FriendlyName, ISNULL(S2.TransactionId, 0) AS TransactionId, ISNULL(S2.RevisionId, 0) AS RevisionId
		FROM PatchSPVersion S1 WITH(NOLOCK) LEFT JOIN PatchSPVersion S2 WITH(NOLOCK) ON S1.Release = S2.Release AND S1.Build = S2.Build AND S1.SPMajor = S2.SPMajor AND S1.SPMinor = S2.SPMinor
WHERE dbo.GetUnixTime(DATEADD(dd, -(S2.nGUIDownloadDelayDays + @i_AddtionalDelayDays), @currentUTCTime)) > S2.Timestamp AND S1.ReleaseStr = @i_Release AND S1.bIsDVDPresent = 1 AND S1.SPMinor = 0 AND S2.nCacheFlags = 0x1 AND S2.nGUIDownloadDelayDays >= 0
		ORDER BY S1.SPMajor DESC, S1.SPMinor DESC, ISNULL(S2.TransactionId, 0) DESC, ISNULL(S2.RevisionId, 0) DESC
	 END
	 IF @i_operationType = 3
     BEGIN
		SELECT TOP 1 S1.SPName, S1.SPMajor, S1.SPMinor, S1.ReleaseStr, S1.BuildIdString, S1.Timestamp, S1.bIsDVDPresent, S1.DVDName, S1.bShowInGUI, S1.FriendlyName, ISNULL(S2.TransactionId, 0) AS TransactionId, ISNULL(S2.RevisionId, 0) AS RevisionId
		FROM PatchSPVersion  S1 WITH(NOLOCK) LEFT JOIN PatchSPVersion S2 WITH(NOLOCK) ON S1.Release = S2.Release AND S1.Build = S2.Build AND S1.SPMajor = S2.SPMajor AND S1.SPMinor = S2.SPMinor
WHERE S1.ReleaseStr = @i_Release AND S1.bIsDVDPresent = 1 AND (S1.SPMajor < @i_SPMajor OR (S1.SPMajor = @i_SPMajor AND S1.SPMINOR <= @i_SPMinor)) AND S1.DVDName IS NOT NULL AND S1.DVDName != '' AND S2.nCacheFlags = 0x1
		ORDER BY S1.SPMajor DESC, S1.SPMinor DESC, ISNULL(S2.TransactionId, 0) DESC, ISNULL(S2.RevisionId, 0) DESC
	 END
IF @i_operationType = 4
     BEGIN
		SELECT TOP 1 S1.SPName, S1.SPMajor, S1.SPMinor, S1.ReleaseStr, S1.BuildIdString, S1.Timestamp, S1.bIsDVDPresent, S1.DVDName, S1.bShowInGUI, S1.FriendlyName, ISNULL(S2.TransactionId, 0) AS TransactionId, ISNULL(S2.RevisionId, 0) AS RevisionId
		FROM PatchSPVersion S1 WITH(NOLOCK) LEFT JOIN PatchSPVersion S2 WITH(NOLOCK) ON S1.Release = S2.Release AND S1.Build = S2.Build AND S1.SPMajor = S2.SPMajor AND S1.SPMinor = S2.SPMinor
WHERE dbo.GetUnixTime(DATEADD(dd, -(S2.nGUIDownloadDelayDays + @i_AddtionalDelayDays), @currentUTCTime)) > S2.Timestamp AND S1.ReleaseStr = @i_Release AND S1.bIsDVDPresent=1 AND (S2.nLTSFlag & 1) <> 0 AND S1.SPMajor >= @i_SPMajor AND S2.nCacheFlags = 0x1 AND S2.nGUIDownloadDelayDays >= 0
		ORDER BY S1.SPMajor DESC, S1.SPMinor DESC, ISNULL(S2.TransactionId, 0) DESC, ISNULL(S2.RevisionId, 0) DESC
	 END
END
GO

IF EXISTS (select * from GxQscripts where name = 'FtpServicePackInfoSelectOps')
	delete from GxQscripts where name = 'FtpServicePackInfoSelectOps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FtpServicePackInfoSelectOps')
	delete from GXDBVersions where aliasname = 'FtpServicePackInfoSelectOps'
GO

insert into GXDBVersions values(2, 'FtpServicePackInfoSelectOps',  '00010005006800080000', 'FtpServicePackInfoSelectOps', '00010005006800080000')
GO

