

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/FindOraclePDBs.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  FindOraclePDBs                             */
/*                                                                            */
/*  Description :  Stored proc used to return app entities                    */
/*             associated with given storage policy id                        */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/FindOraclePDBs.sp,v $ $Id: FindOraclePDBs.sp,v 1.2.44.2 2018/03/27 08:54:51 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: FindOraclePDBs <<<'

IF EXISTS (select * from sysobjects where name='FindOraclePDBs')
	drop procedure FindOraclePDBs
IF EXISTS (select * from GxQscripts where name='FindOraclePDBs')
	delete from GxQscripts where name = 'FindOraclePDBs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FindOraclePDBs')
	delete from GXDBVersions where aliasname = 'FindOraclePDBs'
GO
print '... Creating Procedure: FindOraclePDBs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure FindOraclePDBs
  @instanceId integer,
  @pointInTime integer = 0,
  @pdbName varchar(64) ='',
  @taskOrAppId integer = 0,
  @op integer = 1
AS
  DECLARE @pdbId integer;
  DECLARE @name varchar(64);
  DECLARE @instId integer;
  DECLARE @created integer;
  DECLARE @deleteFlag integer
  DECLARE @deleted integer;
  DECLARE @modified integer;
  DECLARE @opType integer;
  DECLARE @dbAttributes XML;
BEGIN
SET NOCOUNT ON
IF @taskOrAppId = 0
BEGIN
SELECT pdbId, name, instId, created, deleteFlag, deleted, modified, opType, dbAttributes
FROM  OraclePluggableDBs WITH(NOLOCK) where instId = @instanceId and (@pdbName = '' or @pdbName = name)
and ( (@pointInTime = 0 and deleteFlag = 0) or
      (@pointInTime <> 0 and created <= @pointInTime and (deleteFlag = 0 or @pointInTime < deleted) ) )
order by pdbId
END
ELSE
BEGIN
	SELECT pdbId, name, instId, created, deleteFlag, deleted, modified, opType, dbAttributes
	FROM  OraclePluggableDBs  WITH(NOLOCK) where instId = @instanceId and (@pdbName = '' or @pdbName = name)
		and ( (@pointInTime = 0 and deleteFlag = 0) or
		(@pointInTime <> 0 and created <= @pointInTime and (deleteFlag = 0 or @pointInTime < deleted) ) )
		and pdbId in
		 (
			select  case when type = 20 then objId	 when type = 5 then parentId end
			 from OracleObjects where instId = @instanceId and (type = 20 or type = 5)
			and ( (@op = 1 and taskId = @taskOrAppId) or (@op = 2 and subClientId = @taskOrAppId) )
			UNION
			select isnull(pdbId, 0) from OracleTableSpaces where  instId = @instanceId and
			id in (select parentId from OracleObjects where instId = @instanceId and   type = 1
			and ( (@op = 1 and taskId = @taskOrAppId) or (@op = 2 and subClientId = @taskOrAppId) ) )
		) order by pdbId
END
END
GO

IF EXISTS (select * from GxQscripts where name = 'FindOraclePDBs')
	delete from GxQscripts where name = 'FindOraclePDBs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FindOraclePDBs')
	delete from GXDBVersions where aliasname = 'FindOraclePDBs'
GO

insert into GXDBVersions values(2, 'FindOraclePDBs',  '00010002004400020000', 'FindOraclePDBs', '00010002004400020000')
GO

