

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/FDC_RestoreDatabase.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Restore Database
--  +========================================================================+
-- $Id: FDC_RestoreDatabase.sp,v 1.8.2.2 2018/03/20 00:49:36 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: FDC_RestoreDatabase <<<'

IF EXISTS (select * from sysobjects where name='FDC_RestoreDatabase')
	drop procedure FDC_RestoreDatabase
IF EXISTS (select * from GxQscripts where name='FDC_RestoreDatabase')
	delete from GxQscripts where name = 'FDC_RestoreDatabase'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_RestoreDatabase')
	delete from GXDBVersions where aliasname = 'FDC_RestoreDatabase'
GO
print '... Creating Procedure: FDC_RestoreDatabase'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure FDC_RestoreDatabase
  @srcDbName nvarchar(MAX),
  @srcFolder nvarchar(max),
  @dstDbName nvarchar(max),
  @dstFolder nvarchar(max)
AS
  DECLARE @errorCode integer
  DECLARE @errorString nvarchar(MAX)
	SET XACT_ABORT ON
	SET NOCOUNT ON
	DECLARE @SQLString nvarchar(MAX)
	SET @errorCode = 0
	SET @errorString = 'NO ERROR'
	SET @dstFolder = (select filename from sysfiles where name = 'cx_data1')
	SET @dstFolder = SUBSTRING (@dstFolder, 0, (LEN ( @dstFolder) - CHARINDEX ('\', REVERSE(@dstFolder)) + 1))
	SET @SQLString = N'RESTORE DATABASE [' + @dstDbName + '] ' +
	'FROM  DISK = N''' + @srcFolder + '\' + @srcDbName + '.dmp'' ' +
	'WITH  FILE = 1, ' +
	'MOVE N''' + @srcDbName + ''' TO N''' + @dstFolder + '\' + @dstDbName + '.mdf'', ' +
	'MOVE N''' + @srcDbName + '_log'' TO N'''  + @dstFolder + '\' + @dstDbName + '.LDF'', ' +
	'NOUNLOAD,  REPLACE,  STATS = 10 '
	BEGIN TRY
		EXECUTE sp_executesql @SQLString;
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @errorCode = ERROR_NUMBER(),
		@errorString = ERROR_MESSAGE()
   		RAISERROR (@ErrorString, 16,1)
   		SELECT	@errorCode, @errorString
		RETURN (-1)
	END CATCH
	SELECT	0, @errorString
	RETURN (0)
GO

IF EXISTS (select * from GxQscripts where name = 'FDC_RestoreDatabase')
	delete from GxQscripts where name = 'FDC_RestoreDatabase'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_RestoreDatabase')
	delete from GXDBVersions where aliasname = 'FDC_RestoreDatabase'
GO

insert into GXDBVersions values(2, 'FDC_RestoreDatabase',  '00010008000200020000', 'FDC_RestoreDatabase', '00010008000200020000')
GO

