

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/FDC_PostMergeProc.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: FDC_PostMergeProc <<<'

IF EXISTS (select * from sysobjects where name='FDC_PostMergeProc')
	drop procedure FDC_PostMergeProc
IF EXISTS (select * from GxQscripts where name='FDC_PostMergeProc')
	delete from GxQscripts where name = 'FDC_PostMergeProc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_PostMergeProc')
	delete from GXDBVersions where aliasname = 'FDC_PostMergeProc'
GO
print '... Creating Procedure: FDC_PostMergeProc'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure FDC_PostMergeProc
  @inputXMLStr VARCHAR(MAX)
AS
  DECLARE @errorCode INTEGER;
  DECLARE @errorString VARCHAR(MAX);
BEGIN TRY
	BEGIN TRANSACTION FDCPostMergeProc
	DECLARE @logMessage NVARCHAR(MAX)
	SET @logMessage = @inputXMLStr
	EXEC DBLog_Write 1, 'FDC_PostMergeProc', @logMessage
	DECLARE @xmlDoc XML
	SET @xmlDoc = CAST(@inputXMLStr AS XML)
	DECLARE @mergeTime INT
	SELECT @mergeTime = Attributes.list.value('@MergeTime', 'INT') FROM @xmlDoc.nodes('/FDC_PostMergeProcInputs') AS Attributes(list)
	SET @logMessage = 'Setting merge time to ' + CAST(ISNULL(@mergeTime, '**NULL**') AS NVARCHAR(MAX))
	EXEC DBLog_Write 1, 'FDC_PostMergeProc', @logMessage
	DECLARE @curUnixTime INTEGER
	SET @curUnixTime = dbo.GetUnixTime(GETUTCDATE())
	IF ((NOT EXISTS(SELECT * FROM GXGlobalParam WHERE name = 'EDCDumpCaptureTime')) AND (@mergeTime <> 0) AND (@mergeTime IS NOT NULL))
	BEGIN
		PRINT 'Setting  EDCDumpCaptureTime to ' + CAST(@mergeTime AS NVARCHAR(MAX))
		INSERT INTO GXGlobalParam(name, value, created, modified)
		VALUES ('EDCDumpCaptureTime', CAST(@MergeTime AS NVARCHAR(10)), @curUnixTime, 0)
		IF @@ERROR <> 0
		BEGIN
			SET @logMessage =
					'ERROR: PROC(' + ERROR_PROCEDURE() +
					'), LINE(' + CAST(ERROR_LINE() AS NVARCHAR(10)) +
					'), ERROR(' + CAST(ERROR_NUMBER() AS NVARCHAR(10)) +
					'), INFO: ' + ERROR_MESSAGE() + '.'
			SELECT -1, @logMessage
			ROLLBACK TRANSACTION FDCPostMergeProc
			RETURN
		END
	END
	SELECT 0, 'NO_ERROR'
	COMMIT TRANSACTION FDCPostMergeProc
	RETURN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @logMessage =
		'ERROR: PROC(' + ERROR_PROCEDURE() +
		'), LINE(' + CAST(ERROR_LINE() AS NVARCHAR(10)) +
		'), ERROR(' + CAST(ERROR_NUMBER() AS NVARCHAR(10)) +
		'), INFO: ' + ERROR_MESSAGE() + '.'
	RAISERROR ('%s' , 16, 1, @logMessage)
	ROLLBACK TRANSACTION FDCPostMergeProc
	SELECT -1, @logMessage
END CATCH

IF EXISTS (select * from GxQscripts where name = 'FDC_PostMergeProc')
	delete from GxQscripts where name = 'FDC_PostMergeProc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_PostMergeProc')
	delete from GXDBVersions where aliasname = 'FDC_PostMergeProc'
GO

insert into GXDBVersions values(2, 'FDC_PostMergeProc',  '00000000000000000000', 'FDC_PostMergeProc', '00000000000000000000')
GO

