

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/FDC_Merge_VMGuestSize.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: to merge the guest size of the VM.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='FDC_Merge_VMGuestSize')
BEGIN
	print '>>> Drop Stored Procedure: FDC_Merge_VMGuestSize <<<'
	drop procedure FDC_Merge_VMGuestSize
END
IF EXISTS (select * from GxQscripts where name='FDC_Merge_VMGuestSize')
	delete from GxQscripts where name = 'FDC_Merge_VMGuestSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Merge_VMGuestSize')
	delete from GXDBVersions where aliasname = 'FDC_Merge_VMGuestSize'
GO
print '... Creating Procedure: FDC_Merge_VMGuestSize'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure FDC_Merge_VMGuestSize
  @FilePath varchar(MAX)
AS
  DECLARE @errCode integer;
  DECLARE @errStr varchar(MAX);
SET NOCOUNT ON
--DECLARE @errCode integer
SET @errCode = 0
SET @errStr = 'NO ERROR'
BEGIN TRY
	DECLARE @serverAliasName nvarchar(250)
	DECLARE @commCellId INTEGER
	DECLARE @jobCount INTEGER
	DECLARE @attrType INTEGER
	DECLARE @mappedJobId INTEGER
	DECLARE @SQLString nvarchar(500);
	DECLARE @ParmDefinition nvarchar(500);
	DECLARE @clientId INTEGER
	DECLARE @AppID	INTEGER
	DECLARE @input xml;
	SET @SQLString = N'set @local_xml_Out=( SELECT * FROM OPENROWSET ( BULK ''' + @FilePath + ''', SINGLE_CLOB ) AS xmlData)';
	SET @ParmDefinition = N'@local_xml_OUT xml OUTPUT';
	EXECUTE sp_executesql @SQLString, @ParmDefinition, @local_xml_OUT=@input OUTPUT;
	BEGIN TRANSACTION TRAN_FDC_Merge_VMGuestSize
	SET @commCellId = 2
	SET @attrType = 2
	SET @mappedJobId = 0
	SET @clientId = 0
	SET @appID = 0
	SELECT @jobCount = @input.value('count(/FDC_VEEAMJobListForGuestSize/veeamClientVMGuestSize/@jobId)', 'int')
--	select 'jobCount =', @jobCount
	IF(@jobCount = 0 or @jobCount is null)
	BEGIN
		SET @errStr = 'NO_ERROR'
		SET @errCode = 0
		GOTO NORMAL_EXIT
	END
	--SET @serverAliasName = 'NBU_CommNetInt'
	SET  @serverAliasName = ISNULL((SELECT TOP 1 ref.value('@commCellName', 'NVARCHAR(250)')
		FROM @input.nodes('FDC_VEEAMJobListForGuestSize/veeamClientVMGuestSize/commcell') R ( ref )),0)
	--	select @commCellId, @serverAliasName
	if(@commCellId = 0 or @serverAliasName='' or @serverAliasName is null)
	begin
		set @errCode = -1
		set @errStr = 'ERROR: COMMCELL WAS NOT SPECIFIED IN XML'
		goto NORMAL_EXIT
	end
	DECLARE @mergedServerId INT
	DECLARE @edcCvJobCounter INT
	DECLARE @edcCvJobCounterName nvarchar(18)
	--get merged CS id by aliasName:
	SET @mergedServerId = (select id from APP_CommCell where aliasName = @serverAliasName)
	--select '@mergedServerId = ', @mergedServerId
	if(@mergedServerId is null)
	BEGIN
		set @errStr = '2 WARNING - server was not merged yet'
		set @errCode = 2
		GOTO NORMAL_EXIT
	END
	SELECT
			ref.value('@jobId', 'int')				as 'jobId',
			ref.value('@clientVMGuestSize', 'int')			as 'clientVMGuestSize',
			@mergedServerId						as 'commCellId',
			ref.value('@dummyClientName', 'NVARCHAR(255)')		as 'dummyClientName',
			@mappedJobId						as 'mappedJobId',
			ref.value('@clientName', 'NVARCHAR(255)')		as 'clientName',
			ref.value('@subClientName', 'NVARCHAR(128)')		as 'subClientName',
			@clientId						as 'clientId',
			@appId							as 'appId'
	INTO #tempVM_Props
	FROM @input.nodes('FDC_VEEAMJobListForGuestSize/veeamClientVMGuestSize') R ( ref )
	UPDATE #tempVM_Props
	SET clientId = (SELECT A.id FROM APP_Client A, edcClientNameMap ClMap
	WHERE ClMap.exMachineName = #tempVM_Props.clientName AND A.name = ClMap.gxMachineName AND ClMap.exServerAliasName = @serverAliasName)
	UPDATE #tempVM_Props
	SET appId = (SELECT A.id FROM APP_Application A
	WHERE A.clientId = #tempVM_Props.clientId AND A.subclientName = #tempVM_Props.subClientName)
	UPDATE #tempVM_Props
	SET appId = (SELECT A.id FROM APP_Application A
	WHERE A.clientId = #tempVM_Props.clientId AND A.subclientName = 'default') WHERE appID IS NULL
	SELECT * INTO #tmp from edcJobIdMap e JOIN JMBkpStats JM ON e.newJobId = JM.jobId
	UPDATE #tempVM_Props
	SET mappedJobId = (select TOP 1 #tmp.newJobId FROM #tmp
	WHERE #tmp.foreignJobId = SUBSTRING(#tempVM_Props.jobId, 0, CHARINDEX('_', #tempVM_Props.jobId))
		AND #tmp.appId = #tempVM_Props.appId)
--BEGIN
		INSERT INTO APP_VMProp (jobId, commCellId, VMClientId, attrName, attrType, attrVal, ClientJobId)
		SELECT
			T.mappedJobId, @mergedServerId,
			client.id, 'vmAgent', @attrType, T.dummyClientName, T.mappedJobId
		FROM APP_Client client, #tempVM_Props T
		LEFT OUTER JOIN APP_VMProp A ON A.jobId = T.mappedJobId AND A.vmClientId = client.id AND A.attrName LIKE '%Agent%'
		WHERE client.name = T.dummyClientName
		AND A.jobId IS NULL
		set @errCode = @@ERROR
		IF @errCode > 0
			GOTO NORMAL_EXIT
		INSERT INTO APP_VMProp (jobId, commCellId, VMClientId, attrName, attrType, attrVal, ClientJobId)
		SELECT
			T.mappedJobId, @mergedServerId,
			client.id, 'vmGuestSize', @attrType, T.clientVMGuestSize, T.mappedJobId
		FROM APP_Client client, #tempVM_Props T
		LEFT OUTER JOIN APP_VMProp A ON A.jobId = T.mappedJobId AND A.vmClientId = client.id AND A.attrName LIKE '%GuestSize%'
		WHERE client.name = T.dummyClientName
		AND A.jobId IS NULL
		set @errCode = @@ERROR
		IF @errCode > 0
			GOTO NORMAL_EXIT
		COMMIT	TRANSACTION TRAN_FDC_Merge_VMGuestSize
--END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errStr =
		'ERROR: PROC(' + ERROR_PROCEDURE() +
		'), LINE(' + CAST(ERROR_LINE() AS NVARCHAR(10)) +
		'), ERROR(' + CAST(ERROR_NUMBER() AS NVARCHAR(10)) +
		'), INFO: ' + ERROR_MESSAGE() + '.'
	RAISERROR ('%s' , 16, 1, @errStr)
--	SELECT @errorCode, @errorString
	IF(@errCode = 0)
		SET @errCode = -1
END CATCH
NORMAL_EXIT:
IF OBJECT_ID('tempdb.dbo.#tempVM_Props') is not null DROP TABLE #tempVM_Props
IF(@errCode != 0)
	ROLLBACK TRANSACTION TRAN_FDC_Merge_VMGuestSize
select @errCode, @errStr
RETURN (@errCode)
GO

IF EXISTS (select * from GxQscripts where name = 'FDC_Merge_VMGuestSize')
	delete from GxQscripts where name = 'FDC_Merge_VMGuestSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Merge_VMGuestSize')
	delete from GXDBVersions where aliasname = 'FDC_Merge_VMGuestSize'
GO

insert into GXDBVersions values(2, 'FDC_Merge_VMGuestSize',  '00000000000000000000', 'FDC_Merge_VMGuestSize', '00000000000000000000')
GO

