

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/FDC_Merge_StoragePolicy.sp] ---------- 

--  +===========================================================================================+
--  | Stored Precedure: Merge Storage Policy, Storage Policy Copy and retention data to migrate.
--  +===========================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='FDC_Merge_StoragePolicy')
BEGIN
	print '>>> Drop Stored Procedure: FDC_Merge_StoragePolicy <<<'
	drop procedure FDC_Merge_StoragePolicy
END
IF EXISTS (select * from GxQscripts where name='FDC_Merge_StoragePolicy')
	delete from GxQscripts where name = 'FDC_Merge_StoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Merge_StoragePolicy')
	delete from GXDBVersions where aliasname = 'FDC_Merge_StoragePolicy'
GO
print '... Creating Procedure: FDC_Merge_StoragePolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure FDC_Merge_StoragePolicy
  @FilePath varchar(MAX)
AS
  DECLARE @errCode integer;
  DECLARE @errStr nvarchar(MAX);
SET NOCOUNT ON
--DECLARE @errCode integer
SET @errCode = 0
SET @errStr = 'NO ERROR'
	DECLARE @iDoc INTEGER
	DECLARE @serverAliasName nvarchar(250)
	DECLARE @mergedCCId INTEGER
	DECLARE @curUnixTime INTEGER
	DECLARE @storagePolicyCount INTEGER
DECLARE @SQLString nvarchar(500);
DECLARE @ParmDefinition nvarchar(500);
DECLARE @input xml;
BEGIN TRY
SET @SQLString = N'set @local_xml_Out=( SELECT * FROM OPENROWSET ( BULK ''' + @FilePath + ''', SINGLE_CLOB ) AS xmlData)';
SET @ParmDefinition = N'@local_xml_OUT xml OUTPUT';
DECLARE @message NVARCHAR(MAX)
DECLARE @rowcnt	 INT
BEGIN TRANSACTION SPMerge
EXECUTE sp_executesql @SQLString, @ParmDefinition, @local_xml_OUT=@input OUTPUT;
	exec @errCode = sp_xml_preparedocument @iDoc OUTPUT, @input
	if @@error <> 0 OR @errCode <> 0
		GOTO SP_MERGE_EXIT
	--print 'ready with XML parsing'
	SET @curUnixTime = dbo.GetUnixTime(GETUTCDATE())
	-- Get the number of storage policies in XML
	SET @storagePolicyCount =
	(
		SELECT count(policyname)
		FROM
			OPENXML(@iDoc, 'FDC_StoragePolicyList/spList', 0)WITH(policyname NVARCHAR(250) '@policyname')
	)
	DECLARE @isForceMergeEnabled BIT = (
											SELECT ( CASE isForceMergeEnabled WHEN '0' THEN 0 ELSE 1 END )
											FROM
												OPENXML( @iDoc, 'FDC_StoragePolicyList')
											WITH
												( isForceMergeEnabled VARCHAR(1) '@forceMerge' )
										)
	SET @message = 'Force merge has been ' + ( CASE @isForceMergeEnabled WHEN 1 THEN 'Enabled' ELSE 'Disabled' END )
	EXEC DBLog_Write 1, 'FDC_Merge_StoragePolicy', @message
	--print 'No. of storage policies to import'
	--print @storagePolicyCount
	IF(@storagePolicyCount = 0 or @storagePolicyCount is null)
	BEGIN
		SET @errStr = 'NO_ERROR'
		SET @errCode = 0
		GOTO SP_MERGE_EXIT
	END
	-- Get the foreign server name
	SELECT top 1 @serverAliasName = foreignServerName
	FROM
		OPENXML(@iDoc, 'FDC_StoragePolicyList', 0)WITH(foreignServerName NVARCHAR(250) '@foreignServerName')
	IF(@serverAliasName='' or @serverAliasName is null)
	BEGIN
		SET @errCode = -1
		SET @errStr = 'ERROR: COMMCELL WAS NOT SPECIFIED IN XML'
		goto SP_MERGE_EXIT
	END
	--print 'Foreign server name:'
	--print @serverAliasName
	-- Get merged CC id by aliasName
	SET @mergedCCId = (SELECT id FROM APP_CommCell WHERE aliasName = @serverAliasName)
	--print 'Merged CCId:'
	--print @mergedCCId
	IF(@mergedCCId is null)
	BEGIN
		SET @errStr = '2 WARNING - server was not merged yet'
		SET @errCode = 2
		GOTO SP_MERGE_EXIT
	END
	--print 'read storage Policy info'
	IF OBJECT_ID('tempdb.dbo.#temparchGroup') is not null drop table #temparchGroup
	-- Retreive the storagepolicy information from the XML
	SELECT
		txml.policyname       as 'policyname',
		ISNULL(txml.description, '')      as 'description',
		txml.defaultCopyName  as 'defaultCopyName',
		ISNULL(txml.maxStreams, 1)       as 'maxStreams',
		ISNULL(txml.type, 5)             as 'type',
		ISNULL(txml.defaultSnapCopyName, '') as 'defaultSnapCopyName',
		ISNULL(txml.SIBlockSizeKB, 0)    as 'SIBlockSizeKB',
		ISNULL(txml.flags, 0)            as 'flags',
		ISNULL(txml.TimeZone, '')         as 'TimeZone',
		0								as 'origCCarchGroupId'
	INTO #temparchGroup
	FROM
		OPENXML(@iDoc, 'FDC_StoragePolicyList/spList', 0)WITH
		(
			policyname nvarchar(288) '@policyname',
			description nvarchar(250) '@description',
			defaultCopyName nvarchar(250) '@defaultCopyName',
			maxStreams int '@maxStreams',
			type int '@type',
			defaultSnapCopyName nvarchar(250) '@defaultSnapCopyName',
			SIBlockSizeKB int '@SIBlockSizeKB',
			flags int '@flags',
			TimeZone nvarchar(250) '@TimeZone'
		) as txml
	SET @message = 'Number of Storage Policies:' + CAST( @@ROWCOUNT AS VARCHAR(5) )
	EXEC DBLog_Write 1, 'FDC_Merge_StoragePolicy', @message
	DECLARE @origAgID int
	SET @origAgID = ISNULL((select MAX(origCCarchGroupId) from archGroup where origCCcommCellID = @mergedCCId), 0)
	UPDATE #temparchGroup
	SET origCCarchGroupId = @origAgId,
	@origAgId = @origAgId + 1
	FROM #temparchGroup T
	WHERE T.policyname Not In (select name from archGroup where origCCcommCellID = @mergedCCId)
	--print 'Retreived the archGroup data from the Xml'
	-- Insert into archGroup table, insert only values for which storage policy name does not exist in archGroup table
	INSERT INTO archGroup(defaultCopy, name, description, maxStreams, type, incrSP, origCCCommCellID,
				origCCarchGroupId, defaultSnapCopy, SIBlockSizeKB, AuxCopyAlertGB,
				AuxCopyAlertDays, flags, mediaPassword, TimeZoneType, TimeZone)
	SELECT 0, T.policyname, T.description, T.maxStreams, T.type, 0, @mergedCCId,
		T.origCCarchGroupId, 0, T.SIBlockSizeKB, 0,
		0, T.flags, '', 0, T.TimeZone
	FROM #temparchGroup T
	WHERE T.policyname Not In ( select name from archGroup where origCCcommCellID = @mergedCCId)
	select @errCode = @@ERROR, @rowcnt = @@ROWCOUNT
	IF @errCode <> 0
	BEGIN
		SET @errStr = 'FDC_Merge_StoragePolicy : Insert archGroup Failed'
		GOTO SP_MERGE_EXIT
	END
	SET @message = 'Number of Storage Policies added:' + CAST( @rowcnt AS VARCHAR(5) )
	EXEC DBLog_Write 1, 'FDC_Merge_StoragePolicy', @message
	--Update archGroup table for which storagepolicy name already exists
	UPDATE archGroup
	set description = T.description,
	maxStreams = T.maxStreams,
	type = T.type,
	SIBlockSizeKB = T.SIBlockSizeKB,
	flags = T.flags,
	TimeZone = T.TimeZone
	FROM #temparchGroup T, archGroup A
	WHERE T.policyname = A.name and A.origCCcommCellID = @mergedCCId
	select @errCode = @@ERROR, @rowcnt = @@ROWCOUNT
	IF @errCode <> 0
	BEGIN
		SET @errStr = 'FDC_Merge_StoragePolicy : Update archGroup for which storagepolicy name already exists Failed'
		GOTO SP_MERGE_EXIT
	END
	SET @message = 'Number of Storage Policies updated:' + CAST( @rowcnt AS VARCHAR(5) )
	EXEC DBLog_Write 1, 'FDC_Merge_StoragePolicy', @message
	--print 'Inserted the archGroup data to the table'
	-- Retreive the storage policy copy information from the XML
	IF OBJECT_ID('tempdb.dbo.#temparchGroupCopy') is not null drop table #temparchGroupCopy
	SELECT
		txml.archGroupName       as 'archGroupName',
		txml.copy      as 'copy',
		txml.name  as 'name',
		ISNULL(txml.flags, 0)       as 'flags',
		ISNULL(txml.maxMultiplex, 0)             as 'maxMultiplex',
		ISNULL(txml.isActive, 1) as 'isActive',
		ISNULL(txml.type, 1)    as 'type',
		ISNULL(txml.delayedDays, 0)            as 'delayedDays',
		ISNULL(txml.maxStreamNum, 0)         as 'maxStreamNum',
		ISNULL(txml.encType, 0)            as 'encType',
		ISNULL(txml.isSnapCopy, 0)         as 'isSnapCopy',
		ISNULL(txml.description, '')	as 'description',
		ISNULL(txml.retentionDays, -1)	as 'retentionDays',
		ISNULL(txml.retentionType, 1)	as 'retentionType',
		0 as 'archGroupId',
		0 as 'copyId',
		0 as 'origCCarchCopyId',
		0 as 'retentionJobs'
	INTO #temparchGroupCopy
	FROM
		OPENXML(@iDoc, 'FDC_StoragePolicyList/spList/spCopyList', 0)
		WITH
		(
			archGroupName nvarchar(288) '@archGroupName',
			copy int '@copy',
			name nvarchar(250) '@name',
			flags int '@flags',
			maxMultiplex int '@maxMultiplex',
			isActive int '@isActive',
			type int '@type',
			delayedDays int '@delayedDays',
			maxStreamNum int '@maxStreamNum',
			encType int '@encType',
			isSnapCopy int '@isSnapCopy',
			description nvarchar(250) '@description',
			retentionDays int '@retentionDays',
			retentionType int '@retentionType'
		) as txml
	--print 'Retreived the archGroupCopy data from the Xml'
	--Update the archGroupId in the archGroupCopy table
	DECLARE @origAgCID int
	SET @origAgCID = ISNULL((select MAX(origCCarchCopyId) from archGroupCopy where origCCcommCellID = @mergedCCId), 0)
	UPDATE #temparchGroupCopy
	SET origCCarchCopyId = @origAgCId,
	@origAgCId = @origAgCId + 1
	FROM #temparchGroupCopy T, archGroupCopy A
	WHERE T.name NOT IN (select name from archGroupCopy where T.archGroupId = archGroupId and origCCcommCellID = @mergedCCId)
	UPDATE #temparchGroupCopy
	SET archGroupId = AG.id
	FROM archGroup as AG
	WHERE AG.name = archGroupName
	AND AG.origCCcommCellID = @mergedCCId
	--Update archGroupCopy table for which storagepolicy id and copyname already exists
	UPDATE archGroupCopy
	set description = T.description,
	maxMultiplex = T.maxMultiplex,
	type = T.type,
	isActive = T.isActive,
	flags = T.flags,
	delayedDays = T.delayedDays,
	maxStreamNum = T.maxStreamNum,
	encType = T.encType
	FROM #temparchGroupCopy T, archGroupCopy A
	WHERE T.name = A.name and T.archGroupId = A.archGroupId
	AND A.origCCcommCellID = @mergedCCId
	set @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errStr = 'FDC_Merge_StoragePolicy : Update archGroupCopy table for which storagepolicy id and copyname already exists Failed'
		GOTO SP_MERGE_EXIT
	END
	--Update archAgingRule table for which storagepolicy id and copyname already exists
	UPDATE archAgingRule
	set retentionDays = T.retentionDays,
	fullCycles = case when (T.retentionDays < 0) then -1 else 1 end,
	retentionJobs = T.retentionJobs
	FROM #temparchGroupCopy T, archGroupCopy A, archAgingRule as AR
	WHERE T.name = A.name and T.archGroupId = A.archGroupId and A.id = AR.copyId
	AND A.origCCCommcellId = @mergedCCId
	set @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errStr = 'FDC_Merge_StoragePolicy : Update archAgingRule table for which storagepolicy id and copyname already exists Failed'
		GOTO SP_MERGE_EXIT
	END
	-- make a copy
	Select *
	into #tempAGCCopyTable
	from #temparchGroupCopy
	-- Delete rows in #temparchGroupCopy matching from archGroupCopy table
	delete #temparchGroupCopy from #temparchGroupCopy T INNER JOIN archGroupCopy A ON
		T.archGroupId = A.archGroupId AND T.name = A.name AND A.origCCcommCellID = @mergedCCId
	INSERT INTO archGroupCopy
			(archGroupId, copy, name, flags,
			maxMultiplex, isActive, type, startTime, waitForIfOffline,
			waitForIfBusy, archCheckStartTime, origCCcommCellID, origCCarchCopyId, sourceCopyId,
			delayedDays, maxStreamNum, archCheckValidPeriod, calendarId, SIDBStoreId,
			encType, encKeyLen, isSnapCopy, isMirrorCopy, NWWriteSpeed,
			SIDBSnapIntervalHours, siloAppId, nDataInstance, description, dedupeFlags,
			blockCacheValidDays, nSiloStreams, silosInCache, siloRestoreMAClientId, siloRestoreClientId,
			sealStoreTaskId, extendedFlags, destMediaCopyId, archCheckValidPeriodType, endTime)
	SELECT	T.archGroupId, T.copy, T.name, T.flags,
			T.maxMultiplex, T.isActive, T.type,	0, 0,
			0, 0, @mergedCCId, T.origCCarchCopyId, 0,
			T.delayedDays, T.maxStreamNum, 0, 1, 0,
			T.encType, 0, T.isSnapCopy, 0, 0,
			0, 0, 0, T.description, 0,
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 2147483647
	FROM #temparchGroupCopy T
	--WHERE T.archGroupId <> AGC.archGroupId and T.name <> AGC.name
	--WHERE T.name <> AGC.name
	set @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errStr = 'FDC_Merge_StoragePolicy : Insert archGroupCopy Failed'
		GOTO SP_MERGE_EXIT
	END
	-- Update #temparchGroupCopy table with CopyId
	UPDATE #temparchGroupCopy
	SET copyId = AGC.id
	FROM archGroupCopy as AGC, #temparchGroupCopy as T
	WHERE T.archGroupId = AGC.archGroupId and T.name = AGC.name COLLATE Latin1_General_CS_AS AND AGC.origCCcommCellID = @mergedCCId
	--print 'Inserted the archGroupCopy data to the table'
	--Update the defaultCopy column in the archGroup table
	UPDATE archGroup
	SET defaultCopy = AGC.id
	FROM archGroupCopy AGC, #temparchGroup T
	WHERE archGroup.id = AGC.archGroupId and T.defaultCopyName = AGC.name
	AND AGC.origCCcommCellID = @mergedCCId
	set @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errStr = 'FDC_Merge_StoragePolicy : Update archGroup table for defaultCopy column Failed'
		GOTO SP_MERGE_EXIT
	END
	--Update the defaultSnapCopy column in the archGroup table
	UPDATE archGroup
	SET defaultSnapCopy = archGroupCopy.id
	FROM archGroupCopy, #temparchGroup T
	WHERE archGroup.id = archGroupCopy.archGroupId and T.defaultSnapCopyName = archGroupCopy.name and archGroup.origCCcommCellID = @mergedCCId
	set @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errStr = 'FDC_Merge_StoragePolicy : Update archGroup table for defaultSnapCopy column Failed'
		GOTO SP_MERGE_EXIT
	END
	--print 'Inserted the archAgingRule data to the table'
	-- Set the ageing rule for the storage policy
	INSERT INTO archAgingRule(copyId, retentionDays, fullCycles,
				flags, weekStart, monthStart, yearStart, archiverRetDays, retentionJobs,minutesSinceDayStarts)
	SELECT AGC.id, T.retentionDays, case when (T.retentionDays < 0) then -1 else 1 end,
		2, 5, 1, 0, -1, T.retentionJobs,0
	FROM archGroupCopy as AGC, #temparchGroupCopy as T
	WHERE AGC.name = T.name COLLATE Latin1_General_CS_AS and AGC.archGroupId = T.archGroupId and NOT EXISTS (select copyId from archAgingRule WITH (NOLOCK) where copyId = AGC.id)
	AND AGC.origCCcommCellID = @mergedCCId
	set @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errStr = 'FDC_Merge_StoragePolicy : Insert archAgingRule Failed'
		GOTO SP_MERGE_EXIT
	END
	-- Update archAgingRule flag field if Managed disk space is set in XML i.e. retention Type = 2
	UPDATE archAgingRule
	SET archAgingRule.flags = archAgingRule.flags | 8
	FROM archGroupCopy as AGC, #tempAGCCopyTable as T
	WHERE AGC.name = T.name and AGC.archGroupId = T.archGroupId and T.retentionType = 2 and archAgingRule.copyId = AGC.id
	AND AGC.origCCcommCellID = @mergedCCId
	set @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errStr = 'FDC_Merge_StoragePolicy : Update archAgingRule for Managed Disk space Failed'
		GOTO SP_MERGE_EXIT
	END
	--Update archAgingRule flag field if it is spool copy i.e. retentionType = 3
	UPDATE archAgingRule
	SET archAgingRule.archiverRetDays = 0,
	archAgingRule.fullCycles = 0,
	archAgingRule.retentionDays = 0,
	archAgingRule.retentionJobs = 0
	FROM archGroupCopy as AGC, #tempAGCCopyTable as T
	WHERE AGC.name = T.name and AGC.archGroupId = T.archGroupId and T.retentionType = 3 and archAgingRule.copyId = AGC.id
	AND AGC.origCCcommCellID = @mergedCCId
	set @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errStr = 'FDC_Merge_StoragePolicy : Update archAgingRule for spool copy failed'
		GOTO SP_MERGE_EXIT
	END
	-- Retreive the Datapath information and set in MMDatapath table
	IF OBJECT_ID('tempdb.dbo.#tempMMDatapath') is not null drop table #tempMMDatapath
	create table #tempMMDatapath(
			id int IDENTITY(1, 1),
			CopyName nvarchar(288),
			policyname nvarchar(288),
			DrivePoolName nvarchar(288),
			HostClientName nvarchar(250),
			Flag int,
			ReadinessFlag int,
			Priority int,
			IsHardwareCompressed int,
			ChunkSizeMB int,
			FlushBlockSizeKB int,
			UseHardwareEncryption int,
			LibraryName nvarchar(288),
			DrivePoolId int,
			HostClientId int,
			CopyId int
			)
	INSERT INTO #tempMMDatapath
	SELECT
		txml.CopyName       as 'CopyName',
		txml.policyname		as 'policyname',
		ISNULL(txml.DrivePoolName, '')      as 'DrivePoolName',
		txml.HostClientName  as 'HostClientName',
		ISNULL(txml.Flag, 0)       as 'Flag',
		ISNULL(txml.ReadinessFlag, 0)             as 'ReadinessFlag',
		ISNULL(txml.Priority, 0) as 'Priority',
		ISNULL(txml.IsHardwareCompressed, 0)    as 'IsHardwareCompressed',
		ISNULL(txml.ChunkSizeMB, 0)            as 'ChunkSizeMB',
		ISNULL(txml.FlushBlockSizeKB, 0)         as 'FlushBlockSizeKB',
		ISNULL(txml.UseHardwareEncryption, 0)            as 'UseHardwareEncryption',
		txml.LibraryName			as 'LibraryName',
		0 as 'DrivePoolId',
		0 as 'HostClientId',
		0 as 'CopyId'
	FROM
		OPENXML(@iDoc, 'FDC_StoragePolicyList/spList/spCopyList/spDataPathList', 0)
		WITH
		(
			CopyName nvarchar(288) '@CopyName',
			policyname nvarchar(288) '@PolicyName',
			DrivePoolName nvarchar(288) '@DrivePoolName',
			HostClientName nvarchar(250) '@HostClientName',
			Flag int '@Flag',
			ReadinessFlag int '@ReadinessFlag',
			Priority int '@Priority',
			IsHardwareCompressed int '@IsHardwareCompressed',
			ChunkSizeMB int '@ChunkSizeMB',
			FlushBlockSizeKB int '@FlushBlockSizeKB',
			UseHardwareEncryption int '@UseHardwareEncryption',
			LibraryName nvarchar(288) '@LibraryName'
		) as txml
    -- Delete duplicate datapaths sent in the XML. Duplicate datapaths are not supported in Galaxy.
	DELETE FROM #tempMMDatapath
	WHERE id NOT IN
	(
	   SELECT MAX(id)
	   FROM #tempMMDatapath
	   GROUP BY CopyName, policyname, DrivePoolName, HostClientName, LibraryName
	)
	--print 'Retreived the MMDatapath data from the Xml'
	-- Update the HostClientId in #tempMMDatapath table
	UPDATE #tempMMDatapath
	SET HostClientId = APPC.id
	FROM APP_Client as APPC, edcClientNameMap as T
	WHERE HostClientName = T.exMachineName and APPC.name = T.gxMachineName
	-- Update the copyId in #tempMMDatapath table
	UPDATE #tempMMDatapath
	SET CopyId = AGC.id
	FROM archGroupCopy as AGC, archGroup as AG
	WHERE AGC.name = CopyName and AGC.archGroupId = AG.id and AG.name = policyname
	-- Update the DrivepoolId in the #tempMMDatapath table based on the given libraryname
	UPDATE #tempMMDatapath
	SET DrivePoolId = MMDP.DrivePoolId
	FROM MMLibrary as MML, MMMasterPool as MMMP, MMDrivePool as MMDP, #tempMMDatapath as T
	WHERE MML.AliasName = T.LibraryName and MML.LibraryId = MMMP.LibraryId and MMMP.MasterPoolId = MMDP.MasterPoolId
	--Update MMDatapath from #tempMMDatapath for which rows the CopyId, DrivePoolId and HostClientId exists in MMDatapath
	UPDATE MMDataPath
	set ReadinessFlag = T.ReadinessFlag,
	Priority = T.Priority,
	IsHardwareCompressed = T.IsHardwareCompressed,
	ChunkSizeMB = T.ChunkSizeMB,
	FlushBlockSizeKB = T.FlushBlockSizeKB,
	UseHardwareEncryption = T.UseHardwareEncryption
	FROM #tempMMDatapath T, MMDataPath MM
	WHERE T.CopyId = MM.CopyId AND T.DrivePoolId = MM.DrivePoolId AND T.HostClientId = MM.HostClientId
	set @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errStr = 'FDC_Merge_StoragePolicy : Insert archAgingRule Failed'
		GOTO SP_MERGE_EXIT
	END
	-- Delete the copies from archGroupCopy not existing in #temparchGroupCopy
	delete from MMDataPath
	--select * from MMDataPath
	where CopyId in (select id from archGroupCopy
	where archGroupId in (select T.archGroupId from #tempAGCCopyTable as T)
	and name not in (select T.name from #tempAGCCopyTable as T))
	-- Delete Datapaths from MMDataPath not existing in #tempMMDatapath
	delete from MMDataPath
	--select * from #tempMMDatapath
	--select * from MMDataPath
	where CopyId in (select CopyId from #tempMMDatapath)
	and DrivePoolId not in (select T.DrivePoolId from #tempMMDatapath T)
	and HostClientId not in (select T.HostClientId from #tempMMDatapath T)
	-- Delete the copies from archGroupCopy not existing in #temparchGroupCopy
	delete from archAgingRule
	where copyId in (select id from archGroupCopy
	where archGroupId in (select T.archGroupId from #tempAGCCopyTable as T)
	and name not in (select T.name from #tempAGCCopyTable as T))
	create table #tempMGIdList (MediaGroupId int);
	Insert into #tempMGIdList
	select MediaGroupId from archStream
	where archGroupCopyId in (select id from archGroupCopy
	where archGroupId in (select T.archGroupId from #tempAGCCopyTable as T)
	and id not in (select T.copyId from #tempAGCCopyTable as T))
/*
	delete from archStream
	where archGroupCopyId in (select id from archGroupCopy
	where archGroupId in (select T.archGroupId from #tempAGCCopyTable as T)
	and archGroupCopyId not in (select T.copyId from #tempAGCCopyTable as T))
	delete from MMMediaGroup
	where MediaGroupId not in (select MediaGroupId from #tempMGIdList)
*/
	--For EMC Networker, archStream information can change and we need to delete
        -- the archStream entries when archGroupCopy entries are dropped
	delete from archStream where archGroupCopyId
	IN ( select archGroupCopyId from archGroupCopy
	where archGroupId in (select T.archGroupId from #tempAGCCopyTable as T)
	and name not in (select T.name from #tempAGCCopyTable as T)
	and copy <> 1 )
	delete from archGroupCopy
	--select * from archGroupCopy
	where archGroupId in (select T.archGroupId from #tempAGCCopyTable as T)
	and name not in (select T.name from #tempAGCCopyTable as T)
	and copy <> 1
	-- Delete rows in #tempMMDatapath matching from archGroupCopy table
	delete #tempMMDatapath from #tempMMDatapath T INNER JOIN MMDataPath M ON
		T.CopyId = M.CopyId AND T.DrivePoolId = M.DrivePoolId and T.HostClientId = M.HostClientId
	delete #tempMMDatapath  WHERE LibraryName NOT IN (SELECT AliasName FROM MMLibrary WHERE origCCId = @mergedCCId)
	-- Insert the datapath information from the temp table to the MMDatapath table
	INSERT INTO MMDataPath(CopyId, DrivePoolId, HostClientId, Flag, SpareGroupId, ReadinessFlag, Priority,
				IsHardwareCompressed, ChunkSizeMB, FlushBlockSizeKB, UseHardwareEncryption)
	SELECT T.CopyId, T.DrivePoolId, T.HostClientId, 4, 0, T.ReadinessFlag, T.Priority,
		T.IsHardwareCompressed, T.ChunkSizeMB, T.FlushBlockSizeKB, T.UseHardwareEncryption
	FROM #tempMMDatapath T
	--WHERE T.copyId <> MMDP.CopyId and T.DrivePoolId <> MMDP.DrivePoolId and T.HostClientId <> MMDP.HostClientId
	set @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errStr = 'FDC_Merge_StoragePolicy : Insert MMDataPath Failed'
		GOTO SP_MERGE_EXIT
	END
	-- Set the first one as default datapath
	UPDATE MMDataPath
	SET Flag = 7
	WHERE DataPathId IN (SELECT min(DataPathId) as ID
							FROM MMDataPath m, #tempMMDatapath T
							WHERE m.CopyId = T.CopyId
							group by m.CopyId)
	set @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errStr = 'FDC_Merge_StoragePolicy : UPDATE MMDataPath Failed'
		GOTO SP_MERGE_EXIT
	END
	--Create archStream and MMMediaGroup information for each archGroup+archGroupCopy information
	DECLARE @aGroupId INT
	DECLARE @aCopyId  INT
	DECLARE @aMaxStreams INT
	DECLARE @aDrivePoolId INT
	DECLARE @aDatapathId INT
	DECLARE @aRecordingFormat INT
	DECLARE @aDesiredMediaTypeId INT
	DECLARE @aPrimaryCopyId INT
	DECLARE @isPrimaryFlag INT
	DECLARE @retVal INT
	DECLARE @tempTbl TABLE(retVal INT)
	DECLARE curarchGrpCopy CURSOR FOR
	SELECT TC.archGroupId, AGC.id, TG.maxStreams
	FROM #temparchGroupCopy TC, archGroupCopy AGC, #temparchGroup TG
	WHERE TC.archGroupId = AGC.archGroupId and TC.name = AGC.name  COLLATE Latin1_General_CS_AS  and TC.archGroupName = TG.policyname
	OPEN curarchGrpCopy
	FETCH NEXT FROM curarchGrpCopy INTO @aGroupId, @aCopyId, @aMaxStreams
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @aDrivePoolId = 0
		SET @aRecordingFormat = 10001
		SET @aDesiredMediaTypeId = 10001
		SET @aPrimaryCopyId = 0
		SET @isPrimaryFlag = 0
		-- Get the drivepoolId
		SELECT Top 1 @aDrivePoolId = DrivePoolId
		FROM MMDataPath MMDP
		WHERE CopyId = @aCopyId
		-- Get the recording format and desiredMediaTypeId
		SELECT Top 1 @aRecordingFormat = MMR.RecordingFormatId, @aDesiredMediaTypeId = MMDT.DefaultMediaTypeId
		FROM MMDrive MMD, MMRecFmtMedTyp MMR, MMDriveType MMDT
		WHERE MMD.DriveTypeId = MMR.DriveTypeId and MMDT.DriveTypeId = MMD.DriveTypeId and MMD.DriveId =
		(SELECT Top 1 DriveId
		FROM MMDriveController
		WHERE DrivePoolId = @aDrivePoolId) order by MMR.RecordingFormatId desc
		-- Check if this is a primary copy
		SELECT @aPrimaryCopyId = defaultCopy
		FROM archGroup
		WHERE id = @aGroupId
		if (@aPrimaryCopyId = @aCopyId)
		begin
			SET @isPrimaryFlag = 1
		end
		else
		begin
			SET @isPrimaryFlag = 0
		end
		BEGIN TRY
			INSERT INTO @tempTbl
			exec archStreamCreate @aGroupId, @aCopyId, @isPrimaryFlag, @aMaxStreams, 0, @aDrivePoolId, 0, @aDesiredMediaTypeId, @aRecordingFormat
			SELECT TOP 1 @retVal = retVal FROM @tempTbl
			DELETE FROM @tempTbl
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			SET @errCode = 0
			SET @message = 'Ignoring exception thrown inside archStreamCreate - continue creating arch streams'
			EXEC DBLog_Write 1, 'FDC_Merge_StoragePolicy', @message
		END CATCH
		FETCH NEXT FROM curarchGrpCopy INTO @aGroupId, @aCopyId, @aMaxStreams
	END
	CLOSE curarchGrpCopy
	DEALLOCATE curarchGrpCopy
SP_MERGE_EXIT:
	If @errCode = 0
		COMMIT TRANSACTION SPMerge
	If @errCode <> 0
		ROLLBACK TRANSACTION SPMerge
IF OBJECT_ID('tempdb.dbo.#temparchGroup') is not null Drop table #temparchGroup
IF OBJECT_ID('tempdb.dbo.#temparchGroupCopy') is not null Drop table #temparchGroupCopy
IF OBJECT_ID('tempdb.dbo.#tempMMDatapath') is not null Drop table #tempMMDatapath
IF OBJECT_ID('tempdb.dbo.#tempSubClient') is not null Drop table #tempSubClient
IF OBJECT_ID('tempdb.dbo.#tempSubClientDP') is not null Drop table #tempSubClientDP
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	ROLLBACK TRANSACTION SPMerge
	SET @errStr =
		'ERROR: PROC(' + ERROR_PROCEDURE() +
		'), LINE(' + CAST(ERROR_LINE() AS NVARCHAR(10)) +
		'), ERROR(' + CAST(ERROR_NUMBER() AS NVARCHAR(10)) +
		'), INFO: ' + ERROR_MESSAGE() + '.'
	RAISERROR ('%s' , 16, 1, @errStr)
--	SELECT @errorCode, @errorString
	IF(@errCode = 0)
		SET @errCode = -1
END CATCH
EXEC sp_xml_removedocument @iDoc
SELECT @errCode, @errStr
RETURN (@errCode)
GO

IF EXISTS (select * from GxQscripts where name = 'FDC_Merge_StoragePolicy')
	delete from GxQscripts where name = 'FDC_Merge_StoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Merge_StoragePolicy')
	delete from GXDBVersions where aliasname = 'FDC_Merge_StoragePolicy'
GO

insert into GXDBVersions values(2, 'FDC_Merge_StoragePolicy',  '00000000000000000000', 'FDC_Merge_StoragePolicy', '00000000000000000000')
GO

