

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/FDC_Merge_Media.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge Media information stored procedure.
--  +========================================================================+
-- $Id: FDC_Merge_Media.sp,v 1.43.60.8 2020/01/07 05:44:59 cliu Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='FDC_Merge_Media')
BEGIN
	print '>>> Drop Stored Procedure: FDC_Merge_Media <<<'
	drop procedure FDC_Merge_Media
END
IF EXISTS (select * from GxQscripts where name='FDC_Merge_Media')
	delete from GxQscripts where name = 'FDC_Merge_Media'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Merge_Media')
	delete from GXDBVersions where aliasname = 'FDC_Merge_Media'
GO
print '... Creating Procedure: FDC_Merge_Media'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure FDC_Merge_Media
  @FilePath varchar(MAX),
  @UpdateCostHistoryInfo int
AS
  DECLARE @errCode integer;
  DECLARE @errStr varchar(MAX);
SET NOCOUNT ON
--DECLARE @errCode integer
SET @errCode = 0
SET @errStr = 'NO ERROR'
BEGIN TRY
	DECLARE @iDoc INTEGER
	DECLARE @serverAliasName nvarchar(250)
	DECLARE @commCellId INTEGER
	DECLARE @curUnixTime INTEGER
	DECLARE @mediaCount INTEGER
	DECLARE @SQLString nvarchar(500);
	DECLARE @ParmDefinition nvarchar(500);
	DECLARE @input xml;
	DECLARE @retVal INTEGER
	SET @SQLString = N'set @local_xml_Out=( SELECT * FROM OPENROWSET ( BULK ''' + @FilePath + ''', SINGLE_CLOB ) AS xmlData)';
	SET @ParmDefinition = N'@local_xml_OUT xml OUTPUT';
create table #tempMedia
( id INTEGER NOT NULL IDENTITY (1,1),
 barCode  varchar(200),
 origbarCode  varchar(200),
 libraryName  varchar(100),
 libraryId int,
 mediaTypeId int,
 recordingFormatId int,
 mediaId int,
 description varchar(200),
 volumeFlags int,
 volumeFullReason int,
 pinMediaExpireTime bigint,
 retentionExpireTime bigint)
BEGIN TRANSACTION MediaMerge
	EXECUTE sp_executesql @SQLString, @ParmDefinition, @local_xml_OUT=@input OUTPUT;
	exec sp_xml_preparedocument @iDoc OUTPUT, @input
	SET @curUnixTime = dbo.GetUnixTime(GETUTCDATE())
	SET @commCellId = 2
	SET @mediaCount =
	(
		SELECT count(barcode)
		FROM
			OPENXML(@iDoc, 'FDC_ForeignMedias/mediaList/foreignMediaItem', 0)WITH(barcode NVARCHAR(250) '@barcode')
	)
--	select 'mediaCount =', @mediaCount
	IF(@mediaCount = 0 or @mediaCount is null)
	BEGIN
		SET @errStr = 'NO_ERROR'
		SET @errCode = 0
		GOTO NORMAL_EXIT
	END
	--SET @serverAliasName = 'NBU_CommNetInt'
	SELECT top 1 @serverAliasName = exAliasName
	FROM
		OPENXML(@iDoc, 'FDC_ForeignMedias', 0)WITH(exAliasName NVARCHAR(250) '@foreignServerName')
--	select @commCellId, @serverAliasName
	if(@commCellId = 0 or @serverAliasName='' or @serverAliasName is null)
	begin
		set @errCode = -1
		set @errStr = 'ERROR: COMMCELL WAS NOT SPECIFIED IN XML'
		goto NORMAL_EXIT
	end
	DECLARE @mergedServerId INT
	DECLARE @edcCvJobCounter INT
	DECLARE @edcCvJobCounterName nvarchar(18)
	--get merged CS id by aliasName:
	SET @mergedServerId = (select id from APP_CommCell where aliasName = @serverAliasName)
	--select '@mergedServerId = ', @mergedServerId
	if(@mergedServerId is null)
	BEGIN
		set @errStr = '2 WARNING - server was not merged yet'
		set @errCode = 2
		GOTO NORMAL_EXIT
	END
	IF OBJECT_ID('CommServ.dbo.edc_mm_log') is null
	begin
		create table edc_mm_log (line varchar(2048), time datetime)
	end
	Declare @fileStr varchar(max)
	declare @fullpath varchar(max)
	set @fileStr = 'Starting with merge for file :'
	set @fullpath = @fileStr + @FilePath
	Declare @curTime datetime
	SET @curTime = GETUTCDATE()
	insert into edc_mm_log(line, time) values(@fullpath , @curTime)
	-- Retreive the media information from the XML
	INSERT INTO #tempMedia
	( barCode, origbarCode, libraryName, libraryId, mediaTypeId, recordingFormatId, mediaId, description,
	  volumeFlags, volumeFullReason, pinMediaExpireTime, retentionExpireTime )
	SELECT
			tXml.barcode			as 'barCode',
			tXml.barcode			as 'origbarCode',
			tXml.libraryName		as 'libraryName',
			0						as 'libraryId',
			0						as 'mediaTypeId',
			0						as 'recordingFormatId',
			0						as 'mediaId',
			( CASE WHEN description IS NULL THEN '' ELSE description END )		as 'description',
			( CASE WHEN ((volumeFlags IS NULL) or (volumeFlags = 0)) THEN 5 ELSE volumeFlags END )		as 'volumeFlags',
			-- Marked FULL BY USER
			( CASE WHEN volumeFlags = 2 THEN 42000 ELSE 0	END )		as 'volumeFullReason',
			ISNULL(pinMediaExpireTime, 0) as 'pinMediaExpireTime',
			ISNULL(retentionExpireTime, 0)  as 'retentionExpireTime'
	FROM
		OPENXML(@iDoc, 'FDC_ForeignMedias/mediaList/foreignMediaItem', 0)
		WITH
		(
			barcode			nvarchar(250)	'@barcode',
			libraryName		nvarchar(255)	'@foreignLibraryName',
			description		nvarchar(max)	'./details/infoItem[@nameId="200"]/@value',
			volumeFlags		INTEGER			'./details/infoItem[@nameId="215"]/@value',
			pinMediaExpireTime	BIGINT		'./details/infoItem[@nameId="217"]/@value',
			retentioNExpireTime	BIGINT		'./details/infoItem[@nameId="218"]/@value'
		) as tXml
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- #tempMedia -- Insert '
		GOTO NORMAL_EXIT
	END
	SET @curTime = GETUTCDATE()
	insert into edc_mm_log(line, time) values('Inserted into #tempMedia' , @curTime)
	-- Update the Unknown library name with the standalone library name created for this server.
	UPDATE #tempMedia
	SET libraryName = 'NBU_StandAlone_' + @serverAliasName
	WHERE #tempMedia.libraryName = 'Unknown'
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- #tempMedia -- Update standalone library name '
		GOTO NORMAL_EXIT
	END
	-- Update the table with the libraryId for the given matching library names.
	UPDATE #tempMedia
	SET libraryId = MML.LibraryId
	FROM MMLibrary MML
	WHERE #tempMedia.libraryName = MML.AliasName
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- #tempMedia -- Update libraryId '
		GOTO NORMAL_EXIT
	END
	-- Retreive the media attributes and job information from the XML
	SELECT
			tXml.barcode		as 'barcode',
			tXml.nameId			as 'nameId',
			tXml.libraryName	as 'libraryName',
			tXml.value			as 'value',
			0					as 'jobId',
			tXml.mediaType		as 'mediaType',
			0					as 'mediaId',
			0					as 'libId'
	INTO #tempMediaAttributes
	FROM
		OPENXML(@iDoc, 'FDC_ForeignMedias/mediaList/foreignMediaItem/details/infoItem', 0)
		WITH
		(
			barcode		nvarchar(255)	'../../@barcode',
			libraryName nvarchar(255)   '../../@foreignLibraryName',
			nameId		int				'@nameId',
			value		nvarchar(512)	'@value',
			mediaType	int				'../../@mediaType'
		) as tXml
		group by tXml.barcode, tXml.nameId, tXml.libraryName, tXml.value, tXml.mediaType
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- #tempMediaAttributes -- Insert '
		GOTO NORMAL_EXIT
	END
	SET @curTime = GETUTCDATE()
	insert into edc_mm_log(line, time) values('Inserted into #tempMediaAttributes' , @curTime)
	-- Update #tempMediaAttributes with correct JobId.
	UPDATE #tempMediaAttributes
	SET jobId = e.newJobId
	FROM edcJobIdMap e
	WHERE #tempMediaAttributes.nameId = 203 and #tempMediaAttributes.value = e.foreignJobId
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- #tempMediaAttributes -- Update commserve jobId '
		GOTO NORMAL_EXIT
	END
	-- delete the jobs which could not be updated with jobIds
	DELETE from #tempMediaAttributes where nameId = 203 and jobId = 0
	-- Update the media location to Shelf if location type is offsite.
	UPDATE #tempMediaAttributes
	SET value = 3
	WHERE #tempMediaAttributes.nameId = 204 and #tempMediaAttributes.value = 4
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- #tempMediaAttributes -- Update MediaTypeId '
		GOTO NORMAL_EXIT
	END
	-- Update MediaTypeId in #tempMedia table.
	UPDATE #tempMedia
	SET	 mediaTypeId = 10001
	FROM #tempMediaAttributes T
	WHERE #tempMedia.barcode = T.barcode and #tempMedia.libraryName = T.libraryName and T.nameId = 201 and T.mediaType = 2
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- #tempMediaAttributes -- Update MediaTypeId for disk media '
		GOTO NORMAL_EXIT
	END
	-- check for duplicate barcodes and rename those
	UPDATE #tempMedia
	SET barcode = barcode + ' on ' + libraryName
	WHERE barcode in (select barcode from #tempMedia Group By barcode having (count(barcode) > 1))
	and mediaTypeId = 10001
	UPDATE #tempMediaAttributes
	SET #tempMediaAttributes.barcode = TM.barcode
	FROM #tempMedia TM
	WHERE #tempMediaAttributes.barcode = TM.origbarcode
	and #tempMediaAttributes.libraryName = TM.libraryName
	UPDATE #tempMedia
	SET mediaTypeId = T.value
	FROM #tempMediaAttributes T
	WHERE #tempMedia.barcode = T.barcode and T.nameId = 214
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- #tempMedia -- Update MediaTypeId '
		GOTO NORMAL_EXIT
	END
	-- Update the RecordingFormatId in #tempMedia table
	UPDATE #tempMedia
	SET recordingFormatId = MMR.RecordingFormatId
	FROM MMRecFmtMedTyp MMR
	WHERE MMR.RecordingFormatId in (select top 1 RecordingFormatId from MMRecFmtMedTyp where (MediaTypeId = #tempMedia.mediaTypeId or CleaningMediaTypeId = #tempMedia.mediaTypeId)
      		AND
      		DriveTypeId in
      		(select D.DriveTypeId from MMDrive as D, MMMasterPool as MP
     		where D.MasterPoolId = MP.MasterPoolId and
      		MP.LibraryId = #tempMedia.libraryId))
        set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- #tempMedia -- Update RecordingFormatId '
		GOTO NORMAL_EXIT
	END
    --select * from #tempMedia
	DECLARE @maxMediaId INT
	SET @maxMediaId = (SELECT MAX(mediaId) from MMMedia)
	-- ********* Update the Media and related records for which barcode already
	-- ********* exists in commserv DB. (For incremental updates)
	declare @stdalnLibId int
	set @stdalnLibId = (select LibraryId from MMLibrary where AliasName = 'NBU_StandAlone_' + @serverAliasName)
	DECLARE @message NVARCHAR(MAX)
	DECLARE @rowcnt	 INT
	UPDATE MMMedia
	SET MediaTypeId = T.mediaTypeId,
	LibraryId = T.libraryId,
	Descript  = T.description,
	retentionExpireTime = T.retentionExpireTime,
	PinMediaExpireTime  = T.pinMediaExpireTime
	FROM #tempMedia T
	WHERE MMMedia.BarCode = T.barcode and T.libraryId <> @stdalnLibId
	and MMMedia.LibraryId = T.libraryId
	UPDATE MMMedia
	SET retentionExpireTime = T.retentionExpireTime,
	PinMediaExpireTime  = T.pinMediaExpireTime
	FROM #tempMedia T
	WHERE MMMedia.BarCode = T.barcode and T.libraryId = @stdalnLibId
	and MMMedia.LibraryId = T.libraryId
	SELECT @errCode = @@ERROR, @rowcnt = @@ROWCOUNT
	IF (@errCode <> 0)
	BEGIN
		SET @errStr = 'FDC_Merge_Media : Update MMMedia Failed for already existing barcodes'
		GOTO NORMAL_EXIT
	END
	SET @message = 'Number of Media records updated for which barcode already exists in CS DB:' + CAST( @rowcnt AS VARCHAR(5) )
	EXEC DBLog_Write 1, 'FDC_Merge_Media', @message
	--UPDATE MMVolume
	--SET
	--VolumeFlags = T.volumeFlags,
	--VolumeFullReason = T.volumeFullReason
	--FROM #tempMedia T, MMVolume vol, MMMedia media
	--WHERE
	--	T.barCode = media.BarCode
	--AND	vol.MediaId = media.MediaId
	--SET @errCode = @@ERROR
	--IF (@errCode <> 0)
	--BEGIN
	--	SET @errStr = 'FDC_Merge_Media : Update MMVolume Failed to update the VolumeFlags and VolumeFullReason'
	--	GOTO NORMAL_EXIT
	--END
	DECLARE curMountPathUpdate CURSOR FOR
	SELECT TM.barcode, TM.libraryId
	FROM #tempMedia TM
	WHERE TM.mediaTypeId = 10001 and TM.barcode in (select Barcode from MMMedia)
	-- Take a backup of the media list coming from XML before commiting delete media with matching barcode.
	select *
	into #tempMediaTemp
	from #tempMedia
	-- create Qnet libHistory table for updating MMLibraryHistory
	create table #libHistory(libId int, noMediaUsed int, noMediaFreed int, CapacityFreedMB int)
	-- Delete the media's from the #tempMedia table for which barcode already exists in MMMedia table
	delete #tempMedia
	from #tempMedia T
	inner join MMMedia MM on T.barCode = MM.BarCode and T.libraryId = MM.LibraryId
	--where T.barcode = MM.BarCode
	--and T.libraryId = MM.LibraryId
	--select * from #tempMedia
	-- track used media for new media
	insert into #libHistory
	select T.libraryId, count(*), 0, 0
	from #tempMedia T
	where T.barcode in (select barcode from #tempMediaAttributes where nameId = 203)
	group by T.libraryId
	-- Insert @libHistory table for existing media (media used) if media has a job associated
	Insert Into #libHistory
	select T.libraryId, count(*), 0, 0
	from #tempMediaTemp T, MMMedia MM
	where T.barcode = MM.BarCode
	and MM.IsInMediaGroup = 0
	and T.barcode in (select barcode from #tempMediaAttributes where nameId = 203)
	group by T.libraryId
	-- Insert @libHistory table for existing media (media freed) if media does not have a job associated
	Insert into #libHistory
	select T.libraryId, 0, count(*), 0
	from #tempMediaTemp T, MMMedia MM
	where T.barcode = MM.BarCode
	and MM.IsInMediaGroup = 1
	and T.barcode not in (select barcode from #tempMediaAttributes where nameId = 203)
	group by T.libraryId
	SET @curTime = GETUTCDATE()
	insert into edc_mm_log(line, time) values('Updated temp tables' , @curTime)
	--cleanup duplicate barcode if any
	delete from #tempMedia
	where id not in (select MIN(id) from #tempMedia Group By barcode, libraryId)
	SET @rowcnt = @@ROWCOUNT
	SET @message = 'Number of duplicate media records not inserted:' + CAST( @rowcnt AS VARCHAR(5) )
	EXEC DBLog_Write 1, 'FDC_Merge_Media', @message
	print 'inserting to MMMedia now'
	--select * from #tempMedia
	--select * from #tempMediaAttributes
	-- Insert record into MMMedia
	INSERT INTO MMMedia
			([UniqueId],[BarCode],[MediaTypeId],[CreationTime],[NumberOfReUses]
		   ,[LastRestoreTime]
           ,[LastBackupTime]
           ,[LibraryId],[SpareGroupId],[LastExportTime]
           ,[MediaLocation]
           ,[ExternalGUID],[MediaFlags],[IsOMLWritten],[MediaStatusReason],[ExportLocationId]
           ,[LastWriteLibraryId]
           ,[Attributes],[ContainerId],[OverWriteJobId],[origCCcommCellID]
           ,[origCCmediaID],[Descript],[NumberOfSideOverwrites],[ScheduleRunId],[retentionFlags]
           ,[retentionExpireTime],[IsAged],[IsInMediaGroup],[PinMediaExpireTime],[origSpareGroupId]
           ,[RMSpareStatus],[RMSpareStatusUpdateTime], [ExtendedAttributes], [minRetentionTime]
		   ,[HwEncKey]
			)
	SELECT 'UNIQUEID_EDC' + CONVERT(varchar, @mergedServerId) + '_BC_'+ T.barcode + CONVERT(varchar, T.libraryId), T.barcode, T.mediaTypeId, dbo.GetUnixTime(GETUTCDATE()), 0
			, 0  -- LastRestoreTime updated below
			, 0  -- LastBackupTime updated below
			, T.libraryId, 0, 0
			, 0  -- MediaLocation updated below
			, '', 1, 0, 0, 0
			, 0
			, 0, 0, 0, @mergedServerId
			, 0, description, 0, 0, 0
			, T.retentionExpireTime, 0, 0, T.pinMediaExpireTime, 0
			, 0, 0, 0, 0
			, ''
	FROM #tempMedia T
	SELECT @errCode = @@ERROR, @rowcnt = @@ROWCOUNT
	if ((@retval <> 0) or (@errCode <> 0))
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMMedia -- UPDATE'
		GOTO NORMAL_EXIT
	END
	SET @message = 'Number of new media records inserted:' + CAST( @rowcnt AS VARCHAR(5) )
	EXEC DBLog_Write 1, 'FDC_Merge_Media', @message
	SET @curTime = GETUTCDATE()
	insert into edc_mm_log(line, time) values('Inserted into MMMedia' , @curTime)
	-- Update MMSpareGroup table with the MediaTypeId
	UPDATE MMSpareGroup
	SET MediaTypeId = (select top 1 MediaTypeId from MMMedia where LibraryId = T.libraryId)
	FROM #tempMedia T
	WHERE T.libraryId = MMSpareGroup.LibraryId and MMSpareGroup.SpareGroupType = 2
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMSpareGroup -- UPDATE mediaTypeId'
		GOTO NORMAL_EXIT
	END
	-- Update #tempMedia and #tempMediaAttributes
	Update #tempMedia
	set MediaId = MM.MediaId
	from MMMedia MM
	where #tempMedia.barCode = MM.BarCode
	and #tempMedia.libraryId = MM.LibraryId
	UPDATE #tempMediaAttributes
	SET libId = MML.LibraryId
	FROM MMLibrary MML
	WHERE (case when #tempMediaAttributes.libraryName = 'Unknown' then 'NBU_Standalone_'+@serverAliasName else #tempMediaAttributes.libraryName  end) = MML.AliasName
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- ##tempMediaAttributes -- Update libraryId '
		GOTO NORMAL_EXIT
	END
	Update #tempMediaAttributes
	set MediaId = MM.MediaId
	from MMMedia MM
	where #tempMediaAttributes.barcode = MM.BarCode
	and #tempMediaAttributes.libId = MM.LibraryId
	Update #tempMediaTemp
	set MediaId = MM.MediaId
	from MMMedia MM
	where #tempMediaTemp.barcode = MM.BarCode
	and #tempMediaTemp.libraryId = MM.LibraryId
	print 'updating the UniqueID now'
	-- Update the unique Id for each media
	UPDATE MMMedia
	SET UniqueId = CONVERT(varchar, @mergedServerId) + '_BC_'+ barcode + '_' + Convert(varchar, MediaId)
	WHERE UniqueId like 'UNIQUEID_EDC%'
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMMedia -- UPDATE unique Id'
		GOTO NORMAL_EXIT
	END
	--Update the lastrestoretime, lastbackuptime and MediaLocation
	UPDATE MMMedia
	SET LastRestoreTime = CONVERT(int, T.value)
	FROM #tempMediaAttributes T
	WHERE MMMedia.BarCode = T.barcode and T.nameId = 212
	and MMMedia.LibraryId = T.libId
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMMedia -- UPDATE LastRestoreTime'
		GOTO NORMAL_EXIT
	END
	UPDATE MMMedia
	SET LastBackupTime = CONVERT(int, T.value)
	FROM #tempMediaAttributes T
	WHERE MMMedia.BarCode = T.barcode and T.nameId = 211
	and MMMedia.LibraryId = T.libId
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMMedia -- UPDATE LastBackupTime '
		GOTO NORMAL_EXIT
	END
	UPDATE MMMedia
	SET MediaLocation = CONVERT(int, T.value),
	LastWriteLibraryId = (case when T.value = 3 then LibraryId else 0 end)
	FROM #tempMediaAttributes T
	WHERE MMMedia.BarCode = T.barcode and T.nameId = 204
	and MMMedia.LibraryId = T.libId
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMMedia -- UPDATE MediaLocation'
		GOTO NORMAL_EXIT
	END
	UPDATE MMMedia
	SET MediaLocation = 2
	FROM #tempMediaAttributes T
	WHERE MMMedia.MediaTypeId = 10001 and MMMedia.BarCode = T.barcode
	and MMMedia.LibraryId = T.libId
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMMedia -- UPDATE MediaLocation for disk media'
		GOTO NORMAL_EXIT
	END
	-- set the default sparegroupId for the media
	UPDATE MMMedia
	SET SpareGroupId = MMS.SpareGroupId
	FROM MMSpareGroup MMS, #tempMedia T, MMMediaType MT
	WHERE MMMedia.LibraryId = MMS.LibraryId and MMMedia.MediaTypeId <> 10001 and MMS.SpareGroupType = 2
	and MT.MediaTypeId = MMMedia.MediaTypeId and MT.IsCleaningMedia <> 1
	and T.barcode = MMMedia.BarCode
	and MMMedia.LibraryId = T.libraryId
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMMedia -- UPDATE SpareGroupId'
		GOTO NORMAL_EXIT
	END
	--set cleaning media spareGroup
	UPDATE MMMedia
	SET SpareGroupId = MMS.SpareGroupId
	FROM MMSpareGroup MMS, #tempMedia T, MMMediaType MT
	WHERE MMMedia.LibraryId = MMS.LibraryId and MMMedia.MediaTypeId <> 10001 and MMS.SpareGroupType = 32
	and MT.MediaTypeId = MMMedia.MediaTypeId and MT.IsCleaningMedia = 1
	and T.barcode = MMMedia.BarCode
	and MMMedia.LibraryId = T.libraryId
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMMedia -- UPDATE SpareGroupId'
		GOTO NORMAL_EXIT
	END
	SET @curTime = GETUTCDATE()
	insert into edc_mm_log(line, time) values('Updated MMMedia' , @curTime)
	--select * from MMMedia where origCCcommCellID = @mergedServerId
	print 'inserting to MMMediaSide now'
	-- Create record in MMMediaSide for each media inserted
	INSERT INTO [CommServ].[dbo].[MMMediaSide]
			   ([MediaId], [SideName], [MediaSideFlags], [NumberOfRestores], [NumberOfBackups]
			   , [NumberOfMounts]
			   , [NumberOfSoftErrors], [NumberOfHardErrors], [NumberOfReUses]
			   , [LastRestoreTime]
			   , [LastBackupTime]
			   , [TotalSpaceMB]
			   , [FreeBytesMB]
			   , [LogicalBytesMB]
			   , [PhysicalBytesMB]
			   , [IsOMLValid], [FailureReason], [ExternalGUID], [IsOMLWritten], [isErasable], [DownloadDataMB], [UploadDataMB])
	SELECT MM.MediaId, 'A_' + CONVERT(varchar, MM.MediaId), 1, 0, 0
			, 0--ISNULL((select CONVERT(int, T.value) from #tempMediaAttributes T where T.barcode = MM.BarCode and T.nameId = 213), 0) -- NumberOfMounts
			, 0, 0, 0
			, 0--ISNULL((select CONVERT(int, T.value) from #tempMediaAttributes T where T.barcode = MM.BarCode and T.nameId = 212), 0) -- LastRestoreTime
			, 0--ISNULL((select CONVERT(int, T.value) from #tempMediaAttributes T where T.barcode = MM.BarCode and T.nameId = 211), 0) -- LastBackupTime
			, 0--case when TM.mediaTypeId = 10001 then (ISNULL((select (CONVERT(bigint, T.value)/(1024*1024)) from #tempMediaAttributes T where T.barcode = TM.BarCode and T.nameId = 208), 0)) else (select MMT.MaxUncompressCapacityMB from MMMediaType MMT where TM.mediaTypeId = MMT.MediaTypeId) end -- TotalSpaceMB
			, 0--ISNULL((select (CONVERT(bigint, T.value)/(1024 * 1024)) from #tempMediaAttributes T where T.barcode = MM.BarCode and T.nameId = 209), 0) -- FreeBytesMB
			, 0 -- LogicalBytesMB
			, 0--ISNULL((select (CONVERT(bigint, T.value)/(1024 * 1024)) from #tempMediaAttributes T where T.barcode = MM.BarCode and T.nameId = 210), 0) -- PhysicalBytesMB
			, 0, '', '', 0, 0, 0, 0
	FROM #tempMedia TM, MMMedia MM
	WHERE TM.barcode = MM.BarCode
	and TM.libraryId = MM.LibraryId
	set @errCode = @@ERROR
	if ((@retval <> 0) or (@errCode <> 0))
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMMediaSide -- UPDATE'
		GOTO NORMAL_EXIT
	END
	SET @curTime = GETUTCDATE()
	insert into edc_mm_log(line, time) values('Inserting into MMMediaSide' , @curTime)
	--Update numberofMounts
	Update MMMediaSide
	set NumberOfMounts = (case when T.value < 0 then 0 else T.value end)
	From MMMedia MM, #tempMediaAttributes T
	Where T.barcode = MM.BarCode
	and T.nameId = 213
        and MMMediaSide.MediaId = T.MediaId
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMMediaSide -- UPDATE NumberOfMounts'
		GOTO NORMAL_EXIT
	END
	--Update LastRestoreTime
	Update MMMediaSide
	set LastRestoreTime = T.value
	From MMMedia MM, #tempMediaAttributes T
	Where T.barcode = MM.BarCode
	and T.nameId = 212
        and MMMediaSide.MediaId = T.MediaId
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMMediaSide -- UPDATE LastRestoreTime'
		GOTO NORMAL_EXIT
	END
	--Update LastbackupTime
	Update MMMediaSide
	set LastBackupTime = T.value
	From MMMedia MM, #tempMediaAttributes T
	Where T.barcode = MM.BarCode
	and T.nameId = 211
        and MMMediaSide.MediaId = T.MediaId
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMMediaSide -- UPDATE LastBackupTime '
		GOTO NORMAL_EXIT
	END
	--Update TotalSpaceMB for Magnetic Media
	Update MMMediaSide
	set TotalSpaceMB = (CONVERT(bigint, T.value)/(1024 * 1024))
	From MMMedia MM, #tempMediaAttributes T
	Where T.barcode = MM.BarCode
	and T.nameId = 208
	and MMMediaSide.MediaId = T.MediaId
	and MM.MediaTypeId = 10001
       	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMMediaSide -- UPDATE TotalSpaceMB for magnetic '
		GOTO NORMAL_EXIT
	END
	--Update TotalSpaceMB for Media
	Update MMMediaSide
	set TotalSpaceMB = (select MMT.MaxUncompressCapacityMB from MMMediaType MMT where MM.mediaTypeId = MMT.MediaTypeId)
	From MMMedia MM, #tempMediaAttributes T
	Where T.barcode = MM.BarCode
	--and T.nameId = 208
	and MMMediaSide.MediaId = T.MediaId
	and MM.MediaTypeId <> 10001
       	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMMediaSide -- UPDATE TotalSpaceMB for media '
		GOTO NORMAL_EXIT
	END
	--Update TotalSpaceMB
	--Update MMMediaSide
	--set NumberOfMounts = T.value
	--From MMMedia MM, #tempMediaAttributes T
	--Where T.barcode = MM.BarCode
	--and T.nameId = 213
	--Update FreeBytes
	Update MMMediaSide
	set FreeBytesMB = (CONVERT(bigint, T.value)/(1024 * 1024))
	From MMMedia MM, #tempMediaAttributes T
	Where T.barcode = MM.BarCode
	and T.nameId = 209
        and MMMediaSide.MediaId = T.MediaId
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMMediaSide -- UPDATE FreeBytesMB '
		GOTO NORMAL_EXIT
	END
	--Update Physical Bytes
	Update MMMediaSide
	set PhysicalBytesMB = (CONVERT(bigint, T.value)/(1024 * 1024))
	From MMMedia MM, #tempMediaAttributes T
	Where T.barcode = MM.BarCode
	and T.nameId = 210
        and MMMediaSide.MediaId = T.MediaId
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMMediaSide -- UPDATE PhysicalBytesMB '
		GOTO NORMAL_EXIT
	END
	SET @curTime = GETUTCDATE()
	insert into edc_mm_log(line, time) values('Updating MMMediaSide' , @curTime)
	print 'inserting to MMVolume now'
	-- Create record in MMVolume for each media inserted
	INSERT INTO [CommServ].[dbo].[MMVolume]
           ([VolumeName], [CreationTime], [VolumeFlags], [VolumeInitialized], [FlushBlockSizeKB], [NumberOfRestores], [NumberOfBackups]
           ,[NumberOfMounts], [NumberOfSoftErrors], [NumberOfHardErrors], [LastRestoreTime], [LastBackupTime], [LogicalBytesMB]
           ,[PhysicalBytesMB], [NumberOfActiveFiles], [LastFile], [RecordingFormatId], [ExternalGUID], [OMLVersion], [VolumeState], [VolumeFullReason]
           ,[VolumeFullTime], [VolumeFullJobId], [origCCcommCellID], [origCCvolumeID], [MediaId], [MediaSideId], [Attributes], [MediaGroupId]
           ,[ReformatTime], [RMSpareStatus], [RMSpareStatusUpdateTime], [SIDBStoreId], [SiloStatus], [CurrMountPathId], [FailureErrorCode],[MMSpareStatus])
    SELECT 'V_' + CONVERT(varchar, MM.MediaId), 0, TM.VolumeFlags, 1, -1, 0, 0
			, MMS.NumberOfMounts, 0, 0, MMS.LastRestoreTime, MMS.LastBackupTime, 0
			, MMS.PhysicalBytesMB, 0, 0, TM.recordingFormatId, '', 2, 0, TM.VolumeFullReason
			, 0, 0, @mergedServerId, 0, MM.MediaId, MMS.MediaSideId, 0, 0
			, 0, 0, 0, 0, 0, 0, 0, 0
    FROM #tempMedia TM, MMMedia MM, MMMediaSide MMS
    WHERE TM.barcode = MM.BarCode and MM.MediaId = MMS.MediaId
	set @errCode = @@ERROR
	if ((@retval <> 0) or (@errCode <> 0))
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMVolume -- UPDATE'
		GOTO NORMAL_EXIT
	END
	--Update MMVolume again for incremental updates.
	Update MMVolume
	set MMVolume.NumberOfMounts = MS.NumberOfMounts,
	MMVolume.LastBackupTime = MS.LastBackupTime,
	MMVolume.LastRestoreTime = MS.LastRestoreTime,
	MMVolume.PhysicalBytesMB = MS.PhysicalBytesMB
	FROM MMMediaSide MS
	where MMVolume.MediaId = MS.MediaId
	and MS.MediaId in (select distinct MediaId from #tempMediaAttributes)
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMVolume -- UPDATE properties from MMMediaSide '
		GOTO NORMAL_EXIT
	END
	SET @curTime = GETUTCDATE()
	insert into edc_mm_log(line, time) values('Inserted into MMVolume' , @curTime)
	print 'inserting to MMMountPath now'
	-- Create records in MMMountPath for each magnetic media inserted
	DECLARE @barcodeStr varchar(255)
	DECLARE @libId int
	DECLARE @mountPathId int
	DECLARE @masterPoolId int
	DECLARE curMountPath CURSOR FOR
	SELECT TM.barcode, TM.libraryId
	FROM #tempMedia TM
	WHERE TM.mediaTypeId = 10001
	/*
	print 'Update mountPath'
	--Update MMMountPath
	UPDATE MMMountPath
	SET MasterPoolId = (select MasterPoolId from MMMasterPool where LibraryId = T.libraryId),
	LibraryId = T.libraryId
	FROM #tempMountPathUpdate T, MMMedia MM, MMMediaSide MMS
	WHERE T.barcode = MM.BarCode and MM.MediaId = MMS.MediaId and MMMountPath.MediaSideId = MMS.MediaSideId
	print
	*/
	--Update the mountpath information for already existing barcodes
	OPEN curMountPathUpdate
	FETCH NEXT FROM curMountPathUpdate INTO @barcodeStr, @libId
	WHILE @@FETCH_STATUS = 0
	BEGIN
			SET @mountPathId = (select MAX(mountPathId)+1 from MMMountPath )
			SET @masterPoolId = (select masterPoolId from MMMasterPool where LibraryId = @libId)
			UPDATE MMMountPath
			SET MasterPoolId = @masterPoolId,
			LibraryId = @libId
			FROM MMMedia MMM, MMMediaSide MMS
			WHERE @barcodeStr = MMM.BarCode and MMM.MediaId = MMS.MediaId and MMS.MediaSideId = MMMountPath.MediaSideId
			set @errCode = @@ERROR
			if (@errCode <> 0)
			BEGIN
				SET @errStr = 'ERROR: FDC_Merge_Media -- Update MountPath failed'
				GOTO NORMAL_EXIT
			END
			FETCH NEXT FROM curMountPathUpdate INTO @barcodeStr, @libId
	END
	OPEN curMountPath
	FETCH NEXT FROM curMountPath INTO @barcodeStr, @libId
	WHILE @@FETCH_STATUS = 0
	BEGIN
			SET @mountPathId = (select MAX(mountPathId)+1 from MMMountPath )
			SET @masterPoolId = (select masterPoolId from MMMasterPool where LibraryId = @libId)
			INSERT INTO [CommServ].[dbo].[MMMountPath]
					   ([MountPathId], [MountPathName]
					   ,[MediaSideId]
					   ,[UserName],[UserPassword],[IsEnabled],[NumberOfWriters],[MaxConcurrentWriters]
						,[CurrentFileMarker],[IsOffline],[OfflineReason],[MountPathTypeId],[OffLineTimeStamp],[origCCcommCellID],[origCCmediaSideID]
					   ,[MaxDataToWriteMB],[MagneticSpaceRsrvInMB],[Attribute],[MasterPoolId],[LibraryId],[RMStatus],[RMStatusUpdateTime]
					   ,[OrigCCMountPathId],[MagneticChunkFileIncrSizeMB],[MountPathOfflineReasonEventId])
			SELECT  @mountPathId, @barcodeStr
					,(select MMS.MediaSideId from MMMediaSide MMS, MMMedia MM where
					  @barcodeStr = MM.BarCode and MM.MediaId = MMS.MediaId and MM.origcccommcellid = @mergedServerId AND MM.LibraryId = @libId) --MediaSideId
					, '', '', 1, 0, 5
					,0, 0, 0, 0, 0, @mergedServerId, 0
					,0, 0, 0, @masterPoolId, @libId, 0, 0
					,0, 0, 0
		set @errCode = @@ERROR
		if ((@retval <> 0) or (@errCode <> 0))
		BEGIN
			SET @errStr = 'ERROR: FDC_Merge_Media -- MMMountPath -- INSERT'
			GOTO NORMAL_EXIT
		END
		SET @curTime = GETUTCDATE()
		insert into edc_mm_log(line, time) values('Inserting into MMMountPath' , @curTime)
			IF EXISTS (SELECT * FROM GXCounter WHERE name = 'MPID_Counter')
			BEGIN
			   UPDATE GXCounter
			   SET next_l = @mountPathId
			   WHERE name = 'MPID_Counter'
			END
			ELSE
			BEGIN
			   INSERT INTO GXCounter VALUES ('MPID_Counter',0,@mountPathId)
			END
			set @errCode = @@ERROR
			IF ((@retval <> 0) or (@errCode <> 0))
			BEGIN
				SET @errStr = 'ERROR: FDC_Merge_Media -- GXCounter -- UPDATE'
				GOTO NORMAL_EXIT
			END
		-- Update drive information for magnetic media.
		UPDATE MMDrive
		SET MediaId = MM.MediaId,
		DriveOccupied = 1
		FROM MMMedia MM, #tempMediaTemp T, MMMasterPool MMP
		WHERE T.barcode = MM.BarCode
		and T.barcode = @barcodeStr
		and T.libraryId = MMP.LibraryId
		and T.mediaTypeId = 10001
		and DriveId = (select top 1 DriveId from MMDrive MMD, MMMasterPool MMMP where T.libraryId = MMMP.LibraryId and MMMP.MasterPoolId = MMD.MasterPoolId and MMD.DriveOccupied = 0)
		set @errCode = @@ERROR
		if (@errCode <> 0)
		BEGIN
			SET @errStr = 'ERROR: FDC_Merge_Media -- MMDrive -- UPDATE Drive with mediaId for disk media '
			GOTO NORMAL_EXIT
		END
	        SET @curTime = GETUTCDATE()
	        insert into edc_mm_log(line, time) values('Updated MMDrive with Media info for magnetic' , @curTime)
		FETCH NEXT FROM curMountPath INTO @barcodeStr, @libId
	END
/*
	--Update the slot and Drive information for each media in MMSlot and MMDrive tables
	UPDATE MMSlot
	SET MediaId = MM.MediaId,
	IsOccupied = 1,
	BarCode = MM.BarCode
	FROM MMMedia MM, #tempMediaAttributes T, #tempMediaTemp TM, MMBay MMB
	WHERE T.barcode in (select TMA.barcode from #tempMediaAttributes TMA where TMA.nameId = 204 and TMA.value = '1')
	and T.barcode = MM.BarCode
	and MMSlot.SlotName = (select TMAS.value from #tempMediaAttributes TMAS where TMAS.nameId = 205 and TMAS.barcode = MM.BarCode)
	and TM.barcode = T.barcode
	and TM.libraryId = MMB.LibraryId
	and MMSlot.BayId = MMB.BayId
*/
	--Update the slot and Drive information for each media in MMSlot and MMDrive tables
        UPDATE MMSlot
        SET MediaId = T1.MediaId,
        IsOccupied = 1,
        BarCode = T1.barcode
         FROM #tempMediaAttributes T1, #tempMediaAttributes T2, #tempMediaTemp TM, MMBay MMB
        WHERE
        (
                (MMSlot.SlotName = T1.Value and T1.nameId = 205) AND
                (T2.barcode = T1.barcode AND T2.nameId = 204 and T2.value = 1)
        )
        and TM.MediaId = T1.MediaId
        and TM.libraryId = MMB.LibraryId
        and MMSlot.BayId = MMB.BayId
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMSlot -- UPDATE slot with mediaId '
		GOTO NORMAL_EXIT
	END
	SET @curTime = GETUTCDATE()
	insert into edc_mm_log(line, time) values('Updated MMSlot with Media info' , @curTime)
	--select distinct TMA.barcode from #tempMediaAttributes TMA where (TMA.nameId = 204 and TMA.value = '2') or (TMA.mediaType = 2)
	--select * from MMSlot
	print 'Updating MMDrive now'
	-- Now updating drive information, updates only for tape.
	/*
	UPDATE MMDrive
	SET MediaId = MM.MediaId,
	DriveOccupied = 1
	FROM MMMedia MM, #tempMediaAttributes T, #tempMediaTemp TM, MMMasterPool MMP
	WHERE T.barcode in (select distinct TMA.barcode from #tempMediaAttributes TMA where TMA.nameId = 204 and TMA.value = '2')
	and T.barcode = MM.BarCode
	and MMDrive.DriveName = (select TMAS.value from #tempMediaAttributes TMAS where TMAS.nameId = 205 and TMAS.barcode = MM.BarCode)
	and TM.barcode = T.barcode
	and TM.libraryId = MMP.LibraryId
	and MMDrive.MasterPoolId = MMP.MasterPoolId
	*/
	UPDATE MMDrive
	SET MediaId = T1.MediaId,
	DriveOccupied = 1
	FROM #tempMediaAttributes T1, #tempMediaAttributes T2, #tempMediaTemp TM, MMMasterPool MMP
	WHERE
    (
            (MMDrive.DriveName = T1.Value and T1.nameId = 205) AND
            (T2.barcode = T1.barcode AND T2.nameId = 204 and T2.value = 1)
    )
	and TM.MediaId = T1.MediaId
	and TM.libraryId = MMP.LibraryId
	and MMDrive.MasterPoolId = MMP.MasterPoolId
	SET @curTime = GETUTCDATE()
	insert into edc_mm_log(line, time) values('Updated MMDrive with Media info' , @curTime)
	--select * from MMDrive where origCCId = 7
	print 'select for export Location'
	-- Now set the media for which the location has been set to 3, create a export location
	create table #tempExportLocations(exportLoc nvarchar(64), GUIDID uniqueidentifier null)
	INSERT INTO #tempExportLocations
	SELECT  distinct(TMA.value), NULL--(select TMAS.value from #tempMediaAttributes TMAS where TMAS.nameId = 205 and TMAS.barcode = TMA.barcode) exportLocation,
	FROM #tempMediaAttributes TMA
	WHERE TMA.barcode in (select TMA.barcode from #tempMediaAttributes TMA where TMA.nameId = 204 and TMA.value = '3')
	and TMA.value not in (select ExportLocation from MMExportLocation where origCCId = @mergedServerId)
	and TMA.nameId = 205
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- #tempExportLocations -- Insert '
		GOTO NORMAL_EXIT
	END
	UPDATE #tempExportLocations
	SET GUIDID = NEWID()
	INSERT INTO [CommServ].[dbo].[MMExportLocation]
			   ([ExportLocation]
			   ,[Type],[Descript],[origCCId],[GUID])
	SELECT exportLoc, 1, '', @mergedServerId, GUIDID FROM #tempExportLocations
	WHERE exportLoc not in (select ExportLocation from MMExportLocation)
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMExportLocation -- INSERT MMExportLocation '
		GOTO NORMAL_EXIT
	END
	SET @curTime = GETUTCDATE()
	insert into edc_mm_log(line, time) values('Inserting MMExportLocation' , @curTime)
	--SELECT * from MMExportLocation
	--Also update the ExportLocationId in MMMedia table
	UPDATE MMMedia
	SET ExportLocationId = MMEL.ExportLocationId
	FROM MMExportLocation MMEL, #tempMediaAttributes T
	WHERE T.barcode in (select TMA.barcode from #tempMediaAttributes TMA where TMA.nameId = 204 and TMA.value = '3')
	and T.barcode = MMMedia.BarCode
	and MMEL.ExportLocation = (select TMAS.value from #tempMediaAttributes TMAS where TMAS.nameId = 205 and TMAS.barcode = MMMedia.BarCode and TMAS.libId = T.libId)
	and T.libId = MMMedia.LibraryId
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- MMMedia -- UPDATE MMMedia with exportLocationId '
		GOTO NORMAL_EXIT
	END
     print 'select distinct jobs to create aFile'
	-- Creating Job to Media mapping i.e. archFile, archFileCopy, archChunk and archChunkMapping records
	create table #tempJobs(jobId int, barcode varchar(255), mediaType int, isAdminJob int)
	insert into #tempJobs
	Select distinct jobId, '', 0, 0
	from #tempMediaAttributes
	where jobId <> 0
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- #tempJobs -- insert #tempJobs '
		GOTO NORMAL_EXIT
	END
	update #tempJobs
	set #tempJobs.barcode = T.barcode
	from #tempMediaAttributes T
	where #tempJobs.jobId = T.jobId
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- #tempJobs -- Update barcode '
		GOTO NORMAL_EXIT
	END
	update #tempJobs
	set mediaType = T.mediaTypeId
	from #tempMediaTemp T
	where #tempJobs.barcode = T.barcode
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- #tempJobs -- Update MediaType '
		GOTO NORMAL_EXIT
	END
	--update the isAdminJob flag for admin jobs in tempJobs
	update #tempJobs
	set isAdminJob = 1
	where #tempJobs.jobId in (select jobId from JMAdminJobStatsTable where commCellId = @mergedServerId)
	--select * from #tempJobs
	--select * from #tempJobs
	-- create chunk records to be inserted.
	create table #tempChunk(id INTEGER NOT NULL IDENTITY (1,1), barcode varchar(255), jobId int, isAdminJob int)
	insert into #tempChunk(barcode, jobId, isAdminJob)
	select barcode, jobId, 0
	from #tempMediaAttributes
	where nameId = 203
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- #tempChunks -- Insert #tempChunks '
		GOTO NORMAL_EXIT
	END
	--select * from #tempChunk
	--update the isAdminJob flag for admin jobs in tempChunk
	update #tempChunk
	set isAdminJob = 1
	where #tempChunk.jobId in (select jobId from JMAdminJobStatsTable where commCellId = @mergedServerId)
		UPDATE MMMedia
		SET IsInMediaGroup = 0
		FROM #tempMediaTemp T
		WHERE MMMedia.BarCode = T.barcode
		and T.barcode not in (select barcode from #tempChunk)
		set @errCode = @@ERROR
		if (@errCode <> 0)
		BEGIN
			SET @errStr = 'ERROR: FDC_Merge_Media -- MMMedia -- UPDATE MMMedia IsInMediaGroup '
			GOTO NORMAL_EXIT
		END
	-- delete the chunk which are already existing in the DB
	delete from #tempChunk
	where barcode in (select MM.BarCode from MMMedia MM, MMVolume MMV, archChunk AC
						where MM.MediaId = MMV.MediaId and MMV.VolumeId = AC.volumeId and
						AC.id in (select archChunkId from archChunkMapping where commCellId = @mergedServerId))
	and jobId in (select AF.jobId from archFile AF where id in (select archFileId from archChunkMapping where commCellId = @mergedServerId))
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- #tempChunks -- delete #tempChunks '
		GOTO NORMAL_EXIT
	END
	delete from #tempJobs where jobId in (select jobId from archFile where commCellId = @mergedServerId)
	set @errCode = @@ERROR
	if (@errCode <> 0)
	BEGIN
		SET @errStr = 'ERROR: FDC_Merge_Media -- #tempJobs -- delete #tempJobs '
		GOTO NORMAL_EXIT
	END
	print 'delete jobs for which aFile exists'
	--select * from #tempJobs
	-- Create archFile record for each JobId
	IF EXISTS(select * from #tempJobs)
	BEGIN
		INSERT INTO [CommServ].[dbo].[archFile]
				   ([name],[commCellId],[archGroupId]
				   ,[objName1],[flags],[appId],[fileType],[cTime]
				   ,[jobId],[backupLevel],[isValid],[cloudId],[contentIndexTime],[nPushedItems])
		SELECT '', @mergedServerId, JM.dataArchGrpId
				, '', 0, JM.appId, 1, 0,
				JM.jobId, JM.bkpLevel, 1, 0, 0, 0
		FROM JMBkpStats JM, #tempJobs T
		WHERE JM.jobId = T.jobId and JM.commCellId = @mergedServerId
		and T.isAdminJob = 0
		set @errCode = @@ERROR
		IF ((@retval <> 0) or (@errCode <> 0))
		BEGIN
			SET @errStr = 'ERROR: FDC_Merge_Media -- [archFile] -- INSERT'
			GOTO NORMAL_EXIT
		END
		-- added for merging admin jobs
		INSERT INTO [CommServ].[dbo].[archFile]
				   ([name],[commCellId],[archGroupId]
				   ,[objName1],[flags],[appId],[fileType],[cTime]
				   ,[jobId],[backupLevel],[isValid],[cloudId],[contentIndexTime],[nPushedItems])
		SELECT '', @mergedServerId, JM.ArchGrpId
				, '', 0, JM.appId, 1, 0,
				JM.jobId, JM.ER_BkpLevel, 1, 0, 0, 0
		FROM JMAdminJobStatsTable JM, #tempJobs T
		WHERE JM.jobId = T.jobId and JM.commCellId = @mergedServerId
		and T.isAdminJob = 1
		set @errCode = @@ERROR
		IF ((@retval <> 0) or (@errCode <> 0))
		BEGIN
			SET @errStr = 'ERROR: FDC_Merge_Media -- [archFile] -- INSERT'
			GOTO NORMAL_EXIT
		END
		SET @curTime = GETUTCDATE()
		insert into edc_mm_log(line, time) values('Inserting into archFile' , @curTime)
	--	select * from archFile where commCellId = @mergedServerId
		print 'inserted into archFile, now creating archFileCOpy'
		-- Create archFileCopy records
		INSERT INTO [CommServ].[dbo].[archFileCopy]
				   ([archFileId],[commCellID],[archCopyId],[flags],[isValid],[streamNum],[lastChunkNumber]
				   ,[physicalSize],[logicalSize]
				   ,[drivePoolId]
				   ,[encRSA],[encKeyType],[encKey]
				   ,[modifiedTime],[mediaType],[agedBy],[encKeyId],[unCompSize])
		SELECT AF.id, @mergedServerId, JMJD.archGrpcopyId, 2, 1, 1, 1
				,JM.totalBackupSize, JM.totalBackupSize
				,IsNULL((select top 1 MMDP.DrivePoolId from #tempMedia T, MMMasterPool MMMP, MMDrivePool MMDP where T.barcode = (select top 1 TMA.barcode from #tempMediaAttributes TMA where TMA.jobId = JM.jobId) and T.libraryId = MMMP.LibraryId and MMMP.MasterPoolId = MMDP.MasterPoolId), 0)
				, 0, 0, ''
				, 0, T.mediaType, 0, 0, -1
		FROM #tempJobs T, JMBkpStats JM, archFile AF, JMJobDataStats JMJD
		WHERE T.jobId = JM.jobId and JM.commCellId = @mergedServerId and T.jobId = AF.jobId and AF.commCellId = @mergedServerId
		and JMJD.jobId = JM.jobId and JMJD.commCellId = @mergedServerId
		and T.isAdminJob = 0
		set @errCode = @@ERROR
		IF ((@retval <> 0) or (@errCode <> 0))
		BEGIN
			SET @errStr = 'ERROR: FDC_Merge_Media -- [archFileCopy] -- INSERT'
			GOTO NORMAL_EXIT
		END
		-- added for merging admin jobs
		INSERT INTO [CommServ].[dbo].[archFileCopy]
				   ([archFileId],[commCellID],[archCopyId],[flags],[isValid],[streamNum],[lastChunkNumber]
				   ,[physicalSize],[logicalSize]
				   ,[drivePoolId]
				   ,[encRSA],[encKeyType],[encKey]
				   ,[modifiedTime],[mediaType],[agedBy],[encKeyId],[unCompSize])
		SELECT AF.id, @mergedServerId, AG.defaultCopy, 2, 1, 1, 1
				,JM.TotalSize, JM.TotalSize
				,IsNULL((select top 1 MMDP.DrivePoolId from #tempMedia T, MMMasterPool MMMP, MMDrivePool MMDP where T.barcode = (select top 1 TMA.barcode from #tempMediaAttributes TMA where TMA.jobId = JM.jobId) and T.libraryId = MMMP.LibraryId and MMMP.MasterPoolId = MMDP.MasterPoolId), 0)
				, 0, 0, ''
				, 0, T.mediaType, 0, 0, -1
		FROM #tempJobs T, JMAdminJobStatsTable JM, archFile AF, archGroup AG
		WHERE T.jobId = JM.jobId and JM.commCellId = @mergedServerId and T.jobId = AF.jobId and AF.commCellId = @mergedServerId
		and AG.id = JM.archGrpId
		and T.isAdminJob = 1
		set @errCode = @@ERROR
		IF ((@retval <> 0) or (@errCode <> 0))
		BEGIN
			SET @errStr = 'ERROR: FDC_Merge_Media -- [archFileCopy] -- INSERT'
			GOTO NORMAL_EXIT
		END
		SET @curTime = GETUTCDATE()
		insert into edc_mm_log(line, time) values('Inserting into archFileCopy' , @curTime)
	END
	--select * from archFileCopy where commCellID = @mergedServerId
	print 'create archChunk records'
	-- Create archChunk records
	IF exists (select * from #tempChunk)
	BEGIN
		-- Get the chunk counter for this commcell from GxEDCCounters table
		DECLARE @archChunkCounter int
		SET @archChunkCounter = 0
		IF EXISTS (select * from GxEDCCounters where commCellId = @mergedServerId)
		BEGIN
			SET @archChunkCounter = (select archChunkId from GxEDCCounters where commCellId = @mergedServerId)
		END
		ELSE
		BEGIN
			INSERT INTO GxEDCCounters(commCellId, archChunkId)
			VALUES (@mergedServerId, 0)
			set @errCode = @@ERROR
			if (@errCode <> 0)
			BEGIN
				SET @errStr = 'ERROR: FDC_Merge_Media -- GxEDCCounters -- Insert GxEDCCounters '
				GOTO NORMAL_EXIT
			END
		END
		print 'insert into archChunk records'
		INSERT INTO [CommServ].[dbo].[archChunk]
				   ([id],[commCellId]
				   ,[volumeId]
				   ,[fileMarkerNo],[createTime],[version],[cclip],[physicalSize]
				   ,[logicalSize],[writeTime],[flags],[modifiedTime],[hwEncKey],[agedBy], [origCCId])
		SELECT @archChunkCounter + TC.id, @mergedServerId
				, (select MMV.volumeId from MMMedia MMM, MMVolume MMV where MMM.BarCode = TC.barcode and MMM.MediaId = MMV.MediaId and MMM.origcccommcellid = @mergedServerId)
				, 0, 0, 0, 0, JM.totalBackupSize
				, JM.totalBackupSize, 0, 0, 0, '', 0, @mergedServerId
		FROM #tempChunk TC, JMBkpStats JM
		WHERE TC.jobId = JM.jobId and JM.commCellId = @mergedServerId
		and TC.isAdminJob = 0
		set @errCode = @@ERROR
		IF ((@retval <> 0) or (@errCode <> 0))
		BEGIN
			SET @errStr = 'ERROR: FDC_Merge_Media -- [archChunk] -- INSERT'
			GOTO NORMAL_EXIT
		END
		-- added for inserting admin jobs.
		INSERT INTO [CommServ].[dbo].[archChunk]
				   ([id],[commCellId]
				   ,[volumeId]
				   ,[fileMarkerNo],[createTime],[version],[cclip],[physicalSize]
				   ,[logicalSize],[writeTime],[flags],[modifiedTime],[hwEncKey],[agedBy], [origCCId])
		SELECT @archChunkCounter + TC.id, @mergedServerId
				, (select MMV.volumeId from MMMedia MMM, MMVolume MMV where MMM.BarCode = TC.barcode and MMM.MediaId = MMV.MediaId and MMM.origcccommcellid = @mergedServerId)
				, 0, 0, 0, 0, JM.TotalSize
				, JM.TotalSize, 0, 0, 0, '', 0, @mergedServerId
		FROM #tempChunk TC, JMAdminJobStatsTable JM
		WHERE TC.jobId = JM.jobId and JM.commCellId = @mergedServerId
		and TC.isAdminJob = 1
		set @errCode = @@ERROR
		IF ((@retval <> 0) or (@errCode <> 0))
		BEGIN
			SET @errStr = 'ERROR: FDC_Merge_Media -- [archChunk] -- INSERT'
			GOTO NORMAL_EXIT
		END
		SET @curTime = GETUTCDATE()
		insert into edc_mm_log(line, time) values('Inserting into archChunk' , @curTime)
		print 'update isinmediaGroup'
		-- Update IsInMediaGroup column in MMMedia if media has a job associated
		UPDATE MMMedia
		SET IsInMediaGroup = 1
		FROM #tempChunk T
		WHERE MMMedia.BarCode = T.barcode
		set @errCode = @@ERROR
		if (@errCode <> 0)
		BEGIN
			SET @errStr = 'ERROR: FDC_Merge_Media -- MMMedia -- UPDATE MMMedia IsInMediaGroup '
			GOTO NORMAL_EXIT
		END
		-- Update MediaGroupId column in MMVolume if media has a job associated
		UPDATE MMVolume
		SET MediaGroupId = (select top 1 mediaGroupId from archStream where archGroupCopyId in (select archGrpcopyId from JMJobDataStats JS, #tempChunk T where JS.jobId = T.jobId and JS.commCellId = @mergedServerId)),
			VolumeFlags = ( CASE VolumeFlags WHEN 2 THEN 2 ELSE 7 END ),
			VolumeFullReason = (CASE VolumeFlags WHEN 2 THEN 42000 ELSE 42016 END)
		FROM #tempChunk T, MMMedia MM
		WHERE T.barcode = MM.BarCode and MM.MediaId = MMVolume.MediaId
		and T.isAdminJob = 0
		set @errCode = @@ERROR
		if (@errCode <> 0)
		BEGIN
			SET @errStr = 'ERROR: FDC_Merge_Media -- MMVolume -- UPDATE MMVolume MediaGroupId '
			GOTO NORMAL_EXIT
		END
		-- added for inserting admin jobs
		UPDATE MMVolume
		SET MediaGroupId = (select top 1 mediaGroupId from archStream where archGroupCopyId = (select defaultCopy from JMAdminJobStatsTable JM, archGroup AG where JM.jobId = T.jobId and commCellId = @mergedServerId and JM.archGrpId = AG.id)),
			VolumeFlags = ( CASE VolumeFlags WHEN 2 THEN 2 ELSE 7 END ),
			VolumeFullReason = (CASE VolumeFlags WHEN 2 THEN 42000 ELSE 42016 END)
		FROM #tempChunk T, MMMedia MM
		WHERE T.barcode = MM.BarCode and MM.MediaId = MMVolume.MediaId
		and T.isAdminJob = 1
		set @errCode = @@ERROR
		if (@errCode <> 0)
		BEGIN
			SET @errStr = 'ERROR: FDC_Merge_Media -- MMVolume -- UPDATE MMVolume MediaGroupId '
			GOTO NORMAL_EXIT
		END
		--select * from MMMedia
		--select * from MMVolume
		print 'create archChunkMapping records'
		--select * from MMVolume
		--select COUNT(*) as chunks from archChunk where commCellId = @mergedServerId
		/*
			SELECT @archChunkCounter + TC.id
				, (select id from archFile where jobId = JM.jobId and commCellId = @mergedServerId)
				, @mergedServerId, JM.copyID, 1, 0, 0
				, JM.totalBackupSize, JM.totalBackupSize, 0, 0, 0
		FROM #tempChunk TC, JMBkpStats JM
		WHERE TC.jobId = JM.jobId and JM.commCellId = @mergedServerid
		*/
		-- Create archChunk records
		INSERT INTO [CommServ].[dbo].[archChunkMapping]
				   ([archChunkId]
				   ,[archFileId]
				   ,[commCellId],[archCopyId],[chunkNumber],[physicalOffset],[logicalOffset]
				   ,[physicalSize],[logicalSize],[flags],[modifiedTime],[dedupedSize],[agedBy],[chunkCommCellId],[jobId])
		SELECT @archChunkCounter + TC.id
				, (select id from archFile where jobId = JM.jobId and commCellId = @mergedServerId)
				, @mergedServerId, JMJD.archGrpcopyId, 1, 0, 0
				, JM.totalBackupSize, JM.totalBackupSize, 0, 0, 0, 0, @mergedServerId, JM.jobId
		FROM #tempChunk TC, JMBkpStats JM, JMJobDataStats JMJD
		WHERE TC.jobId = JM.jobId and JM.commCellId = @mergedServerid
		and JMJD.jobId = JM.jobId and JMJD.commCellId = @mergedServerid
		and TC.isAdminJob = 0
		set @errCode = @@ERROR
		IF ((@retval <> 0) or (@errCode <> 0))
		BEGIN
			SET @errStr = 'ERROR: FDC_Merge_Media -- [archChunkMapping] -- INSERT'
			GOTO NORMAL_EXIT
		END
		-- added for inserting admin jobs
		INSERT INTO [CommServ].[dbo].[archChunkMapping]
				   ([archChunkId]
				   ,[archFileId]
				   ,[commCellId],[archCopyId],[chunkNumber],[physicalOffset],[logicalOffset]
				   ,[physicalSize],[logicalSize],[flags],[modifiedTime],[dedupedSize],[agedBy],[chunkCommCellId],[jobId])
		SELECT @archChunkCounter + TC.id
				, (select id from archFile where jobId = JM.jobId and commCellId = @mergedServerId)
				, @mergedServerId, AG.defaultCopy, 1, 0, 0
				, JM.TotalSize, JM.TotalSize, 0, 0, 0, 0, @mergedServerId, JM.jobId
		FROM #tempChunk TC, JMAdminJobStatsTable JM, archGroup AG
		WHERE TC.jobId = JM.jobId and JM.commCellId = @mergedServerid
		and AG.id = JM.archGrpId
		and TC.isAdminJob = 1
		set @errCode = @@ERROR
		IF ((@retval <> 0) or (@errCode <> 0))
		BEGIN
			SET @errStr = 'ERROR: FDC_Merge_Media -- [archChunkMapping] -- INSERT'
			GOTO NORMAL_EXIT
		END
		SET @curTime = GETUTCDATE()
		insert into edc_mm_log(line, time) values('Inserting into archChunkMapping' , @curTime)
		print 'archCHunkMapping '
		--select * from archChunkMapping where commCellId = @mergedServerId
		-- set the GxEDCCounter for the number of records inserted in archChunk
		DECLARE @chunkcount int
		Set @chunkcount = (select max(id) from #tempChunk)
		-- Update GxEDCCounters table for archChunk records
		Declare @lastChunkCount int
		set @lastChunkCount = (select archChunkId from GxEDCCounters where commCellId = @mergedServerId)
		print @lastChunkCount
		Update GxEDCCounters
		set archChunkId = @lastChunkCount + @chunkcount + 1
		where commCellId = @mergedServerId
		set @errCode = @@ERROR
		if (@errCode <> 0)
		BEGIN
			SET @errStr = 'ERROR: FDC_Merge_Media -- GxEDCCounters -- UPDATE GxEDCCounters archChunkId '
			GOTO NORMAL_EXIT
		END
		-- Update the mediaGroupId in MMVolume table
		UPDATE MMVolume
		set MediaGroupId = A.MediaGroupId
		FROM #tempChunk TC, MMMedia MM, JMJobDataStats JM, archStream A
		WHERE TC.barcode = MM.BarCode and MM.MediaId = MMVolume.MediaId and JM.jobId = TC.jobId
		and JM.archGrpcopyId = A.archGroupCopyId
		and JM.commCellId = @mergedServerId
		and TC.isAdminJob = 0
		set @errCode = @@ERROR
		if (@errCode <> 0)
		BEGIN
			SET @errStr = 'ERROR: FDC_Merge_Media -- MMVolume -- UPDATE MMVolume MediaGroupId '
			GOTO NORMAL_EXIT
		END
		--added for inserting admin jobs
		UPDATE MMVolume
		set MediaGroupId = A.MediaGroupId
		FROM #tempChunk TC, MMMedia MM, JMAdminJobStatsTable JM, archStream A, archGroup AG
		WHERE TC.barcode = MM.BarCode and MM.MediaId = MMVolume.MediaId and JM.jobId = TC.jobId
		and AG.defaultCopy = A.archGroupCopyId
		and JM.archGrpId = AG.id
		and JM.commCellId = @mergedServerId
		and TC.isAdminJob = 1
		set @errCode = @@ERROR
		if (@errCode <> 0)
		BEGIN
			SET @errStr = 'ERROR: FDC_Merge_Media -- MMVolume -- UPDATE MMVolume MediaGroupId '
			GOTO NORMAL_EXIT
		END
	END
	-- Update MMLibrary History for Qnet reports.
	IF EXISTS (select * from #libHistory)
	BEGIN
	    INSERT INTO MMLibraryHistory
	    SELECT libId, 1, 0, 0, 0, noMediaUsed, noMediaFreed, 0, 0, 0, 0, CapacityFreedMB, 0 ,0
	    from #libHistory
	END
	--select * from MMVolume where origCCcommCellID = @mergedServerId
	--select * from GxEDCCounters
	--select * from archChunk where commCellId = @mergedServerId
	--select * from archChunkMapping where commCellId = @mergedServerId
	--select * from #tempMediaAttributes
	--select * from #tempMedia
	SET @curTime = GETUTCDATE()
	insert into edc_mm_log(line, time) values('Finished processing for XML file' , @curTime)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errStr =
		'ERROR: PROC(' + ERROR_PROCEDURE() +
		'), LINE(' + CAST(ERROR_LINE() AS NVARCHAR(10)) +
		'), ERROR(' + CAST(ERROR_NUMBER() AS NVARCHAR(10)) +
		'), INFO: ' + ERROR_MESSAGE() + '.'
	RAISERROR ('%s' , 16, 1, @errStr)
--	SELECT @errorCode, @errorString
	IF(@errCode = 0)
		SET @errCode = -1
END CATCH
NORMAL_EXIT:
If @errCode = 0
	COMMIT TRANSACTION MediaMerge
If @errCode <> 0
	ROLLBACK TRANSACTION MediaMerge
EXEC sp_xml_removedocument @iDoc
IF OBJECT_ID('tempdb.dbo.#tempMedia') is not null DROP TABLE #tempMedia
IF OBJECT_ID('tempdb.dbo.#tempMediaTemp') is not null DROP TABLE #tempMediaTemp
IF OBJECT_ID('tempdb.dbo.#tempMediaAttributes') is not null DROP TABLE #tempMediaAttributes
IF OBJECT_ID('tempdb.dbo.#tempExportLocations') is not null DROP TABLE #tempExportLocations
IF OBJECT_ID('tempdb.dbo.#tempJobs') is not null DROP TABLE #tempJobs
IF OBJECT_ID('tempdb.dbo.#tempChunk') is not null DROP TABLE #tempChunk
IF OBJECT_ID('tempdb.dbo.#tempChunk') is not null DROP TABLE #libHistory
NOOP_EXIT:
select @errCode, @errStr
RETURN (@errCode)
GO

IF EXISTS (select * from GxQscripts where name = 'FDC_Merge_Media')
	delete from GxQscripts where name = 'FDC_Merge_Media'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Merge_Media')
	delete from GXDBVersions where aliasname = 'FDC_Merge_Media'
GO

insert into GXDBVersions values(2, 'FDC_Merge_Media',  '00010043006000080000', 'FDC_Merge_Media', '00010043006000080000')
GO

