

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/FDC_Merge_Job.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture client application data to migrate.
--  +========================================================================+
-- $Id: FDC_Merge_Job.sp,v 1.8.60.2 2018/03/27 08:01:00 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: FDC_Merge_JOB <<<'

IF EXISTS (select * from sysobjects where name='FDC_Merge_JOB')
	drop procedure FDC_Merge_JOB
IF EXISTS (select * from GxQscripts where name='FDC_Merge_JOB')
	delete from GxQscripts where name = 'FDC_Merge_JOB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Merge_JOB')
	delete from GXDBVersions where aliasname = 'FDC_Merge_JOB'
GO
print '... Creating Procedure: FDC_Merge_JOB'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure FDC_Merge_JOB
  @FilePath varchar(MAX)
AS
  DECLARE @errCode integer;
  DECLARE @errStr varchar(MAX);
SET NOCOUNT ON
--DECLARE @errCode integer
SET @errCode = 0
SET @errStr = 'NO ERROR'
BEGIN TRY
	DECLARE @iDoc INTEGER
	DECLARE @serverAliasName nvarchar(250)
	DECLARE @commCellId INTEGER
	DECLARE @curUnixTime INTEGER
	DECLARE @jobCount INTEGER
	DECLARE @SQLString nvarchar(500);
	DECLARE @ParmDefinition nvarchar(500);
	DECLARE @input xml;
	SET @SQLString = N'set @local_xml_Out=( SELECT * FROM OPENROWSET ( BULK ''' + @FilePath + ''', SINGLE_CLOB ) AS xmlData)';
	SET @ParmDefinition = N'@local_xml_OUT xml OUTPUT';
	EXECUTE sp_executesql @SQLString, @ParmDefinition, @local_xml_OUT=@input OUTPUT;
	exec sp_xml_preparedocument @iDoc OUTPUT, @input
	SET @curUnixTime = dbo.GetUnixTime(GETUTCDATE())
	SET @commCellId = 2
	SET @jobCount =
	(
		SELECT count(nativeJobId)
		FROM
			OPENXML(@iDoc, 'FDC_JobList/jobs', 0)WITH(nativeJobId NVARCHAR(512) '@nativeJobId')
	)
--	select 'jobCount =', @jobCount
	IF(@jobCount = 0 or @jobCount is null)
	BEGIN
		SET @errStr = 'NO_ERROR'
		SET @errCode = 0
		GOTO NORMAL_EXIT
	END
	--SET @serverAliasName = 'NBU_CommNetInt'
	SELECT top 1 @serverAliasName = exAliasName
	FROM
		OPENXML(@iDoc, 'FDC_JobList/jobs/commcell', 0)WITH(exAliasName NVARCHAR(250) '@commCellName')
--	select @commCellId, @serverAliasName
	if(@commCellId = 0 or @serverAliasName='' or @serverAliasName is null)
	begin
		set @errCode = -1
		set @errStr = 'ERROR: COMMCELL WAS NOT SPECIFIED IN XML'
		goto NORMAL_EXIT
	end
	DECLARE @mergedServerId INT
	DECLARE @edcCvJobCounter INT
	DECLARE @edcCvJobCounterName nvarchar(18)
	--get merged CS id by aliasName:
	SET @mergedServerId = (select id from APP_CommCell where aliasName = @serverAliasName)
	--select '@mergedServerId = ', @mergedServerId
	if(@mergedServerId is null)
	BEGIN
		set @errStr = '2 WARNING - server was not merged yet'
		set @errCode = 2
		GOTO NORMAL_EXIT
	END
	SELECT
			tXml._nativeJobId			as 'jobId',
			@commCellId				as 'commCellId',
			tXml.storagePolicyName			as 'storagePolicyName'
	INTO #tempCCM_JMBkpStats
	FROM
		OPENXML(@iDoc, 'FDC_JobList/jobs/backupStat/backupOpt', 0)
		WITH
		(
			_nativeJobId			nvarchar(512)	'../../@nativeJobId',
			storagePolicyName		nvarchar(255)	'datastoragePolicy/@storagePolicyName'
		) as tXml
	--IF NOT EXISTS
--	(SELECT  COUNT(*)
--	FROM archGroup AG, edcJobIdMap emap, #tempCCM_JMBkpStats T, JMBkpStats
--	WHERE JMBkpStats.jobId = emap.newJobId and emap.mergedCcId = @mergedServerId and T.storagePolicyName = AG.name and T.jobId = emap.foreignJobId
--	and JMBkpStats.commCellId = @mergedServerId and JMBkpStats.copyID = AG.defaultCopy)
--	BEGIN
		UPDATE JMBkpStats
		SET dataArchGrpId = AG.id,
		copyID = AG.defaultCopy
		FROM archGroup AG, edcJobIdMap emap, #tempCCM_JMBkpStats T
		WHERE JMBkpStats.jobId = emap.newJobId and emap.mergedCcId = @mergedServerId and T.storagePolicyName = AG.name and T.jobId = emap.foreignJobId
		and JMBkpStats.commCellId = @mergedServerId
		set @errCode = @@ERROR
		IF @errCode > 0
			GOTO NORMAL_EXIT
--	END
--	IF NOT EXISTS
--	(SELECT  COUNT(*)
--	FROM archGroup AG, edcJobIdMap emap, #tempCCM_JMBkpStats T, JMJobDataStats
--	WHERE JMJobDataStats.jobId = emap.newJobId and emap.mergedCcId = @mergedServerId and T.storagePolicyName = AG.name and T.jobId = emap.foreignJobId
--	and JMJobDataStats.commCellId = @mergedServerId and JMJobDataStats.archGrpCopyId = AG.defaultCopy)
--	BEGIN
		UPDATE JMJobDataStats
		SET archGrpId = AG.id,
		archGrpcopyId = AG.defaultCopy
		FROM archGroup AG, edcJobIdMap emap, #tempCCM_JMBkpStats T
		WHERE JMJobDataStats.jobId = emap.newJobId and emap.mergedCcId = @mergedServerId and T.storagePolicyName = AG.name and T.jobId = emap.foreignJobId
		and JMJobDataStats.commCellId = @mergedServerId
		set @errCode = @@ERROR
		IF @errCode > 0
			GOTO NORMAL_EXIT
--	END
--	IF NOT EXISTS
--	(SELECT  COUNT(*)
--	FROM archGroup AG, edcJobIdMap emap, #tempCCM_JMBkpStats T, JMBkpAtmptStats
--	WHERE JMBkpAtmptStats.jobId = emap.newJobId and emap.mergedCcId = @mergedServerId and T.storagePolicyName = AG.name and T.jobId = emap.foreignJobId
--	and JMBkpAtmptStats.commCellId = @mergedServerId and JMBkpAtmptStats.copyId = AG.defaultCopy)
--	BEGIN
		UPDATE JMBkpAtmptStats
		SET archGrpId= AG.id,
		copyId = AG.defaultCopy
		FROM archGroup AG, edcJobIdMap emap, #tempCCM_JMBkpStats T
		WHERE JMBkpAtmptStats.jobId = emap.newJobId and emap.mergedCcId = @mergedServerId and T.storagePolicyName = AG.name and T.jobId = emap.foreignJobId
		and JMBkpAtmptStats.commCellId = @mergedServerId
		set @errCode = @@ERROR
		IF @errCode > 0
			GOTO NORMAL_EXIT
--	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errStr =
		'ERROR: PROC(' + ERROR_PROCEDURE() +
		'), LINE(' + CAST(ERROR_LINE() AS NVARCHAR(10)) +
		'), ERROR(' + CAST(ERROR_NUMBER() AS NVARCHAR(10)) +
		'), INFO: ' + ERROR_MESSAGE() + '.'
	RAISERROR ('%s' , 16, 1, @errStr)
--	SELECT @errorCode, @errorString
	IF(@errCode = 0)
		SET @errCode = -1
END CATCH
NORMAL_EXIT:
EXEC sp_xml_removedocument @iDoc
--IF OBJECT_ID('tempdb.dbo.#tempMap') is not null DROP TABLE #tempMap
--IF OBJECT_ID('tempdb.dbo.#tempCCM_JMJobStats') is not null DROP TABLE #tempCCM_JMJobStats
IF OBJECT_ID('tempdb.dbo.#tempCCM_JMBkpStats') is not null DROP TABLE #tempCCM_JMBkpStats
--IF OBJECT_ID('tempdb.dbo.#tempCCM_JMJobDataStats') is not null DROP TABLE #tempCCM_JMJobDataStats
--IF OBJECT_ID('tempdb.dbo.#tempCCM_JMBkpAtmptStats') is not null DROP TABLE #tempCCM_JMBkpAtmptStats
select @errCode, @errStr
RETURN (@errCode)
GO

IF EXISTS (select * from GxQscripts where name = 'FDC_Merge_Job')
	delete from GxQscripts where name = 'FDC_Merge_Job'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Merge_Job')
	delete from GXDBVersions where aliasname = 'FDC_Merge_Job'
GO

insert into GXDBVersions values(2, 'FDC_Merge_Job',  '00010008006000020000', 'FDC_Merge_Job', '00010008006000020000')
GO

