

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/FDC_Delete_StoragePolicy.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Delete Storage Policies discovered
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: FDC_Delete_StoragePolicy <<<'

IF EXISTS (select * from sysobjects where name='FDC_Delete_StoragePolicy')
	drop procedure FDC_Delete_StoragePolicy
IF EXISTS (select * from GxQscripts where name='FDC_Delete_StoragePolicy')
	delete from GxQscripts where name = 'FDC_Delete_StoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Delete_StoragePolicy')
	delete from GXDBVersions where aliasname = 'FDC_Delete_StoragePolicy'
GO
print '... Creating Procedure: FDC_Delete_StoragePolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure FDC_Delete_StoragePolicy
  @FilePath NVARCHAR(MAX)
AS
  DECLARE @errorCode integer;
  DECLARE @errorString NVARCHAR(MAX);
SET XACT_ABORT ON
SET NOCOUNT ON
SET @errorCode = 0
SET @errorString = 'NO ERROR'
DECLARE @SQLString nvarchar(500);
DECLARE @ParmDefinition nvarchar(500);
DECLARE @input xml;
DECLARE @iDoc  INT;
BEGIN TRY
	SET @SQLString = N'set @local_xml_Out=( SELECT * FROM OPENROWSET ( BULK ''' + @FilePath + ''', SINGLE_CLOB ) AS xmlData)';
	SET @ParmDefinition = N'@local_xml_OUT xml OUTPUT';
	EXECUTE sp_executesql @SQLString, @ParmDefinition, @local_xml_OUT=@input OUTPUT;
	exec sp_xml_preparedocument @iDoc OUTPUT, @input
BEGIN TRANSACTION SPDelete
	DECLARE @curDateTime varchar(19)
	SET @curDateTime = CONVERT(VARCHAR(19), CURRENT_TIMESTAMP, 0)
	-- Retreive the storagepolicy information from the XML
	UPDATE archGroup
	SET
	description = description +
				  CASE description WHEN '' THEN '' ELSE  '. ' END
				  + 'Deleted on External Server at ' + @curDateTime
	WHERE name IN
	(
		SELECT policyname as 'name'
		FROM OPENXML( @iDoc, 'FDC_StoragePolicyList/spList', 0 )
		WITH
		(
			policyname nvarchar(288) '@policyname'
		)
	) AND -- Mark only those storage policies that are not marked as deleted already
	description not like '%Deleted on External Server at%'
	DECLARE @message NVARCHAR(MAX) = 'Number of Storage Policies deleted: ' + CAST( @@ROWCOUNT AS NVARCHAR(MAX) )
	EXEC DBLog_Write 1, 'FDC_Delete_StoragePolicy', @message
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = -1
	SET @errorString =
		'ERROR: PROC(' + ERROR_PROCEDURE() +
		'), LINE(' + CAST(ERROR_LINE() AS NVARCHAR(10)) +
		'), ERROR(' + CAST(ERROR_NUMBER() AS NVARCHAR(10)) +
		'), INFO: ' + ERROR_MESSAGE() + '.'
	RAISERROR ('%s' , 16, 1, @errorString)
	SELECT @errorCode, @errorString
	EXEC sp_xml_removedocument @iDoc
	ROLLBACK TRANSACTION SPDelete
	RETURN
END CATCH
NORMAL_EXIT:
EXEC sp_xml_removedocument @iDoc
COMMIT TRANSACTION SPDelete
SELECT 0, 'NO ERROR'
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'FDC_Delete_StoragePolicy')
	delete from GxQscripts where name = 'FDC_Delete_StoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Delete_StoragePolicy')
	delete from GXDBVersions where aliasname = 'FDC_Delete_StoragePolicy'
GO

insert into GXDBVersions values(2, 'FDC_Delete_StoragePolicy',  '00000000000000000000', 'FDC_Delete_StoragePolicy', '00000000000000000000')
GO

