

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/FDC_Delete_Job.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture ALL data for commcell migration merge.
--  +========================================================================+
-- $Id: FDC_Delete_Job.sp,v 1.11.60.2 2018/03/20 00:33:19 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: FDC_Delete_Job <<<'

IF EXISTS (select * from sysobjects where name='FDC_Delete_Job')
	drop procedure FDC_Delete_Job
IF EXISTS (select * from GxQscripts where name='FDC_Delete_Job')
	delete from GxQscripts where name = 'FDC_Delete_Job'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Delete_Job')
	delete from GXDBVersions where aliasname = 'FDC_Delete_Job'
GO
print '... Creating Procedure: FDC_Delete_Job'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure FDC_Delete_Job
  @FilePath NVARCHAR(MAX)
AS
  DECLARE @errorCode integer;
  DECLARE @errorString NVARCHAR(MAX);
SET XACT_ABORT ON
SET NOCOUNT ON
DECLARE @input xml
DECLARE @SQLString nvarchar(500)
DECLARE @ParmDefinition nvarchar(500)
SET @SQLString = N'set @local_xml_Out=( SELECT * FROM OPENROWSET ( BULK ''' + @FilePath + ''', SINGLE_CLOB ) AS xmlData)'
SET @ParmDefinition = N'@local_xml_OUT xml OUTPUT'
EXECUTE sp_executesql @SQLString, @ParmDefinition, @local_xml_OUT=@input OUTPUT
DECLARE @jobCount INT
DECLARE @commCellName NVARCHAR(1000)	--AliasName
SET @errorCode = 0
SET @errorString = 'NO ERROR'
---- Get Job Count: --------------------------------
SET @jobCount = (SELECT count(ref.query('*')) FROM @input.nodes('FDC_JobList/jobs') R (ref))
IF(@jobCount = 0)
	GOTO EXIT_NOTRAN
--- Get Foreign Server AliasName:
SET @commCellName = (SELECT ref.value('@commCellName', 'nvarchar(MAX)') FROM @input.nodes('FDC_JobList/jobs[position() = 1]/commcell') R (ref))
IF(	@commCellName = '' or
	@commCellName is null)
BEGIN
	SET @errorCode = -1
	SET @errorString = 'ERROR: No commCellName found in xml file[' + @FilePath + ']'
	GOTO EXIT_NOTRAN
END
-- Get Merged Server Id by Foreign Server AliasName:
--SET @mergedServerId = (select id from CommServ..APP_CommCell where aliasName like @commCellName)
--IF(	@mergedServerId < 2 or
--	@mergedServerId is null)
--BEGIN
--	SET @errorCode = -1
--	SET @errorString = 'ERROR: Merged Served Not Found for AliasName[' + @commCellName + ']'
--	GOTO EXIT_NOTRAN
--END
BEGIN TRY
	BEGIN TRANSACTION TRAN_FDC_Delete_Job
	DECLARE @curUnixTime INTEGER
	SET @curUnixTime = dbo.GetUnixTime(GetUTCDate())
	INSERT INTO CommServ..archForeignJobCopyToDelete
	(
		commCellId,
		jobId,
		copyId,
		pruneTime,
		flags
	)
	SELECT DISTINCT
		map.mergedCcId,
		map.newJobId,
		jinfo.archGrpCopyId,
		@curUnixTime,
		0
	FROM
		CommServ..edcJobIdMap as map,
		CommServ..APP_CommCell as cell,
		CommServ..JMJobDataStats as jinfo
	WHERE
		map.mergedCcId = cell.id and
		cell.aliasName = @commCellName and
		map.mergedCcId = jinfo.commCellId and
		map.newJobId = jinfo.jobId and
		map.foreignJobId in
		(
			SELECT ref.value('@nativeJobId', 'nvarchar(512)')
			FROM @input.nodes('FDC_JobList/jobs') R (ref)
		) and
		map.newJobId not in
		(
			SELECT deleted.jobId
			FROM CommServ..archForeignJobCopyToDelete as deleted
			where map.mergedCcId = deleted.commCellId
		)
	DECLARE @message NVARCHAR(MAX) = 'Number of jobs deleted :' + CAST( @jobCount AS NVARCHAR(5) )
	EXEC DBLog_Write 1, 'FDC_Delete_Job', @message
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = -1
	SET @errorString =
		'ERROR: PROC(' + ERROR_PROCEDURE() +
		'), LINE(' + CAST(ERROR_LINE() AS NVARCHAR(10)) +
		'), ERROR(' + CAST(ERROR_NUMBER() AS NVARCHAR(10)) +
		'), INFO: ' + ERROR_MESSAGE() + '.'
	ROLLBACK TRANSACTION TRAN_FDC_Delete_Job
	RAISERROR ('%s' , 16, 1, @errorString)
	SELECT @errorCode, @errorString
	RETURN
END CATCH
COMMIT TRANSACTION TRAN_FDC_Delete_Job
if 0<(select COUNT(*) from CommServ..archForeignJobCopyToDelete)
BEGIN
	EXEC @errorCode = archDeleteForeignJobs 1	-- only if table has something
	IF @errorCode <> 0
		SET @errorString = 'ERROR: SP archDeleteForeignJobs() failed with error(' + CAST(@errorCode AS NVARCHAR(10))+ ')'
	ELSE
		SET @errorString = 'Jobs were deleted successfully'
END
ELSE BEGIN
	SET @errorString = 'NOTHING TO DELETE'
END
EXIT_NOTRAN:
SELECT @errorCode, @errorString
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'FDC_Delete_Job')
	delete from GxQscripts where name = 'FDC_Delete_Job'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Delete_Job')
	delete from GXDBVersions where aliasname = 'FDC_Delete_Job'
GO

insert into GXDBVersions values(2, 'FDC_Delete_Job',  '00010011006000020000', 'FDC_Delete_Job', '00010011006000020000')
GO

