

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/FDC_Delete_Client.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Delete Clients discovered to be deleted in EDC job
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: FDC_Delete_Client <<<'

IF EXISTS (select * from sysobjects where name='FDC_Delete_Client')
	drop procedure FDC_Delete_Client
IF EXISTS (select * from GxQscripts where name='FDC_Delete_Client')
	delete from GxQscripts where name = 'FDC_Delete_Client'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Delete_Client')
	delete from GXDBVersions where aliasname = 'FDC_Delete_Client'
GO
print '... Creating Procedure: FDC_Delete_Client'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure FDC_Delete_Client
  @FilePath NVARCHAR(MAX)
AS
  DECLARE @errorCode integer;
  DECLARE @errorString NVARCHAR(MAX);
SET XACT_ABORT ON
SET NOCOUNT ON
DECLARE @SQLString nvarchar(500);
DECLARE @ParmDefinition nvarchar(500);
DECLARE @input xml;
SET @SQLString = N'set @local_xml_Out=( SELECT * FROM OPENROWSET ( BULK ''' + @FilePath + ''', SINGLE_CLOB ) AS xmlData)';
SET @ParmDefinition = N'@local_xml_OUT xml OUTPUT';
EXECUTE sp_executesql @SQLString, @ParmDefinition, @local_xml_OUT=@input OUTPUT;
--EXEC @errorCode = FDC_Capture_App @input, 1, @errorString OUTPUT
BEGIN TRY
BEGIN TRANSACTION TRAN_DELETE_CLIENTS
	DECLARE @exServerName VARCHAR(MAX)
	SELECT TOP 1 @exServerName = aliasName from CommServ_Merge..CCM_APP_CommCell
	IF @exServerName is NULL
	BEGIN
		SELECT -1, 'No CommCell name specified'
		ROLLBACK TRANSACTION TRAN_DELETE_CLIENTS
		RETURN
	END
	DECLARE @CSId int
	SELECT @CSid = id from APP_CommCell where aliasName = @exServerName
	SELECT Clients.list.value('@clientName', 'varchar(MAX)') as 'name', 0 as 'id'
	INTO #tempClient
	FROM @input.nodes('App_ClientsList/clients/client/clientEntity') as Clients(list)
	UPDATE #tempClient
		SET #tempClient.name = edcClientNameMap.gxMachineName
	FROM #tempClient, edcClientNameMap
	WHERE
		edcClientNameMap.exMachineName = #tempClient.Name
	UPDATE #tempClient
		SET #tempClient.id = APP_Client.id
	FROM
		APP_Client, #tempClient
	WHERE
		APP_Client.name = #tempClient.name
	DECLARE @curUnixTime INT
	SET @curUnixTime = dbo.GetUnixTime( GETUTCDATE() )
	DECLARE @curDateTime varchar(19)
	SET @curDateTime = CONVERT(VARCHAR(19), CURRENT_TIMESTAMP, 0)
	--UPDATE APP_SubClientProp
	--SET modified = @curUnixTime
	--WHERE componentNameId in ( SELECT id from APP_Application where clientId in ( SELECT id FROM #tempClient ) and
	--origCCId = @CSId ) and attrName = 'User Description'
	DECLARE @maxId INT
	SELECT @maxId = MAX(ID) FROM APP_SubClientProp
	UPDATE APP_SubClientProp
	SET attrVal = subclient_property.attrVal +
				  CASE subclient_property.attrVal WHEN '' THEN '' ELSE '. ' END
				  + 'Deleted on External Server at ' + @curDateTime
	FROM
		APP_SubClientProp subclient_property, APP_Application application
	WHERE	application.clientId in ( SELECT id FROM #tempClient ) AND
			application.id = subclient_property.componentNameId AND
			application.origCCId = @CSId AND
			--Mark only the active entry not marked as deleted already
			subclient_property.attrName = 'User Description' AND
			subclient_property.attrVal not like '%Deleted on External Server at%' AND
			subclient_property.modified = 0
	INSERT INTO APP_SubClientProp
	SELECT
		application.id as componentNameId,
		'User Description' as attrName , 1 as attrType,
		'Deleted On External Server at ' + 	@curDateTime as attrVal,
		@curUnixTime as created , 0 as modified,
		@CSId as origCCId
	FROM APP_Application application WHERE clientId in ( SELECT id FROM #tempClient )
		 AND origCCId = @CSId
		 --Insert a new entry only if there is no active entry already in the table
		 AND NOT EXISTS ( SELECT id  FROM APP_SubClientProp WHERE attrName = 'User Description' AND modified = 0
						  AND componentNameId = application.id )
	UPDATE APP_Client
	SET clientDescription = clientDescription +
							CASE clientDescription WHEN '' THEN '' ELSE '. ' END
							+ 'Deleted on External Server at ' + 	@curDateTime
	WHERE id in ( SELECT id FROM #tempClient ) AND origCCId = @CSId
	--Mark only clients that have not been deleted already
	AND clientDescription not like '%Deleted on External Server at%'
	DECLARE @message NVARCHAR(MAX)
	SET @message = 'Number of clients marked for deletion:' + CAST( @@ROWCOUNT AS NVARCHAR(MAX) )
	EXEC DBlog_Write 1, 'FDC_Delete_Client', @message
	COMMIT TRANSACTION TRAN_DELETE_CLIENTS
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = -1
	SET @errorString =
		'ERROR: PROC(' + ERROR_PROCEDURE() +
		'), LINE(' + CAST(ERROR_LINE() AS NVARCHAR(10)) +
		'), ERROR(' + CAST(ERROR_NUMBER() AS NVARCHAR(10)) +
		'), INFO: ' + ERROR_MESSAGE() + '.'
	ROLLBACK TRANSACTION TRAN_DELETE_CLIENTS
	RAISERROR ('%s' , 16, 1, @errorString)
	SELECT @errorCode, @errorString
	RETURN
END CATCH
SELECT 0, 'NO ERROR'
IF OBJECT_ID('tempdb.dbo.#tempClient') IS NOT NULL DROP TABLE #tempClient
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'FDC_Delete_Client')
	delete from GxQscripts where name = 'FDC_Delete_Client'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Delete_Client')
	delete from GXDBVersions where aliasname = 'FDC_Delete_Client'
GO

insert into GXDBVersions values(2, 'FDC_Delete_Client',  '00000000000000000000', 'FDC_Delete_Client', '00000000000000000000')
GO

