

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/FDC_Capture_StoragePolicy.sp] ---------- 

--  +===========================================================================================+
--  | Stored Precedure: Merge Storage Policy, Storage Policy Copy and retention data to migrate.
--  +===========================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='FDC_Capture_StoragePolicy')
BEGIN
	print '>>> Drop Stored Procedure: FDC_Capture_StoragePolicy <<<'
	drop procedure FDC_Capture_StoragePolicy
END
IF EXISTS (select * from GxQscripts where name='FDC_Capture_StoragePolicy')
	delete from GxQscripts where name = 'FDC_Capture_StoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Capture_StoragePolicy')
	delete from GXDBVersions where aliasname = 'FDC_Capture_StoragePolicy'
GO
print '... Creating Procedure: FDC_Capture_StoragePolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure FDC_Capture_StoragePolicy
  @FilePath varchar(MAX)
AS
  DECLARE @errCode integer;
  DECLARE @errStr nvarchar(MAX);
SET NOCOUNT ON
--DECLARE @errCode integer
SET @errCode = 0
SET @errStr = 'NO ERROR'
	DECLARE @iDoc INTEGER
	DECLARE @serverAliasName nvarchar(250)
	DECLARE @mergedCCId INTEGER
	DECLARE @curUnixTime INTEGER
	DECLARE @storagePolicyCount INTEGER
DECLARE @SQLString nvarchar(500);
DECLARE @ParmDefinition nvarchar(500);
DECLARE @input xml;
BEGIN TRY
SET @SQLString = N'set @local_xml_Out=( SELECT * FROM OPENROWSET ( BULK ''' + @FilePath + ''', SINGLE_CLOB ) AS xmlData)';
SET @ParmDefinition = N'@local_xml_OUT xml OUTPUT';
BEGIN TRANSACTION SPCapture
EXECUTE sp_executesql @SQLString, @ParmDefinition, @local_xml_OUT=@input OUTPUT;
	exec @errCode = sp_xml_preparedocument @iDoc OUTPUT, @input
	if @@error <> 0 OR @errCode <> 0
		GOTO SP_MERGE_EXIT
	--print 'ready with XML parsing'
	SET @curUnixTime = dbo.GetUnixTime(GETUTCDATE())
	-- Get the number of storage policies in XML
	SET @storagePolicyCount =
	(
		SELECT count(policyname)
		FROM
			OPENXML(@iDoc, 'FDC_StoragePolicyList/spList', 0)WITH(policyname NVARCHAR(250) '@policyname')
	)
	--print 'No. of storage policies to import'
	--print @storagePolicyCount
	IF(@storagePolicyCount = 0 or @storagePolicyCount is null)
	BEGIN
		SET @errStr = 'NO_ERROR'
		SET @errCode = 0
		GOTO SP_MERGE_EXIT
	END
        DECLARE @message NVARCHAR(MAX)
	SET @message = 'Number of storage policies imported:' + CAST( @storagePolicyCount AS NVARCHAR(MAX) )
	EXEC DBLog_Write 1, 'FDC_Capture_StoragePolicy', @message
	-- Get the foreign server name
	SELECT top 1 @serverAliasName = foreignServerName
	FROM
		OPENXML(@iDoc, 'FDC_StoragePolicyList', 0)WITH(foreignServerName NVARCHAR(250) '@foreignServerName')
	IF(@serverAliasName='' or @serverAliasName is null)
	BEGIN
		SET @errCode = -1
		SET @errStr = 'ERROR: COMMCELL WAS NOT SPECIFIED IN XML'
		goto SP_MERGE_EXIT
	END
	--print 'Foreign server name:'
	--print @serverAliasName
	-- Get merged CC id by aliasName
	SET @mergedCCId = (SELECT id FROM APP_CommCell WHERE aliasName = @serverAliasName)
	--print 'Merged CCId:'
	--print @mergedCCId
	IF(@mergedCCId is null)
	BEGIN
		SET @errStr = '2 WARNING - server was not merged yet'
		SET @errCode = 2
		GOTO SP_MERGE_EXIT
	END
	--print 'read storage Policy info'
	IF OBJECT_ID('tempdb.dbo.#temparchGroup') is not null drop table #temparchGroup
	-- Retreive the storagepolicy information from the XML
	SELECT
		txml.policyname       as 'policyname',
		ISNULL(txml.description, '')      as 'description',
		txml.defaultCopyName  as 'defaultCopyName',
		ISNULL(txml.maxStreams, 1)       as 'maxStreams',
		ISNULL(txml.type, 5)             as 'type',
		ISNULL(txml.defaultSnapCopyName, '') as 'defaultSnapCopyName',
		ISNULL(txml.SIBlockSizeKB, 0)    as 'SIBlockSizeKB',
		ISNULL(txml.flags, 0)            as 'flags',
		ISNULL(txml.TimeZone, '')         as 'TimeZone',
		0								as 'origCCarchGroupId'
	INTO #temparchGroup
	FROM
		OPENXML(@iDoc, 'FDC_StoragePolicyList/spList', 0)WITH
		(
			policyname nvarchar(288) '@policyname',
			description nvarchar(250) '@description',
			defaultCopyName nvarchar(250) '@defaultCopyName',
			maxStreams int '@maxStreams',
			type int '@type',
			defaultSnapCopyName nvarchar(250) '@defaultSnapCopyName',
			SIBlockSizeKB int '@SIBlockSizeKB',
			flags int '@flags',
			TimeZone nvarchar(250) '@TimeZone'
		) as txml
	--print 'Retreived the archGroup data from the Xml'
	-- Insert into archGroup table, insert only values for which storage policy name does not exist in archGroup table
	INSERT INTO commserv_capture..CCM_archGroup(id, defaultCopy, name, description, maxStreams, type, incrSP, origCCCommCellID,
				origCCarchGroupId, defaultSnapCopy, SIBlockSizeKB, AuxCopyAlertGB,
				AuxCopyAlertDays, flags, mediaPassword, TimeZoneType, TimeZone)
	SELECT 0, 0, T.policyname, T.description, T.maxStreams, T.type, 0, 0,
		T.origCCarchGroupId, 0, T.SIBlockSizeKB, 0,
		0, T.flags, '', 0, T.TimeZone
	FROM #temparchGroup T
	set @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errStr = 'FDC_Merge_StoragePolicy : Insert archGroup Failed'
		GOTO SP_MERGE_EXIT
	END
	--Update archGroup table for which storagepolicy name already exists
	UPDATE commserv_capture..CCM_archGroup
	set description = T.description,
	maxStreams = T.maxStreams,
	type = T.type,
	SIBlockSizeKB = T.SIBlockSizeKB,
	flags = T.flags,
	TimeZone = T.TimeZone
	FROM #temparchGroup T
	where name = T.policyname
	set @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errStr = 'FDC_Merge_StoragePolicy : Update archGroup for which storagepolicy name already exists Failed'
		GOTO SP_MERGE_EXIT
	END
	--Update archGroup table for which storagepolicy name already exists
	UPDATE commserv_capture..CCM_archGroup
	set id = A.origCCarchGroupId
	FROM #temparchGroup T, archGroup A
	WHERE T.policyname = A.name and A.origCCcommCellID = @mergedCCId
	and commserv_capture..CCM_archGroup.name = A.name
	DECLARE @archId int
	SET @archId = ISNULL((select MAX(origCCarchGroupId) from archGroup where origCCcommCellID = @mergedCCId), 0)
	UPDATE commserv_capture..CCM_archGroup
	set id = @archId,
	@archId = @archId + 1
	WHERE commserv_capture..CCM_archGroup.name not in (select name from archGroup where origCCcommCellID = @mergedCCId)
	set @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errStr = 'FDC_Merge_StoragePolicy : Update archGroup for which storagepolicy name already exists Failed'
		GOTO SP_MERGE_EXIT
	END
	--print 'Inserted the archGroup data to the table'
	-- Retreive the storage policy copy information from the XML
	IF OBJECT_ID('tempdb.dbo.#temparchGroupCopy') is not null drop table #temparchGroupCopy
	SELECT
		txml.archGroupName       as 'archGroupName',
		txml.copy      as 'copy',
		txml.name  as 'name',
		ISNULL(txml.flags, 0)       as 'flags',
		ISNULL(txml.maxMultiplex, 0)             as 'maxMultiplex',
		ISNULL(txml.isActive, 1) as 'isActive',
		ISNULL(txml.type, 1)    as 'type',
		ISNULL(txml.delayedDays, 0)            as 'delayedDays',
		ISNULL(txml.maxStreamNum, 0)         as 'maxStreamNum',
		ISNULL(txml.encType, 0)            as 'encType',
		ISNULL(txml.isSnapCopy, 0)         as 'isSnapCopy',
		ISNULL(txml.description, '')	as 'description',
		ISNULL(txml.retentionDays, -1)	as 'retentionDays',
		0 as 'archGroupId',
		0 as 'copyId',
		0 as 'origCCarchCopyId'
	INTO #temparchGroupCopy
	FROM
		OPENXML(@iDoc, 'FDC_StoragePolicyList/spList/spCopyList', 0)
		WITH
		(
			archGroupName nvarchar(288) '@archGroupName',
			copy int '@copy',
			name nvarchar(250) '@name',
			flags int '@flags',
			maxMultiplex int '@maxMultiplex',
			isActive int '@isActive',
			type int '@type',
			delayedDays int '@delayedDays',
			maxStreamNum int '@maxStreamNum',
			encType int '@encType',
			isSnapCopy int '@isSnapCopy',
			description nvarchar(250) '@description',
			retentionDays int '@retentionDays'
		) as txml
	--print 'Retreived the archGroupCopy data from the Xml'
	--Update the archGroupId in the archGroupCopy table
	UPDATE #temparchGroupCopy
	SET archGroupId = AG.id
	FROM commserv_capture..CCM_archGroup as AG
	WHERE AG.name = archGroupName
	--Update archAgingRule table for which storagepolicy id and copyname already exists
	INSERT INTO commserv_capture..CCM_archGroupCopy
			(id, archGroupId, copy, name, flags,
			maxMultiplex, isActive, type, startTime, waitForIfOffline,
			waitForIfBusy, archCheckStartTime, origCCcommCellID, origCCarchCopyId, sourceCopyId,
			delayedDays, maxStreamNum, archCheckValidPeriod, calendarId, SIDBStoreId,
			encType, encKeyLen, isSnapCopy, isMirrorCopy, NWWriteSpeed,
			SIDBSnapIntervalHours, siloAppId, nDataInstance, description, dedupeFlags,
			blockCacheValidDays, nSiloStreams, silosInCache, siloRestoreMAClientId, siloRestoreClientId,
			sealStoreTaskId, extendedFlags, destMediaCopyId, archCheckValidPeriodType, endTime)
	SELECT	0, T.archGroupId, T.copy, T.name, 8,
			T.maxMultiplex, T.isActive, T.type,	0, 0,
			0, 0, 0, T.origCCarchCopyId, 0,
			T.delayedDays, T.maxStreamNum, 0, 1, 0,
			T.encType, 0, T.isSnapCopy, 0, 0,
			0, 0, 0, T.description, 0,
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 2147483647
	FROM #temparchGroupCopy T
	--WHERE T.archGroupId <> AGC.archGroupId and T.name <> AGC.name
	--WHERE T.name <> AGC.name
	set @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errStr = 'FDC_Merge_StoragePolicy : Insert archGroupCopy Failed'
		GOTO SP_MERGE_EXIT
	END
	--print 'Inserted the archGroupCopy data to the table'
	UPDATE commserv_capture..CCM_archGroupCopy
	set id = A.origCCarchCopyId
	FROM archGroupCopy A, archGroup B, commserv_capture..CCM_archGroup C
	WHERE A.origCCcommCellID = @mergedCCId
	and commserv_capture..CCM_archGroupCopy.name = A.name
	and B.origCCarchGroupId = C.id
	and B.id = A.archGroupId
	and C.id = commserv_capture..CCM_archGroupCopy.archGroupId
	DECLARE @archCopyId int
	SET @archCopyId = ISNULL((select MAX(origCCarchCopyId) from archGroupCopy where origCCcommCellID = @mergedCCId), 0)
	UPDATE commserv_capture..CCM_archGroupCopy
	set id = @archCopyId,
	@archCopyId = @archCopyId + 1
	WHERE commserv_capture..CCM_archGroupCopy.id = 0
	--Update the defaultCopy column in the archGroup table
	UPDATE commserv_capture..CCM_archGroup
	SET defaultCopy = commserv_capture..CCM_archGroupCopy.id
	FROM commserv_capture..CCM_archGroupCopy, #temparchGroup T
	WHERE commserv_capture..CCM_archGroup.id =commserv_capture..CCM_archGroupCopy.archGroupId and T.defaultCopyName = commserv_capture..CCM_archGroupCopy.name
	set @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errStr = 'FDC_Merge_StoragePolicy : Update archGroup table for defaultCopy column Failed'
		GOTO SP_MERGE_EXIT
	END
--Update the defaultCopy column in the archGroup table
	UPDATE commserv_capture..CCM_archGroup
	SET defaultSnapCopy = commserv_capture..CCM_archGroupCopy.id
	FROM commserv_capture..CCM_archGroupCopy, #temparchGroup T
	WHERE commserv_capture..CCM_archGroup.id =commserv_capture..CCM_archGroupCopy.archGroupId and T.defaultSnapCopyName = commserv_capture..CCM_archGroupCopy.name
	set @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errStr = 'FDC_Merge_StoragePolicy : Update archGroup table for defaultCopy column Failed'
		GOTO SP_MERGE_EXIT
	END
	--print 'Inserted the archAgingRule data to the table'
SP_MERGE_EXIT:
	If @errCode = 0
		COMMIT TRANSACTION SPCapture
	If @errCode <> 0
		ROLLBACK TRANSACTION SPCapture
IF OBJECT_ID('tempdb.dbo.#temparchGroup') is not null Drop table #temparchGroup
IF OBJECT_ID('tempdb.dbo.#temparchGroupCopy') is not null Drop table #temparchGroupCopy
IF OBJECT_ID('tempdb.dbo.#tempMMDatapath') is not null Drop table #tempMMDatapath
GOTO NORMAL_EXIT
	--print 'Inserted the MMDatapath data to the table'
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errStr =
		'ERROR: PROC(' + ERROR_PROCEDURE() +
		'), LINE(' + CAST(ERROR_LINE() AS NVARCHAR(10)) +
		'), ERROR(' + CAST(ERROR_NUMBER() AS NVARCHAR(10)) +
		'), INFO: ' + ERROR_MESSAGE() + '.'
	RAISERROR ('%s' , 16, 1, @errStr)
--	SELECT @errorCode, @errorString
	IF(@errCode = 0)
		SET @errCode = -1
END CATCH
NORMAL_EXIT:
EXEC sp_xml_removedocument @iDoc
SELECT @errCode, @errStr
RETURN (@errCode)
GO

IF EXISTS (select * from GxQscripts where name = 'FDC_Capture_StoragePolicy')
	delete from GxQscripts where name = 'FDC_Capture_StoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Capture_StoragePolicy')
	delete from GXDBVersions where aliasname = 'FDC_Capture_StoragePolicy'
GO

insert into GXDBVersions values(2, 'FDC_Capture_StoragePolicy',  '00000000000000000000', 'FDC_Capture_StoragePolicy', '00000000000000000000')
GO

