

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/FDC_Capture_Main.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture ALL data for commcell migration merge.
--  +========================================================================+
-- $Id: FDC_Capture_Main.sp,v 1.10.208.1 2018/03/20 00:31:52 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: FDC_Capture_Main <<<'

IF EXISTS (select * from sysobjects where name='FDC_Capture_Main')
	drop procedure FDC_Capture_Main
IF EXISTS (select * from GxQscripts where name='FDC_Capture_Main')
	delete from GxQscripts where name = 'FDC_Capture_Main'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Capture_Main')
	delete from GXDBVersions where aliasname = 'FDC_Capture_Main'
GO
print '... Creating Procedure: FDC_Capture_Main'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure FDC_Capture_Main
  @FilePath NVARCHAR(MAX),
  @JobAggregate_Interval BIGINT
AS
  DECLARE @errorCode integer;
  DECLARE @errorString NVARCHAR(MAX);
SET XACT_ABORT ON
SET NOCOUNT ON
DECLARE @SQLString nvarchar(500);
DECLARE @ParmDefinition nvarchar(500);
DECLARE @input xml;
SET @SQLString = N'set @local_xml_Out=( SELECT * FROM OPENROWSET ( BULK ''' + @FilePath + ''', SINGLE_CLOB ) AS xmlData)';
SET @ParmDefinition = N'@local_xml_OUT xml OUTPUT';
EXECUTE sp_executesql @SQLString, @ParmDefinition, @local_xml_OUT=@input OUTPUT;
BEGIN TRANSACTION TRAN_FDC_Capture_Main
	SET @errorCode = 0
	SET @errorString = 'ERROR: GENERAL ERROR!'
	---------------------------------------------------------
	--TODO: Test code. remove
--	IF EXISTS (SELECT * FROM APP_CommCell WHERE ID = 2 AND number = -1)
--	BEGIN
--		SET @errorString = 'DATABASE CommServ DOES NOT HAVE PERMANENT LICENSE'
--		GOTO CX_ERROR_EXIT
--	END
	IF NOT EXISTS (SELECT * FROM MASTER..SYSDATABASES WHERE NAME = 'CommServ_Capture')
	BEGIN
		SET @errorString = 'DATABASE CommServ_Capture DOES NOT EXIST'
		GOTO CX_ERROR_EXIT
	END
--	IF EXISTS (SELECT * FROM CommServ_Capture..CCM_APP_CommCell)
--	BEGIN
--		SET @errorString = 'DATABASE CommServ_Capture HAS OLD CONTENTS, PLEASE DROP IT AND RECREATE A NEW ONE'
--		GOTO CX_ERROR_EXIT
--	END
	---------------------------------------------------------
	-- The following code is written to generate an unique id for the captured database
	-- The id is constructed using source commcell number and current time linked with char '_'
	IF EXISTS (SELECT * FROM CommServ_Capture..SYSOBJECTS WHERE NAME = 'FDC_DB_ID') DROP TABLE CommServ_Capture..FDC_DB_ID
	CREATE TABLE CommServ_Capture..FDC_DB_ID (id varchar(128))
	DECLARE @currentTime integer;
	DECLARE @commCellNum integer;
	DECLARE @id_string varchar(128);
	set @commCellNum = (select number from APP_CommCell where id = 2)
	set @currentTime = (select datediff(second, 'january 01, 1970',getdate()))
	set @id_string = convert(varchar(64), @commCellNum) + '_' + convert(varchar(64), @currentTime)
	INSERT INTO CommServ_Capture..FDC_DB_ID SELECT @id_string
	---------------------------------------------------------
	SET @errorString = ''
--	EXEC @errorCode = FDC_Capture_CreateTables @errorString
--	IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	EXEC @errorCode = FDC_Capture_App @input, 1, @errorString OUTPUT
	IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	EXEC @errorCode = FDC_Capture_Job @input, @JobAggregate_Interval, @errorString OUTPUT
	IF @errorCode <> 0 GOTO CX_ERROR_EXIT
--	EXEC @errorCode = FDC_Capture_MM @input, @errorString
--	IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	---------------------------------------------------------
	COMMIT	TRANSACTION TRAN_FDC_Capture_Main
	SET @errorString = 'NO_ERROR'
	SELECT	0, @errorString
	RETURN
CX_ERROR_EXIT:
	IF(@errorCode = 2)
	BEGIN
		COMMIT	TRANSACTION TRAN_FDC_Capture_Main
		SELECT	2, @errorString
	END
	ELSE BEGIN
		ROLLBACK TRANSACTION TRAN_FDC_Capture_Main
		RAISERROR ('%s' , 16, 1, @errorString)
		SELECT	-1, @errorString
	END
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'FDC_Capture_Main')
	delete from GxQscripts where name = 'FDC_Capture_Main'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Capture_Main')
	delete from GXDBVersions where aliasname = 'FDC_Capture_Main'
GO

insert into GXDBVersions values(2, 'FDC_Capture_Main',  '00010010020800010000', 'FDC_Capture_Main', '00010010020800010000')
GO

