

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/FDC_Capture_MM.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture client(APP) to migrate from FDC.
--  +========================================================================+
-- Do not use transcation as FDC_Capture_Main already encompasses it
-- $Id: FDC_Capture_MM.sp,v 1.10.190.1 2018/03/20 00:50:58 jiechen Exp $
-- TODO: Lic_Usage, PatchInfo
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: FDC_Capture_MM <<<'

IF EXISTS (select * from sysobjects where name='FDC_Capture_MM')
	drop procedure FDC_Capture_MM
IF EXISTS (select * from GxQscripts where name='FDC_Capture_MM')
	delete from GxQscripts where name = 'FDC_Capture_MM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Capture_MM')
	delete from GXDBVersions where aliasname = 'FDC_Capture_MM'
GO
print '... Creating Procedure: FDC_Capture_MM'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure FDC_Capture_MM
  @input XML,
  @errStr nvarchar(MAX) OUTPUT
AS
SET NOCOUNT ON
DECLARE @flag INTEGER
DECLARE @index INTEGER
DECLARE @indexCount INTEGER
DECLARE @indexJob INTEGER
DECLARE @indexStorage INTEGER
DECLARE @time DATETIME
DECLARE @retVal INTEGER
DECLARE @countMedia INTEGER
DECLARE @countStorageList INTEGER
DECLARE @countJobs INTEGER
DECLARE @isPresent INTEGER
DECLARE @installPath nvarchar(MAX)
DECLARE @volumeName nvarchar(MAX)
DECLARE @tmpCommCellName nvarchar(MAX)
DECLARE @barcode nvarchar(MAX)
DECLARE @mediaType nvarchar(MAX)
DECLARE @mediaTypeDBId nvarchar(MAX)
DECLARE @recordingFormatId  INTEGER
DECLARE @volNameDB  nvarchar(MAX)
DECLARE @sideNameDB   nvarchar(MAX)
DECLARE @mediaGroupNameDB nvarchar(MAX)
DECLARE @archGroupNameDB nvarchar(MAX)
DECLARE @archGroupCopyNameDB nvarchar(MAX)
DECLARE @productId nvarchar(MAX)
DECLARE @capacityKB  BIGINT
DECLARE @capacityMB  BIGINT
DECLARE @usedKB      BIGINT
DECLARE @freeMB      BIGINT
DECLARE @jobId       INTEGER
DECLARE @backupLevel INTEGER
DECLARE @isValid     INTEGER
DECLARE @nameInt     INTEGER
--DECLARE @errStr      nvarchar(MAX)
--TODO: Write information to the following tables
--	CommServ_Capture..CCM_MMVolume
--	CommServ_Capture..CCM_MMMedia
--	CommServ_Capture..CCM_MMMediaGroup
--	CommServ_Capture..CCM_MMExportLocation
--	CommServ_Capture..CCM_MMMediaSide
--	CommServ_Capture..CCM_MMMountPath
SET @backupLevel = 1
SET @isValid = 1
SET @index = 1
--*****************************************************************************************************************
--Start: Capture_MM
SET @countStorageList = (SELECT count(ref.exist('*')) from @input.nodes('FDC_ForeignLibraryList/mediaStorageList') R (ref))
IF (@countStorageList = 0)
BEGIN
	SET @errStr = 'NO_ERROR'
	RETURN (0)
END
SET @indexStorage = 1
WHILE @indexStorage <= @countStorageList
BEGIN
SET @countMedia = (SELECT count(ref.exist('*')) from @input.nodes('FDC_ForeignLibraryList/mediaStorageList[position() = sql:variable("@indexStorage")]/mediaList') R (ref))
IF (@countMedia = 0)
BEGIN
	SET @errStr = 'NO_ERROR'
	RETURN (0)
END
SET @time = GETDATE()
SET @indexCount = 1
SET @indexJob = 1
WHILE @indexCount <= @countMedia
BEGIN
-- Insert the fields in the CommServ_Capture..CCM_MMMedia table
		SET @barCode = ISNULL((SELECT ref.value('@barcode', 'nvarchar(100)') from @input.nodes('FDC_ForeignLibraryList/mediaStorageList[position() = sql:variable("@indexStorage")]/mediaList[position() = sql:variable("@indexCount")]') R (ref)), '')
		SET @barCode = ISNULL((SELECT ref.value('@barcode', 'nvarchar(100)') from @input.nodes('FDC_ForeignLibraryList/mediaStorageList[position() = sql:variable("@indexStorage")]/mediaList[position() = sql:variable("@indexCount")]') R (ref)), '')
		SET @mediaType = ISNULL((SELECT ref.value('@MediaType', 'int') from @input.nodes('FDC_ForeignLibraryList/mediaStorageList[position() = sql:variable("@indexStorage")]/mediaList[position() = sql:variable("@indexCount")]') R (ref)), 0)
		SET @capacityKB = ISNULL((SELECT ref.value('@capacityKb', 'int') from @input.nodes('FDC_ForeignLibraryList/mediaStorageList[position() = sql:variable("@indexStorage")]/mediaList[position() = sql:variable("@indexCount")]') R (ref)), 0)
		SET @usedKB = ISNULL((SELECT ref.value('@usedKb', 'int') from @input.nodes('FDC_ForeignLibraryList/mediaStorageList[position() = sql:variable("@indexStorage")]/mediaList[position() = sql:variable("@indexCount")]') R (ref)), 0)
		SET @mediaTypeDBId = 0
		IF (@mediaType = 1) -- Tape
			SET @mediaTypeDBId = 143
		ELSE
		IF (@mediaType = 2) -- Magnetic
			SET @mediaTypeDBId = 10001
		ELSE
		IF (@mediaType = 3) -- Optical
			SET @mediaTypeDBId = 20004
		DECLARE @message NVARCHAR(MAX)
		--Insert the fields in the CommServ_Capture..CCM_MMMedia table
		INSERT INTO CommServ_Capture..CCM_MMMedia(MediaId, UniqueId, BarCode, MediaTypeId,
				CreationTime, NumberOfReUses, LastRestoreTime, LastBackupTime,
				LibraryId, SpareGroupId,
				LastExportTime, MediaLocation, ExternalGUID,
				MediaFlags, IsOMLWritten, MediaStatusReason,
				ExportLocationId, LastWriteLibraryId, Attributes, ContainerId, OverWriteJobId, origCCcommCellID, origCCmediaID, Descript, NumberOfSideOverwrites, ScheduleRunId, retentionFlags, retentionExpireTime,
				IsAged, IsInMediaGroup, PinMediaExpireTime, origSpareGroupId, RMSpareStatus, RMSpareStatusUpdateTime)
			VALUES(@index, 'N/A', @barCode, @mediaTypeDBId,
				 dbo.GetUnixTime(getutcdate()), 0, 0, 0,
				 0, 0,
				 0, -1, 'N/A',
				 -1, 0, 0,
				 0, 0, 0, 0, 0, 0, 0, 'N/A', 0, 0, 0, 0,
				 0, 0, 0, 0, 0, 0)
		SET @message = 'Number of Media Captured:' + CAST( @@ROWCOUNT as NVARCHAR(MAX) )
		EXEC DBLog_Write 1, 'FDC_Capture_MM', @message
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: FDC_Capture_MM -- CCM_MMMedia'
			GOTO CX_ERROR_EXIT
		END
		--Insert the fields in the CommServ_Capture..CCM_MMVolume table
		SET @volNameDB = 'V_' + convert(varchar(2), @index)
		INSERT INTO CommServ_Capture..CCM_MMVolume(VolumeId, VolumeName, CreationTime, VolumeFlags, VolumeInitialized,
			FlushBlockSizeKB, NumberOfRestores, NumberOfBackups, NumberOfMounts, NumberOfSoftErrors,
			NumberOfHardErrors,	LastRestoreTime, LastBackupTime, LogicalBytesMB, PhysicalBytesMB,
			NumberOfActiveFiles, LastFile, RecordingFormatId, ExternalGUID, OMLVersion,
			VolumeState, VolumeFullReason, VolumeFullTime, VolumeFullJobId, origCCcommCellID,
			origCCvolumeID, MediaId, MediaSideId, Attributes, MediaGroupId,
			ReformatTime, RMSpareStatus, RMSpareStatusUpdateTime, SIDBStoreId, SiloStatus, CurrMountPathId)
		VALUES(@index, @volNameDB, dbo.GetUnixTime(getutcdate()), 5, 0,
			64,	0,	0,	0,	0,
			0,	0,	0,	0,	0,
			0,	0,	0, '', 2,
			0, 0,	0, 0, 0,
			0, @index, @index, 0, 1,
			dbo.GetUnixTime(getutcdate()), -1, 0, 0, -1, 0)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: FDC_Capture_MM -- CCM_MMVolume'
			GOTO CX_ERROR_EXIT
		END
		--Insert the fields in the CommServ_Capture..CCM_MMMediaSide
		SET @sideNameDB = 'A_' + convert(varchar(2), @index)
		SET @capacityMB = @capacityKB / 1024
		SET @freeMB = (@capacityKB - @usedKB) / 1024
		INSERT INTO CommServ_Capture..CCM_MMMediaSide(MediaSideId, MediaId, SideName, MediaSideFlags,
				NumberOfRestores, NumberOfBackups, NumberOfMounts,
				NumberOfSoftErrors, NumberOfHardErrors, NumberOfReUses,
				LastRestoreTime, LastBackupTime, TotalSpaceMB, FreeBytesMB,
				LogicalBytesMB, PhysicalBytesMB, IsOMLValid, FailureReason,
				ExternalGUID, IsOMLWritten, isErasable)
			VALUES(@index, @index, @sideNameDB, 1,
				0, 0, 0,
				0, 0, 0,
				0, 0, @capacityMB, @freeMB,
				0, 0, 0, 'N/A',
				'', 2, 0)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: FDC_Capture_MM -- CCM_MMMediaSide'
			GOTO CX_ERROR_EXIT
		END
		IF (@mediaType = 2) -- IF magnetic media
		BEGIN
			--Insert the fields in the CommServ_Capture..CCM_MMMountPath
			INSERT INTO CommServ_Capture..CCM_MMMountPath(MountPathId, MountPathName, MediaSideId, UserName,
					UserPassword, IsEnabled, NumberOfWriters,
					MaxConcurrentWriters, CurrentFileMarker,
					IsOffline, OfflineReason, MountPathTypeId, OffLineTimeStamp,
					origCCcommCellID, origCCmediaSideID, MaxDataToWriteMB, MagneticSpaceRsrvInMB, Attribute, MasterPoolId, LibraryId, RMStatus, RMStatusUpdateTime, OrigCCMountPathId, MagneticChunkFileIncrSizeMB,
					MountPathOfflineReasonEventId)
				VALUES(@index, @barcode, @index, '',
					'', 1, 0,
					5, -1,
					0, 0, 0, 0,
					0, 0, -1, 2048, 0, 0, 0, 0, 0, 0, 128,
					0)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: FDC_Capture_MM -- CCM_MMMountPath'
				GOTO CX_ERROR_EXIT
			END
		END
		SET @countJobs = (SELECT COUNT(ref.exist('*')) from @input.nodes('FDC_ForeignLibraryList/mediaStorageList[position() = sql:variable("@indexStorage")]/mediaList[position() = sql:variable("@indexCount")]/details') R (ref))
		DECLARE @indexDetails int
		SET @indexDetails = 1
		WHILE @indexDetails <= @countJobs
		BEGIN
			SET @nameInt = ISNULL((SELECT ref.value('@name', 'int') from @input.nodes('FDC_ForeignLibraryList/mediaStorageList[position() = sql:variable("@indexStorage")]/mediaList[position() = sql:variable("@indexCount")]/details[position() = sql:variable("@indexDetails")]') R (ref)), 0)
			IF (@nameInt = 17)
			BEGIN
				SET @jobId = ISNULL((SELECT ref.value('@value', 'int') from @input.nodes('FDC_ForeignLibraryList/mediaStorageList[position() = sql:variable("@indexStorage")]/mediaList[position() = sql:variable("@index")]/details[position() = sql:variable("@indexDetails")]') R (ref)), 0)
				--*****************************************************************************************************************
				DECLARE @archGroupId int
				DECLARE @archGroupCopyId  int
				SET @archGroupId = (SELECT id from archGroup)
				SET @archGroupCopyId = (SELECT id from archGroupCopy)
				--Start: Capture_AF
				--Insert the fields in the CommServ_Capture..CCM_ArchFile
				INSERT INTO CommServ_Capture..CCM_archFile(id, name, commCellId, archGroupId,
							objName1, flags, appId, fileType,
							cTime, jobId, backupLevel, isValid,
							cloudId, contentIndexTime, nPushedItems)
						VALUES(@indexJob, 'Not Named', 0, @archGroupId,
							'N/A', 0, 0, 1,
							dbo.GetUnixTime(getutcdate()), @jobId, @backupLevel, @isValid,
							0, 0, 0)
				--Insert the fields in the CommServ_Capture..CCM_ArchFileCopy
				INSERT INTO CommServ_Capture..CCM_archFileCopy(archFileId, commCellId, archCopyId, flags,
							isValid, streamNum, lastChunkNumber,
							physicalSize, logicalSize, drivePoolId,
							encRSA, encKeyType, encKey, modifiedTime)
						 VALUES(@indexJob, 0, @archGroupCopyId, 2,
							1, 1, 1,
							0, 0, 1,
							0, 0, '', dbo.GetUnixTime(getutcdate()))
				--Insert the fields in the CommServ_Capture..CCM_ArchChunkMapping
				INSERT INTO CommServ_Capture..CCM_archChunkMapping(archChunkId, archFileId, commCellId, archCopyId,
							chunkNumber, physicalOffset, logicalOffset, physicalSize,
							logicalSize, flags, modifiedTime)
						VALUES(@indexJob, @indexJob, 0, 1,
							1, 0, 0, 0,
							0, 0, dbo.GetUnixTime(getutcdate()))
				--Insert the fields in the CommServ_Capture..CCM_ArchChunk
				INSERT INTO CommServ_Capture..CCM_archChunk(id, commCellId, volumeId, fileMarkerNo,
							createTime, version, cclip, physicalSize,
							logicalSize, writeTime, flags, modifiedTime, hwEncKey)
						VALUES(@indexJob, 0, @index, 0,
							dbo.GetUnixTime(getutcdate()), 3, '', 0,
							0, 0, 0, 0, '')
			END
			SET @indexDetails = @indexDetails + 1
			SET @indexJob = @indexJob + 1
		END
		SET @index = @index + 1
		SET @indexCount = @indexCount + 1
	END --end loop medialist
	SET @indexStorage = @indexStorage + 1
END  --end loop mediastoragelist
SET @mediaGroupNameDB = 'AG[' + Convert(varchar(2), 1) + ']_AGC[' + Convert(varchar(2), 1) + ']_stream[' + Convert(varchar(2), 1) + ']'
--Insert the fields in the CommServ_Capture..CCM_MMMediaGroup table
INSERT INTO CommServ_Capture..CCM_MMMediaGroup(MediaGroupId, MediaGroupName,
			DrivePoolId, SpareGroupId, DesiredMediaTypeId,
			RecordingFormatId, DataPathId)
		VALUES(1, @mediaGroupNameDB,
			1, 0, 10001,
			10001, 0)
IF	@@ERROR > 0
BEGIN
	SET @errStr = 'ERROR: FDC_Capture_MM -- CCM_MMMediaGroup'
	GOTO CX_ERROR_EXIT
END
--Insert the fields in the CommServ_Capture..CCM_MMExportLocation
INSERT INTO CommServ_Capture..CCM_MMExportLocation(ExportLocationId, ExportLocation, Type, Descript, origCCId, GUID)
		VALUES(0, 'Not Available', 1, '', DEFAULT, '')
IF	@@ERROR > 0
BEGIN
	SET @errStr = 'ERROR: FDC_Capture_MM -- CCM_MMExportLocation'
	GOTO CX_ERROR_EXIT
END
SET @errStr = 'NO_ERROR'
RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'FDC_Capture_MM')
	delete from GxQscripts where name = 'FDC_Capture_MM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Capture_MM')
	delete from GXDBVersions where aliasname = 'FDC_Capture_MM'
GO

insert into GXDBVersions values(2, 'FDC_Capture_MM',  '00010010019000010000', 'FDC_Capture_MM', '00010010019000010000')
GO

