

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/FDC_Capture_Job.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture client application data to migrate.
--  +========================================================================+
-- $Id: FDC_Capture_Job.sp,v 1.90.2.5 2019/05/08 18:01:09 mmohan Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='FDC_Capture_JOB')
BEGIN
	print '>>> Drop Stored Procedure: FDC_Capture_JOB <<<'
	drop procedure FDC_Capture_JOB
END
IF EXISTS (select * from GxQscripts where name='FDC_Capture_JOB')
	delete from GxQscripts where name = 'FDC_Capture_JOB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Capture_JOB')
	delete from GXDBVersions where aliasname = 'FDC_Capture_JOB'
GO
print '... Creating Procedure: FDC_Capture_JOB'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure FDC_Capture_JOB
  @input XML,
  @jobaggregate_interval BIGINT,
  @errStr varchar(MAX) OUTPUT
AS
SET NOCOUNT ON
DECLARE @errCode integer
SET @errCode = 0
SET @errStr = 'NO ERROR'
--DECLARE @isPresent int
--DECLARE @jobIndex int
--DECLARE @jobAttmptIndex int
--DECLARE @jobId int
--DECLARE @jobAttmptCount int
--DECLARE @clientName nvarchar(1000)
--DECLARE @instanceName nvarchar(1000)
--DECLARE @backupSetName nvarchar(1000)
--DECLARE @appName nvarchar(1000)
--DECLARE @subclientName nvarchar(1000)
--DECLARE @clientId int
--DECLARE @instanceId int
--DECLARE @backupSetId int
--DECLARE @appTypeId int
--DECLARE @appId int
--DECLARE @JobNode XML
BEGIN TRY
	DECLARE @defaultArchGroupIdData INTEGER
	SET @defaultArchGroupIdData = 1
	DECLARE @snapbackup INTEGER
	SET @snapbackup = 59
	DECLARE @snapbackup3rd INTEGER
	SET @snapbackup3rd = 65
	DECLARE @defaultStoragePolicyId INTEGER
	DECLARE @defaultStoragePolicyCopyId INTEGER
	SET @defaultStoragePolicyId = 1
	SET @defaultStoragePolicyCopyId = 0
		---------------------------------------------------------
	--	CommServ_Capture..CCM_JMJobStats
	--	CommServ_Capture..CCM_JMBkpStats
	--	CommServ_Capture..CCM_JMBkpAtmptStats
	--	CommServ_Capture..CCM_JMJobDataStats
	--	CommServ_Capture..CCM_JMAdminJobStatsTable
	--	CommServ_Capture..CCM_JMAdminJobAttemptStatsTable
	--	CommServ_Capture..CCM_JMJobOptions
	--	CommServ_Capture..CCM_JMJobDataLink
	--	CommServ_Capture..CCM_JMOracleRACClientsUsed
	--	CommServ_Capture..CCM_archCheckHistory
		---------------------------------------------------------
	----------------------------------------------------------------------------------------------------
	DECLARE @iDoc INTEGER
	DECLARE @serverAliasName nvarchar(250)
	DECLARE @commCellId INTEGER
	DECLARE @curUnixTime INTEGER
	DECLARE @jobCount INTEGER
	exec sp_xml_preparedocument @iDoc OUTPUT, @input
	SET @curUnixTime = dbo.GetUnixTime(GETUTCDATE())
	SET @commCellId = 2
	SET @jobCount =
	(
		SELECT count(nativeJobId)
		FROM
			OPENXML(@iDoc, 'FDC_JobList/jobs', 0)WITH(nativeJobId NVARCHAR(250) '@nativeJobId')
	)
--	select 'jobCount =', @jobCount
	IF(@jobCount = 0 or @jobCount is null)
	BEGIN
		SET @errStr = 'NO_ERROR'
		SET @errCode = 0
		GOTO NORMAL_EXIT
	END
	DECLARE @message NVARCHAR(MAX)
	DECLARE @isForceMergeEnabled BIT = (
											SELECT ( CASE isForceMergeEnabled WHEN '0' THEN 0 ELSE 1 END )
											FROM
												OPENXML( @iDoc, 'FDC_JobList')
											WITH
												( isForceMergeEnabled VARCHAR(1) '@forceMerge' )
										)
	SET @message = 'Force merge has been ' + ( CASE @isForceMergeEnabled WHEN 1 THEN 'Enabled' ELSE 'Disabled' END )
	EXEC DBLog_Write 1, 'FDC_Capture_Job', @message
	--SET @serverAliasName = 'NBU_CommNetInt'
	SELECT top 1 @serverAliasName = exAliasName
	FROM
		OPENXML(@iDoc, 'FDC_JobList/jobs/commcell', 0)WITH(exAliasName NVARCHAR(250) '@commCellName')
--	select @commCellId, @serverAliasName
	if(@commCellId = 0 or @serverAliasName='' or @serverAliasName is null)
	begin
		set @errCode = -1
		set @errStr = 'ERROR: COMMCELL WAS NOT SPECIFIED IN XML'
		goto NORMAL_EXIT
	end
	DECLARE @EDCInstanceType INT = (	SELECT EDCInstanceType
										FROM
										OPENXML ( @iDoc, 'FDC_JobList')
										WITH
										( EDCInstanceType VARCHAR (10) '@EDCInstanceType' )
									)
	DECLARE @mergedServerId INT
	DECLARE @edcCvJobCounter INT
	DECLARE @edcCvJobCounterName nvarchar(18)
	--get merged CS id by aliasName:
	SET @mergedServerId = (select id from APP_CommCell where aliasName = @serverAliasName)
	--select '@mergedServerId = ', @mergedServerId
	if(@mergedServerId is null)
	BEGIN
		set @errStr = '2 WARNING - server was not merged yet'
		set @errCode = 2
		GOTO NORMAL_EXIT
	END
	DECLARE @nativeJobId NVARCHAR(100)
	-- Before inserting the Job details into capture DB, check if the apptype is already installed
	-- in the client. If installed, do not insert the jobs into capture DB
	DECLARE @AppTypeList TABLE ( clientName NVARCHAR(MAX), appType INTEGER )
	INSERT INTO @AppTypeList
	SELECT clientName, appType FROM dbo.GetAppTypesList( @serverAliasName )
	-- MAP:
	SELECT
		tXml.nativeJobId	as 'nativeJobId',
		tXml.jobId			as 'jobId',
		tXml.aliasName		as 'aliasName',
		tXml.clientName	    as 'clientName',
		null				as 'clientId',
		gxClientName		as 'gxClientName',
		isnull(tXml.instanceName,'DefaultInstanceName') as 'instanceName',
		null				as 'instanceId',
		backupSetName		as 'backupSetName',
		null				as 'backupSetId',
		appName				as 'appName',
		null				as 'appId',
		null				as 'origappId',
		appTypeId			as 'appTypeId',
		subclientName		as 'subclientName',
		0					as 'aggregated', --this is valid for NBU only. If a job is aggregated with its parent job
											  -- it should no longer be considered.
		isnull(totalUncompBytes,0)	as 'tUncompBytes',
		servStartDate				as 'servStartDate',
		ISNULL(totalBackupSize,0)	as 'tBackupSize',
		ISNULL(totalNumFiles, 0)	as 'tNumFiles'
	INTO #tempMap
	FROM
		OPENXML(@iDoc, 'FDC_JobList/jobs', 0)
		WITH
		(
			nativeJobId		nvarchar(250)	'@nativeJobId',
			jobId			integer			'@jobId',
			appTypeId		integer			'@appId',
			aliasName		nvarchar(250)	'commcell/@commCellName',
			clientName	    nvarchar(250)	'source/@clientName',
			gxClientName	nvarchar(250)	'@dummy',
			instanceName	nvarchar(250)	'source/@instanceName',
			backupSetName	nvarchar(250)	'source/@backupsetName',
			appName			nvarchar(250)	'source/@appName',
			subclientName	nvarchar(250)	'source/@subclientName',
			totalUncompBytes     bigint		'backupStat/backupOpt/@totalUncompBytes',
			servStartDate		 integer	'backupStat/backupOpt/@startDate',
			totalBackupSize		 bigint		'backupStat/backupOpt/@totalBackupSize',
			totalNumFiles		 bigint	'backupStat/backupOpt/@totalNumOfFiles'
		) as tXml
		WHERE
		( @isForceMergeEnabled  = 1 OR NOT EXISTS ( SELECT * FROM @AppTypeList WHERE clientName = tXml.clientName AND	appType = tXml.appTypeId ) )
	IF @EDCInstanceType = 1
	BEGIN
		--UPDATE #tempMap
		--SET aggregated = ( CASE WHEN #tempMap.tUncompBytes = 0 THEN 0 ELSE 1 END ),
		--tUncompBytes += ( CASE WHEN #tempMap.tUncompBytes = 0 THEN src.tUncompBytes ELSE 0 END ),
		--tBackupSize += ( CASE WHEN #tempMap.tUncompBytes = 0 THEN src.tBackupSize ELSE 0 END ),
		--tNumFiles += ( CASE WHEN #tempMap.tUncompBytes = 0 THEN src.tNumFiles ELSE 0 END )
	 --   --SELECT #tempMap.nativeJobId, src.nativeJobId, #tempMap.tUncompBytes, src.tUncompBytes--SUM(src.tUncompBytes)
		--FROM #tempMap, #tempMap src
		--WHERE
		--	src.appTypeId = #tempMap.appTypeId
		--	AND src.clientName = #tempMap.clientName
		--	AND	src.instanceName = #tempMap.instanceName
		--	AND src.backupSetName = #tempMap.backupSetName
		--	AND src.subclientName = #tempMap.subclientName
		--	AND src.servStartDate - #tempMap.servStartDate BETWEEN -120 AND 120
		--	AND src.nativeJobId <> #tempMap.nativeJobId
		----AND #tempMap.tUncompBytes = 0 GROUP BY #tempMap.nativeJobId
		----DELETE FROM #tempMap WHERE aggregated = 1
		--UPDATE #tempMap
		--SET tUncompBytes = SUM(src.tUncompBytes)
		--FROM #tempMap, #tempMap src
		--WHERE
		--	src.appTypeId = #tempMap.appTypeId
		--	AND src.clientName = #tempMap.clientName
		--	AND	src.instanceName = #tempMap.instanceName
		--	AND src.backupSetName = #tempMap.backupSetName
		--	AND src.subclientName = #tempMap.subclientName
		--	AND src.servStartDate - #tempMap.servStartDate BETWEEN -120 AND 120
		--	AND src.nativeJobId <> #tempMap.nativeJobId
		SELECT
			t.nativeJobId  as 'nativeJobId',
			SUM(CAST(src.tUncompBytes as BIGINT)) as 'tUncompBytes',
			SUM(CAST(src.tBackupSize as BIGINT))  as 'tBackupSize',
			SUM(CAST(src.tNumFiles as BIGINT))	  as 'tNumFiles'
		INTO #tempSummary
		FROM #tempMap t INNER JOIN #tempMap src
		ON
			src.appTypeId = t.appTypeId
			AND src.clientName = t.clientName
			AND	src.instanceName = t.instanceName
			AND src.backupSetName = t.backupSetName
			AND src.subclientName = t.subclientName
			AND (t.servStartDate - src.servStartDate) BETWEEN -@jobaggregate_interval AND @jobaggregate_interval
		GROUP BY t.nativeJobId
		UPDATE #tempMap
		SET tUncompBytes = summary.tUncompBytes,
			tBackupSize  = summary.tBackupSize,
			tNumFiles    = summary.tNumFiles,
			aggregated	 = 1
		FROM    #tempSummary summary
		WHERE
			summary.nativeJobId = #tempMap.nativeJobId
		DELETE FROM #tempMap
		WHERE #tempMap.nativeJobId <>
			( SELECT TOP 1 t.nativeJobId FROM #tempMap t
					WHERE   #tempMap.appTypeId = t.appTypeId
						AND #tempMap.clientName = t.clientName
						AND	#tempMap.instanceName = t.instanceName
						AND #tempMap.backupSetName = t.backupSetName
						AND #tempMap.subclientName = t.subclientName
						AND #tempMap.servStartDate - t.servStartDate BETWEEN 0 AND @jobaggregate_interval
						AND #tempMap.nativeJobId <> t.nativeJobId
					)
	END
	--Veeam  server jobs
	IF (@EDCInstanceType = 15)
	BEGIN
		DELETE FROM #tempMap
		WHERE SUBSTRING(#tempMap.nativeJobId, 0, CHARINDEX('_', #tempMap.nativeJobId)) IN
		(	SELECT M.foreignJobId
			FROM	edcJobIdMap AS M
			WHERE	M.mergedCcId = @mergedServerId
		)
	END
	SET @message = 'Number of Jobs Captured:' + CAST( @@ROWCOUNT AS NVARCHAR(MAX) )
	EXEC DBLog_Write 1, 'FDC_Capture_JOB', @message
	--set nativeJobId if jobId is specified and native jobId is not:
	update #tempMap
		set nativeJobId = (SELECT CONVERT(NVARCHAR, jobId))
	where
		jobId is not null and
		jobId>0 and
		nativeJobId is null
	--set mapped jobId by nativeJobId:
	-- update job id's in tempMap with values which are alredy were merged
	UPDATE	#tempMap
	SET		jobId = JM.newJobId
	FROM    edcJobIdMap AS JM
	WHERE		JM.foreignJobId = nativeJobId
		    AND JM.mergedCcId = @mergedServerId
	-- assign new jobId for the new nativeJobId
	-- we need to assign commserv side job id for each job.
	-- in order to do that we are going to maintain external job id's counter
	SET @edcCvJobCounterName = 'edc_'+ CONVERT(NVARCHAR, @mergedServerId) + '_jobId'
	-- get new job id from the counter
	SET @edcCvJobCounter = (SELECT next_l FROM GXCounter WHERE name = @edcCvJobCounterName)
	-- if previous call returned NULL (or 0) then most probably counter for this server
	-- does not exists. create one.
	if((@edcCvJobCounter IS NULL) OR (@edcCvJobCounter = 0))
	BEGIN
		SET @edcCvJobCounter = 1
		INSERT INTO GXCounter (name, next_h, next_l)
		VALUES (@edcCvJobCounterName, 0, @edcCvJobCounter)
	END
	-- for all jobs which are in #tempMap table and which were not yet transfered
	-- into CommServ db assign new jobId
	UPDATE	#tempMap
	SET		jobId = @edcCvJobCounter,
			@edcCvJobCounter = @edcCvJobCounter + 1
	WHERE		nativeJobId NOT IN(
									SELECT	JM.foreignJobId
									FROM	edcJobIdMap AS JM
									WHERE   JM.mergedCcId = @mergedServerId
								   )
			AND nativeJobId is not null
	-- insert into Capture DB mapping information that needs to be merged
	-- excluding information that already exists in a local edcJobIdMap table
	INSERT  INTO CommServ_Capture..CCM_edcJobIdMap ( foreignJobId, mergedCcId, newJobId )
			SELECT	TM.nativeJobId, @mergedServerId, TM.jobId
			FROM 	#tempMap as TM
			WHERE		TM.nativeJobId NOT IN (
												SELECT M.foreignJobId
												FROM	edcJobIdMap AS M
												WHERE	M.mergedCcId = @mergedServerId
											   )
					AND TM.jobId IS NOT NULL
					AND TM.jobId > 0
	EXEC DBLog_Write 2, 'FDC_Capture_Job', 'edcJobIdMap created successfully'
--DB:TODO
	update #tempMap
	set
		gxClientName = clMap.gxMachineName
	from
		edcClientNameMap as clMap
	where
		clMap.exMachineName = clientName and
		clMap.exServerAliasName = aliasName
	update #tempMap
		set appId		= app.id,
			clientId	= app.clientId,
			instanceId	= app.instance,
			backupSetId	= app.backupSet,
			appTypeId	= app.appTypeId
	FROM	CommServ_Capture..CCM_APP_Application as app
		   WHERE	app.clientId  in (SELECT distinct(id) FROM CommServ_Capture..CCM_APP_Client where name = #tempMap.gxClientName)
					and app.appTypeId in (SELECT type FROM APP_IDAType where name=#tempMap.appName)
					and app.instance  in (SELECT distinct(id) FROM CommServ_Capture..CCM_APP_InstanceName where name=#tempMap.instanceName)
					and app.backupSet in (SELECT distinct(id) FROM CommServ_Capture..CCM_APP_BackupSetName where name=#tempMap.backupSetName)
					and app.subclientName = #tempMap.subclientName
	update #tempMap
		set origappId		= app.id
	FROM	CommServ..APP_Application as app
		   WHERE	app.clientId  in (SELECT distinct(id) FROM CommServ..APP_Client where name = #tempMap.gxClientName)
					and app.appTypeId in (SELECT type FROM APP_IDAType where name=#tempMap.appName)
					and app.instance  in (SELECT distinct(id) FROM CommServ..APP_InstanceName where name=#tempMap.instanceName)
					and app.backupSet in (SELECT distinct(id) FROM CommServ..APP_BackupSetName where name=#tempMap.backupSetName)
					and app.subclientName = #tempMap.subclientName
	-- Check for all missed out job id, this will account for deleted subclients.
	-- all these will go to default subclient
	update #tempMap
		set appId		= app.id,
			clientId	= app.clientId,
			instanceId	= app.instance,
			backupSetId	= app.backupSet,
			appTypeId	= app.appTypeId
	FROM	CommServ_Capture..CCM_APP_Application as app
		   WHERE	isnull(appid, 0) = 0
					and app.clientId  in (SELECT distinct(id) FROM CommServ_Capture..CCM_APP_Client where name = #tempMap.gxClientName)
					and app.appTypeId in (SELECT type FROM APP_IDAType where name=#tempMap.appName)
					and app.instance  in (SELECT distinct(id) FROM CommServ_Capture..CCM_APP_InstanceName where name=#tempMap.instanceName)
					and app.backupSet in (SELECT distinct(id) FROM CommServ_Capture..CCM_APP_BackupSetName where name=#tempMap.backupSetName)
					and app.subclientName = 'default'
DECLARE @Csv VARCHAR(MAX)
SELECT @Csv = COALESCE(@Csv + '; ',  '"')+ nativeJobId + ' ' + subclientName + char(13) FROM #tempMap where appId is null
--SET @Csv = SUBSTRING(@Csv, 1, LEN(@Csv)  1)
SET @errStr = @Csv
--select @errStr
--	select * from #tempMap
	SELECT
		tmap.jobId					as 'jobId',
		isnull(status,0)			as 'status',
		isnull(opType, 4)			as 'opType',
		@commCellId					as 'commCellId',
		isnull(jobCategory, 0)		as 'jobCategory',
		isnull(jobDescription, 'N/A')as 'jobDescription',
		isnull(xmlJobInfo, '')		as 'xmlJobInfo',
		isnull(foreignToken, _nativeJobId)	as 'foreignToken'
	INTO #tempCCM_JMJobStats
	FROM 		#tempMap as tmap,
		OPENXML(@iDoc, 'FDC_JobList/jobs/stat', 0)
		WITH
		(
 			status			integer			'@status',
 			opType			integer			'@operationType',
 			jobCategory		integer			'@category',
 			jobDescription	nvarchar(1024)	'@JobDescription',
 			xmlJobInfo		nvarchar(max)	'@xmlJobInfo',
 			_nativeJobId	nvarchar(512)	'../@nativeJobId',
 			foreignToken	nvarchar(250)	'../@foreignToken'
		) as tXml
	WHERE
		tmap.appId is not null and
		tXml._nativeJobId = tmap.nativeJobId
--	select * from #tempCCM_JMJobStats
	INSERT INTO CommServ_Capture..CCM_JMJobStats
	(
		jobId, status, opType, commCellId, jobCategory, jobDescription, xmlJobInfo, subOpType, foreignToken
	)
	SELECT
		jobId, status, opType, commCellId, jobCategory, jobDescription, xmlJobInfo, 0, foreignToken
	FROM #tempCCM_JMJobStats
	SELECT
			tmap.jobId						as 'jobId',
			@commCellId						as 'commCellId',
			tmap.appId						as 'appId',
			tmap.appTypeId					as 'appType',
			isnull(numAttempts,0)			as 'numAttempts',
			@defaultArchGroupIdData			as 'dataArchGrpId',
			isnull(copyID,0)				as 'copyID',
			isnull(backUpLevel,0)			as 'bkpLevel',
			isnull(indexOverride,0)			as 'indexOverride',
			isnull(displayStatus,0)			as 'status',	--isnull(ref.value('@status', 'integer'),0),
			isnull(duration,0)				as 'duration',
			isnull(numStreams,1)			as 'numStreams',
			isnull(startDate,0)				as 'servStartDate',
			(isnull(startDate,0) + isnull(duration,0))	as 'servEndDate',
			isnull(operationType,4)			as 'opType',
			isnull(fullCycleNumber,0)		as 'fullCycleNum',
			isnull(initFrom,1)				as 'initFrom',
			isnull(failureReason,'')		as 'failureReason',
			isnull(backupOptions,0)			as 'bkpOptions',
			isnull(scanFileFailures,0)		as 'scanFileFailures',
			isnull(scanFolderFailures,0)	as 'scanFolderFailures',
			isnull(bkpFileFailures,0)		as 'backupFileFailures',
			isnull(bkpFolderFailures,0)		as 'backupFolderFailures',
			isnull(oraSubLevel,0)			as 'oraSubLevel',
			isnull(username,'External User')	as 'username',
			isnull(totalWriteTime,0)		as 'totalWriteTime',
			isnull(priority,0)				as 'priority',
			isnull(totalCompBytes,0)		as 'totalCompBytes',
			(CASE WHEN @EDCInstanceType IN (1,8,12) THEN tMap.tUncompBytes ELSE isnull(totalUncompBytes,0) END) as 'totalUncompBytes',
			(CASE WHEN @EDCInstanceType IN (1,8,12) THEN tMap.tNumFiles ELSE isnull(totalNumOfFiles,0) END) as 'totalNumOfFiles',
			isnull(backUpAttributes,0)		as 'bkpattributes',
			-1								as 'logArchGrpId',
			isnull(totalNumOfFolders,0)		as 'totalNumOfFolders',
			isnull(failureErrorCode,0)		as 'failureErrorCode',
			isnull(lastIncrJobTime,0)		as 'lastIncrJobTime',
			isnull(scanType,0)				as 'scanType',
			isnull(scanTypeChangeReason,'')	as 'scanTypeChangeReason',
			isnull(numStreamsRequested,1)	as 'numStreamsRequested',
			isnull(dataStatus,0)			as 'dataStatus',
			isnull(agedTime,0)				as 'agedTime',
			isnull(mediaDeletedTime,0)		as 'mediaDeletedTime',
			@curUnixTime					as 'modifiedTime',
			14								as 'version',
			14								as 'idaVersion',
			isnull(cIndexTime,0)			as 'cIndexTime',
			isnull(cycleSequence,0)			as 'cycleSequence',
			isnull(filesToXfer,0)			as 'filesToXfer',
			isnull(cloudId,0)				as 'cloudId',
			-1								as 'diffArchGrpId',
			(CASE WHEN @EDCInstanceType IN (1,8,12) THEN tMap.tBackupSize ELSE isnull(totalBackupSize,0) END) as 'totalBackupSize',
			isnull(percentageChange,0)		as 'percentageChange',
			-1								as 'targetClientId',
			isnull(totalUncompBytesToXfer,0)as 'totalUncompBytesToXfer',
			isnull(displayStatus,0)			as 'displayStatus',
			isnull(dataBackedUp,0)			as 'dataBackedUp',
			isnull(logsBackedUp,0)			as 'logsBackedUp',
			isnull(openChain,0)				as 'openChain',
			0								as 'secondaryBkpLevel',
			0								as 'jobIdPrepared',
			0								as 'jobIdActedOn',
			0								as 'fromTime',
			0								as 'toTime',
			0								as 'subTaskId',
			0								as 'transDataSize',
			tXml.storagePolicyName			as 'storagePolicyName'
	INTO #tempCCM_JMBkpStats
	FROM 		#tempMap as tmap,
		OPENXML(@iDoc, 'FDC_JobList/jobs/backupStat/backupOpt', 0)
		WITH
		(
			_nativeJobId			nvarchar(250)	'../../@nativeJobId',
			numAttempts				integer			'@numAttempts',
			copyID					integer			'@copyID',
			backUpLevel				integer			'@backUpLevel',
			indexOverride			integer			'@indexOverride',
			displayStatus			integer			'@displayStatus',
			duration				integer			'@duration',
			numStreams				integer			'@numStreams',
			startDate				integer			'@startDate',
			operationType			integer			'@operationType',
			fullCycleNumber			integer			'@fullCycleNumber',
			initFrom				integer			'@initFrom',
			failureReason			nvarchar(1024)	'@failureReason',
			backupOptions			integer			'@backupOptions',
			scanFileFailures		integer			'@scanFileFailures',
			scanFolderFailures		integer			'@scanFolderFailures',
			bkpFileFailures			integer			'@backupFileFailures',
			bkpFolderFailures		integer			'@backupFolderFailures',
			oraSubLevel				integer			'@oraSubLevel',
			username				nvarchar(100)	'@username',
			totalWriteTime			integer			'@totalWriteTime',
			priority				integer			'@priority',
			totalCompBytes			bigint			'@totalCompBytes',
			totalUncompBytes		bigint			'@totalUncompBytes',
			totalNumOfFiles			bigint			'@totalNumOfFiles',
			backUpAttributes		bigint			'@backUpAttributes',
			totalNumOfFolders		bigint			'@totalNumOfFolders',
			failureErrorCode		integer			'@failureErrorCode',
			lastIncrJobTime			integer			'@lastIncrJobTime',
			scanType				integer			'@scanType',
			scanTypeChangeReason	nvarchar(1024)	'@scanTypeChangeReason',
			numStreamsRequested		integer			'@numStreamsRequested',
			dataStatus				integer			'@dataStatus',
			agedTime				integer			'@agedTime',
			mediaDeletedTime		integer			'@mediaDeletedTime',
			cIndexTime				integer			'@cIndexTime',
			cycleSequence			integer			'@cycleSequence',
			filesToXfer				integer			'@filesToXfer',
			cloudId					integer			'@cloudId',
			totalBackupSize			bigint			'@totalBackupSize',
			percentageChange		integer			'@percentageChange',
			totalUncompBytesToXfer	bigint			'@totalUncompBytesToXfer',
			dataBackedUp			integer			'@dataBackedUp',
			logsBackedUp			integer			'@logsBackedUp',
			openChain				integer			'@openChain',
			storagePolicyName		nvarchar(255)	'datastoragePolicy/@storagePolicyName'
		) as tXml
	WHERE
		tmap.appId is not null and
		tXml._nativeJobId = tmap.nativeJobId
	-- update JMJobDataStats with correct archive group and copy id, if present
	UPDATE #tempCCM_JMBkpStats
	SET #tempCCM_JMBkpStats.dataArchGrpId = A.id, #tempCCM_JMBkpStats.copyID = A.defaultCopy
	FROM CommServ_Capture..CCM_archGroup A
	WHERE #tempCCM_JMBkpStats.storagepolicyName = A.name
DECLARE @full integer
DECLARE @incr integer
DECLARE @fullStartTime integer
DECLARE @incrStartTime integer
DECLARE @origappid integer
DECLARE @appid integer
DECLARE appidlist2 CURSOR FOR
SELECT DISTINCT origappid, appid FROM #tempMap
OPEN appidlist2
FETCH NEXT FROM appidlist2
INTO @origappid, @appid
WHILE @@FETCH_STATUS = 0
BEGIN
	set @fullStartTime = (select MAX(servStartDate) from JMBkpStats where appid = @origappid and bkpLevel = 1)
	IF NOT EXISTS ( SELECT * FROM #tempCCM_JMBkpStats WHERE appid = @appid AND servStartDate < @fullStartTime and bkpLevel = 1 )
	AND NOT EXISTS ( SELECT * FROM CommServ_Capture..CCM_APP_SubClientPRop WHERE modified = 0 and attrName = 'sys:full cycle num' and componentNameId = @appId )
	BEGIN
	set @full = (select MAX (fullcyclenum) from JMBkpStats where appid = @origappid and servStartDate = @fullStartTime)
	set @incr = (select top 1 (cycleSequence) from JMBkpStats where appid = @origappid and servStartDate = @incrStartTime order by jobId desc)
	END
	ELSE
	BEGIN
		IF(EXISTS(SELECT * FROM CommServ_Capture..CCM_APP_SubClientPRop WHERE modified = 0 and attrName = 'sys:full cycle num' and componentNameId = @appId))
		BEGIN
			set @full = (SELECT CONVERT(INT, attrVal) FROM COmmServ_Capture..CCM_APP_SubClientProp WHERE modified = 0
							AND attrName = 'sys:full cycle num' and componentNameId = @appId)
			set @incr = (SELECT CONVERT(INT, attrVal) FROM COmmServ_Capture..CCM_APP_SubClientProp WHERE modified = 0
							AND attrName = 'sys:non full cycle num' and componentNameId = @appId)
		END
	END
--	set @appid = (select distinct appid from #tempmap where origappid = @origappid)
	set @full = ISNULL(@full, 0)
	set @incr = ISNULL(@incr, 0)
	UPDATE #tempCCM_JMBkpStats
      set @full =
            case bkplevel
                  when 1 then @full + 1      -- for full and offline full jobs
                  when 1024 then @full + 1
                  else @full
            end,
      @incr =
            case bkplevel
                  when 1 then 1
                  when 1024 then 1
                  else @incr + 1
            end,
      fullCycleNum = isnull(@full, 0), cycleSequence = isnull(@incr, 0)
      WHERE STATUS = 1 AND appid = @appid
	IF((@appid IS NOT NULL))
    BEGIN
		IF( EXISTS (
      				SELECT * FROM CommServ_Capture..CCM_APP_SubClientProp
      				WHERE modified = 0 and attrName = 'sys:full cycle num' and componentNameId = @appId
      				)
      	  	  )
      	BEGIN
      	UPDATE CommServ_Capture..CCM_APP_SubClientProp
      	SET
      			attrVal = CASE attrName WHEN 'sys:full cycle num' THEN CONVERT(NVARCHAR(MAX), @full)
      						WHEN 'sys:non full cycle num' THEN CONVERT(NVARCHAR(MAX), @incr)
      				  END
      	WHERE  componentNameId = @appId and modified = 0 and attrName in ('sys:full cycle num', 'sys:non full cycle num')
	    END
      	ELSE
	    BEGIN
		INSERT INTO CommServ_Capture..CCM_APP_SubClientProp
		(
			id,	componentNameId, attrName, attrType, attrVal, created, modified, ccpId
		)
		SELECT
			0,	@appId, 'sys:full cycle num', 10, isnull(@full, 0), @curUnixTime, 0, 0
		INSERT INTO CommServ_Capture..CCM_APP_SubClientProp
		(
			id,	componentNameId, attrName, attrType, attrVal, created, modified, ccpId
		)
		SELECT
			0,	@appId, 'sys:non full cycle num', 10, isnull(@incr, 0), @curUnixTime, 0, 0
		END
	END
	FETCH NEXT FROM appidlist2
	INTO @origappid, @appid
END
CLOSE appidlist2
DEALLOCATE appidlist2
	INSERT INTO CommServ_Capture..CCM_JMBkpStats
	(
		jobId, commCellId, appId, appType,numAttempts, dataArchGrpId, copyID, bkpLevel,
		indexOverride, status, duration, numStreams, servStartDate, servEndDate, opType,
		fullCycleNum, initFrom, failureReason, bkpOptions, scanFileFailures, scanFolderFailures,
		backupFileFailures, backupFolderFailures, oraSubLevel, username, totalWriteTime,
		priority, totalCompBytes, totalUncompBytes, totalNumOfFiles, bkpattributes, logArchGrpId,
		totalNumOfFolders, failureErrorCode, lastIncrJobTime, scanType, scanTypeChangeReason,
		numStreamsRequested, dataStatus, agedTime, mediaDeletedTime, modifiedTime, version,
		idaVersion, cIndexTime, cycleSequence, filesToXfer, cloudId, diffArchGrpId, totalBackupSize,
		percentageChange, targetClientId, totalUncompBytesToXfer, displayStatus, dataBackedUp,
		logsBackedUp, openChain, secondaryBkpLevel, jobIdPrepared, jobIdActedOn, fromTime, toTime,
		subTaskId,nwTransBytes, totSkippedObjects, bkpAttributesEx, jobReferenceTime
	)
	SELECT
		jobId, commCellId, appId, appType,numAttempts, dataArchGrpId, copyID, bkpLevel,
		indexOverride, status, duration, numStreams, servStartDate, servEndDate, opType,
		fullCycleNum, initFrom, failureReason, bkpOptions, scanFileFailures, scanFolderFailures,
		backupFileFailures, backupFolderFailures, oraSubLevel, username, totalWriteTime,
		priority, totalCompBytes, totalUncompBytes, totalNumOfFiles, bkpattributes, logArchGrpId,
		totalNumOfFolders, failureErrorCode, lastIncrJobTime, scanType, scanTypeChangeReason,
		numStreamsRequested, dataStatus, agedTime, mediaDeletedTime, modifiedTime, version,
		idaVersion, cIndexTime, cycleSequence, filesToXfer, cloudId, diffArchGrpId, totalBackupSize,
		percentageChange, targetClientId, totalUncompBytesToXfer, displayStatus, dataBackedUp,
		logsBackedUp, openChain, secondaryBkpLevel, jobIdPrepared, jobIdActedOn, fromTime, toTime,
		subTaskId,transDataSize, 0, 0, 0
	FROM #tempCCM_JMBkpStats
	SELECT
		tmap.jobId				as 'jobId',
		@defaultArchGroupIdData	as 'archGrpId',
		case operationType
			when @snapbackup	then 2
			when @snapbackup3rd	then 2
			else 1
		end						as 'archGrpCopyId',
		isnull(dataType,1)		as 'dataType',
		isnull(operationType,4)	as 'opType',
		0						as 'auxCopyJobId',
		100						as 'status',
		CASE imageExpireTime WHEN 0 THEN 0
							 WHEN NULL THEN 0
							 ELSE 2
		END												as 'disabled',
		tmap.appId				as 'appId',
		@commCellId				as 'commCellId',
		0						as 'archCheckEndTime',
		0						as 'archCheckStatus',
		0						as 'retentionFlags',
		ISNULL(imageExpireTime, 0)						as 'manualRetentionEndTime',
		@curUnixTime			as 'copiedTime',
		0						as 'agedTime',
		0						as 'mediaDeletedTime',
		@curUnixTime			as 'modifiedTime',
		isnull(totalUncompBytes,0)as 'sizeOnMedia',
		0						as 'agedBy',
		tXml.storagePolicyName	as 'storagePolicyName'
	INTO #tempCCM_JMJobDataStats
	FROM 		#tempMap as tmap,
		OPENXML(@iDoc, 'FDC_JobList/jobs/dataStat/dataOpt', 0)
		WITH
		(
			_nativeJobId		nvarchar(250)	'../../@nativeJobId',
			dataType			integer '@dataType',
			operationType		integer	'@operationType',
			totalUncompBytes	bigint	'@totalUncompBytes',
			imageExpireTime		integer	 '@imageExpireTime',
			storagePolicyName	nvarchar(255)	'storagePolicy/@storagePolicyName'
		) as tXml
	WHERE
		tmap.appId is not null and
		tXml._nativeJobId = tmap.nativeJobId
	-- update JMJobDataStats with correct archive group and copy id, if present
	UPDATE #tempCCM_JMJobDataStats
	SET #tempCCM_JMJobDataStats.archGrpId = A.id, #tempCCM_JMJobDataStats.archGrpCopyId =
			(case archGrpCopyId when 2 then
					A.defaultsnapcopy
			else
					A.defaultcopy
			end)
	FROM CommServ_Capture..CCM_archGroup A
	WHERE #tempCCM_JMJobDataStats.storagepolicyName = A.name
--	select * from #tempCCM_JMJobDataStats
	INSERT INTO CommServ_Capture..CCM_JMJobDataStats
	(
		jobId, archGrpId, archGrpCopyId, dataType,opType, auxCopyJobId, status, disabled,
		appId, commCellId, archCheckEndTime, archCheckStatus, retentionFlags,
		manualRetentionEndTime, copiedTime, agedTime, mediaDeletedTime, modifiedTime,
		sizeOnMedia, agedBy, flags, jobSelectionTime
	)
	SELECT
		jobId, archGrpId, archGrpCopyId, dataType,opType, auxCopyJobId, status, disabled,
		appId, commCellId, archCheckEndTime, archCheckStatus, retentionFlags,
		manualRetentionEndTime, copiedTime, agedTime, mediaDeletedTime, modifiedTime,
		sizeOnMedia, agedBy, 0, 0
	FROM #tempCCM_JMJobDataStats
	SELECT
		tmap.jobId	as 'jobId',
		1	as 'number', --fake attempt
		isnull(phase, 7)			as 'phase',
		isnull(duration,0)			as 'elapsedTime',
		isnull(startDate,0)			as 'servStartDate',
		(isnull(startDate,0) + isnull(duration,0) ) 	as 'servEndDate',
		isnull(unCompBytes,0)		as 'unCompBytes',
		isnull(compBytes,0)			as 'compBytes',
		isnull(numObjects,0)		as 'numObjects',
		isnull(status,0)			as 'status',
		isnull(failureReason, '')	as 'failureReason',
		isnull(writeTime,0)			as 'writeTime',
		isnull(restartString, '')	as 'restartString',
		isnull(attributes,0)		as 'attributes',
		@commCellId					as 'commCellId',
		isnull(numFolders,0)		as 'numFolders',
		@defaultStoragePolicyId		as 'archGrpId',
		@defaultStoragePolicyCopyId	as 'copyId',
		isnull(maxStreamsUsed,0)	as 'maxStreamsUsed',
		@curUnixTime				as 'modifiedTime',
		0                           as 'nwTransBytes'
	INTO #tempCCM_JMBkpAtmptStats
	FROM 		#tempMap as tmap,
		OPENXML(@iDoc, 'FDC_JobList/jobs/backupAtmptStat', 0)
		WITH
		(
			_nativeJobId	nvarchar(250)	'../@nativeJobId',
			phase			integer			'@phase',
			duration		integer			'@duration',
			startDate		integer			'@startDate',
			unCompBytes		bigint 			'@unCompBytes',
			compBytes		bigint 			'@compBytes',
			numObjects		bigint 			'@numObjects',
			status			integer			'@status',
			failureReason	nvarchar(1000)	'@failureReason',
			writeTime		integer			'@writeTime',
			restartString	nvarchar(1000)	'@restartString',
			attributes		integer			'@attributes',
			numFolders		integer			'@numFolders',
			maxStreamsUsed	integer			'@maxStreamsUsed'
		) as tXml
	WHERE
		tmap.appId is not null and
		tXml._nativeJobId = tmap.nativeJobId
--	select * from #tempCCM_JMBkpAtmptStats
	if((select COUNT(jobId) from #tempCCM_JMBkpAtmptStats) > 0)
		BEGIN
		INSERT INTO CommServ_Capture..CCM_JMBkpAtmptStats
		(
			jobId, number, phase, elapsedTime, servStartDate, servEndDate, unCompBytes, compBytes,
			numObjects, status, failureReason, writeTime, restartString, attributes, commCellId,
			numFolders,	archGrpId, copyId, maxStreamsUsed, modifiedTime, nwTransBytes
		)
		SELECT
			jobId, number, phase, elapsedTime, servStartDate, servEndDate, unCompBytes, compBytes,
			numObjects, status, failureReason, writeTime, restartString, attributes, commCellId,
			numFolders,	archGrpId, copyId, maxStreamsUsed, modifiedTime, nwTransBytes
		FROM #tempCCM_JMBkpAtmptStats
	END
	-- Admin stats
	SELECT
			tmap.jobId		as 'jobId',
			@commCellId		as 'commCellId',
			tmap.appId		as 'appId',
			tXml.operationType		as 'opType',
			tXml.status			as 'status',
			tXml.servStartTime		as 'servStart',
			tXml.servEndTime		as  'servEnd',
			-1 			as  'archGrpID',
			'' 			as  'archGrpName',
			0			as  'AP_NumDays',
			0			as 'AP_IsForecast',
			0			as 'AP_SeqNum',
			0			as 'AC_NewMediaFlag',
			0			as	'ER_BkpLevel',
			''			as  'ER_DbName',
			''			as  'ER_Destination',
			0 			as  'ER_SendCount',
			''			as  'ER_MediasUsed',
			0			as  'EX_TotalMedia',
			0			as  'EX_TotalSuccess',
			0			as  'EX_TotalFailures',
			1			as  'initFrom',
			''			as  'failureReason',
			0 			as  'archGrpCopyID',
			0 			as   'LibraryID',
			'' 			as   'MI_InventoryType',
			'' 			as   'username',
			0			as   'totalWriteTime',
			0 			as	'noOfStreams',
			0			as 'priority',
			0			as 'failureErrorCode',
			tXml.totalSize		as 'TotalSize',
			0			as 'fullCycleNum',
			0			as 'dataStatus',
			0			as 'workFlowId',
			0			as 'embeddedObjects',
			0			as 'uncompBytes',
			0			as 'numFiles',
			0			as 'skippedItems',
			0			as 'jobFlags',
			0 			as 'cloudId',
			0			as 'successIndex',
			0			as 'failIndex',
			0			as 'totalBackupSize',
			14			as 'version',
			0			as 'fromTime',
			0			as 'toTime',
			0			as 'subTaskId',
			''          as 'otherOpName',
			0           as 'nwTransBytes'
	INTO #tempCCM_JMAdminStats
	FROM 		#tempMap as tmap,
		OPENXML(@iDoc, 'FDC_JobList/jobs/adminStats/adminOpt', 0)
		WITH
		(
			_nativeJobId		nvarchar(250)	'../../@nativeJobId',
			operationType  		integer 		'../../stat/@operationType',
			status				integer			'../../stat/@status',
			servStartTime  		integer 		'@servStartTime',
			servEndTime  		integer   		'@servEndTime',
			duration 			integer 		'@duration',
			totalSize 			bigint 			'@totalSize'
		) as tXml
	WHERE
		tmap.appId is not null and
		tXml._nativeJobId = tmap.nativeJobId
	DECLARE @defaultArchGroupId  INT = (SELECT MIN(id) FROM CommServ_Capture..CCM_archGroup )
       	DECLARE @defaultArchGroupName NVARCHAR(300) = (SELECT name FROM CommServ_Capture..CCM_archGroup WHERE id = @defaultArchGroupId)
	 IF((SELECT COUNT(jobId) from #tempCCM_JMAdminStats) > 0)
		BEGIN
		INSERT INTO CommServ_Capture..CCM_JMAdminJobStatsTable
		( jobId,opType,status,servStart,servEnd, archGrpID,archGrpName,AP_NumDays,AP_IsForecast,AP_SeqNum,
			AC_NewMediaFlag,ER_BkpLevel,ER_DbName,ER_Destination,ER_SendCount,ER_MediasUsed,EX_TotalMedia,
			EX_TotalSuccess,EX_TotalFailures,initFrom,failureReason,archGrpCopyID,LibraryID,MI_InventoryType,
			username,totalWriteTime,noOfStreams, priority,commCellId,appID,failureErrorCode,
			TotalSize,fullCycleNum,dataStatus,workFlowId, embeddedObjects,uncompBytes,numFiles,
			skippedItems,jobFlags,cloudId,successIndex, failIndex,totalBackupSize,version,
			fromTime,toTime,subTaskId, otherOpName, nwTransBytes)
		SELECT
		 jobId,opType,status,servStart,servEnd, @defaultArchGroupId,@defaultArchGroupName,AP_NumDays,AP_IsForecast,AP_SeqNum,
			AC_NewMediaFlag,ER_BkpLevel,ER_DbName,ER_Destination,ER_SendCount,ER_MediasUsed,EX_TotalMedia,
			EX_TotalSuccess,EX_TotalFailures,initFrom,failureReason,archGrpCopyID,LibraryID,MI_InventoryType,
			username,totalWriteTime,noOfStreams, priority,commCellId,appID,failureErrorCode,
			TotalSize,fullCycleNum,dataStatus,workFlowId, embeddedObjects,uncompBytes,numFiles,
			skippedItems,jobFlags,cloudId,successIndex, failIndex,totalBackupSize,version,
			fromTime,toTime,subTaskId, otherOpName, nwTransBytes
	FROM #tempCCM_JMAdminStats
  END
-- ------------------------------------------------------------------------------------------
-- job pending reason block
-- ------------------------------------------------------------------------------------------
    SELECT  tmap.jobId,
            tmap.gxClientName,
            tmap.appTypeId,
            tXml.*
    INTO    #tempJPRData
    FROM    #tempMap as tmap,
	        OPENXML(@iDoc, 'FDC_JobList/jobs/JPRList/frparameters', 0)
	        WITH
	        (	_NodeId				integer			'@mp:parentid',
				_nativeJobId		nvarchar(250)	'../../@nativeJobId',
		        eventId             integer         '../@eventId',
		        subsystem           nvarchar(250)   '../@subsystem',
		        paramPosition		integer	        '@paramPosition',
		        paramType           integer         '@paramType',
		        paramValue	        nvarchar(1000)  '@paramValue'
	        ) as tXml
    WHERE		tmap.appId is not null
			AND	tXml._nativeJobId = tmap.nativeJobId
	--SELECT * FROM #tempJPRData
	DECLARE @currentMessageId       int
    DECLARE @currentJobId           nvarchar(250)
    DECLARE @currentNodeId			int
    DECLARE @currentEventId         int
    DECLARE @currentSubSystem       nvarchar(250)
    DECLARE @currentClientName      nvarchar(1000)
    DECLARE @currentAppId           nvarchar(1000)
    DECLARE @currentMergedJobId     int
    DECLARE @totalParams            int
    SET @currentJobId           = (SELECT MIN(_nativeJobId) FROM #tempJPRData)
	SET @currentNodeId			= null
    SET @currentEventId         = null
    SET @currentSubSystem       = null
    SET @currentClientName      = null
    SET @currentAppId           = null
    SET @currentMergedJobId     = null
	SET @currentMessageId		= 0
    WHILE @currentJobId IS NOT NULL BEGIN
		SELECT	@currentNodeId = MIN(_NodeId)
		FROM	#tempJPRData
		WHERE	_nativeJobId = @currentJobId
		WHILE @currentNodeId IS NOT NULL BEGIN
			-- get general information about event
			SELECT  TOP(1)
					@currentEventId = eventId,
					@currentSubSystem = subsystem,
					@currentClientName = gxClientName,
					@currentAppId = appTypeId,
					@currentMergedJobId = jobId
			FROM    #tempJPRData
			WHERE       _nativeJobId = @currentJobId
					AND _NodeId = @currentNodeId
			-- calculate number of parameters
            SELECT  @totalParams = COUNT(*)
            FROM    #tempJPRData
            WHERE       _nativeJobId = @currentJobId
                    AND _NodeId = @currentNodeId
			-- in CCM database CCM_JMFailureReasonMsg table does not have identity column.
			-- we need to specify unique one
			SELECT @currentMessageId = ((ISNULL(MAX(id), 0)) + 1) FROM CommServ_Capture..CCM_JMFailureReasonMsg
            INSERT	INTO CommServ_Capture..CCM_JMFailureReasonMsg
							( id, messageId, paramNum, errorType, commCellId, jobId, client, subsystem, copyId,
							  rcId, reservationId, flags, guiAlertColorLevel, clientVersion, serverVersion, iDA,
							  opType, phaseNumber, customMessageId, failureReasonTime )
					VALUES	( @currentMessageId, @currentEventId, @totalParams, 0, @commCellId, @currentMergedJobId,
						      @currentClientName, @currentSubSystem, 0, 0, 0, 0, 0, 0, 13, @currentAppId, 0, 0, 0, 0 )
			INSERT	INTO CommServ_Capture..CCM_JMFailureReasonMsgParam
			SELECT	@currentMessageId, @currentEventId, paramPosition, paramType, LEN(paramValue), paramValue
			FROM	#tempJPRData
			WHERE       _nativeJobId = @currentJobId
					AND _NodeId = @currentNodeId
			SELECT	@currentNodeId = MIN(_NodeId)
			FROM	#tempJPRData
			WHERE		_nativeJobId = @currentJobId
					AND _NodeId > @currentNodeId
		END
        SELECT  @currentJobId = MIN(_nativeJobId)
        FROM    #tempJPRData
        WHERE   _nativeJobId > @currentJobId
    END
-- ------------------------------------------------------------------------------------------
-- end job pending reason block
-- ------------------------------------------------------------------------------------------
-- ------------------------------------------------------------------------------------------
-- job options block
-- ------------------------------------------------------------------------------------------
	SELECT  tmap.jobId		as	'jobId',
            @commCellId		as	'commCellId',
            0				as	'attributeId',
            tXml.attrName	as	'attributeName',
            tXml.valueType	as	'attributeValueInt',
            tXml.value		as	'attributeValue'
    INTO    #tempJobOptions
    FROM    #tempMap as tmap,
	        OPENXML(@iDoc, 'FDC_JobList/jobs/option/attributes', 0)
	        WITH
	        (
				_nativeJobId		nvarchar(250)	'../../@nativeJobId',
	        	attrName			nvarchar(250)	'@name',
		        valueType			integer         '@valueType',
		        value	            nvarchar(250)   '@value'
	        ) as tXml
    WHERE		tmap.appId is not null
			AND	tXml._nativeJobId = tmap.nativeJobId
	INSERT	INTO CommServ_Capture..CCM_JMJobOptions
	SELECT	jobId, commCellId, attributeId, attributeName, attributeValueInt, attributeValue, 0 -- enter 0 for now. this value doesn't affect licensing numbers
	FROM	#tempJobOptions
-- ------------------------------------------------------------------------------------------
-- end job options block
-- ------------------------------------------------------------------------------------------
	-- Save counter value:
	UPDATE GXCounter
	SET next_l= @edcCvJobCounter
	WHERE (name=@edcCvJobCounterName)
	IF(@EDCInstanceType = 15)
	BEGIN
		UPDATE CommServ_Capture..CCM_JMJobStats SET foreignToken = SUBSTRING(tmap.nativeJobId, 0, CHARINDEX('_', tmap.nativeJobId))
		FROM #tempMap as tmap
		WHERE CommServ_Capture..CCM_JMJobStats.foreignToken = tmap.nativeJobId
		UPDATE CommServ_Capture..CCM_edcJobIdMap SET foreignJobId = SUBSTRING(tmap.nativeJobId, 0, CHARINDEX('_', tmap.nativeJobId))
		FROM #tempMap as tmap
		WHERE CommServ_Capture..CCM_edcJobIdMap.foreignJobId = tmap.nativeJobId
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errStr =
		'ERROR: PROC(' + ERROR_PROCEDURE() +
		'), LINE(' + CAST(ERROR_LINE() AS NVARCHAR(10)) +
		'), ERROR(' + CAST(ERROR_NUMBER() AS NVARCHAR(10)) +
		'), INFO: ' + ERROR_MESSAGE() + '.'
	RAISERROR ('%s' , 16, 1, @errStr)
--	SELECT @errorCode, @errorString
	IF(@errCode = 0)
		SET @errCode = -1
END CATCH
NORMAL_EXIT:
EXEC sp_xml_removedocument @iDoc
IF OBJECT_ID('tempdb.dbo.#tempMap') is not null DROP TABLE #tempMap
IF OBJECT_ID('tempdb.dbo.#tempCCM_JMJobStats') is not null DROP TABLE #tempCCM_JMJobStats
IF OBJECT_ID('tempdb.dbo.#tempCCM_JMBkpStats') is not null DROP TABLE #tempCCM_JMBkpStats
IF OBJECT_ID('tempdb.dbo.#tempCCM_JMJobDataStats') is not null DROP TABLE #tempCCM_JMJobDataStats
IF OBJECT_ID('tempdb.dbo.#tempCCM_JMBkpAtmptStats') is not null DROP TABLE #tempCCM_JMBkpAtmptStats
RETURN (@errCode)
GO

IF EXISTS (select * from GxQscripts where name = 'FDC_Capture_Job')
	delete from GxQscripts where name = 'FDC_Capture_Job'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Capture_Job')
	delete from GXDBVersions where aliasname = 'FDC_Capture_Job'
GO

insert into GXDBVersions values(2, 'FDC_Capture_Job',  '00010090000200050000', 'FDC_Capture_Job', '00010090000200050000')
GO

