

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/FDC_Capture_App.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture client(APP) to migrate from FDC.
--  +========================================================================+
-- Do not use transcation as FDC_Capture_Main already encompasses it
-- $Id: FDC_Capture_App.sp,v 1.120.60.7 2019/08/01 17:01:04 mmohan Exp $
-- TODO: Lic_Usage, PatchInfo
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='FDC_Capture_App')
BEGIN
	print '>>> Drop Stored Procedure: FDC_Capture_App <<<'
	drop procedure FDC_Capture_App
END
IF EXISTS (select * from GxQscripts where name='FDC_Capture_App')
	delete from GxQscripts where name = 'FDC_Capture_App'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Capture_App')
	delete from GXDBVersions where aliasname = 'FDC_Capture_App'
GO
print '... Creating Procedure: FDC_Capture_App'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure FDC_Capture_App
  @input XML,
  @insertDefaultValue int,
  @errorString varchar(MAX) OUTPUT
AS
SET NOCOUNT ON
DECLARE @errorCode INTEGER
SET @errorCode = 0
SET @errorString = 'NO_ERROR'
DECLARE @iDoc INTEGER
exec sp_xml_preparedocument @iDoc OUTPUT, @input
DECLARE @curUnixTime INTEGER
SET @curUnixTime = dbo.GetUnixTime(GETUTCDATE())
DECLARE @commcellId INTEGER
SET @commcellId = 2
--For storing date&time in string format for marking deleted subclients
DECLARE @curDateTime varchar(19)
SET @curDateTime = CONVERT(VARCHAR(19), CURRENT_TIMESTAMP, 0)
DECLARE @defaultReleaseString nvarchar(10)
SET @defaultReleaseString = '9.0'
--supported galaxy version:
INSERT INTO CommServ_Capture..CCM_simAllGalaxyRel (id, release)
SELECT id, release
FROM simAllGalaxyRel as rel
WHERE rel.id >= 14
DECLARE @dummy_ccpId INTEGER
SET @dummy_ccpId = 0
DECLARE @dummy_ccpTime INTEGER
SET @dummy_ccpTime = 0
DECLARE @dummy_GUID nvarchar(100)
SET @dummy_GUID = '00000000-0000-0000-0000-000000000000'
DECLARE @serverHostName NVARCHAR(1000)
SET @serverHostName = 'SERVERHOSTNAME'
DECLARE @id_cntr integer
BEGIN TRY
	DECLARE @count int
	SET @count =
	(
		SELECT count(exClientHostName)
		FROM
			OPENXML(@iDoc, 'App_ClientsList/clients/client/clientEntity', 0)
				WITH(exClientHostName NVARCHAR(250) '@hostName')
	)
	DECLARE @message NVARCHAR(MAX)
	DECLARE @isForceMergeEnabled BIT = (
											SELECT ( CASE isForceMergeEnabled WHEN '0' THEN 0 ELSE 1 END )
											FROM
												OPENXML( @iDoc, 'App_ClientsList')
											WITH
												( isForceMergeEnabled VARCHAR(1) '@forceMerge' )
										)
	SET @message = 'Force merge has been ' + ( CASE @isForceMergeEnabled WHEN 1 THEN 'Enabled' ELSE 'Disabled' END )
	EXEC DBLog_Write 1, 'FDC_Capture_App', @message
	DECLARE @EDCInstanceType INT = (	SELECT EDCInstanceType
										FROM
											OPENXML ( @iDoc, 'App_ClientsList')
										WITH
											( EDCInstanceType VARCHAR (10) '@EDCInstanceType' )
									)
--	select @count as 'number of clients'
	IF(@count = 0 or @count is null)
	BEGIN
		SET @errorString = 'NO_ERROR'
		SET @errorCode = 0
		GOTO NORMAL_EXIT
	END
	-- SERVER
	SELECT
		@commcellId					as 'id',
		-1							as 'number',
		null						as 'clientId',
		1							as 'parentId',
		tXml.aliasName				as 'aliasName',
		ISNULL(tXml.flags, 2)		as 'flags',
		ISNULL(tXml.refTime, 0)		as 'refTime',
		ISNULL(tXml.userName, '')	as 'userName',
		ISNULL(tXml.userPassword, '') as 'userPassword',
		ISNULL(tXml.smtpServer, '')	as 'smtpServer',
		ISNULL(tXml.timeZone, '')	as 'timeZone',
		ISNULL(tXml.ipAddress, '')	as 'ipAddress',
		ISNULL(tXml.modified, @curUnixTime) as 'modified',
		ISNULL(tXml.ccOpMode, 0)	as 'ccOpMode',
		tXml.vendorId				as 'type',	--type
		ISNULL(tXml.drIpAddress,'')	as 'drIpAddress',
		ISNULL(tXml.encNumber, '')	as 'encNumber',
		@dummy_GUID					as 'csGUID',
		net_hostname				as 'csHostName'
	INTO #tempServer
	FROM
	--	#tempClient as tCl,
		OPENXML(@iDoc, 'App_ClientsList/clients', 0)
			WITH
			(
	--		permanentLicenseNumber integer	'server/@permanentLicenseNumber',
			aliasName		nvarchar(250)	'server/serverEntity/@commCellName',
			flags			integer			'server/@flags',
			refTime			integer			'server/@lastReferenceTime',
			userName		nvarchar(250)	'server/@userName',
			userPassword	nvarchar(250)	'server/@password',
			smtpServer		nvarchar(250)	'server/@smtpServer',
			timeZone		nvarchar(250)	'server/@timeZone',
			ipAddress		nvarchar(250)	'server/@ipAddress',
			modified		integer			'server/@modifiedTime',
			ccOpMode		integer			'server/@ccOpMode',
			vendorId		integer			'server/@serverVendor',
			drIpAddress		nvarchar(250)	'server/@drIpAddress',
			encNumber		nvarchar(250)	'server/@encryption',
			csGUID			nvarchar(50)	'server/@csGUID',
			type			tinyint			'server/@type',
			net_hostname	nvarchar(250)	'client/clientEntity/@hostName'
			) as tXml
	WHERE
		tXml.aliasName is not null
	--select * from #tempServer
	DECLARE @csHostName nvarchar(250)
	DECLARE @csAliasName nvarchar(250)
	DECLARE @serverType INTEGER
	SELECT
		@csHostName = csHostName,
		@csAliasName = aliasName,
		@serverType = type
	FROM #tempServer
	IF(@csHostName is null or @csAliasName is null or @serverType is null)
	BEGIN
		DECLARE @commcellIdPrev INTEGER
		SELECT TOP 1 @csAliasName = aliasName, @commcellIdPrev = clientId from CommServ_Capture..CCM_APP_CommCell
		SELECT @csHostName = net_hostname from CommServ_Capture..CCM_APP_Client where id = @commcellIdPrev
		IF(@csHostName is null or @csAliasName is null)
		BEGIN
			SET @errorCode = -1
			SET @errorString = 'ERROR: Server information was Not specified or incorrect in the xml file.'
			GOTO NORMAL_EXIT
		END
	END
	SET @message = 'Capture is being done for ' + @csAliasName
	EXEC DBLog_Write 2, 'FDC_Capture_App', @message
	DECLARE @defaultClDescription nvarchar(1024)
	SET @defaultClDescription = 'Client discovered by External Data Connector'
	IF @serverType >= 100
	BEGIN
		SET @serverType = @serverType - 100 + 2  -- 100 -> 2
		DECLARE @productShortName nvarchar(10)
		DECLARE @productName nvarchar(250)
		SELECT
			@productShortName = shortName,
			@productName = longName
		FROM edcServerTypeInfo
		WHERE id = @serverType
		SET @message = 'Product Name is :' + @productName
		EXEC DBLog_Write 2, 'FDC_Capture_App', @message
		if(@productShortName is null or @productShortName = '' or @productName is null or @productName = '')
		BEGIN
			SET @errorCode = -1
			SET @errorString = 'ERROR: Unable to find information in table edcServerTypeInfo for provided server type.'
			GOTO NORMAL_EXIT
		END
		SET @defaultClDescription = @productName + ' (' + @productShortName + ') Client'
	END
	--Customer Calendar Generation. must be for CCM_archGroupCopy:
	DECLARE @defaultCustomerCalendarId INTEGER
	DECLARE @defaultSpName nvarchar(100)
	DECLARE @defaultDataArchGroupId INTEGER
	DECLARE @defaultLogArchGroupId INTEGER
	DECLARE @defaultSnapCopyId INTEGER
	DECLARE @defaultArchGroupCopyId INTEGER
	DECLARE @calendarIdCount INTEGER
	SELECT @calendarIdCount = COUNT(id) FROM CommServ_Capture..CCM_APP_CustomCalendar
	SET @defaultSpName = @csAliasName
	SET @defaultLogArchGroupId = 0
		SET @defaultCustomerCalendarId = 1
		SET @defaultDataArchGroupId = 1
		SET @defaultArchGroupCopyId = 1
	SET @defaultSnapCopyId = 2
	-- CLIENT:
	/**
		The _CSClientId fields contains the map between this particular client entry and
		the corresponding client entry in the CommServe Database
	*/
	SELECT
		clientId				as 'id',
		clientName				as 'name',
		clientName				as 'displayName',
		osId					as 'simOperatingSystemId',
		net_hostname			as 'net_hostname',
		clientPassword			as 'client_password',
		ISNULL(refTime,0)		as 'refTime',
		ISNULL(modified, @curUnixTime) as 'modified',
		ISNULL(offlineEntity, 0) as 'offlineEntity',
		ISNULL(offlineTimeStamp, 0) as 'offlineTimeStamp',
		@csHostName				as 'csHostName',
		ISNULL(clientDescription, @defaultClDescription) as 'clientDescription',
		ISNULL(installDirectory, 'UNKNOWN') as 'jobResultDir',
		ISNULL(clientSkewTime, 0) as 'clientSkewTime',
		ISNULL(cvdPort, 0)		as 'cvdPort',
		ISNULL(evmgrcPort, 0)	as 'evmgrcPort',
		ISNULL(client_Status, 0) as 'status',
		releaseString as 'releaseString',
		0 as 'releaseId',
		ISNULL(spaceCheckFlags, 0) as 'spaceCheckFlags',
		@dummy_ccpId			as 'ccpId',
		@dummy_ccpTime			as 'ccpTime',
		@commcellId			as 'origCCId',
		@dummy_GUID			as 'GUID',
		clientName			as 'newClientName',
		net_hostname			as 'newnet_hostname',
		0				as 'reMergeClient',
		0				as '_CSClientId',
		(CASE WHEN isCommCellPackageAbsent = 1 THEN 11 ELSE 0 END) as 'specialClientFlags'
	INTO #tempClient
	FROM
		OPENXML(@iDoc, 'App_ClientsList/clients', 0)
		WITH
		(
			clientId				int				'client/clientEntity/@clientId',
			clientName				nvarchar(250)	'client/clientEntity/@clientName',
			osId					int				'client/osInfo/@osId',
			net_hostname			nvarchar(250)	'client/clientEntity/@hostName',
			clientPassword			nvarchar(250)	'client/@clientPassword',
			refTime					int				'client/@refTime',
			modified				int				'client/@modified',
			offlineEntity			int				'client/@offlineEntity',
			offlineTimeStamp		int				'client/@offlineTimeStamp',
			clientDescription		nvarchar(2024)	'client/@clientDescription',
			installDirectory		nvarchar(2048)	'client/@installDirectory',
			clientSkewTime			int				'client/@clockSkewInSeconds',
			cvdPort					int				'client/@cvdPort',
			evmgrcPort				int				'client/@evmgrcPort',
			client_Status			int				'client/@status',
			releaseString			nvarchar(250)	'client/versionInfo/GalaxyRelease/@ReleaseString',
			spaceCheckFlags			int				'client/@spaceCheckFlags',
			isCommCellPackageAbsent BIT 		'clientProps/@isCommCellPackageAbsent'
		)
	SELECT @id_cntr = MAX(id) FROM CommServ_Capture..CCM_APP_Client
	IF @id_cntr IS NULL
		SET @id_cntr = 1
	UPDATE	#tempClient
	SET	@id_cntr = @id_cntr + 1, id	= @id_cntr
	update #tempServer
	set
		clientId = tcl.id
	from 		#tempClient as tcl
	where
		tcl.net_hostname = #tempServer.csHostName
	IF @EDCInstanceType NOT IN (2, 6, 9, 10, 11) -- APP_EDC_NETAPP*
		UPDATE #tempClient SET status = status | 2
	SET @message = 'Number of Clients Captured: ' + CAST( @id_cntr - 1 AS NVARCHAR(MAX) )
	UPDATE #tempClient
	set  newnet_hostname = clMap.gxMachineHostName, newClientName = clMap.gxMachineName, reMergeClient = 1
	FROM #tempClient tCl, edcClientNameMap clMap
	WHERE tCl.name = clMap.exMachineName AND clMap.exServerAliasName = @csAliasName
	EXEC DBLog_Write 1, 'FDC_Capture_App', @message
    -- rename clients with the sames name or net_hostname but belong to different commcells
    DECLARE   @curClientId		INT
    DECLARE   @curClientName		NVARCHAR(510)
    DECLARE   @curClientHostName	NVARCHAR(510)
    DECLARE   @curExistingClientName	NVARCHAR(510)
    DECLARE   @curExistingHostName	NVARCHAR(510)
    DECLARE   rename_cursor CURSOR  FOR SELECT  NC.id, NC.name, NC.net_hostName, EC.name, EC.net_hostname
                                        FROM    APP_Client EC INNER JOIN #tempClient NC ON ((NC.name = EC.name) OR (NC.net_hostname = EC.net_hostname))
					INNER JOIN APP_CommCell  CC ON EC.origCCId = CC.id
					AND CC.aliasName <> @csAliasName
					AND NC.reMergeClient = 0
    OPEN rename_cursor
    FETCH NEXT FROM rename_cursor
    INTO @curClientId, @curClientName, @curClientHostName, @curExistingClientName, @curExistingHostName
    DECLARE @clNameCounter		INT = 1
    DECLARE @clHostNameCounter	INT = 1
    WHILE @@FETCH_STATUS = 0
    BEGIN
		DECLARE @newName NVARCHAR(510) = @curClientName
		DECLARE @newHostName NVARCHAR(510) = @curClientHostName
		DECLARE @conflictFound INT = 1
		WHILE @conflictFound = 1
		BEGIN
			SET @conflictFound = 0
			IF (EXISTS(SELECT id FROM APP_Client WHERE name = @newName) OR
				EXISTS(SELECT id FROM #tempClient WHERE newClientName = @newName AND id <> @curClientId))
			BEGIN
				SET @clNameCounter += 1
				SET @newName = @curClientName + '_' + CAST(@clNameCounter AS NVARCHAR(32))
				SET @conflictFound = 1
				UPDATE #tempClient SET newClientName = @newName, displayName = @newName WHERE id = @curClientId
			END
			IF (EXISTS(SELECT id FROM APP_Client WHERE net_hostname = @newHostName) OR
				EXISTS(SELECT id FROM #tempClient WHERE newnet_hostname = @newHostName AND id <> @curClientId))
			BEGIN
				SET @clHostNameCounter += 1
				SET @newHostName = @curClientHostName + '_' + CAST(@clHostNameCounter AS NVARCHAR(32))
				SET @conflictFound = 1
				UPDATE #tempClient SET newClientName = @newName, displayName = @newName WHERE id = @curClientId
			END
		END
		SET @message = 'In order to avoid collision with existing client [' + @curClientName + '] on [' + @curExistingHostName + '] '
        SET @message = @message + 'discovered client renamed to [' + @newName + '] on [' + @newHostName + ']'
		EXEC DBLog_Write 1, 'FDC_Capture_App', @message
        FETCH NEXT FROM rename_cursor
        INTO @curClientId, @curClientName, @curClientHostName, @curExistingClientName, @curExistingHostName
    END
    CLOSE rename_cursor
    DEALLOCATE rename_cursor
	DECLARE   rename_cursor CURSOR  FOR SELECT  NC.id, NC.name, NC.net_hostName, NC.name, NC.net_hostName
                                    FROM    #tempClient NC WHERE NC.reMergeClient = 0 AND
									EXISTS (SELECT * FROM #tempClient ITC WHERE ITC.remergeClient = 0 AND ITC.id <> NC.id AND (NC.name = ITC.newClientName OR NC.net_hostname = ITC.newnet_hostname))
    OPEN rename_cursor
    FETCH NEXT FROM rename_cursor
    INTO @curClientId, @curClientName, @curClientHostName, @curExistingClientName, @curExistingHostName
    SET @clNameCounter		= 1
    SET @clHostNameCounter	= 1
    WHILE @@FETCH_STATUS = 0
    BEGIN
		SET @newName = @curClientName
		SET @newHostName = @curClientHostName
		SET @conflictFound = 1
		WHILE @conflictFound = 1
		BEGIN
			SET @conflictFound = 0
			IF (EXISTS(SELECT id FROM APP_Client WHERE name = @newName) OR
				EXISTS(SELECT id FROM #tempClient WHERE newClientName = @newName AND id <> @curClientId))
			BEGIN
				SET @clNameCounter += 1
				SET @newName = @curClientName + '_' + CAST(@clNameCounter AS NVARCHAR(32))
				SET @conflictFound = 1
				UPDATE #tempClient SET newClientName = @newName, displayName = @newName WHERE id = @curClientId
			END
			IF (EXISTS(SELECT id FROM APP_Client WHERE net_hostname = @newHostName) OR
				EXISTS(SELECT id FROM #tempClient WHERE newnet_hostname = @newHostName AND id <> @curClientId))
			BEGIN
				SET @clHostNameCounter += 1
				SET @newHostName = @curClientHostName + '_' + CAST(@clHostNameCounter AS NVARCHAR(32))
				SET @conflictFound = 1
				UPDATE #tempClient SET newnet_hostname = @newHostName, displayName = @newName WHERE id = @curClientId
			END
		END
		SET @message = 'In order to avoid collision with existing client [' + @curClientName + '] on [' + @curExistingHostName + '] '
        SET @message = @message + 'discovered client renamed to [' + @newName + '] on [' + @newHostName + ']'
		EXEC DBLog_Write 1, 'FDC_Capture_App', @message
        FETCH NEXT FROM rename_cursor
        INTO @curClientId, @curClientName, @curClientHostName, @curExistingClientName, @curExistingHostName
    END
    CLOSE rename_cursor
    DEALLOCATE rename_cursor
	-- specify server's client ID:
	--select * from #tempServer
	UPDATE CommServ_Capture..CCM_APP_Client SET displayName = name
	--PROCESS Client Names:
	-- 1. add new hostname which are not known (in the target CS):
	INSERT INTO CommServ_Capture..CCM_edcClientNameMap
	( exServerAliasName, exMachineName, exMachineHostName, gxMachineName, gxMachineHostName, creationTime )
	SELECT @csAliasName, I.name, I.net_hostname, I.newClientName, I.newnet_hostname, @curUnixTime
	FROM #tempClient I WHERE I.reMergeClient = 0
	--Copy client id, GUID, and release id from APP_Client table for remerge
	UPDATE  #tempClient
	SET     #tempClient._CSClientId = CL.id, #tempClient.GUID = CL.GUID, #tempClient.releaseId = CL.releaseId
	FROM    #tempClient, APP_Client CL
	WHERE   #tempClient.newClientName = CL.name
	--Insert new GUID, and the release id for new merge
	--If release string is present in XML honor that, else latest release id
	DECLARE @maxReleaseId INT
	SELECT @maxReleaseId = max(id) FROM simAllGalaxyRel
	UPDATE	#tempClient
	SET	#tempClient.GUID = NEWID(), #tempClient.releaseId = (CASE WHEN (#tempClient.releaseString IS NULL) THEN @maxReleaseId ELSE (SELECT top 1(id) FROM simAllGalaxyRel WHERE release = #tempClient.releaseString) END)
	WHERE	#tempClient._CSClientId = 0
    -- 2nd bit should be set for new clients
	UPDATE	#tempClient
	SET		#tempClient.Status = (#tempClient.Status | 2)
	WHERE	#tempClient._CSClientId = 0
	-- in some cases version info from XML data can be different from what we have in APP_Client table.
	-- lets update operating system id for those clients for which we already have information APP_Client table
	-- and which have different os id, but only if those os'es which are belonging to the same os group.
	UPDATE	#tempClient
	SET		simOperatingSystemId = CL.simOperatingSystemId
	FROM	APP_Client CL, simOperatingSystem CLOS, simOperatingSystem TCOS
	WHERE		CL.id = #tempClient._CSClientId
			AND #tempClient.simOperatingSystemId <> CL.simOperatingSystemId
			AND CLOS.id      = CL.simOperatingSystemId
			AND TCOS.id     = #tempClient.simOperatingSystemId
			AND CLOS.Type    = TCOS.Type
			AND CLOS.SubType = TCOS.SubType
	INSERT INTO CommServ_Capture..CCM_APP_Client
	(
		id, name, simOperatingSystemId, net_hostname, client_password, refTime, modified, offlineEntity,
		offlineTimeStamp, csHostName, clientDescription, jobResultDir, clientSkewTime, cvdPort, evmgrcPort,
		status, releaseId, spaceCheckFlags, ccpId, ccpTime, origCCId, GUID, specialClientFlags, displayName
	)
	SELECT
		id, /*name*/ newClientName, simOperatingSystemId, newnet_hostname, client_password, refTime, modified, offlineEntity,
		offlineTimeStamp, csHostName, clientDescription, jobResultDir, clientSkewTime, cvdPort, evmgrcPort,
		status, releaseId, spaceCheckFlags, ccpId, ccpTime, origCCId, GUID, specialClientFlags, displayName
	FROM #tempClient
	/**
		Insert the client properties such as client encryption, compression etc.,
		into the APP_ClientProp table
	*/
	SELECT  Attributes.list.value('@name', 'varchar(MAX)') as 'attrName',
			Attributes.list.value('@valueType', 'varchar(MAX)') as 'attrType',
			Attributes.list.value('@value', 'varchar(MAX)') as 'attrVal',
			Clients.list.value('@clientName', 'varchar(MAX)') as 'clientName'
	INTO #tempClientPropertyTable
	FROM @input.nodes('App_ClientsList/clients/clientProps/attributes') as Attributes(list)
	cross apply Attributes.list.nodes('../../client/clientEntity') as Clients(list)
	INSERT INTO CommServ_Capture..CCM_APP_ClientProp
	(
		id, componentNameId, attrName, attrType, attrVal, created,
		modified, ccpId
	)
	SELECT
		1, tmpClient.id, tmpClientPropertyTable.attrName,
		tmpClientPropertyTable.attrType,
		tmpClientPropertyTable.attrVal, @curUnixTime, 0, 0
	FROM #tempClient as tmpClient, #tempClientPropertyTable as tmpClientPropertyTable
	WHERE
		tmpClient.name = tmpClientPropertyTable.clientName
	-- for those client which are not already in database we have to provide
	-- property that will bring this client as deconfigured
	INSERT INTO CommServ_Capture..CCM_APP_ClientProp
	(
		id, componentNameId, attrName, attrType, attrVal, created,
		modified, ccpId
	)
	SELECT	1, #tempClient.id, 'PlatformDeleted 4', 2, 1, @curUnixTime, 0, 0
	FROM	#tempClient
	WHERE	#tempClient._CSClientId = 0
	IF EXISTS (SELECT * FROM APP_CommCell WHERE aliasName = @csAliasName)
	BEGIN
		UPDATE #tempServer
		SET csGUID = CC.csGUID
		FROM #tempServer TS, APP_CommCell CC
		WHERE TS.aliasName = CC.aliasName
	END
	ELSE
	BEGIN
		UPDATE #tempServer
		SET csGUID = TC.GUID
		FROM #tempServer TS, #tempClient TC
		WHERE TS.clientId = TC.id
	END
	INSERT INTO CommServ_Capture..CCM_APP_CommCell
	(
		id, number, clientId, parentId, aliasName, flags, refTime, userName, userPassword, smtpServer,
		timeZone, ipAddress, modified, ccOpMode, drIpAddress, encNumber, csGUID, type
	)
	SELECT
		id, number, clientId, parentId, aliasName, flags, refTime, userName, userPassword, smtpServer,
		timeZone, ipAddress, modified, ccOpMode, drIpAddress, encNumber, csGUID, type
	FROM #tempServer
	DECLARE @CSId INT
	SELECT @CSId = APP_CommCell.id FROM CommServ_Capture..CCM_APP_CommCell CommCell, APP_CommCell
	WHERE CommCell.aliasName = APP_CommCell.aliasName
	-- Platform Table
	--	Entity				entityType	PlatformType
	--	COMMCELL_ENTITY		1			1
	--	MEDIAAGENT_ENTITY	11			2
	--	CLIENT_ENTITY		3			4
	SELECT
		tCl.id			as 'clientId',
		case
			when tXml.entityType = 11 then 2	--MediaAgent
			when tXml.entityType = 3  then 4	--CommClient
			else tXml.entityType				--CommServe
		end				as 'platformType',
		installDir		as 'install_dir',
		@curUnixTime	as 'refTime'
	INTO #tempPlatform
	FROM 		#tempClient as tCl,
		OPENXML(@iDoc, 'App_ClientsList/clients/client/components', 0)
		WITH
		(
			entityType		integer		'entityType/@_type_',
			installDir	nvarchar(2048)	'@installDir',
			_clientName	nvarchar(250)	'../clientEntity/@clientName'
		) as tXml
	WHERE
		_clientName = tCl.name and
		tXml.entityType in (1, 3, 11)
	--select * from #tempPlatform --order by clientId, platformType
	INSERT INTO CommServ_Capture..CCM_APP_Platform
	(
		clientId, platformType, install_dir, refTime
	)
	SELECT
		clientId, platformType, install_dir, refTime
	FROM #tempPlatform
	INSERT INTO CommServ_Capture..CCM_MMHost
	(
		ClientId,MmHostType,MmHostSoftState,MmHostEnabled,OfflineReason,OfflineTimeStamp,
		PatchLevel, IndexCacheUser,IndexCachePassword,IndexCachePathName, IsIndexShared,Attribute,
		ScanIntervalInSec,/*Descript,*/ MaxReservations,RMStatus,RMStatusUpdateTime, RolesBitMask
	)
	SELECT
		iPl.clientId,0,1,1,0,0,
		0,'N/A','N/A','N/A', 0,37,
		86400, 100,-1,0, 0
	FROM
		CommServ_Capture..CCM_APP_Platform as iPl,
		CommServ_Capture..CCM_APP_Client as exCl
	--	inner join CommServ_Capture..CCM_APP_Client as exCl on iPl.clientId = exCl.id
	WHERE
		iPl.clientId = exCl.id and
		iPl.platformType = 2 --and	--MA PlatformType only
		and NOT EXISTS(SELECT * FROM CommServ_Capture..CCM_MMHost WHERE clientId = iPl.clientId)
	--	exCl.net_hostname not in (select gxCl.net_hostname from CommServ..APP_Client as gxCl, CommServ..MMHost as gxMmh where gxCl.id = gxMmh.ClientId)
	--WARNING: above line is necessary when we merge exMA which goes to active (native) gxMA. Such exMA record should be ignored
	--ida:
	SELECT
		null					as 'id',
		tCl.id					as 'clientId',
		tXml.appTypeId			as 'appTypeId',
		ISNULL(tXml.status, 0)	as 'status',
		ISNULL(tXml.refTime, 0) as 'refTime',
		ISNULL(tXml.modified, @curUnixTime) as 'modified',
		dbo.IsAppTypeInstalled( @csAliasName, tXml._clientName, tXml._clientHost, appTypeId ) as 'ignoreiDA',
		tXml._clientName,
		tXml._idaName,
		null					as 'idaId'
	INTO #tempIda
	FROM 		#tempClient as tCl,
		OPENXML(@iDoc, 'App_ClientsList/clients/client/idaList', 0)
		WITH
		(
			id			integer			'@appId',
			appTypeId	integer			'idaEntity/@applicationId',
			status		integer			'@status',
			refTime		integer			'@lastReferenceTime',
			modified	integer			'@modifiedTime',
			_clientName nvarchar(250)	'../clientEntity/@clientName',
			_clientHost nvarchar(250)   '../clientEntity/@hostName',
			_idaName	nvarchar(250)	'idaEntity/@appName'
		) as tXml
	WHERE
		_clientName = tCl.name
	-- ignore ida which has different operating system than CS DB, corner case.
	UPDATE  #tempIda SET ignoreiDA = 1
	FROM    APP_Client cl, #tempClient tcl
	WHERE       cl.name = tcl.newClientName     -- We should use the tempClient  newName to match with App_Client entries
	        AND tcl.name = #tempIda._ClientName
	        AND cl.simOperatingSystemId <> tcl.simOperatingSystemId
	        AND cl.simOperatingSystemId <> 0
	IF @isForceMergeEnabled = 0
	BEGIN
		DECLARE @tempIgnoredIDA TABLE ( clientName NVARCHAR(MAX), appName NVARCHAR(100),rownum INT IDENTITY (1, 1) PRIMARY KEY NOT null )
		INSERT INTO @tempIgnoredIDA
		SELECT _clientName, _iDAName FROM #tempIda WHERE ignoreiDA = 1
		DELETE FROM #tempIda WHERE ignoreiDA = 1
		DECLARE @maxRows INT
		DECLARE @RC INT = 1
		SELECT @maxRows = COUNT(*) FROM @tempIgnoredIDA
		WHILE @RC <= @maxRows
		BEGIN
			  SELECT @message = clientName + ':' + appName + ' has been ignored' FROM
								@tempIgnoredIDA WHERE rownum = @RC
			  SET @RC = @RC + 1
			  EXEC DBLog_Write 1, 'FDC_Capture_App', @message
		END
	END
	SET @id_cntr = 0
	UPDATE	#tempIda SET	@id_cntr = @id_cntr + 1, idaId = @id_cntr, id = @id_cntr
	IF @EDCInstanceType NOT IN (2, 6, 9, 10, 11) -- APP_EDC_NETAPP*
		UPDATE #tempIDA SET status = status | 2 -- Very important: Status field should be OR(ed) with 2
	--select * from #tempIda
	INSERT INTO CommServ_Capture..CCM_APP_IDAName
	(
		id, clientId, appTypeId, status, refTime, modified
	)
	SELECT
		id, clientId, appTypeId, status, refTime, modified
	FROM #tempIda
	--INSTANCE:
	SELECT
		null					as 'id',
		tXml._instanceName		as 'name',
		ISNULL(tXml.refTime, 0) as 'refTime',
		ISNULL(tXml.modified, @curUnixTime) as 'modified',
		ISNULL(tXml.status, 0)	as 'status',
		@dummy_ccpId			as 'ccpId',
		@dummy_ccpTime			as 'ccpTime',
		tXml._clientName,
		tXml._idaName,
		tXml._instanceName,
		tIda.clientId,
		tIda.idaId,
		tIda.appTypeId,
		NULL					as 'instanceId',
		tXml._clientName		as 'newClientName'
	INTO #tempInst
	FROM 		#tempIda as tIda,
		OPENXML(@iDoc, 'App_ClientsList/clients/client/idaList/instanceList', 0)
		WITH
		(
			refTime			integer			'@lastReferenceTime',
			modified		integer			'@modifiedTime',
			status			integer			'@status',
			_clientName		nvarchar(250)	'../../clientEntity/@clientName',
			_idaName		nvarchar(250)	'../idaEntity/@appName',
			_instanceName	nvarchar(250)	'instEntity/@instanceName'
		) as tXml
	WHERE
		tXml._clientName = tIda._clientName and
		tXml._idaName = tIda._idaName
--select '1', * from #tempInst
	SET @id_cntr = 1
	UPDATE	#tempInst
	SET
		instanceId = 1,
		id = 1
	WHERE
		_instanceName is null or
		_instanceName = 'DefaultInstanceName'
--select '2', * from #tempInst
	UPDATE	#tempInst
	SET
		@id_cntr = @id_cntr + 1,
		instanceId = @id_cntr,
		id = @id_cntr
	WHERE
		_instanceName is not null and
		_instanceName <> 'DefaultInstanceName'
    -- update client name for instance
    -- 1. from previously registered clients
	UPDATE  #tempInst
	SET     #tempInst.newClientName = edcClientNameMap.gxMachineName
	FROM    #tempInst, edcClientNameMap
	WHERE   #tempInst._clientName = edcClientNameMap.exMachineName
    -- 2. from clients which are about to be registered
	UPDATE  #tempInst
	SET     #tempInst.newClientName = CNM.gxMachineName
	FROM    #tempInst, CommServ_Capture..CCM_edcClientNameMap CNM
	WHERE   #tempInst._clientName = CNM.exMachineName
	IF @EDCInstanceType NOT IN (2, 6, 9, 10, 11) -- APP_EDC_NETAPP*
		UPDATE #tempInst set status = status | 2 -- Very important: Status has to be OR(ed) with 2
	SELECT
		DISTINCT (id)		as  _CaptureInstanceId,
		0		as  _CSInstanceId,
		1		as  _FromEDC,
		@dummy_GUID as _CSGUID
	INTO
		FDC_MAP_Instance
	FROM	#tempInst
	/**
		The FDC_MAP_Instance table holds the mapping between the Capture DB instance id and the
		CommServe DB instance id
	*/
	UPDATE FDC_MAP_Instance
	SET
		_CSInstanceId = instance.id, _CSGUID = instance.GUID
	FROM 	#tempInst tempInst,
			APP_InstanceName instance, APP_Client client, APP_Application application,
			FDC_MAP_Instance
	WHERE
		instance.name = tempInst.name and
		application.clientId = client.id and
		application.instance = instance.id and
		client.name = tempInst.newClientName and
		application.appTypeId = tempInst.appTypeId and
		FDC_MAP_Instance._CaptureInstanceId = tempInst.id
--select '3', * from #tempInst
	INSERT INTO CommServ_Capture..CCM_APP_InstanceName
	(
		id, name, refTime, modified, status, GUID
	)
	SELECT
		distinct id, name, refTime, modified, status, (CASE MAP_INST._CSInstanceId WHEN 0 THEN NEWID() ELSE MAP_INST._CSGUID END)
	FROM #tempInst TI, FDC_MAP_Instance MAP_INST
	WHERE TI.id = MAP_INST._CaptureInstanceId
	--Instance properties:
	SELECT
		null				as 'id',
		tInst.Id			as 'componentNameId',
		tXml.attrName		as 'attrName',
		tXml.attrType		as 'attrType',
		tXml.attrVal		as 'attrVal',
		@curUnixTime		as 'created',
		0					as 'modified',
		@dummy_ccpId		as 'ccpId',
		tInst.clientId, tInst.idaId, tInst.instanceId
	INTO #tempInstProp
	FROM 		#tempInst as tInst,
		OPENXML(@iDoc, 'App_ClientsList/clients/client/idaList/instanceList/propertyList', 0)
		WITH
		(
			attrName		nvarchar(250)	'@name',
			attrType		integer			'@valueType',
			attrVal			nvarchar(MAX)	'@value',
			_clientName		nvarchar(250)	'../../../clientEntity/@clientName',
			_idaName		nvarchar(250)	'../../idaEntity/@appName',
			_instanceName	nvarchar(250)	'../instEntity/@instanceName'
		) as tXml
	WHERE
		tXml._clientName = tInst._clientName and
		tXml._idaName = tInst._idaName and
		tXml._instanceName = tInst._instanceName
	SET @id_cntr = 0
	UPDATE	#tempInstProp
	SET @id_cntr = @id_cntr + 1, id = @id_cntr
--	select * from #tempInstProp
	INSERT INTO CommServ_Capture..CCM_APP_InstanceProp
	(
		id, componentNameId, attrName, attrType, attrVal, created, modified, ccpId
	)
	SELECT
		id, componentNameId, attrName, attrType, attrVal, created, modified, ccpId
	FROM #tempInstProp
	--backupset
	SELECT
		null as 'id',
		tXml._backupsetName		as 'name',
		ISNULL(tXml.refTime, 0)	as 'refTime',
		ISNULL(tXml.modified, @curUnixTime) as 'modified',
		ISNULL(tXml.status, 0)	as 'status',
		@dummy_ccpId			as 'ccpId',
		@dummy_ccpTime			as 'ccpTime',
		@commCellId				as 'origCCId',
		@dummy_GUID				as 'GUID',
		tXml._clientName,
		tXml._idaName,
		tXml._instanceName,
		tXml._backupsetName,
		tInst.clientId,
		tInst.idaId,
		tInst.appTypeId,
		tInst.instanceId,
		NULL					as 'backupsetId',
		tXml._clientName		as 'newclientName'
	INTO #tempBset
	FROM 		#tempInst as tInst,
		OPENXML(@iDoc, 'App_ClientsList/clients/client/idaList/instanceList/backupSetList', 0)
		WITH
		(
			refTime			integer			'@lastReferenceTime',
			modified		integer			'@modifiedTime',
			status			integer			'@status',
			_clientName		nvarchar(250)	'../../../clientEntity/@clientName',
			_idaName		nvarchar(250)	'../../idaEntity/@appName',
			_instanceName	nvarchar(250)	'../instEntity/@instanceName',
			_backupsetName	nvarchar(250)	'backupSetEntity/@backupsetName'
		) as tXml
	WHERE
		tXml._clientName = tInst._clientName and
		tXml._idaName = tInst._idaName and
		tXml._instanceName = tInst._instanceName
	SET @id_cntr = 0
	UPDATE	#tempBset
	SET @id_cntr = @id_cntr + 1, backupsetId = @id_cntr, id = @id_cntr
	IF @EDCInstanceType NOT IN (2, 6, 9, 10, 11) -- APP_EDC_NETAPP*
		UPDATE #tempBset SET status = status | 2 -- Very important: Status field has to be OR(ed) with 2
    -- update client name for backupsets
    -- 1. from previously registered clients
	UPDATE  #tempBset
	SET     #tempBset.newclientName = edcClientNameMap.gxMachineName
	FROM    #tempBset, edcClientNameMap
	WHERE   #tempBset._clientName = edcClientNameMap.exMachineName
    -- 2. from clients which are about to be registered
	UPDATE  #tempBset
	SET     #tempBset.newclientName = SNM.gxMachineName
	FROM    #tempBset, CommServ_Capture..CCM_edcClientNameMap SNM
	WHERE   #tempBset._clientName = SNM.exMachineName
	/**
		The FDC_MAP_BackupSet table contains map between the Capture DB backupset entries and Client DB backupset
		entries
	*/
	SELECT
		id		as  _CaptureBackupSetId,
		0		as  _CSBackupSetId,
		1		as  _FromEDC,
		@dummy_GUID as _CSGUID
	INTO
		FDC_MAP_BackupSet
	FROM	#tempBSet
	UPDATE FDC_MAP_BackupSet
	SET
		_CSBackupSetId = backupset.id, _CSGUID = backupset.GUID
	FROM	#tempBSet tempBSet, APP_BackupSetName backupset,
			APP_Client client, APP_Application application,
			FDC_MAP_BackupSet, FDC_MAP_Instance
	WHERE
		backupset.name			= tempBSet.name			 AND
		application.clientId	= client.id				 AND
		application.backupSet	= backupset.id			 AND
		application.appTypeId	= tempBSet.appTypeId	 AND
		client.name				= tempBSet.newclientName AND
		FDC_MAP_BackupSet._CaptureBackupSetId = tempBSet.id AND
		application.instance	= FDC_MAP_Instance._CSInstanceId AND
		tempBset.instanceId	= FDC_MAP_Instance._CaptureInstanceId
	INSERT INTO CommServ_Capture..CCM_APP_BackupSetName
	(
		id, name, refTime, modified, status, ccpId, ccpTime, origCCId, GUID
	)
	SELECT
		id, name, refTime, modified, status, ccpId, ccpTime, origCCId, (CASE MAP_BSET._CSBackupSetId WHEN 0 THEN NEWID() ELSE MAP_BSET._CSGUID END)
	FROM #tempBset TBSet, FDC_MAP_BackupSet MAP_BSET
	WHERE TBSet.id = MAP_BSET._CaptureBackupSetId
	--subclients:
	SELECT
		null						as 'id',
		tBset.clientId				as 'clientId',
		tBset.appTypeId				as 'appTypeId',
		tBset.instanceId			as 'instance',
		tBset.backupsetId			as 'backupSet',
		0							as 'appNumber',
		@defaultDataArchGroupId		as 'dataArchGrpID',
		@defaultLogArchGroupId		as 'logArchGrpID',
		ISNULL(tXml.refTime, @curUnixTime)	as 'refTime',
		ISNULL(tXml.modified, @curUnixTime) as 'modified',
		tXml._subclientName			as subclientName,
		ISNULL(tXml.status, 0)		as 'subclientStatus',
		@dummy_ccpId				as 'ccpId',
		@dummy_ccpTime				as 'ccpTime',
		tXml._clientName,
		tXml._idaName,
		tXml._instanceName,
		tXml._backupsetName,
		tXml._subclientName,
		--tBset.clientId,
		tBset.idaId,
		tBset.instanceId,
		tBset.backupsetId,
		NULL						as 'subclientId',
		@dummy_GUID					as 'GUID'
	INTO #tempSubcl
	FROM 		#tempBset as tBset,
		OPENXML(@iDoc, 'App_ClientsList/clients/client/idaList/instanceList/backupSetList/subClientList', 0)
		WITH
		(
			refTime			integer			'@lastReferenceTime',
			modified		integer			'@modifiedTime',
			status			integer			'@status',
			_clientName		nvarchar(250)	'../../../../clientEntity/@clientName',
			_idaName		nvarchar(250)	'../../../idaEntity/@appName',
			_instanceName	nvarchar(250)	'../../instEntity/@instanceName',
			_backupsetName	nvarchar(250)	'../backupSetEntity/@backupsetName',
			_subclientName	nvarchar(250)	'subClientEntity/@subclientName'
		) as tXml
	WHERE
		tXml._clientName	= tBset._clientName and
		tXml._idaName		= tBset._idaName and
		tXml._instanceName	= tBset._instanceName and
		tXml._backupsetName	= tBset._backupsetName
	SET @id_cntr = 0
	UPDATE	#tempSubcl
	SET @id_cntr = @id_cntr + 1, subclientId = @id_cntr, id = @id_cntr
	--select * from #tempSubcl
	IF @EDCInstanceType NOT IN (2, 6, 9, 10, 11) -- APP_EDC_NETAPP*
		update #tempSubcl SET subClientStatus = subClientStatus | 2 -- Very important : Status has to be OR(ed) with 2
	SELECT
		id				'_CaptureAppId',
		0				'_CSAppId',
		1				'_FromEDC',
		@dummy_GUID		'_CSGUID'
	INTO FDC_MAP_SubClient
	FROM #tempSubCl
	UPDATE FDC_MAP_SubClient
	SET _CSAppId = application.id, _CSGUID = application.GUID
	FROM
		APP_Application application , FDC_MAP_BackupSet map_backupset,
		FDC_MAP_Instance map_instance, FDC_MAP_SubClient map_subclient,	#tempSubCl subcl, #tempClient cl
	WHERE
		application.subclientName	= subcl._subClientName and
		application.clientId        = cl._CSClientId			and
		cl.id						= subcl.clientId	and
		application.instance		= map_instance._CSInstanceId and
		application.backupSet       = map_backupset._CSBackupSetId and
		map_subclient._CaptureAppId = subcl.id and
		application.appTypeId		= subcl.appTypeId and
		map_instance._CaptureInstanceId		= subcl.instance and
		map_backupset._CaptureBackupSetId	= subcl.backupset
	DECLARE @maxAPPID INT
	SELECT @maxAPPID = MAX(id) FROM #tempSubCl
	INSERT INTO FDC_MAP_SubClient
	--(
		--'_CaptureAppId', '_CSAppId', '_FromEDC'
	--)
	SELECT
		0, id, 0, application.GUID
	FROM APP_Application application
	WHERE application.id NOT IN ( SELECT _CSAppId FROM FDC_MAP_SubClient )
	AND application.origCCId = @CSId
	AND application.clientId in ( SELECT _CSClientId from #tempClient )
	--Mark only active subclients as deleted
	AND NOT EXISTS ( SELECT id FROM CommServ..APP_SubClientProp WHERE componentNameId = application.id
				AND attrName = 'User Description' and attrVal like '%Deleted on External Server at%'
				AND modified = 0 )
	INSERT INTO CommServ_Capture..CCM_APP_Application
	(
		id, clientId, appTypeId, instance, backupSet, appNumber, dataArchGrpID, logArchGrpID, refTime,
		modified, subClientName, subClientStatus, GUID
	)
	SELECT
		id, clientId, appTypeId, instance, backupSet, appNumber, dataArchGrpID, logArchGrpID, refTime,
		modified, subClientName, subClientStatus, (CASE map_app._CSAppId WHEN 0 THEN NEWID() ELSE map_app._CSGUID END)
	FROM #tempSubcl tSubCl, FDC_MAP_SubClient map_app
	WHERE tSubCl.id = map_app._CaptureAppId and map_app._FromEDC <> 0
	INSERT INTO CommServ_Capture..CCM_JMJobAction
	SELECT clientId, 0, 0, 4, 1, id, 0, 0, 0, 0,instance, ''
	FROM CommServ_Capture..CCM_APP_Application
	WHERE subClientName = 'default'
	INSERT INTO CommServ_Capture..CCM_APP_Application
	(
		id, clientId, appTypeId, instance, backupSet, appNumber, dataArchGrpID, logArchGrpID, refTime,
		modified, subClientName, subclientStatus, GUID
	)
	SELECT
		0, clientId, appTypeId, instance, backupSet, appNumber, dataArchGrpID, logArchGrpID, refTime,
		modified, subClientName, subClientStatus, GUID
	FROM APP_Application application
	WHERE application.id in ( SELECT _CSAppID from FDC_MAP_SubClient WHERE _FromEDC = 0 )
	INSERT INTO FDC_MAP_Instance
	(
		_CSInstanceId, _CaptureInstanceId, _FromEDC, _CSGUID
	)
	SELECT
		DISTINCT(instance) as _CSInstanceId, 0 as _CaptureInstanceID, 0 as _FromEDC, @dummy_GUID
	FROM CommServ_Capture..CCM_APP_Application
	WHERE instance not in ( SELECT _CSInstanceID from FDC_MAP_Instance ) and id = 0
	INSERT INTO FDC_MAP_BackupSet
	(
		_CSBackupSetId, _CaptureBackupSetId, _FromEDC, _CSGUID
	)
	SELECT
		DISTINCT(backupset) as _CSBackupSetId, 0 as _CaptureBackupSetId, 0 as _FromEDC, @dummy_GUID as _CSGUID
	FROM CommServ_Capture..CCM_APP_Application
	WHERE backupSet not in ( SELECT _CSBackupSetID FROM FDC_MAP_BackupSet ) and id = 0
	DECLARE @maxInstanceId INT
	SELECT @maxInstanceId = COALESCE( MAX(_CaptureInstanceId), 0 ) + 1 from FDC_MAP_Instance
	DECLARE @maxBackupSetId INT
	SELECT @maxBackupSetId = COALESCE( MAX(_CaptureBackupSetId), 0 ) + 1 from FDC_MAP_BackupSet
        UPDATE FDC_MAP_Instance
	SET _CaptureInstanceId = @maxInstanceId , @maxInstanceId = @maxInstanceId + 1
	WHERE _CaptureInstanceId = 0
	UPDATE FDC_MAP_BackupSet
	SET  _CaptureBackupSetId = @maxBackupSetId , @maxBackupSetId = @maxBackupSetId + 1
	WHERE _CaptureBackupSetId = 0
        INSERT INTO CommServ_Capture..CCM_APP_InstanceName
	(
		id, name, reftime, modified, status, origCCId, GUID
	)
	SELECT
		map_instance._CaptureInstanceId, name, reftime, modified, status, origCCId, GUID
	FROM APP_InstanceName, FDC_MAP_Instance map_instance
	WHERE id = map_instance._CSInstanceId
	AND map_instance._FromEDC = 0
        INSERT INTO CommServ_Capture..CCM_APP_BackupSetName
	(
		id,	name, refTime, modified, status,	ccpId,	ccpTime,	GUID
	)
	SELECT
		map_backupset._CaptureBackupSetid, name, refTime, modified, status,	ccpId,	ccpTime, GUID
	FROM App_BackupSetName, FDC_MAP_BackupSet map_backupset
	WHERE id = map_backupset._CSBackupSetId
	AND map_backupset._FromEDC = 0
	UPDATE CommServ_Capture..CCM_APP_Application
	SET instance = map_instance._CaptureInstanceId
	FROM
		CommServ_Capture..CCM_APP_Application capture_application, FDC_MAP_Instance map_instance
	WHERE
		capture_application.instance = map_instance._CSInstanceId AND
		capture_application.id = 0
	UPDATE CommServ_Capture..CCM_APP_Application
	SET backupSet = map_backupset._CaptureBackupSetId
	FROM
		CommServ_Capture..CCM_APP_Application capture_application, FDC_MAP_BackupSet map_backupset
	WHERE
		capture_application.backupSet = map_backupset._CSBackupSetId AND
		capture_application.id = 0
	UPDATE CommServ_Capture..CCM_APP_Application
	SET CommServ_Capture..CCM_APP_Application.clientId = tcl.id
	FROM
		CommServ_Capture..CCM_APP_Application capture_application, #tempClient tcl
	WHERE
		capture_application.clientId = tcl._CSClientId AND
		capture_application.id = 0
	DECLARE @id_cntr2 INTEGER
	SET @id_cntr2 = ( CASE WHEN @maxAPPID IS null THEN 1 ELSE @maxAppId + 1 END )
	SET @id_cntr = @id_cntr2
	UPDATE CommServ_Capture..CCM_APP_Application
	SET CommServ_Capture..CCM_APP_Application.id = @id_cntr, @id_cntr = @id_cntr + 1
	WHERE CommServ_Capture..CCM_APP_Application.id = 0
	UPDATE FDC_MAP_SubClient
	SET _CaptureAppId = @id_cntr2, @id_cntr2 = @id_cntr2 + 1
	WHERE _FromEDC = 0
	-- The compression property of subclients get into the archPipeConfig table
	INSERT INTO CommServ_Capture..CCM_archPipeConfig
	SELECT
		tSubcl.subclientId	as 'appNumber',
		attrVal				as 'compressWhere',
		0					as 'numNWAgents',
		0					as 'NWWriteSpeed'
	FROM #tempSubcl as tSubcl,
		OPENXML(@iDoc, 'App_ClientsList/clients/client/idaList/instanceList/backupSetList/subClientList/propertyList[@name="compression"]', 0)
		WITH
		(
			attrVal			integer			'@value',
			_clientName		nvarchar(250)	'../../../../../clientEntity/@clientName',
			_idaName		nvarchar(250)	'../../../../idaEntity/@appName',
			_instanceName	nvarchar(250)	'../../../instEntity/@instanceName',
			_backupsetName	nvarchar(250)	'../../backupSetEntity/@backupsetName',
			_subclientName	nvarchar(250)	'../subClientEntity/@subclientName'
		) as tXml
	WHERE
		tXml._clientName	= tSubcl._clientName and
		tXml._idaName		= tSubcl._idaName and
		tXml._instanceName	= tSubcl._instanceName and
		tXml._backupsetName	= tSubcl._backupsetName and
		tXml._subclientName = tSubcl._subclientName
	INSERT INTO CommServ_Capture..CCM_JMJobAction
	SELECT
		1					as 'clientId',
		1					as 'mediaAgentId',
		0					as 'appType',
		4					as 'opType',
		1					as 'action',
		tSubcl.subclientId	as 'appId',
		0					as 'clientGroupId',
		0					as 'enableTimeZone',
		0					as 'enableTime',
		0					as 'UNCenableTime',
		tSubcl.instance				as 'instance',
		''					as 'reason'
	FROM #tempSubcl as tSubcl,
		OPENXML(@iDoc, 'App_ClientsList/clients/client/idaList/instanceList/backupSetList/subClientList/propertyList[@name="Enable Backup" and @value="0"]', 0)
		WITH
		(
			_clientName		nvarchar(250)	'../../../../../clientEntity/@clientName',
			_idaName		nvarchar(250)	'../../../../idaEntity/@appName',
			_instanceName	nvarchar(250)	'../../../instEntity/@instanceName',
			_backupsetName	nvarchar(250)	'../../backupSetEntity/@backupsetName',
			_subclientName	nvarchar(250)	'../subClientEntity/@subclientName'
		) as tXml
	WHERE
		tXml._clientName	= tSubcl._clientName and
		tXml._idaName		= tSubcl._idaName and
		tXml._instanceName	= tSubcl._instanceName and
		tXml._backupsetName	= tSubcl._backupsetName and
		tXml._subclientName = tSubcl._subclientName
	--subclient properties:
	SELECT
		null				as 'id',
		tSubcl.subclientId	as 'componentNameId',
		tXml.attrName		as 'attrName',
		tXml.attrType		as 'attrType',
		tXml.attrVal		as 'attrVal',
		isnull(tXml._createTime, CASE WHEN isnull(tXml._modifyTime, 0) = 0 THEN @curUnixTime ELSE 0 END) as 'created',
		isnull(tXml._modifyTime, 0) as 'modified',
		@dummy_ccpId		as 'ccpId',
		tSubcl.clientId, tSubcl.idaId, tSubcl.instanceId, tSubcl.backupsetId, tSubcl.subclientId, tSubcl._subclientName
	INTO #tempProp
	FROM 		#tempSubcl as tSubcl,
		OPENXML(@iDoc, 'App_ClientsList/clients/client/idaList/instanceList/backupSetList/subClientList/propertyList', 0)
		WITH
		(
			attrName		nvarchar(250)	'@name',
			attrType		integer			'@valueType',
			attrVal			nvarchar(MAX)	'@value',
			_clientName		nvarchar(250)	'../../../../../clientEntity/@clientName',
			_idaName		nvarchar(250)	'../../../../idaEntity/@appName',
			_instanceName	nvarchar(250)	'../../../instEntity/@instanceName',
			_backupsetName	nvarchar(250)	'../../backupSetEntity/@backupsetName',
			_subclientName	nvarchar(250)	'../subClientEntity/@subclientName',
			_createTime		int				'@createTime',
			_modifyTime		int				'@modifyTime'
		) as tXml
	WHERE
		tXml._clientName	= tSubcl._clientName and
		tXml._idaName		= tSubcl._idaName and
		tXml._instanceName	= tSubcl._instanceName and
		tXml._backupsetName	= tSubcl._backupsetName and
		tXml._subclientName = tSubcl._subclientName
	SET @id_cntr = 0
	UPDATE	#tempProp
	SET @id_cntr = @id_cntr + 1, id = @id_cntr
	--select * from #tempProp
	INSERT INTO CommServ_Capture..CCM_APP_SubClientProp
	(
		id,	componentNameId, attrName, attrType, attrVal, created, modified, ccpId
	)
	SELECT
		id,	componentNameId, attrName, attrType, attrVal, created, modified, ccpId
	FROM #tempProp
	--Unchanged properties should hold the same created time so that the merge will update the same row instead of
	--creating a new one
	UPDATE CommServ_Capture..CCM_APP_SubClientProp
	SET
		created = subclientprop.created
	FROM
		CommServ_Capture..CCM_APP_SubClientProp capture_prop, FDC_MAP_SubClient map_subclient, APP_SubClientProp subclientprop
	WHERE
		map_subclient._FromEDC = 1 AND
		capture_prop.componentNameId = map_subclient._CaptureAppId AND
		map_subclient._CSAppId = subclientprop.componentNameId AND
		subclientprop.modified = 0 AND
		capture_prop.attrName = subclientprop.attrName AND capture_prop.attrType = subclientprop.attrType
		AND capture_prop.attrVal = subclientprop.attrVal AND
		capture_prop.attrType <> 118
	--Properties that have changed should be updated properly with modified time as current time
	IF @EDCInstanceType NOT IN (2, 6, 9, 10, 11) -- APP_EDC_NETAPP*
	BEGIN
		INSERT INTO CommServ_Capture..CCM_APP_SubClientProp
		(
			id,	componentNameId, attrName, attrType, attrVal, created, modified, ccpId
		)
		SELECT
			0,	map_application._CaptureAppId, subclient_prop.attrName, subclient_prop.attrType, subclient_prop.attrVal,
			subclient_prop.created, @curUnixTime, subclient_prop.ccpId
		FROM
			APP_SubClientProp subclient_prop JOIN FDC_MAP_SubClient map_application
		ON
			map_application._CSAppId	= subclient_prop.componentNameId AND
			subclient_prop.modified		= 0	AND
			map_application._FromEDC	= 1
		LEFT OUTER JOIN	CommServ_Capture..CCM_APP_SubClientProp AS capture_subclprop
		ON
			map_application._CaptureAppId = capture_subclprop.componentNameId AND
			subclient_prop.attrName = capture_subclprop.attrName AND
			subclient_prop.attrVal = capture_subclprop.attrVal AND
			subclient_prop.attrType = capture_subclprop.attrType
		WHERE
			capture_subclprop.attrName  IS NULL
	END
	INSERT INTO CommServ_Capture..CCM_APP_SubClientProp
	(
		id,	componentNameId, attrName, attrType, attrVal, created, modified, ccpId
	)
	SELECT
		0,	capture_application.id, 'User Description', 1, 'Deleted on External Server at ' + @curDateTime,
		@curUnixTime, 0, 0
	FROM CommServ_Capture..CCM_APP_Application capture_application
	WHERE capture_application.id > @maxAPPID
	DECLARE @deletedItems INTEGER
	SELECT @deletedItems = COUNT(*) FROM CommServ_Capture..CCM_APP_Application WHERE id > @maxAPPID
	IF @deletedItems IS null
		SET @deletedItems = 0
	SET @message = 'Number of subclients marked for deletion:' + CAST(@deletedItems as VARCHAR(MAX))
    EXEC DBLog_Write 2, 'FDC_Capture_App', @message
    UPDATE CommServ_Capture..CCM_APP_SubClientProp
	SET CommServ_Capture..CCM_APP_SubClientProp.attrVal = subclient_property.attrVal + '  ' + capture_property.attrVal
	FROM CommServ_Capture..CCM_APP_SubClientProp capture_property, FDC_MAP_SubClient map_subclient,
		 APP_SubClientProp subclient_property
	WHERE
		capture_property.attrName = 'User Description' AND
		capture_property.componentNameId > @maxAPPID AND
		capture_property.modified = 0 AND
		capture_property.componentNameId = map_subclient._CaptureAppId AND
		map_subclient._CSAppId = subclient_property.componentNameId AND
		subclient_property.attrName = 'User Description' AND
		subclient_property.attrVal <> '' AND
		subclient_property.modified = 0
	--Reset description for items that have reappeared
	INSERT INTO CommServ_Capture..CCM_APP_SubClientProp
	(
		id,	componentNameId, attrName, attrType, attrVal, created, modified, ccpId
	)
	SELECT
		0,	capture_application.id, 'User Description', 1,
		--Instead of resetting the value, remove the 'deleted on external server' string
		( SELECT SUBSTRING( attrVal, 1, PATINDEX( '%Deleted on External Server at%', attrVal ) - 1 )
		  FROM APP_SubClientProp
		  WHERE componentNameId = map_subclient._CSAppId
		  AND	attrName = 'User Description' and modified = 0 ),
		@curUnixTime, 0, 0
	FROM CommServ_Capture..CCM_APP_Application capture_application, FDC_MAP_SubClient map_subclient
	WHERE capture_application.id <= @maxAPPID and capture_application.id = map_subclient._CaptureAppId
	and EXISTS ( SELECT id FROM APP_SubClientProp WHERE componentNameId = map_subclient._CSAppId
				 AND attrName = 'User Description' AND attrVal like '%Deleted on External Server at%'
				 AND modified = 0 )
	--subclient srcPaths:
	SELECT
		null				as 'id',
		tSubcl.subclientId	as 'componentNameId',
		tXml.type			as 'type',
		isnull(tXml.attrName, 'not specified')	as 'fileName',
		isnull(tXml._createTime, CASE WHEN isnull(tXml._modifyTime, 0) = 0 THEN @curUnixTime ELSE 0 END) as 'created',
		isnull(tXml._modifyTime, 0) as 'modified',
		@dummy_ccpId		as 'ccpid',
		tSubcl.clientId, tSubcl.idaId, tSubcl.instanceId, tSubcl.backupsetId, tSubcl.subclientId, tSubcl._subclientName
	INTO #tempFlt
	FROM 		#tempSubcl as tSubcl,
		OPENXML(@iDoc, 'App_ClientsList/clients/client/idaList/instanceList/backupSetList/subClientList/filterList', 0)
		WITH
		(
			attrName		nvarchar(2048)	'@value',
			type			int				'@valueType',
			_clientName		nvarchar(250)	'../../../../../clientEntity/@clientName',
			_idaName		nvarchar(250)	'../../../../idaEntity/@appName',
			_instanceName	nvarchar(250)	'../../../instEntity/@instanceName',
			_backupsetName	nvarchar(250)	'../../backupSetEntity/@backupsetName',
			_subclientName	nvarchar(250)	'../subClientEntity/@subclientName',
			_createTime		int				'@createTime',
			_modifyTime		int				'@modifyTime'
		) as tXml
	WHERE
		tXml._clientName	= tSubcl._clientName and
		tXml._idaName		= tSubcl._idaName and
		tXml._instanceName	= tSubcl._instanceName and
		tXml._backupsetName	= tSubcl._backupsetName and
		tXml._subclientName = tSubcl._subclientName
	SET @id_cntr = 0
	UPDATE	#tempFlt
	SET @id_cntr = @id_cntr + 1, id = @id_cntr
	--select * from #tempFlt
	INSERT INTO CommServ_Capture..CCM_APP_ScFilterFile
	(
		id, componentNameId, type, fileName, created, modified, ccpId
	)
	SELECT
		id, componentNameId, type, SUBSTRING(fileName, 1, 1024), created, modified, ccpId
	FROM #tempFlt
	UPDATE CommServ_Capture..CCM_APP_ScFilterFile SET created = filter.created
	FROM
		FDC_MAP_SubClient map_application, CommServ_Capture..CCM_APP_ScFilterFile capture_filter, APP_ScFilterFile filter
	WHERE
		capture_filter.componentNameId	= map_application._CaptureAppId AND
		map_application._CSAppId		= filter.componentNameId AND
		capture_filter.fileName			= filter.fileName AND
		filter.modified					= 0 --Consider the active contents alone
	IF @EDCInstanceType NOT IN (2, 6, 9, 10, 11) -- APP_EDC_NETAPP*
	BEGIN
		INSERT INTO CommServ_Capture..CCM_APP_ScFilterFile
		(
			id, componentNameId, type, fileName, created, modified, ccpId
		)
		SELECT
			0, map_application._CaptureAppId, filter.type, filter.fileName, filter.created, @curUnixTime, filter.ccpId
		FROM
			APP_ScFilterFile filter JOIN FDC_MAP_SubClient map_application
		ON
			map_application._CSAppId	= filter.componentNameId AND
			filter.modified				= 0	AND
			map_application._FromEDC	= 1
		LEFT OUTER JOIN	CommServ_Capture..CCM_APP_ScFilterFile AS capture_filter
		ON
			map_application._CaptureAppId = capture_filter.componentNameId AND
			filter.fileName				  = capture_filter.fileName
		WHERE
			capture_filter.fileName  IS NULL
		SET @id_cntr = (select MAX(id) from CommServ_Capture..CCM_APP_ScFilterFile )
		UPDATE	CommServ_Capture..CCM_APP_ScFilterFile
		SET @id_cntr = @id_cntr + 1, id = @id_cntr
		where id = 0
	END
	--Populate the oracleTableSpaces table first
	SELECT DISTINCT
		NULL					as id,
		tempXML.name			as 'tablespaceName',
		inst._instanceName		as 'instanceName',
		inst.id			as	'instanceId',	tempXml.idaName as 'idaName',
		inst._clientName as 'clientName',  '0'				as 'bkpNode',
		0				as	'status',	    tempXml.created	as 'created',
		(CASE WHEN tempXml.deleted > 0 THEN 1 ELSE 0 END)	as 'deleteFlag',    tempXml.deleted	as 'deleted',
		@curUnixTime	as 'modified',      0				as 'opType',
		0				as 'backupsetId',  -1				as 'tablespaceId',
		0				as 'maxDBdataSize',
		0				as 'freeDBDataSize'
	INTO	#temporacleTableSpaces
	FROM	#tempInst as inst,
		OPENXML(@iDoc, 'App_ClientsList/clients/client/idaList/instanceList/oracleInstanceInfo/oracleTableSpaceInfo', 0)
		WITH
		(
			name			nvarchar(MAX)	'@name',
			created			INTEGER			'@createdTime',
			deleted			INTEGER			'@deletedTime',
			clientName		nvarchar(MAX)	'../../../../clientEntity/@clientName',
			idaName			nvarchar(MAX)	'../../../idaEntity/@appName',
			instanceName	nvarchar(MAX)	'../../instEntity/@instanceName'
		) as tempXml
	WHERE
		tempXml.clientName		= inst._clientName and
		tempXml.idaName			= inst._idaName and
		tempXml.instanceName	= inst._instanceName
	SET	@id_cntr = 0
	UPDATE #tempOracleTableSpaces
	SET	@id_cntr = @id_cntr + 1,
		id = @id_cntr
	DECLARE @TYPE integer
	SET @TYPE = 1
	IF @input.exist('App_ClientsList/clients/client/idaList/instanceList/backupSetList/subClientList/oracleSubClientContentInfo') = 1
	BEGIN
		SET @TYPE = 0
	END
	/**
		TYPE = 1 means a full subclient.
		TYPE = 0 means a partial subclient.
		For a full subclient, deleted entries have to be handled.
		For partial, only insertion/updation is taken care of.
		Create FDC_MAP_OracleTableSpaces that contains the mapping between the Capture DB tablespace id
		and the CommServ DB tablespace id
	*/
		SELECT
			tempOracleTableSpaces.id	as _CaptureTableSpaceId,
			0							as _CSTableSpaceId
		INTO
				FDC_MAP_OracleTableSpaces
		FROM	#tempOracleTableSpaces tempOracleTableSpaces
		UPDATE FDC_Map_OracleTableSpaces
		SET
			FDC_Map_OracleTableSpaces._CSTableSpaceId = oracleTableSpaces.id
		FROM #tempOracleTableSpaces tempOracleTableSpaces,
			 FDC_Map_Instance,
			CommServ..oracleTableSpaces,
			FDC_Map_OracleTableSpaces
		--GROUP BY tempOracleTableSpaces.name, tempOracleTableSpaces.instanceId
		--HAVING
		WHERE
			tempOracleTableSpaces.tablespaceName = oracleTableSpaces.name and
			tempOracleTableSpaces.instanceId = FDC_Map_Instance._CaptureInstanceId and
			tempOracleTableSpaces.id = FDC_Map_OracleTableSpaces._CaptureTableSpaceId and
			oracleTableSpaces.instId = FDC_Map_Instance._CSInstanceId and
			oracleTableSpaces.deleteFlag = 0
			-- Map the already existing active entry to the entry with the least created time
			-- If we don't then we will be breaking the link
			and tempOracleTableSpaces.created = (
				SELECT MIN(created) from #tempOracleTableSpaces tempOracleTableSpacesInner
				WHERE tempOracleTableSpacesInner.tablespaceName = tempOracleTableSpaces.tablespaceName
				and tempOracleTableSpacesInner.instanceId = tempOracleTableSpaces.instanceId
			)
		/**
			Make use of the active entry's created time (in CommServ DB). Only then
			the existing entry will be updated. Else, a new entry will be created which
			we done need
		*/
		UPDATE #tempOracleTableSpaces
		SET #tempOracleTableSpaces.created = oracleTableSpaces.created
		FROM
			FDC_Map_OracleTableSpaces, #tempOracleTableSpaces, CommServ..oracleTableSpaces
		WHERE
			FDC_Map_OracleTableSpaces._CaptureTableSpaceId = #tempOracleTableSpaces.id and
			oracleTableSpaces.id = FDC_Map_OracleTableSpaces._CSTableSpaceId and
			FDC_Map_OracleTableSpaces._CSTableSpaceId <> 0
	--Populate the oracleDataFiles table
	SELECT DISTINCT
		NULL						as id,
		tempXML.name				as 'datafileName',
		tempTblspace.instanceId		as 'instanceId',
		tempTblspace.tablespaceName as 'tablespaceName',
		tempTblspace.id				as 'tblId',
		'0'							as 'bkpNode',
		tempTblspace.created        as 'tablespaceCreated',
		0					as 'status',	   tempXml.created	as 'created',
		(CASE WHEN tempXml.deleted > 0 THEN 1 ELSE 0 END)	as 'deleteFlag',   tempXml.deleted	as 'deleted',
		0					as 'modified',       0				as 'opType',
		0					as 'backupsetId',   -1				as 'tablespaceId',
		0					as 'maxDBdataSize',
		0					as 'freeDBDataSize', 0				as 'underDBDir',
		0					as 'contType',		 0				as 'totalPages',
		0					as 'isAccessible'
	INTO	#tempOracleDataFiles
	FROM	#tempOracleTableSpaces as tempTblspace,
		OPENXML(@iDoc, 'App_ClientsList/clients/client/idaList/instanceList/oracleInstanceInfo/oracleTableSpaceInfo/oracleDataFile', 0)
		WITH
		(
			name			nvarchar(MAX)	'@path',
			clientName		nvarchar(MAX)	'../../../../../clientEntity/@clientName',
			idaName			nvarchar(MAX)	'../../../../idaEntity/@appName',
			instanceName	nvarchar(MAX)	'../../../instEntity/@instanceName',
			tablespaceName	nvarchar(MAX)	'../@name',
			created			INTEGER			'@createdTime',
			deleted			INTEGER			'@deletedTime',
			tablespaceCreated INTEGER		'../@createdTime'
		) as tempXml
	WHERE
		tempXml.clientName		= tempTblspace.clientName and
		tempXml.idaName			= tempTblspace.idaName and
		tempXml.instanceName	= tempTblspace.instanceName and
		tempXml.tablespaceName	= tempTblspace.tablespaceName and
		tempXml.tablespaceCreated = tempTblspace.created
	SET	@id_cntr = 0
	UPDATE #tempOracleDataFiles
	SET	@id_cntr = @id_cntr + 1,
		id = @id_cntr
	/**
		Map tables are created for OracleDataFiles the same way they are created for
		OracleTableSpaces
	*/
		SELECT
			tblId		as tablespaceId,
			id			as _CaptureDataFileId,
			0			as _CSDataFileId
		INTO FDC_MAP_OracleDataFiles
		FROM #tempOracleDataFiles
		UPDATE FDC_MAP_OracleDataFiles
		SET
			_CSDataFileId = oracleDataFiles.id
		FROM
			FDC_Map_OracleTableSpaces, oracleDataFiles, #tempOracleDataFiles, FDC_Map_OracleDataFiles
		WHERE
			FDC_Map_OracleDataFiles.tablespaceId = FDC_Map_OracleTableSpaces._CaptureTableSpaceId
			and FDC_Map_OracleTableSpaces._CSTableSpaceId = oracleDataFiles.tblId
			and #tempOracleDataFiles.created = oracleDataFiles.created
			and oracleDataFiles.deleteFlag = 0
			--If this line is not there, then during merge, DB will be left in an inconsistent state
			and #tempOracleDataFiles.created = (
				SELECT MIN(created) from #tempOracleDataFiles tempOracleDataFilesInner
				WHERE tempOracleDataFilesInner.datafileName = #tempOracleDataFiles.datafileName
				and tempOracleDataFilesInner.tblId = FDC_Map_OracleTableSpaces._CaptureTableSpaceId
			)
		UPDATE #tempOracleDataFiles
		SET #tempOracleDataFiles.created = oracleDataFiles.created
		FROM
			FDC_Map_OracleDataFiles, #tempOracleDataFiles, CommServ..oracleDataFiles
		WHERE
			FDC_Map_OracleDataFiles._CaptureDataFileId = #tempOracleDataFiles.id and
			oracleDataFiles.id = FDC_Map_OracleDataFiles._CSDataFileId and
			FDC_Map_OracleDataFiles._CSDataFileId <> 0
	SELECT DISTINCT
		NULL								as id,
		tmpSubClient.id						as 'subClientId',
		0									as 'taskId',
		tempTblspace.instanceId				as 'instId',
		1									as 'type',
		tempTblspace.id						as 'parentId',
		tempOracleDataFiles.id				as 'objId',
		2					as 'setType',
		0					as 'actionType',	 ''			as 'name',
		0					as 'underDBDir',     0			as 'contType',
		0					as 'totalPages',     0			as 'isAccessible'
	INTO	#temporacleObjects
	FROM	#tempOracleTableSpaces as tempTblspace, #tempOracleDataFiles as tempOracleDataFiles, #tempClient as tmpClient, #tempSubCl as tmpSubClient,
		OPENXML(@iDoc, 'App_ClientsList/clients/client/idaList/instanceList/backupSetList/subClientList/oracleSubClientContentInfo/oracleTableSpaceInfo/oracleDataFile', 0)
		WITH
		(
			datafileName	nvarchar(MAX)	'@path',
			tablespaceName	nvarchar(MAX)	'../@name',
			type			int				'../@type',
			subClientName	nvarchar(MAX)	'../../../subClientEntity/@subclientName',
			instanceName	nvarchar(MAX)	'../../../../../instEntity/@instanceName',
			idaName			nvarchar(MAX)	'../../../../../../idaEntity/@appName',
			clientName		nvarchar(MAX)	'../../../../../../../clientEntity/@clientName'
		) as tempXml
	WHERE
		tempXml.tablespaceName		= tempTblspace.tablespaceName and
		tempXml.datafileName		= tempOracleDataFiles.datafileName and
		tempTblspace.id				= tempOracleDataFiles.tblId and
		tempTblspace.clientName		= tmpClient.name and
		tmpSubClient.clientId		= tmpClient.id and
		tmpSubclient.subclientName	= tempXml.subClientName and
		tmpSubclient.instance		= tempTblspace.instanceId
	INSERT INTO #temporacleObjects
	(
		id,		subClientId,taskId,		instId,	type,		parentId,
		objId,	setType,	actionType,	name,	underDBDir,	contType,
		totalPages,	isAccessible
	)
	SELECT DISTINCT
		NULL,	tmpSubClient.id,	0,		tempTblspace.instanceId,	5,	0,
		tempTblspace.id, 2,	0,'',	0,	0,	0,	0
	FROM	#tempOracleTableSpaces as tempTblspace, #tempOracleDataFiles as tempOracleDataFiles, #tempClient as tmpClient, #tempSubCl as tmpSubClient,
			OPENXML(@iDoc, 'App_ClientsList/clients/client/idaList/instanceList/backupSetList/subClientList/oracleSubClientContentInfo/oracleTableSpaceInfo[not(oracleDataFile)]', 0)
	WITH
		(
			tablespaceName	nvarchar(MAX)	'@name',
			subClientName	nvarchar(MAX)	'../../subClientEntity/@subclientName',
			instanceName	nvarchar(MAX)	'../../../../instEntity/@instanceName',
			idaName			nvarchar(MAX)	'../../../../../idaEntity/@appName',
			clientName		nvarchar(MAX)	'../../../../../../clientEntity/@clientName'
		) as tempXml
	WHERE
		tempXml.tablespaceName		= tempTblspace.tablespaceName and
		tempTblspace.clientName		= tmpClient.name and
		tmpSubClient.clientId		= tmpClient.id and
		tmpSubclient.subclientName	= tempXml.subClientName and
		tmpSubclient.instance		= tempTblspace.instanceId
	SET	@id_cntr = 0
	UPDATE #temporacleObjects
	SET	@id_cntr = @id_cntr + 1,
		id = @id_cntr
	--	We have all the temporary tables for Oracle Subclient Content populated now.
	--	Insert them into the Capture DB
	INSERT INTO CommServ_Capture..CCM_oracleTableSpaces
	(
		id, name, instId, bkpNode, status, created, deleteFlag, deleted,
		modified, opType, backupsetId, tablespaceId, maxDBdataSize, freeDBDataSize
	)
	SELECT
		id,	tablespaceName, instanceId, bkpNode, status, created, deleteFlag, deleted,
		modified, opType, backupsetId, tablespaceId, maxDBdataSize, freeDBDataSize
	FROM	#tempOracleTableSpaces
	/**
		In case of Partial, we need to pull records from the CommServ DB and insert that into
		Capture DB as at any point of time the Merge expects the entire tablespace information
	*/
	IF @TYPE = 1
	BEGIN
		INSERT INTO CommServ_Capture..CCM_oracleTableSpaces
		(
		id, name, instId, bkpNode, status, created, deleteFlag, deleted,
		modified, opType, backupsetId, tablespaceId, maxDBdataSize, freeDBDataSize
		)
		SELECT 0, oracleTblSpaces.name, FDC_Map_Instance._CaptureInstanceId,
			oracleTblSpaces.bkpNode, oracleTblSpaces.status, oracleTblSpaces.created, 1,
			@curUnixTime, @curUnixTime, 0, 0, -1, 0, 0
		FROM CommServ..oracleTableSpaces oracleTblSpaces , FDC_Map_Instance
		WHERE oracleTblSpaces.instId = FDC_Map_Instance._CSInstanceId and
			oracleTblSpaces.deleteFlag = 0 and
			oracleTblSpaces.id not in ( SELECT FDC_Map_OracleTableSpaces._CSTableSpaceId from FDC_Map_OracleTableSpaces)
		--Make sure that the same information is not already in #tempOracleTableSpaces
		--and not exists ( SELECT * FROM #tempOracleTableSpaces, FDC_Map_Instance where oracleTblSpaces.name = #tempOracleTableSpaces.tablespaceName
		--and oracleTblSpaces.instId = FDC_Map_Instance._CSInstanceId and  #tempOracleTableSpaces.instanceId =
		--FDC_Map_Instance._CaptureInstanceId and #tempOracleTableSpaces.created = oracleTblSpaces.created
		--)
		DECLARE @maxTblid int
		SELECT @maxTblid = MAX(id) FROM CommServ_Capture..CCM_oracleTableSpaces
		UPDATE CommServ_Capture..CCM_oracleTableSpaces
		SET @maxTblid = @maxTblid + 1, id = @maxTblid
		WHERE id = 0
		INSERT INTO FDC_Map_OracleTableSpaces
		(
			_CaptureTableSpaceId, _CSTableSpaceId
		)
		SELECT
			id, 0
		FROM CommServ_Capture..CCM_oracleTableSpaces
		WHERE
			CommServ_Capture..CCM_oracleTableSpaces.id not in
			( SELECT _CaptureTableSpaceId from FDC_Map_OracleTableSpaces )
		--Update the Map as the Capture DB has been changed
		UPDATE FDC_Map_OracleTableSpaces
		SET
			FDC_Map_OracleTableSpaces._CSTableSpaceId = oracleTableSpaces.id
		FROM
			CommServ_Capture..CCM_oracleTableSpaces captureTblSpace,
			FDC_Map_Instance, FDC_Map_OracleTableSpaces,
			oracleTableSpaces
		WHERE
			captureTblSpace.id = FDC_Map_OracleTableSpaces._CaptureTableSpaceId
			and captureTblSpace.instId = FDC_Map_Instance._CaptureInstanceId
			and oracleTableSpaces.instId = FDC_Map_Instance._CSInstanceId
			and oracleTableSpaces.name = captureTblSpace.name
			and oracleTableSpaces.created = captureTblSpace.created
	END
	INSERT INTO CommServ_Capture..CCM_oracleDataFiles
	(
		id, name, tblId, instId, bkpNode, status, created, deleteFlag, deleted, modified,
		opType, backupsetId, maxDBdataSize, freeDBDataSize, underDBDir, contType, totalPages,
		isAccessible
	)
	SELECT
		id, datafileName, tblId, instanceId, bkpNode, status, created, deleteFlag, deleted,
		modified, opType, backupsetId, maxDBdataSize, freeDBDataSize, underDBDir, contType,
		totalPages, isAccessible
	FROM	#tempOracleDataFiles
	IF @TYPE = 1
		BEGIN
			INSERT INTO CommServ_Capture..CCM_oracleDataFiles
			(
			id, name, tblId, instId, bkpNode, status, created, deleteFlag, deleted, modified,
			opType, backupsetId, maxDBdataSize, freeDBDataSize, underDBDir, contType, totalPages,
			isAccessible
			)
			SELECT
				0, oraDataFile.name, FDC_Map_OracleTableSpaces._CaptureTableSpaceId,
				FDC_Map_Instance._CaptureInstanceId, oraDataFile.bkpNode, oraDataFile.status, oraDataFile.created, 1,
				( CASE oraDataFile.deleted WHEN 0 THEN @curUnixTime ELSE oraDataFile.deleted END ),
				@curUnixTime, oraDataFile.opType, oraDataFile.backupsetId, oraDataFile.maxDBdataSize,
				oraDataFile.freeDBDataSize, oraDataFile.underDBDir, oraDataFile.contType,
				oraDataFile.totalPages, oraDataFile.isAccessible
			FROM	CommServ..oracleDataFiles oraDataFile, CommServ..oracleTableSpaces,
					FDC_Map_Instance, FDC_Map_OracleTableSpaces
			WHERE
				oracleTableSpaces.id = oraDataFile.tblId and
				FDC_Map_Instance._CSInstanceId = oracleTableSpaces.instId and
				FDC_Map_OracleTableSpaces._CSTableSpaceId = oracleTableSpaces.id and
				oraDataFile.id not in (SELECT _CSDataFileId from FDC_Map_OracleDataFiles)
				--and not exists (
				--	SELECT * FROM #tempOracleDataFiles WHERE oraDataFile.created = #tempOracleDataFiles.created
				--	and FDC_Map_OracleTableSpaces._CaptureTableSpaceId = #tempOracleDataFiles.tblId
				--)
			DECLARE @maxDataFileid int
			SELECT @maxDataFileid = MAX(id) FROM CommServ_Capture..CCM_oracleDataFiles
			UPDATE CommServ_Capture..CCM_oracleDataFiles
			SET @maxDataFileid = @maxDataFileid + 1, id = @maxDataFileid
			WHERE id = 0
		END
	INSERT INTO CommServ_Capture..CCM_oracleObjects
	SELECT * FROM #temporacleObjects
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorString =
		'ERROR: PROC(' + ERROR_PROCEDURE() +
		'), LINE(' + CAST(ERROR_LINE() AS NVARCHAR(10)) +
		'), ERROR(' + CAST(ERROR_NUMBER() AS NVARCHAR(10)) +
		'), INFO: ' + ERROR_MESSAGE() + '.'
	RAISERROR ('%s' , 16, 1, @errorString)
	IF(@errorCode = 0)
		SET @errorCode = -1
--	SELECT @errorCode, @errorString
END CATCH
NORMAL_EXIT:
EXEC sp_xml_removedocument @iDoc
IF OBJECT_ID('tempdb.dbo.#tempClient') is not null DROP TABLE #tempClient
IF OBJECT_ID('tempdb.dbo.#tempServer') is not null DROP TABLE #tempServer
--IF OBJECT_ID('tempdb.dbo.#tempComp') is not null DROP TABLE #tempComp
IF OBJECT_ID('tempdb.dbo.#tempPlatform') is not null DROP TABLE #tempPlatform
IF OBJECT_ID('tempdb.dbo.#tempIda') is not null DROP TABLE #tempIda
IF OBJECT_ID('tempdb.dbo.#tempInst') is not null DROP TABLE #tempInst
IF OBJECT_ID('tempdb.dbo.#tempBset') is not null DROP TABLE #tempBset
IF OBJECT_ID('tempdb.dbo.#tempSubcl') is not null DROP TABLE #tempSubcl
IF OBJECT_ID('tempdb.dbo.#tempProp') is not null DROP TABLE #tempProp
IF OBJECT_ID('tempdb.dbo.#tempFlt') is not null DROP TABLE #tempFlt
IF OBJECT_ID('tempdb.dbo.#tempInstProp') is not null DROP TABLE #tempInstProp
IF OBJECT_ID('tempdb.dbo.#temporacleObjects') is not null DROP TABLE #temporacleObjects
IF OBJECT_ID('tempdb.dbo.#tempOracleDataFiles') is not null DROP TABLE #tempOracleDataFiles
IF OBJECT_ID('tempdb.dbo.#tempOracleTableSpaces') is not null DROP TABLE #tempOracleTableSpaces
IF OBJECT_ID('FDC_MAP_Instance') is not null DROP TABLE FDC_MAP_Instance
IF OBJECT_ID('FDC_MAP_BackupSet') is not null DROP TABLE FDC_MAP_BackupSet
IF OBJECT_ID('FDC_MAP_SubClient') is not null DROP TABLE FDC_MAP_SubClient
IF OBJECT_ID('FDC_MAP_OracleTableSpaces') is not null DROP TABLE FDC_MAP_OracleTableSpaces
IF OBJECT_ID('FDC_MAP_OracleDataFiles') is not null DROP TABLE FDC_MAP_OracleDataFiles
--select 'end time', dbo.GetUnixTime(GETDATE())
RETURN (@errorCode)
GO

IF EXISTS (select * from GxQscripts where name = 'FDC_Capture_App')
	delete from GxQscripts where name = 'FDC_Capture_App'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_Capture_App')
	delete from GXDBVersions where aliasname = 'FDC_Capture_App'
GO

insert into GXDBVersions values(2, 'FDC_Capture_App',  '00010120006000070000', 'FDC_Capture_App', '00010120006000070000')
GO

