

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/FDC_BackupDatabase.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Backup Database
--  +========================================================================+
-- $Id: FDC_BackupDatabase.sp,v 1.4.34.2 2018/03/20 00:31:02 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: FDC_BackupDatabase <<<'

IF EXISTS (select * from sysobjects where name='FDC_BackupDatabase')
	drop procedure FDC_BackupDatabase
IF EXISTS (select * from GxQscripts where name='FDC_BackupDatabase')
	delete from GxQscripts where name = 'FDC_BackupDatabase'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_BackupDatabase')
	delete from GXDBVersions where aliasname = 'FDC_BackupDatabase'
GO
print '... Creating Procedure: FDC_BackupDatabase'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure FDC_BackupDatabase
  @dbName nvarchar(MAX),
  @dstFolder nvarchar(MAX)
AS
  DECLARE @errorCode integer
  DECLARE @errorString nvarchar(MAX)
	SET XACT_ABORT ON
	SET NOCOUNT ON
	DECLARE @SQLString nvarchar(MAX)
	SET @errorCode = 0
	SET @errorString = 'NO ERROR'
	SET @SQLString = N'BACKUP DATABASE [' + @dbName + '] ' +
		'TO DISK = N''' + @dstFolder + '\' + @dbName + '.dmp'' ' +
		'WITH NOFORMAT, INIT, '+
		'NAME = N''' + @dbName + ' Full Database Backup'' ,' +
		'SKIP, NOREWIND, NOUNLOAD,  STATS = 10 '
	BEGIN TRY
		EXECUTE sp_executesql @SQLString;
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @errorCode = ERROR_NUMBER(),
		@errorString = ERROR_MESSAGE()
   		RAISERROR (@ErrorString, 16,1)
   		SELECT	@errorCode, @errorString
		RETURN (-1)
	END CATCH
	SELECT	0, @errorString
	RETURN (0)
GO

IF EXISTS (select * from GxQscripts where name = 'FDC_BackupDatabase')
	delete from GxQscripts where name = 'FDC_BackupDatabase'
GO

IF EXISTS (select * from GXDBVersions where aliasname='FDC_BackupDatabase')
	delete from GXDBVersions where aliasname = 'FDC_BackupDatabase'
GO

insert into GXDBVersions values(2, 'FDC_BackupDatabase',  '00010004003400020000', 'FDC_BackupDatabase', '00010004003400020000')
GO

