

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EvPrePopulateEventsBulk.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/EvPrePopulateEventsBulk.sp,v $ $Id: EvPrePopulateEventsBulk.sp,v 1.4.202.3 2018/03/20 00:43:10 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: EvPrePopulateEventsBulk <<<'

IF EXISTS (select * from sysobjects where name='EvPrePopulateEventsBulk')
	drop procedure EvPrePopulateEventsBulk
IF EXISTS (select * from GxQscripts where name='EvPrePopulateEventsBulk')
	delete from GxQscripts where name = 'EvPrePopulateEventsBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvPrePopulateEventsBulk')
	delete from GXDBVersions where aliasname = 'EvPrePopulateEventsBulk'
GO
print '... Creating Procedure: EvPrePopulateEventsBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EvPrePopulateEventsBulk
  @i_EvLocaleMsgsFilePath NVARCHAR(1024),
  @i_EvLocaleMsgArgFilePath NVARCHAR(1024)
AS
-- Cursor Output
  DECLARE @o_retVal INTEGER
BEGIN
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER = 0
	DECLARE @l_delimiter	VARCHAR(256) = 'CV0X12'
	DECLARE @SQL			VARCHAR(2048)
	BEGIN TRY
		-- Generate a drop and create SQL Command for all foreign keys and schema bound views
		-- that need to be dropped before truncate can be performed and then re-create them
		-- aftwards.
		IF OBJECT_ID('tempdb.dbo.#Scripts') IS NOT NULL
			DROP TABLE #Scripts
		CREATE TABLE #Scripts
		(
			type			INT,		-- 0 drop FK, 1 create FK, 2 drop View, 3 create view
			tableObjectId	INT,
			refObjectId		INT,
			tableName		NVARCHAR(128),
			refName			NVARCHAR(128),
			script			NVARCHAR(MAX),
			PRIMARY KEY (type, tableObjectId, refObjectId)
		);
		INSERT INTO #Scripts
			EXEC GenTableTruncateSqlScripts 'EvLocaleMsgArgInfo'
		INSERT INTO #Scripts
			EXEC GenTableTruncateSqlScripts 'EvLocaleMsgs'
		-- Concatenate all drop scripts into one string for execution
		DECLARE @dropSQL	NVARCHAR(MAX) = ''
		SELECT
			@dropSQL += s.script + NCHAR(13) + NCHAR(10)
		FROM #Scripts s
		WHERE
			s.type IN (0, 2)	-- drop foreign keys and schema bound views
		-- Concatenate all creates scripts into one string for execution
		DECLARE @createSQL	NVARCHAR(MAX) = ''
		SELECT
			@createSQL += s.script + NCHAR(13) + NCHAR(10)
		FROM #Scripts s
		WHERE
			s.type = 1	-- re-create foreign keys
		BEGIN TRANSACTION EvLocaleMsg_Population
		-- Drop constraints that keep truncate from working EvLocaleMsgs table
		IF (@dropSQL <> '')
		BEGIN
			PRINT 'Executing...' + NCHAR(13) + NCHAR(10) + @dropSQL + NCHAR(13) + NCHAR(10)
			EXEC(@dropSQL)
			PRINT 'Done.'
		END
		-- Remove all existing event rows
		TRUNCATE TABLE EvLocaleMsgArgInfo
		TRUNCATE TABLE EvLocaleMsgs
		-- Re-add dropped foreign keys
		IF (@createSQL <> '')
		BEGIN
			PRINT 'Executing...' + NCHAR(13) + NCHAR(10) + @createSQL + NCHAR(13) + NCHAR(10)
			EXEC(@createSQL)
			PRINT 'Done.'
		END
		-- Re-add schema bound views -- must execute as separate batches
		DECLARE viewCursor CURSOR FOR
			SELECT
				s.script
			FROM #Scripts s
			WHERE
				s.type = 3	-- re-create schema bound views
		OPEN viewCursor
		DECLARE @curOpen INT = 1
		FETCH NEXT FROM viewCursor INTO @createSQL
		WHILE @@FETCH_STATUS = 0
		BEGIN
			PRINT 'Executing...' + NCHAR(13) + NCHAR(10) + @createSQL + NCHAR(13) + NCHAR(10)
			EXEC(@createSQL)
			PRINT 'Done.'
			FETCH NEXT FROM viewCursor INTO @createSQL
		END
		CLOSE viewCursor
		DEALLOCATE viewCursor
		SET @curOpen = 0
		-- Load files with BULK operations into tables
		SET @SQL = 'BULK INSERT EvLocaleMsgs FROM '''+ @i_EvLocaleMsgsFilePath + ''' WITH (FIELDTERMINATOR = ''' + @l_delimiter + ''', DATAFILETYPE = ''widechar'' )'
		PRINT 'Populating EvLocaleMsgs...'
		EXEC (@SQL)
		PRINT 'Done.'
		SET @SQL = 'BULK INSERT EvLocaleMsgArgInfo FROM ''' + @i_EvLocaleMsgArgFilePath + ''' WITH (FIELDTERMINATOR = ''' + @l_delimiter + ''', DATAFILETYPE = ''widechar'' )'
		PRINT 'Populating EvLocaleMsgArgInfo...'
		EXEC (@SQL)
		PRINT 'Done.'
		COMMIT TRANSACTION EvLocaleMsg_Population
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		IF (@curOpen = 1)
		BEGIN
			CLOSE viewCursor
			DEALLOCATE viewCursor
		END
		ROLLBACK TRANSACTION EvLocaleMsg_Population
		SET @errorCode = 1
	END CATCH
	SELECT @errorCode
	RETURN @errorCode
END
GO

IF EXISTS (select * from GxQscripts where name = 'EvPrePopulateEventsBulk')
	delete from GxQscripts where name = 'EvPrePopulateEventsBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvPrePopulateEventsBulk')
	delete from GXDBVersions where aliasname = 'EvPrePopulateEventsBulk'
GO

insert into GXDBVersions values(2, 'EvPrePopulateEventsBulk',  '00010004020200030000', 'EvPrePopulateEventsBulk', '00010004020200030000')
GO

