

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EvMoveJobStatsToHistoryDB.sp] ---------- 

------------------------------------------------------------------------------------------------------
--- ProcName    : EvMoveJobStatsToHistoryDB
--- Description : Collect data of pending, waiting jobs and store it in historyDB
------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='EvMoveJobStatsToHistoryDB')
BEGIN
	print '>>> Drop Stored Procedure: EvMoveJobStatsToHistoryDB <<<'
	drop procedure EvMoveJobStatsToHistoryDB
END
IF EXISTS (select * from GxQscripts where name='EvMoveJobStatsToHistoryDB')
	delete from GxQscripts where name = 'EvMoveJobStatsToHistoryDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvMoveJobStatsToHistoryDB')
	delete from GXDBVersions where aliasname = 'EvMoveJobStatsToHistoryDB'
GO
print '... Creating Procedure: EvMoveJobStatsToHistoryDB'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure EvMoveJobStatsToHistoryDB
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @maxEntriesToRetain INT = ISNULL((select value FROM GXGlobalParam with (nolock) WHERE name = 'MaxEntriesToRetainInJobStatSummary' and modified=0),250000)
	DECLARE @maxDaysJobStatusRetain INT = ISNULL((select value FROM GXGlobalParam with (nolock) WHERE name = 'MaxDaysToRetainInJobStatusSummary' and modified=0),200)
	DECLARE @moveToJobStatusTable INT = ISNULL((SELECT TOP 1 value from GxGlobalParam WHERE name='MoveDataToJobStatusHistoryDB' and modified=0),1)
	DECLARE @moveToAuxCopyTable INT = ISNULL((SELECT TOP 1 value from GxGlobalParam WHERE name='MoveDataToAuxCopyHistoryDB' and modified=0),1)
	DECLARE @maxJobsToRetain INT = ISNULL((SELECT TOP 1 value from GxGlobalParam WHERE name='MaxJobsToRetainInJobRuntimeHistory' and modified=0),200)
	DECLARE @jobRunTimeHistoryLastPrunedTime INT = ISNULL((SELECT TOP 1 value FROM GxGlobalParam WHERE name = 'JobRunTimeHistoryLastPrunedTime' and modified=0),0)
	DECLARE @currentTime DATETIME = GETUTCDATE()
	DECLARE @currentTimeInt INT = dbo.getUnixTime(GETUTCDATE())
	DECLARE @currentHr INT = DATEPART(HOUR,@currentTime)
	DECLARE @currentDay INT = DATEPART(DAY,@currentTime)
	DECLARE @currentweekDay INT = DATEPART(WEEKDAY,@currentTime)
	DECLARE @currentDate DATE = @currentTime
	DECLARE @currentTimeHr INT = (dbo.GETUNIXTIME(@currentTime)/3600) *3600
	BEGIN TRANSACTION MoveJobStats
        --restore jobs
		MERGE HistoryDB.dbo.JobStatSummary as Target
		USING (
SELECT  2 AS jobType,
				srcClientId AS clientId,
				@currentDate AS evDate,
				@currentDay AS evDay,
				@currentweekDay AS evWeekday,
				@currentHr AS evHour,
				COUNT(1) AS occur,
				state AS jobStatus
		FROM runningrestores WHERE
				state in (2,3) AND --CVJobState_PENDING,CVJobState_WAITING
				DATEDIFF(MINUTE,DATEADD(SECOND,jobStartTime,'19700101'),@currentTime)>60
		GROUP BY
				state,
				srcClientId
			  ) AS Source
		ON (
			Target.jobType = Source.jobType AND
			Target.clientId = Source.clientId AND
			Target.evDate = Source.evDate AND
			Target.evDay = Source.evDay AND
			Target.evWeekday = Source.evWeekday AND
			Target.evHour = Source.evHour AND
			Target.jobStatus = Source.jobStatus
		   )
		WHEN MATCHED THEN
			UPDATE SET TARGET.occurances = occur
		WHEN NOT MATCHED BY TARGET THEN
			 INSERT (jobType,clientId,evDate,evDay,evWeekday,evHour,occurances,jobStatus)
			 values(Source.jobType,Source.clientId,Source.evDate,Source.evDay,Source.evWeekday,Source.evHour,Source.occur,Source.jobStatus);
	    --admin jobs
	 	MERGE HistoryDB.dbo.JobStatSummary as Target
		USING (
SELECT  4 AS jobType,
				clientId AS clientId,
				@currentDate AS evDate,
				@currentDay AS evDay,
				@currentweekDay AS evWeekday,
				@currentHr AS evHour,
				COUNT(1) AS occur,
				state AS jobStatus
		FROM runningadminjobs WHERE
				state in (2,3) AND --CVJobState_PENDING,CVJobState_WAITING
				DATEDIFF(MINUTE,DATEADD(SECOND,jobStartTime,'19700101'),@currentTime)>60 AND
opType NOT IN (17,39,92,35,36,67,68,84,64,90)
		GROUP BY
				state,
				clientId
			  ) AS Source
		ON (
			Target.jobType = Source.jobType AND
			Target.clientId = Source.clientId AND
			Target.evDate = Source.evDate AND
			Target.evDay = Source.evDay AND
			Target.evWeekday = Source.evWeekday AND
			Target.evHour = Source.evHour AND
			Target.jobStatus = Source.jobStatus
		   )
		WHEN MATCHED THEN
			UPDATE SET TARGET.occurances = occur
		WHEN NOT MATCHED BY TARGET THEN
			 INSERT (jobType,clientId,evDate,evDay,evWeekday,evHour,occurances,jobStatus)
			 values(Source.jobType,Source.clientId,Source.evDate,Source.evDay,Source.evWeekday,Source.evHour,Source.occur,Source.jobStatus);
	    --backup jobs
	 	MERGE HistoryDB.dbo.JobStatSummary as Target
		USING (
SELECT  CASE(Client.status & (CONVERT(INT,0x1000)|CONVERT(INT,0x10000000)))
WHEN 0 	THEN 1
ELSE 8
				END AS jobType,
				clientId AS clientId,
				@currentDate AS evDate,
				@currentDay AS evDay,
				@currentweekDay AS evWeekday,
				@currentHr AS evHour,
				COUNT(1) AS occur,
				state AS jobStatus
		FROM runningbackups BKP
		INNER JOIN App_Client Client WITH(NOLOCK) ON BKP.clientId = Client.id
		WHERE
				state in (2,3) AND --CVJobState_PENDING,CVJobState_WAITING
				DATEDIFF(MINUTE,DATEADD(SECOND,jobStartTime,'19700101'),@currentTime)>60
		GROUP BY
				state,
				clientId,
Client.status & (CONVERT(INT,0x1000)|CONVERT(INT,0x10000000))
			  ) AS Source
		ON (
			Target.jobType = Source.jobType AND
			Target.clientId = Source.clientId AND
			Target.evDate = Source.evDate AND
			Target.evDay = Source.evDay AND
			Target.evWeekday = Source.evWeekday AND
			Target.evHour = Source.evHour AND
			Target.jobStatus = Source.jobStatus
		   )
		WHEN MATCHED THEN
			UPDATE SET TARGET.occurances = occur
		WHEN NOT MATCHED BY TARGET THEN
			 INSERT (jobType,clientId,evDate,evDay,evWeekday,evHour,occurances,jobStatus)
			 values(Source.jobType,Source.clientId,Source.evDate,Source.evDay,Source.evWeekday,Source.evHour,Source.occur,Source.jobStatus);
	   DECLARE @totalRows INT = 0
	   DECLARE @lastRowId INT = 0
	   SELECT @totalRows = count(*),@lastRowId = MAX(id) FROM HistoryDB.dbo.JobStatSummary
	   IF (@totalRows > @maxEntriesToRetain) AND (@totalRows - @maxEntriesToRetain) > 5000
		BEGIN
			DELETE
			FROM HistoryDB.dbo.JobStatSummary
			WHERE id <= (@lastRowId - @maxEntriesToRetain)
		END
		-----------------------------------------------------------------------------------------------------------------
		----------------------------Move data to historydb.dbo.jobStatusTable--------------------------------------------
		-----------------------------------------------------------------------------------------------------------------
		IF @moveToJobStatusTable = 1
		BEGIN
			DECLARE @earliestDate DATETIME
			DECLARE @latestDate DATETIME
			DECLARE @latestHour INT
			DECLARE @lastDataMovedDateTime DATETIME
			DECLARE @lastDataMovedTime INT
			SELECT @earliestDate = MIN(evDate), @latestDate = MAX(evDate) FROM historydb.dbo.JobStatusSummary  WITH (NOLOCK)
			SELECT @latestHour = MAX(evHour) FROM historydb.dbo.JobStatusSummary  WITH (NOLOCK) WHERE evDate = @latestDate
			DECLARE @diff INT = DATEDIFF(DAY,@earliestDate,@latestDate)
		    DECLARE @earliestRequired DATETIME = DATEADD(DAY, -@maxDaysJobStatusRetain, @latestDate)
			-- if the history table is empty- populate it with maxDaysJobStatusRetain days old data
			-- this is an one time operation in all setups
			IF @latestDate IS NULL
				SET @lastDataMovedDateTime = DATEADD(DAY, -@maxDaysJobStatusRetain, @currentTime)
			ELSE
				SET @lastDataMovedDateTime = DATEADD(HOUR, @latestHour, @latestDate)
			SET @lastDataMovedTime = dbo.GetUnixTime(@lastDataMovedDateTime)
			INSERT INTO HistoryDB.dbo.JobStatusSummary(jobType,evDate,evDay,evWeekDay,evHour,occurances,jobStatus)
SELECT  2 ,
					CAST(DATEADD(SECOND,(servEndTime/3600)*3600 + 3600,'19700101') AS DATE),
					DATEPART(DAY,DATEADD(SECOND,(servEndTime/3600)*3600 + 3600,'19700101')) ,
					DATEPART(WEEKDAY,DATEADD(SECOND,(servEndTime/3600)*3600 + 3600,'19700101')) ,
					DATEPART(HOUR,DATEADD(SECOND,(servEndTime/3600)*3600 + 3600,'19700101')) ,
					COUNT(1) ,
					status
			FROM JMRestoreStats WITH(NOLOCK)
			WHERE servEndTime >=  @lastDataMovedTime AND servEndTime < @currentTimeHr
			GROUP BY
					status,
					(servEndTime / 3600)
			UNION ALL
SELECT  4 ,
					CAST(DATEADD(SECOND,(servEnd/3600)*3600 + 3600,'19700101') AS DATE) ,
					DATEPART(DAY,DATEADD(SECOND,(servEnd/3600)*3600 + 3600,'19700101')) ,
					DATEPART(WEEKDAY,DATEADD(SECOND,(servEnd/3600)*3600 + 3600,'19700101')) ,
					DATEPART(HOUR,DATEADD(SECOND,(servEnd/3600)*3600 + 3600,'19700101')) ,
					COUNT(1) ,
					status
			FROM JMAdminJobStatsTable WITH(NOLOCK)
			WHERE servEnd >= @lastDataMovedTime AND servEnd < @currentTimeHr
AND opType NOT IN (17,39,92,35,36,67,68,84,64,90)
			GROUP BY
					status,
					(servEnd / 3600)
			UNION ALL
			SELECT jobType ,date_,day_,weekday_,hour_,SUM(cnt_),status_
			FROM
			(
				SELECT  CASE(Client.status & (CONVERT(INT,0x1000)|CONVERT(INT,0x10000000)))
				WHEN 0 	THEN 1
				ELSE 8
						END AS jobType,
						CAST(DATEADD(SECOND,(servEndDate/3600)*3600 + 3600,'19700101') AS DATE) date_,
						DATEPART(DAY,DATEADD(SECOND,(servEndDate/3600)*3600 + 3600,'19700101')) day_,
						DATEPART(WEEKDAY,DATEADD(SECOND,(servEndDate/3600)*3600 + 3600,'19700101')) weekday_,
						DATEPART(HOUR,DATEADD(SECOND,(servEndDate/3600)*3600 + 3600,'19700101')) hour_,
						COUNT(1) cnt_,
						BKP.status status_
				FROM jmbkpstats BKP WITH(NOLOCK)
				INNER JOIN App_Application APP WITH(NOLOCK) on BKP.appId = App.id
				INNER JOIN App_Client Client WITH(NOLOCK) ON APP.clientId = Client.id
				WHERE servEndDate >= @lastDataMovedTime AND servEndDate < @currentTimeHr
				GROUP BY
						BKP.status,
						(servEndDate / 3600),
						Client.status
			)A
			GROUP BY jobType,date_,day_,weekday_,hour_,status_
		   -- maintain maxDaysJobStatusRetain days' data - prune every 10 days after that
		   IF ( @diff > (@maxDaysJobStatusRetain + 10))
		   BEGIN
				DELETE FROM HistoryDB.dbo.JobStatusSummary	WHERE evDate < @earliestRequired
		   END
		END
		-----------------------------------------------------------------------------------------------------------------
		----------------------------Move data to historydb.dbo.AuxCopyJobHistory--------------------------------------------
		-----------------------------------------------------------------------------------------------------------------
		IF @moveToAuxCopyTable = 1
		BEGIN
			DECLARE @latestDateAux INT = 0
			DECLARE @earliestDateAux INT = 0
			SELECT @earliestDateAux = ISNULL(MIN(endTime),0), @latestDateAux = ISNULL(MAX(endTime),0) FROM historydb.dbo.AuxCopyJobHistory  WITH (NOLOCK)
			DECLARE @diffAux INT =  (@latestDateAux - @earliestDateAux)/(60*60*24)
			DECLARE @earliestRequiredAux INT = @latestDateAux - (@maxDaysJobStatusRetain*24*60*60)
			INSERT INTO HistoryDb.dbo.AuxCopyJobHistory
				SELECT JRH.jobId, MAX(JA.archGrpId), JRH.copyId, JA.servStart, MAX(JRH.ReleaseTime), DC.dataToCopy
				FROM JMAdminJobStatsTable JA WITH (READUNCOMMITTED)
				INNER JOIN JMDataCopiedStatsTable DC WITH (READUNCOMMITTED) ON JA.jobId = DC.jobId
				INNER JOIN JMJobResourceHistory JRH WITH (READUNCOMMITTED) ON DC.jobId = JRH.jobId AND DC.archGrpCopyID = JRH.copyId
				WHERE JA.opType IN (104,13) --CVOpType_AUXCOPY2,CVOpType_AUXCOPY
				AND JA.servEnd >  @latestDateAux -- @timestamp after which jobs ran and completed successfully
				AND JA.status IN (1,14)--CVJobStatus_JMSUCCESS,CVJobStatus_JMSUCCESSWITHWARNINGS
				AND JA.archGrpCopyID = 0
				GROUP BY JRH.jobId,JRH.copyId, JA.servStart, DC.dataToCopy
				UNION ALL
				SELECT jobId, archGrpId, archGrpCopyID, servStart, servEnd, EX_TotalMedia
				FROM JMAdminJobStatsTable JA WITH (READUNCOMMITTED)
				WHERE opType IN (104,13) --CVOpType_AUXCOPY2,CVOpType_AUXCOPY
				AND status IN (1,14) --CVJobStatus_JMSUCCESS,CVJobStatus_JMSUCCESSWITHWARNINGS
				AND servEnd >  @latestDateAux
			-- maintain maxDaysJobStatusRetain days' data - prune every 10 days after that
		   IF ( @diffAux > (@maxDaysJobStatusRetain + 10))
		   BEGIN
				DELETE FROM HistoryDB.dbo.AuxCopyJobHistory	WHERE endTime < @earliestRequiredAux
		   END
		END
		-----------------------------------------------------------------------------------------------------------------
		----------------------------Move data to historydb.dbo.JMJobRuntimeHistory table--------------------------------------------
		-----------------------------------------------------------------------------------------------------------------
		BEGIN
			DECLARE @lastJobEndTime INT = ISNULL((SELECT MAX(jobEndTime) FROM HistoryDB.dbo.JMJobRuntimeHistory), 0)
			INSERT INTO HistoryDB.dbo.JMJobRuntimeHistory(subclientId, opType, bkpLevel, jobStartTime, jobEndTime, filesToXfer)
			SELECT appId, opType, bkpLevel, servStartDate, servEndDate, filesToXfer
			FROM JmBkpStats
			WHERE (opType = 14 /*CVOpType_SYNTHFULL*/ OR bkpLevel = 64 /*CVBkpLevel_SYNTHETIC_FULL*/)
				  AND servEndDate > @lastJobEndTime
				  AND status IN (1, 3, 14) /*JMJobStatus_JMSUCCESS,JMJobStatus_PARTIALSUCCESS, JMJobStatus_JMSUCCESSWITHWARNINGS*/
			-- prune once in 7 days
			-- remove the entries from subclient,opType,bkpLevel combo that has more than @maxJobsToRetain(200) entries
			IF @currentTimeInt - @jobRunTimeHistoryLastPrunedTime > 60*60*24*7
			BEGIN
				DELETE JRH
				FROM HistoryDB.dbo.JMJobRuntimeHistory JRH
				INNER JOIN
				(SELECT ROW_NUMBER() OVER (PARTITION BY subclientId, opType, bkplevel ORDER BY jobStartTime DESC) rowId, id
				FROM HistoryDB.dbo.JMJobRuntimeHistory
				)JRHwithRowId ON JRH.id = JRHwithRowId.id
				WHERE JRHwithRowId.rowId > @maxJobsToRetain
				--SELECT TOP 1 value FROM GxGlobalParam WHERE name = 'JobRunTimeHistoryLastPrunedTime'
				IF EXISTS  (SELECT TOP 1 value FROM GxGlobalParam WHERE name = 'JobRunTimeHistoryLastPrunedTime' AND modified = 0)
					UPDATE GxGlobalParam SET value = @currentTimeInt WHERE name = 'JobRunTimeHistoryLastPrunedTime' AND modified = 0
				ELSE
					INSERT INTO GxGlobalParam(name, value, created, modified)
					VALUES('JobRunTimeHistoryLastPrunedTime', @currentTimeInt, @currentTimeInt, 0)
			END
		END
	COMMIT TRANSACTION MoveJobStats
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	ROLLBACK TRANSACTION MoveJobStats
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'EvMoveJobStatsToHistoryDB')
	delete from GxQscripts where name = 'EvMoveJobStatsToHistoryDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvMoveJobStatsToHistoryDB')
	delete from GXDBVersions where aliasname = 'EvMoveJobStatsToHistoryDB'
GO

insert into GXDBVersions values(2, 'EvMoveJobStatsToHistoryDB',  '00000000000000000000', 'EvMoveJobStatsToHistoryDB', '00000000000000000000')
GO

