

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EvMoveEventsToHistoryDB.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: EvMoveEventsToHistoryDB <<<'

IF EXISTS (select * from sysobjects where name='EvMoveEventsToHistoryDB')
	drop procedure EvMoveEventsToHistoryDB
IF EXISTS (select * from GxQscripts where name='EvMoveEventsToHistoryDB')
	delete from GxQscripts where name = 'EvMoveEventsToHistoryDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvMoveEventsToHistoryDB')
	delete from GXDBVersions where aliasname = 'EvMoveEventsToHistoryDB'
GO
print '... Creating Procedure: EvMoveEventsToHistoryDB'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure EvMoveEventsToHistoryDB
AS
BEGIN TRY
	DECLARE @keyName nvarchar(50) = 'Last Processed Event For History DB'
	DECLARE @lastProcessedEvent INT = (select value FROM GXGlobalParam with (nolock) WHERE name = @keyName and modified=0)
	DECLARE @processEventsTill INT = (select max(id) from evMsg where type<>2)
	DECLARE @maxEventsToRetain INT = ISNULL((select value FROM GXGlobalParam with (nolock) WHERE name = 'MaxEventsToRetainInEvMsgSummary' and modified=0),250000)
	BEGIN TRANSACTION MoveEvents
		MERGE HistoryDB.dbo.evMsgSummary as Target
		USING (
		SELECT  messageId,
				clientId,
				CONVERT(DATE,DATEADD(ss, timeServer, '19700101')) as evDate,
				DATEPART(DAY,DATEADD(ss, timeServer, '19700101')) AS evDay,
				DATEPART(WEEKDAY,DATEADD(ss, timeServer, '19700101')) AS evWeekday,
				DATEPART(HOUR,DATEADD(ss, timeServer, '19700101')) AS evHour,
				count(*) as occur,
				type
		FROM evMsg	where
				type<>2 AND
				id < @processEventsTill AND
				id >= ISNULL(@lastProcessedEvent,0)
		GROUP BY
				messageid,
				clientId,
				CONVERT(DATE,DATEADD(ss, timeServer, '19700101')),
				DATEPART(DAY,DATEADD(ss, timeServer, '19700101')),
				DATEPART(WEEKDAY,DATEADD(ss, timeServer, '19700101')),
				DATEPART(HOUR,DATEADD(ss, timeServer, '19700101')),
				type
			  ) AS Source
		ON (
			Target.messageId = Source.MessageId AND
			Target.clientId = Source.clientId AND
			Target.evDate = Source.evDate AND
			Target.evDay = Source.evDay AND
			Target.evWeekday = Source.evWeekday AND
			Target.evHour = Source.evHour
		   )
		WHEN MATCHED THEN
			UPDATE SET TARGET.occurances += occur
		WHEN NOT MATCHED BY TARGET THEN
			 INSERT (messageId,clientId,evDate,evDay,evWeekday,evHour,occurances,type)
			 values(Source.MessageID,Source.clientId,Source.evDate,Source.evDay,Source.evWeekday,Source.evHour,Source.occur,Source.type);
       IF @lastProcessedEvent IS NULL
			INSERT INTO GxGlobalParam(name, value, created, modified)
			values(@keyName,@processEventsTill,datediff(second, '01/01/1970', GetUTCdate()),0)
	   ELSE
			UPDATE GXGlobalParam  set value = @processEventsTill, created = datediff(second, '01/01/1970', GetUTCdate())
			WHERE name = @keyName
	   DECLARE @totalRows INT = 0
	   DECLARE @lastRowId INT = 0
	   SELECT @totalRows = count(*),@lastRowId = MAX(id) FROM HistoryDB.dbo.evMsgSummary
	   IF (@totalRows > @maxEventsToRetain) AND (@totalRows - @maxEventsToRetain) > 5000
		BEGIN
			DELETE
			FROM HistoryDB.dbo.evMsgSummary
			WHERE id <= (@lastRowId - @maxEventsToRetain)
		END
	COMMIT TRANSACTION MoveEvents
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	ROLLBACK TRANSACTION MoveEvents
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'EvMoveEventsToHistoryDB')
	delete from GxQscripts where name = 'EvMoveEventsToHistoryDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvMoveEventsToHistoryDB')
	delete from GXDBVersions where aliasname = 'EvMoveEventsToHistoryDB'
GO

insert into GXDBVersions values(2, 'EvMoveEventsToHistoryDB',  '00000000000000000000', 'EvMoveEventsToHistoryDB', '00000000000000000000')
GO

