

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EvMarkAnomalousEvents.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- -----------------------------------------------------------------------------------------
--        ProcName:EvMarkAnomalousEvents
--		  Marks events in evmsg anomalous with values 1(occurrence),2(frequency),3(both)
--        output: number of events marked anomalous
--------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='EvMarkAnomalousEvents')
BEGIN
	print '>>> Drop Stored Procedure: EvMarkAnomalousEvents <<<'
	drop procedure EvMarkAnomalousEvents
END
IF EXISTS (select * from GxQscripts where name='EvMarkAnomalousEvents')
	delete from GxQscripts where name = 'EvMarkAnomalousEvents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvMarkAnomalousEvents')
	delete from GXDBVersions where aliasname = 'EvMarkAnomalousEvents'
GO
print '... Creating Procedure: EvMarkAnomalousEvents'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure EvMarkAnomalousEvents
AS
  DECLARE @anomalousCount INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @nullSTD float=0
	DECLARE @hr INT=1
	DECLARE @nStdO float
	DECLARE @nStdF float
	DECLARE @minDays INT
	SELECT @nStdO = ISNULL((SELECT value from GxGlobalParam WHERE name='mulFactorForOccurrenceEventAnomaly'),3)
	SELECT @nStdF = ISNULL((SELECT value from GxGlobalParam WHERE name='mulFactorForFrequencyEventAnomaly'),3)
	SELECT @minDays = ISNULL((SELECT value from GxGlobalParam WHERE name='mulFactorForFrequencyEventAnomaly'),30)
	IF OBJECT_ID('tempdb.dbo.#t') IS NOT NULL
		DROP TABLE #t
	CREATE TABLE #t
	( messageid INT,
	clientId INT,
	evDate DATE,
	evHOUR INT,
	occ INT,
	severity INT)
	DECLARE @noOfDays INT=0
	DECLARE @currentTimeHr DATETIME = DATEADD(HOUR, DATEDIFF(second, '01/01/1970', GETUTCDATE())/(60*60), '19700101')
	DECLARE @useHistoryDb INT =ISNULL((SELECT 0 FROM GXGlobalParam with (nolock) WHERE name = 'MoveEventsToHistoryDB' and modified=0 and value='false'),1)
	DECLARE @lastProcessedEvent INT = ISNULL((SELECT value FROM GXGlobalParam with (nolock) WHERE name = 'Last Processed Event For History DB' and modified=0),0)
	--populate history data for calculation based on number of occurances of event
	--get events for at a particular hr every day,
	--and different hours in same day
	IF @useHistoryDb=1
		INSERT INTO #t
					SELECT messageid,
					clientId,
					evDate ,
					evHOUR,
					occurances,
					0
					FROM historyDB.dbo.evmsgsummary WHERE
					evHOUR = datepart(hour,DATEADD(hour,-@hr,GETUTCDATE()))
	MERGE #t as Target
	USING (
	SELECT messageid,
	clientId as clientID,
	CONVERT(DATE,DATEADD(ss, timeServer, '19700101')) as evDate,
	DATEPART(HOUR,DATEADD(ss, timeServer, '19700101')) as evHOUR,
	COUNT(*) as Occurences
	FROM evMsg WHERE type<>2
	AND DATEDIFF(DAY,DATEADD(ss, timeServer, '19700101'),GETUTCDATE())<= 365
	AND (
						(DATEPART(HOUR,DATEADD(ss, timeServer, '19700101')) = DATEPART(HOUR,DATEADD(HOUR,-@hr,GETUTCDATE())) AND (DATEDIFF(DAY,DATEADD(ss, timeServer, '19700101'),GETUTCDATE()) > 0 )
						OR
						(DATEDIFF(DAY,DATEADD(ss, timeServer, '19700101'),GETUTCDATE()) = 0) AND DATEPART(HOUR,DATEADD(ss, timeServer, '19700101')) < DATEPART(HOUR,DATEADD(HOUR,-@hr,GETUTCDATE())))
		)
	AND id>@lastProcessedEvent
	GROUP BY
	messageid,clientId,
	CONVERT(DATE,DATEADD(ss, timeServer, '19700101')),
	DATEPART(HOUR,DATEADD(ss, timeServer, '19700101'))
	) AS SOURCE
	ON(
			Source.messageId=Target.messageId AND
			Source.evDate = Target.evDate AND
			Source.evHOUR = Target.evHOUR AND
			Source.clientID=Target.clientId
	)
	WHEN MATCHED THEN
			UPDATE  SET TARGET.occ+=SOURCE.Occurences
	WHEN NOT MATCHED BY TARGET THEN
			INSERT (messageId, evDate,evHOUR,occ,clientId,severity)
			VALUES(Source.messageId,Source.evDate, Source.evHOUR,SOURCE.Occurences,Source.clientId,0);
	SET @noOfDays= (select DATEDIFF(DAY,MIN(evDate),MAX(evDate)) FROM #t)
	DECLARE @std TABLE
		(messageid INT,
		clientId INT,
		std float,
		AVG float,
		noOfDataPoints INT,
		contribution FLOAT
		)
	DECLARE @totalEventCount FLOAT=(SELECT (SUM(occ)) from #t)
	INSERT INTO @std
	SELECT messageid,clientId, isnull(STDEV(occ),0),AVG(occ) ,COUNT(1),SUM(occ)*100.0/@totalEventCount FROM #t GROUP BY messageid,clientID
	--select * from #t where messageid=117440723
	--select * from @std where messageid=117440723
	TRUNCATE TABLE #t
	INSERT INTO #t
	SELECT messageid,clientId,
	CONVERT(DATE,DATEADD(ss, timeServer, '19700101')) as evDate,
	DATEPART(HOUR,DATEADD(ss, timeServer, '19700101')) as evHour,
	COUNT(*) as Occurences,
	severity
	FROM evMsg WHERE type<>2
	AND DATEDIFF(HOUR,DATEADD(HOUR,timeserver/(60*60),'19700101'),@currentTimeHr)=@hr
	GROUP BY
	messageid,
	clientId,
	severity,
	CONVERT(DATE,DATEADD(ss, timeServer, '19700101')),
	DATEPART(HOUR,DATEADD(ss, timeServer, '19700101'))
	--SELECT T.messageid,T.clientId,AVG+(@nStdO*T2.std) threshold,t.occ FROM #t as T LEFT JOIN @std as T2  on T.messageid = T2.messageid and T.clientId=t2.clientid where T.messageid=536871271
	DECLARE @filter TABLE(messageid INT, clientID int, flag INT)
	INSERT INTO @filter
	SELECT T.messageid,T.clientId,1 FROM #t as T LEFT JOIN @std as T2 on T.messageid = T2.messageid and T.clientID=T2.clientID
WHERE (T.occ > 1.1*AVG+((std+1)*@nStdO*(1+ABS(std+1))/(std+1)) and T.occ >= 1 and (T2.noOfDataPoints>10 OR @noOfDays>@minDays)) OR (T2.messageid is null AND (T.severity = 6 OR T.severity = 9))
	-- freq calculation
	IF OBJECT_ID('tempdb.dbo.#freqHist') IS NOT NULL
		DROP TABLE #freqHist
	CREATE TABLE #freqHist
	(
	messageid INT,
	clientId INT,
	evDateWithHOUR dateTime,
	severity INT
	)
	--populate history data for calculation based on frequency of occurances of events
	--get occurance time of events
	IF @useHistoryDb=1
	INSERT INTO #freqHist
			SELECT messageid,clientId,
			DATEADD(HOUR,evHOUR,evDate),0
			FROM historyDB.dbo.evmsgsummary WHERE
			(
					DATEDIFF(HOUR,DATEADD(HOUR,evHOUR,evDate),@currentTimeHr)>@hr
			)
			GROUP BY messageid,clientId,
			DATEADD(HOUR,evHOUR,evDate)
	MERGE #freqHist as Target
	USING (
		SELECT messageid,clientId,
				DATEADD(HOUR,timeserver/(60*60),'19700101') evDateWithHOUR
				FROM evMsg WHERE type<>2
				AND DATEDIFF(HOUR,DATEADD(HOUR,timeserver/(60*60),'19700101'),@currentTimeHr)>@hr
				AND id > @lastProcessedEvent
				GROUP BY
				messageid,clientId,
				DATEADD(HOUR,timeserver/(60*60),'19700101')
	) AS SOURCE
	ON(
			Source.messageId=Target.messageId AND
			Source.evDateWithHOUR = Target.evDateWithHOUR AND
			Source.clientID=Target.clientId
	  )
	WHEN NOT MATCHED BY TARGET THEN
						INSERT (messageId,clientID, evDateWithHOUR,severity)
			VALUES(Source.messageId,Source.clientId,Source.evDateWithHOUR,0);
	DECLARE @freqTABLE TABLE(messageId INT,clientId int, timeDiff float,evDateWithHOUR dateTime)
	--find the difference in occurance time of events
	INSERT INTO @freqTABLE(messageId,clientId, timeDiff, evDateWithHour)
	SELECT
	messageId,clientID,
	DATEDIFF(HOUR,lead(evDateWithHour) over (partition by messageId,clientID ORDER BY evDateWithHour desc),evDateWithHour ),
	evDateWithHour
	FROM  #freqHist
	DECLARE @stdfreq TABLE
	(
	messageid INT,clientId INT,
	std float,
	AVG float,
	lastOccurance dateTime,
	noOfDataPoints INT
	)
	INSERT INTO @stdfreq
	SELECT messageid,clientID, ISNULL(STDEV(timeDiff),@nullSTD),ISNULL(AVG(timeDiff),0),MAX(evDateWithHour),count(1) FROM @freqTABLE GROUP BY messageId,clientId
	--prevents flagging of second info event
	DELETE FROM @stdfreq WHERE avg=0
	TRUNCATE TABLE #freqHist
	INSERT INTO #freqHist(messageId,clientid,evDateWithHour,severity)
	SELECT messageid,clientId,
	DATEADD(HOUR,timeserver/(60*60),'19700101') as evDateWithHour,severity
	FROM evMsg WHERE type<>2
	AND DATEDIFF(HOUR,DATEADD(HOUR,timeserver/(60*60),'19700101'),@currentTimeHr)=@hr
	GROUP BY
	messageid,clientId,severity,
	DATEADD(HOUR,timeserver/(60*60),'19700101')
	--SELECT *, DATEDIFF(HOUR,T2.lastOccurance, T.evDateWithHour) diff,AVG+(@nStdF*T2.std) threshold FROM #freqHist as T LEFT JOIN @stdfreq as T2 on T.messageid = T2.messageid and T.clientID=T2.clientID where t.messageid=117440723
	INSERT INTO @filter
	SELECT T.messageid,T.clientId,2 FROM #freqHist as T LEFT JOIN @stdfreq as T2 on T.messageid = T2.messageid and T.clientID=T2.clientid
WHERE (DATEDIFF(HOUR,T2.lastOccurance, T.evDateWithHour) >  1.1*AVG+((std+1)* @nStdF *(1+abs(std+1))/(std+1)) AND (T2.noOfDataPoints > 10  OR @noOfDays > @minDays )) AND (T.severity = 6 OR T.severity = 9)
	UPDATE E
	SET E.anomalous = flag
	FROM EvMsg E INNER JOIN @filter F ON E.messageId = F.messageid AND E.clientId = F.clientId
	WHERE type<>2
	AND DATEDIFF(HOUR,DATEADD(HOUR,timeserver/(60*60),'19700101'),@currentTimeHr)=@hr
	SELECT @@rowcount
	DROP TABLE #t
	DROP TABLE #freqHist
GO

IF EXISTS (select * from GxQscripts where name = 'EvMarkAnomalousEvents')
	delete from GxQscripts where name = 'EvMarkAnomalousEvents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvMarkAnomalousEvents')
	delete from GXDBVersions where aliasname = 'EvMarkAnomalousEvents'
GO

insert into GXDBVersions values(2, 'EvMarkAnomalousEvents',  '00000000000000000000', 'EvMarkAnomalousEvents', '00000000000000000000')
GO

