

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EvGuiGetLocaleByName.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/EvGuiGetLocaleByName.sp,v $ $Id: EvGuiGetLocaleByName.sp,v 1.4 2009/10/27 20:31:18 skatz Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROC : "EvGuiGetLocaleByName"									|
--	| Description: Retrieves locale info based on input name				|
--	|    Attempt to resolve locale will be done in the following order:		|
--	|		1. Exact match for i_localeName									|
--	|		2. For 2 char i_locale, search for 1st like 'xx-'				|
--	|		3. For form xx-yy, search for 1st like 'xx-'					|
--	|		4. return for "en-us"											|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: EvGuiGetLocaleByName <<<'

IF EXISTS (select * from sysobjects where name='EvGuiGetLocaleByName')
	drop procedure EvGuiGetLocaleByName
IF EXISTS (select * from GxQscripts where name='EvGuiGetLocaleByName')
	delete from GxQscripts where name = 'EvGuiGetLocaleByName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvGuiGetLocaleByName')
	delete from GXDBVersions where aliasname = 'EvGuiGetLocaleByName'
GO
print '... Creating Procedure: EvGuiGetLocaleByName'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure EvGuiGetLocaleByName
  @i_localeName varchar(20)			
AS
  DECLARE @retCode integer;
  DECLARE @id integer;
  DECLARE @srcExt varchar(12);
  DECLARE @LCID integer;
  DECLARE @locale varchar(12);
  DECLARE @displayString varchar(256);
  DECLARE @cvLocaleId integer;
  DECLARE @displayLocaleName varchar(256);
SET NOCOUNT ON
SET @retCode = 0					-- ASSUME SUCCESS
Declare @MatchId	integer
SET		@matchId	= ISNULL((Select [Id] from evLocales where rtrim([locale]) = @i_localeName), -1)
IF @matchId >= 0					-- HAVE AN EXACT MATCH!
	goto RESULTS
--------------------------------------------------
-- NO, Exact match, try for hierarchial lookup	--
-- Correct format for "heierarchial is 'xx-yy'  --
--------------------------------------------------
SET @retCode = 1					-- From this point on, anything returned is NOT exact match
IF (LEN(@i_localeName) = 2)			-- if 2 character named was passed in, "fake" xx-yy format
	SET @i_localeName = @i_localeName + '-xx'
IF ISNULL(PATINDEX('%-%', @i_localeName), -1) <> 3
BEGIN
	SET @MatchId = 0				-- NOT CORRECT INPUT FORMAT FOR HIERARCHIAL,
	goto RESULTS					-- SO DEFAULT TO "US-EN"
END
-- Either find a "match" for parent, or default to US-EN
SET @i_localeName	= SUBSTRING(@i_localeName, 1, 3)+ '%'
SET	@matchId		= ISNULL((Select top 1 [Id] from evLocales where rtrim([locale])  like @i_localeName order by [id]), 0)
------------------------------
-- RETURN RESULTS TO CALLER --
------------------------------
RESULTS:
SELECT @retCode, [Id], [srcExt], [LCID], [locale], [displayString], [cvLocaleId], [displayLocaleName]
FROM evLocales Where [id] = @matchId
GO
-- exec EvGuiGetLocaleByName 'zh-hy'

IF EXISTS (select * from GxQscripts where name = 'EvGuiGetLocaleByName')
	delete from GxQscripts where name = 'EvGuiGetLocaleByName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvGuiGetLocaleByName')
	delete from GXDBVersions where aliasname = 'EvGuiGetLocaleByName'
GO

insert into GXDBVersions values(2, 'EvGuiGetLocaleByName',  '00010004000000000000', 'EvGuiGetLocaleByName', '00010004000000000000')
GO

