

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EvGuiAuditPrune.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/EvGuiAuditPrune.sp,v $ $Id: EvGuiAuditPrune.sp,v 1.6.72.7 2020/04/07 01:46:33 njudge Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "EvGuiAuditPrune"									|
--	|Description: Retrieve GUI Audit Trail Informtion						|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='EvGuiAuditPrune')
BEGIN
	print '>>> Drop Stored Procedure: EvGuiAuditPrune <<<'
	drop procedure EvGuiAuditPrune
END
IF EXISTS (select * from GxQscripts where name='EvGuiAuditPrune')
	delete from GxQscripts where name = 'EvGuiAuditPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvGuiAuditPrune')
	delete from GXDBVersions where aliasname = 'EvGuiAuditPrune'
GO
print '... Creating Procedure: EvGuiAuditPrune'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EvGuiAuditPrune
  @i_RetentionDaysCritical integer,
  @i_RetentionDaysHigh integer,
  @i_RetentionDaysMedium integer,
  @i_RetentionDaysLow integer
AS
  DECLARE @o_retVal integer;
SET NOCOUNT ON
	SET @o_retVal = 0
	-- This table holds all evMsgId in EvMsg for gui operations
	IF OBJECT_ID('TempDb..#tblOpEvMsg') IS NOT NULL
		DROP TABLE #tblOpEvMsg
	CREATE TABLE #tblOpEvMsg (
		evMsgId		INT,
		opId		INT,
		PRIMARY KEY (evMsgId, opId)
	)
	-- Temp table to support batching based on operations
	IF OBJECT_ID('TempDb..#tblOpEvMsgTemp') IS NOT NULL
		DROP TABLE #tblOpEvMsgTemp
	CREATE TABLE #tblOpEvMsgTemp (
		evMsgId		INT,
		opId		INT,
		PRIMARY KEY (evMsgId, opId)
	)
	-- This table holds all evMsgId in EvMsg for gui parameters
	-- It will later on holds all evMsgId to be pruned
	IF OBJECT_ID('TempDb..#tblParamEvMsg') IS NOT NULL
		DROP TABLE #tblParamEvMsg
	CREATE TABLE #tblParamEvMsg (
		evMsgId		INT PRIMARY KEY
	)
	DECLARE @CurrentTime integer
	DECLARE @PruneTime_Critical integer
	DECLARE @PruneTime_High integer
	DECLARE @PruneTime_Medium integer
	DECLARE @PruneTime_Low integer
	DECLARE @lastYear INTEGER
	SET @CurrentTime = dbo.getUnixTime(getUTCDate())
	SET @PruneTime_Critical = @CurrentTime - @i_RetentionDaysCritical * 24 * 3600;
	SET @PruneTime_High = @CurrentTime - @i_RetentionDaysHigh * 24 * 3600;
	SET @PruneTime_Medium = @CurrentTime - @i_RetentionDaysMedium * 24 * 3600;
	SET @PruneTime_Low = @CurrentTime - @i_RetentionDaysLow * 24 * 3600;
	SET @lastYear = @CurrentTime - (365 *24 * 3600)
	IF OBJECT_ID('TempDb..#tblOpRetention') IS NOT NULL
		DROP TABLE #tblOpRetention
	CREATE TABLE #tblOpRetention (
			opMsgId			int,
			userId			int,
			retentionDays	int,
			PRIMARY KEY (opMsgId, userId)
	)
	DECLARE @useAuditRetention TINYINT = 0
	IF object_id('dbo.EvGuiAuditRetention') is not null
	BEGIN
		INSERT INTO #tblOpRetention (opMsgId, userId, retentionDays)
			SELECT
				 opMsgId,
				 userId,
				 retentionDays
			FROM EvGuiAuditRetention WITH(NOLOCK)
		SET @useAuditRetention = @@ROWCOUNT
	END
	-- Retrieve all events for GUI operation
	-- Set default audit level to AUDIT_TRAIL_LEVEL_HIGH = 2
	--NOTE (lpulickal 03-10-2014 ) : Restricting the audit trail pruning to local commcell events since these are not migrated at present.
	-- If it is to be migrated in future, commcellId column should be added in EvGuiAuditOperation & EvGuiAuditParameter and the code of this sp need to be changed
	DECLARE @retentionRows INT = 0
	IF (@useAuditRetention > 0)
	BEGIN
		INSERT INTO #tblOpEvMsg
			SELECT
				a.id,
				b.id
			FROM EvMsg a WITH (NOLOCK)
				INNER JOIN EvGuiAuditOperation b WITH (NOLOCK) ON
					a.id = b.EvMsgId
					AND a.commCellID = 2
				INNER JOIN #tblOpRetention d ON
					a.messageId = d.opMsgId
					AND a.userId = d.userId
			WHERE
				d.retentionDays > 0
				AND a.timeServer < (@CurrentTime - d.retentionDays * 24 * 3600)
		SET @retentionRows = @@ROWCOUNT
	END
	IF (@retentionRows > 0)
	BEGIN
		INSERT INTO #tblOpEvMsg
			SELECT
				a.id,
				b.id
			FROM EvMsg a WITH (NOLOCK)
				INNER JOIN EvGuiAuditOperation b WITH (NOLOCK) ON
					a.id = b.EvMsgId
					AND a.commCellID = 2
				LEFT OUTER JOIN EvGuiAuditLevel c WITH (NOLOCK) ON
					a.messageId = c.opMsgId
				LEFT OUTER JOIN #tblOpEvMsg t ON
					t.evMsgId = a.id
					AND t.opId = b.id
			WHERE
				(
					t.evMsgId IS NULL		-- add row to table
					AND c.auditLevel IS NULL
					AND a.timeServer < @PruneTime_High
				)
				OR (
					t.evMsgId IS NULL		-- add row to table
					AND c.auditLevel >= 1
					AND c.auditLevel <= 4
					AND a.timeServer < (
						CASE c.auditLevel
							WHEN 1 THEN @PruneTime_Critical
							WHEN 2 THEN @PruneTime_High
							WHEN 3 THEN @PruneTime_Medium
							ELSE @PruneTime_Low
						END
					)
				)
	END
	ELSE
	BEGIN
		-- No retention rows capture
		INSERT INTO #tblOpEvMsg
			SELECT
				a.id,
				b.id
			FROM EvMsg a WITH (NOLOCK)
				INNER JOIN EvGuiAuditOperation b WITH (NOLOCK) ON
					a.id = b.EvMsgId
					AND a.commCellID = 2
				LEFT OUTER JOIN EvGuiAuditLevel c WITH (NOLOCK) ON
					a.messageId = c.opMsgId
			WHERE
				(
					c.auditLevel IS NULL
					AND a.timeServer < @PruneTime_High
				)
				OR (
					c.auditLevel >= 1
					AND c.auditLevel <= 4
					AND a.timeServer < (
						CASE c.auditLevel
							WHEN 1 THEN @PruneTime_Critical
							WHEN 2 THEN @PruneTime_High
							WHEN 3 THEN @PruneTime_Medium
							ELSE @PruneTime_Low
						END
					)
				)
	END
	-- MR Reference : 240897, We will keep "Audit Trail Retention days modification"
	-- Audit atleast for one year, independent of retention days.
	;WITH AuditTrailRetentionAudit AS(
		SELECT EM.id Id, OP.id OpId
			FROM evMsg EM
			INNER JOIN EvGuiAuditOperation OP
				ON EM.id = OP.evMsgId
WHERE EM.messageId = (544 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				AND EM.timeServer > @lastYear
		)
		DELETE EM FROM #tblOpEvMsg EM
		INNER JOIN (
			SELECT Id FROM AuditTrailRetentionAudit
				UNION
			SELECT PD.evMsgId
				FROM AuditTrailRetentionAudit AR
				INNER JOIN EvGuiAuditParameter PD
					ON AR.OpId = PD.opId
			)ARA ON Em.evMsgId = ARA.Id
	-- Do batching based on operations so that TL log size doesnt increase lot.
	WHILE (1>0)
	BEGIN
	-- In case of error from previous iteration, error out as before
	IF @o_retVal<>0
	BEGIN
		BREAK;
	END
	IF NOT EXISTS(SELECT 1 FROM #tblOpEvMsg)
	BEGIN
	         BREAK;
	END
	TRUNCATE TABLE #tblParamEvMsg
	DELETE TOP (1000) FROM #tblOpEvMsg
	OUTPUT DELETED.* INTO #tblOpEvMsgTemp
	INSERT INTO #tblParamEvMsg
		SELECT
			b.evMsgId
		FROM #tblOpEvMsgTemp a
			INNER JOIN EvGuiAuditParameter b WITH(NOLOCK) ON
				a.opId = b.opId
		GROUP BY b.evMsgId
	-- Get clusterered index id columns for all table rows that need to be pruned
	IF OBJECT_ID('TempDb..#DelIds') IS NOT NULL
		DROP TABLE #DelIds
	CREATE TABLE #DelIds (
		type	TINYINT,		-- EvGuiAuditParameter(1), EvGuiAuditOperation(2), EvMsg(3)
		id		INT,
		PRIMARY KEY (type, id)
	)
	INSERT INTO #DelIds (type, id)
		SELECT
			1,		-- EvGuiAuditParameter
			ap.id
		FROM EvGuiAuditParameter ap WITH(NOLOCK)
			INNER JOIN #tblParamEvMsg t ON
				t.evMsgId = ap.evMsgId
		UNION ALL
		SELECT
			2,		-- EvGuiAuditOperation
			ao.id
		FROM EvGuiAuditOperation ao WITH(NOLOCK)
		WHERE
			ao.id IN (
				SELECT
					opId
				FROM #tblOpEvMsgTemp
				GROUP BY opId
			)
		UNION ALL
		SELECT		-- delete all event messages found not just the ones with associated parameters
			3,		-- EvMsg
			e.evMsgId
		FROM #tblOpEvMsgTemp e
	INSERT INTO #DelIds (type, id)
        SELECT
            3,      -- EvMsg
            m.id
        FROM EvMsg m WITH(NOLOCK)
            INNER JOIN #tblParamEvMsg p ON
                p.evMsgId = m.id
                AND m.commcellId = 2
            LEFT OUTER JOIN #DelIds d ON
                d.type = 3
                AND d.id = p.evMsgId
        WHERE
            d.id IS NULL
        GROUP BY m.id
	-- Perform table row deletion for all captured delete Ids
	BEGIN TRY
		BEGIN TRANSACTION EvGuiAuditPruneTran
		DELETE p
		FROM EvParam p
		WHERE
			p.commcellId = 2
			AND p.evMsgId IN (SELECT evMsgId FROM #tblParamEvMsg)
		DELETE ap
		FROM EvGuiAuditParameter ap
		WHERE
			ap.id IN (SELECT id FROM #DelIds WHERE type = 1)
		DELETE ao
		FROM EvGuiAuditOperation ao
		WHERE
			ao.id IN (SELECT id FROM #DelIds WHERE type = 2)
		DELETE m
		FROM EvMsg m
			INNER JOIN #DelIds d ON
				d.type = 3
				AND d.id = m.id
				AND m.commcellId = 2	-- the original code deleted the child rows above for other commcellids why saving the EvMgs rows for 2?
		IF OBJECT_Id('dbo.EvGuiAuditMessage') IS NOT NULL
		BEGIN
			DELETE a
			FROM EvGuiAuditMessage a
			INNER JOIN #DelIds d ON
				d.type = 3
				AND d.id = a.evMsgId
				AND a.commcellId = 2	-- the original code deleted the child rows above for other commcellids why saving the EvMgs rows for 2?
			-- Left outer join can be costly???
			--DELETE a
			--FROM EvGuiAuditMessage a
			--	LEFT OUTER JOIN EvMsg b ON
			--		a.evMsgId = b.id
			--WHERE
			--	b.id IS NULL
		END
		COMMIT TRANSACTION EvGuiAuditPruneTran
		SET @o_retVal = 0
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		ROLLBACK TRANSACTION EvGuiAuditPruneTran
		SET @o_retVal = -1
	END CATCH
	END
	IF OBJECT_ID('TempDb..#tblOpEvMsg') IS NOT NULL
		DROP TABLE #tblOpEvMsg
	IF OBJECT_ID('TempDb..#tblOpEvMsgTemp') IS NOT NULL
		DROP TABLE #tblOpEvMsgTemp
	IF (@o_retVal = 0)
	BEGIN
		-- EvGuiAuditMessage one time cleanup for dangling rows
		-- Code moved from EvGuiAuditMessage.script to improve performance of database upgrade time
		DECLARE @nowTime    INT =  DATEDIFF(second, '01/01/1970', GETUTCDATE())
		-- This set of commands is a Run Once Activity
		DECLARE @auditGuid    VARCHAR(40) = '9C1C9391-383D-42D3-8693-7E0B250B4D92'
		IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @auditGuid)
		BEGIN
			PRINT 'Start: Cleanup dangling EvGuiAuditMessage rows.'
			SET @o_retVal = 0
			DECLARE @rcnt INT = 1
			WHILE (@rcnt > 0)
			BEGIN
				BEGIN TRY
					-- Do not need transaction control here since it is only 1 DELETE Op
					-- Batch delete to control log file growth
					DELETE TOP (5000) am
					FROM EvGuiAuditMessage am
						LEFT OUTER JOIN EvGuiAuditOperation ao ON
							ao.id = am.opId
					WHERE
						ao.id IS NULL
				END TRY
				BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
					SET @o_retVal = -1
				END CATCH
				IF (@o_retVal <> 0)
				BEGIN
					GOTO END_OF_PROC
				END
				SET @rcnt = @@ROWCOUNT
			END
			PRINT 'Completed: Cleanup dangling EvGuiAuditMessage rows.'
			INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
VALUES (@auditGuid, 'CleanupEvGuiAuditMessage', 'Delete dangling EvGuiAuditMessage Rows', @nowTime,  16, 0, (16 + 2))
		END
		-- Pruning the entries of GxQscriptExec assuming the severity as low for these entries
		DELETE QE from GxQscriptExec QE
		where DATEDIFF(SECOND,'01/01/1970',QE.timeEnd) < @PruneTime_Low
	END
END_OF_PROC:
	SELECT @o_retVal
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'EvGuiAuditPrune')
	delete from GxQscripts where name = 'EvGuiAuditPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvGuiAuditPrune')
	delete from GXDBVersions where aliasname = 'EvGuiAuditPrune'
GO

insert into GXDBVersions values(2, 'EvGuiAuditPrune',  '00010006007200070000', 'EvGuiAuditPrune', '00010006007200070000')
GO

