

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EvGuiAuditGetMsg.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/EvGuiAuditGetMsg.sp,v $ $Id: EvGuiAuditGetMsg.sp,v 1.57.2.14 2020/04/07 02:49:32 jge Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "EvGuiAuditGetMsg"									|
--	|Description: Retrieve GUI Audit Trail Informtion						|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='EvGuiAuditGetMsg')
BEGIN
	print '>>> Drop Stored Procedure: EvGuiAuditGetMsg <<<'
	drop procedure EvGuiAuditGetMsg
END
IF EXISTS (select * from GxQscripts where name='EvGuiAuditGetMsg')
	delete from GxQscripts where name = 'EvGuiAuditGetMsg'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvGuiAuditGetMsg')
	delete from GXDBVersions where aliasname = 'EvGuiAuditGetMsg'
GO
print '... Creating Procedure: EvGuiAuditGetMsg'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EvGuiAuditGetMsg
  @i_jobId integer,
  @i_auditLevel integer,
  @s_searchString nvarchar(max),
  @i_userIdList NTEXT,
  @i_guiAuditOperationId integer = NULL,
  @i_entityType integer = 0,
  @i_entityId integer = 0
AS
  DECLARE @o_evMsgId integer;
  DECLARE @o_locId integer;
  DECLARE @o_commcellId integer;
  DECLARE @o_userId integer;
  DECLARE @o_time integer;
  DECLARE @o_messageId integer;
  DECLARE @o_opId integer;
  DECLARE @o_paramId integer;
  DECLARE @o_auditLevel integer;
  DECLARE @o_entityType integer;
  DECLARE @o_entityId integer;
  DECLARE @o_oldMsgId integer;
  DECLARE @o_newMsgId integer;
  DECLARE @o_msgSpanNum integer;
  DECLARE @o_isList integer;
  DECLARE @o_listOpType integer;
  DECLARE @o_hierarchyLevel integer;
  DECLARE @o_msgText nvarchar(MAX);
  DECLARE @o_oldValue nvarchar(MAX);
  DECLARE @o_newValue nvarchar(MAX);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @locId			integer = 0
	DECLARE @startTime		integer = 0
	DECLARE @endTime		integer = 0
	DECLARE @lastOpId		integer = 0
	DECLARE @lastOpIdOperation integer = 0
	DECLARE @lastMsgId integer = 0
	DECLARE @err			integer = 0
	DECLARE @userId			integer = 0
	-- Get user Id
	-- For alerting purposes, we dont pass jobId. We retrieve based on audit operationId. for alerting, we can assume admin user.
	if @i_jobId=0
	begin
		set @userId  = ISNULL((Select top 1 ID from UMUSERS where (flags & 67) = 67 AND Name <> 'ROMS'), 1)
	end
	else
	begin
SET @userId = dbo.GetOptionInt(140019, @i_jobId, 0, 0)
	end
	IF (@s_searchString!='')
		SET @s_searchString = '%'+@s_searchString+'%'
	IF object_ID('tempdb..#userFilter') IS NOT NULL
	begin
		DROP table #userFilter
	end
	create table #userFilter (userId INT)
	IF OBJECT_ID('tempdb.dbo.#finalResult') IS NOT NULL
	begin
		DROP TABLE #finalResult
	end
	CREATE TABLE #finalResult
	(
		evMsgId			integer,
		locId			integer,
		commcellId		integer,
		userId			integer,
		timeServer				integer,
		messageId		integer,
		opId				integer,
		paramId			integer,
		auditLevel		integer,
		entityType		integer,
		entityId			integer,
		oldMsgId			integer,
		newMsgId			integer,
		msgSpanNum		integer,
		isList			integer,
		listOpType		integer,
		hierarchyLevel	integer,
		messageText			nvarchar(MAX),
		oldValue			nvarchar(MAX),
		newValue			nvarchar(MAX)
	)
	IF object_id('tempdb.dbo.#tempOpCount') IS NOT NULL DROP TABLE #tempOpCount
	IF object_id('tempdb.dbo.#tempOpAuditLevel') IS NOT NULL DROP TABLE #tempOpAuditLevel
    IF OBJECT_ID('tempdb.dbo.#TEGAM') IS NOT NULL DROP TABLE #TEGAM
	CREATE TABLE #EvGuiAuditMessage
	(
			evMsgId		integer,
			locId		integer,
			commcellId	integer,
			userId		integer,
			timeServer	integer,
			messageId	integer,
			opId		integer,
			paramId		integer,
			auditLevel	integer,
			entityType	integer,
			entityId	integer,
			oldMsgId	integer,
			newMsgId	integer,
			msgSpanNum	integer,
			messageText	nvarchar(max),
			oldValue	nvarchar(max),
			newValue	nvarchar(max),
			isList		int default 0,
			listOpType	int default 0,
			hierarchyLevel	integer default 0
	)
	create table #tempOpCount ( opId int, msgSpanNum int)
	create table #tempOpAuditLevel ( opId int, auditLevel int)
	CREATE TABLE #TEGAM ( opId INT )
	DECLARE @userIdHandle int
	EXEC sp_xml_preparedocument @userIdHandle OUTPUT, @i_userIdList
	-- Get local of report
	if @i_jobId!=0
SET @locId	= dbo.GetOptionInt(1421724997, @i_jobId, 0, 0)
	else
		SET @locId	= IsNull((SELECT localeId FROM OPENXML (@userIdHandle, '/TMMsg_JobOption/adminOpts/reportOption/commonOpt/locale', 0)  WITH (localeId integer)),0)
	-- Get time range for report
	EXEC RptOptGetTime @i_jobId, @startTime OUTPUT, @endTime OUTPUT
	IF	@endTime = 0
		SET	@endTime = dbo.GetUnixTime(GETUTCDATE())
	SELECT	@lastOpId = ISNULL(MAX(opId), 0) FROM EvGuiAuditMessage WHERE locId = @locId
	SELECT  @lastMsgId = evMsgId FROM EvGuiAuditMessage WHERE locId = @locId AND opId = @lastOpId
	-- Retrieve GUI Audit events, default all event to AUDIT_TRAIL_LEVEL_HIGH = 0
    --Ignore GUIAUDIT_OPS_ENTITY_AUDIT
    --Bhushan 11/24/2015
	INSERT INTO #EvGuiAuditMessage
	SELECT	a.id, @locId, a.commcellId, a.userId, a.timeServer, a.messageId, b.id, 0, 2, b.EntityType, b.EntityId, 0, 0, 0, N'', N'', N'',0,0,0
	FROM	EvMsg a inner join EvGuiAuditOperation b on a.id = b.evMsgId and a.type = 2 and b.id > @lastOpId AND a.id > @lastMsgId  AND a.messageId <> 1409286622
	SET @err = @@ERROR
	IF @err <> 0 GOTO END_TRAN
	SELECT	@lastOpIdOperation = ISNULL(MAX(opId), 0) FROM #EvGuiAuditMessage WHERE locId = @locId
    --Ignore GUIAUDIT_PARAMS_ENTITY_AUDIT_NOTE
    --Bhushan 11/24/2015
	INSERT INTO #EvGuiAuditMessage
	SELECT	a.id, @locId, a.commcellId, a.userId, a.timeServer, a.messageId, b.opId, b.id, 2, 0, 0, isnull(b.OldMsgId, 0), isnull(b.NewMsgId, 0), 0, N'', isnull(b.OldValue, N''),isnull(b.NewValue, N''),b.isList,b.listOpType, b.hierarchyLevel
	FROM	EvMsg a inner join EvGuiAuditParameter b on a.id = b.evMsgId and a.type = 2 and b.opId > @lastOpId and b.opId <= @lastOpIdOperation AND a.messageId <> 1426064727
	SET @err = @@ERROR
	CREATE INDEX #EvGuiAuditMessage_opId_idx ON #EvGuiAuditMessage (opId)
	INSERT INTO #tempOpCount
	SELECT	opId, COUNT(*)
	FROM	#EvGuiAuditMessage
	WHERE	msgSpanNum = 0
	GROUP BY opId
	SET @err = @@ERROR
	IF @err <> 0 GOTO END_TRAN
	UPDATE	#EvGuiAuditMessage
	SET		msgSpanNum = b.msgSpanNum
	FROM	#EvGuiAuditMessage a, #tempOpCount b
	WHERE	a.opId = b.opId
	SET @err = @@ERROR
	IF @err <> 0 GOTO END_TRAN
	INSERT INTO #tempOpAuditLevel
	SELECT	a.opId, Max(b.auditLevel)
	FROM	#EvGuiAuditMessage a, EvGuiAuditLevel b
	WHERE	a.messageId = b.opMsgId AND a.messageId > 0
	GROUP BY a.opId
	SET @err = @@ERROR
	IF @err <> 0 GOTO END_TRAN
	UPDATE	#EvGuiAuditMessage
	SET		auditLevel = b.auditLevel
	FROM	#EvGuiAuditMessage a, #tempOpAuditLevel b
	WHERE	a.opId = b.opId AND b.auditLevel > 0
	SET @err = @@ERROR
	IF @err <> 0 GOTO END_TRAN
	UPDATE	#EvGuiAuditMessage
	SET		messageText = ISNULL(DBO.fn_EvFormatEventMsgText(evMsgId, @locId, messageId, 1, 2), '')
	SET @err = @@ERROR
END_TRAN:
	IF @err = 0 AND NOT EXISTS (SELECT 1 FROM EvGuiAuditMessage WHERE locId = @locId AND opId > @lastOpId)
		INSERT INTO EvGuiAuditMessage
		SELECT * FROM #EvGuiAuditMessage
	declare	@include	integer
	set @include = 0
	set @include = (SELECT include FROM OPENXML (@userIdHandle, '/TMMsg_JobOption/adminOpts/reportOption/usersList/flags', 1)
										WITH (include integer))
	declare	@endUserSecurity	integer
	set @endUserSecurity = isnull((SELECT endUserSecurity FROM OPENXML (@userIdHandle, 'TMMsg_JobOption/adminOpts/reportOption/commonOpt', 1)
										WITH (endUserSecurity integer)), 0)
	IF object_ID('tempdb..#EvGuiAuditMessage') IS NOT NULL
		DROP table #EvGuiAuditMessage
	IF object_ID('tempdb..#entitiesWithViewSchedCapability') IS NOT NULL
		DROP table #entitiesWithViewSchedCapability
	IF object_ID('tempdb..#includeOperationId') IS NOT NULL
		DROP table #includeOperationId
	CREATE TABLE #includeOperationId (OpId INT)
create table  #entitiesWithViewSchedCapability ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
    EXEC sec_getUserObjects @userId, 0, 0, '#entitiesWithViewSchedCapability'
	IF object_id('tempdb.dbo.#subTaskList') is not null
			DROP TABLE #subTaskList
	CREATE TABLE #subTaskList (subTaskId INT NOT NULL)
	CREATE CLUSTERED INDEX subTaskList_subTaskId_Index ON #subTaskList (subTaskId)
EXEC sec_getNonIdaObjectsForThisUser @userId, 68, 0, '#subTaskList'
DECLARE @_EV_VIEW					BIGINT = POWER(2, 31-1)
	-- For all subtasks which are explcility associated to user, add their tasks to #entitiesWithViewSchedCapability
	-- Also add all associations for schedules which are shared with this user. Created by tenant admin if the logged in user is part of tenant admin group.
	INSERT INTO #entitiesWithViewSchedCapability(capabilities, TaskId)
	SELECT DISTINCT @_EV_VIEW, TM_Subtask.taskId -- Assign view capabilities to this taskId
	FROM #subTaskList subTaskList
	INNER JOIN TM_Subtask ON TM_Subtask.subtaskId = subTaskList.subtaskId
	DECLARE @xmlOut XML = '<TMMsg_GetTaskListReq>
							  <filter isCalendar="0" policy="1" schedules="1" isWorkflow="1">
								<entity libraryId="0" clientGroupId="0" applicationId="0" clientId="0" subclientId="0" backupsetId="0" instanceId="0" />
								<operationTypes val="0" />
							  </filter>
							</TMMsg_GetTaskListReq>'
	EXEC TM_GetCommCellTaskList @userId,0,@xmlOut OUTPUT
	IF OBJECT_ID('tempdb.dbo.#getUsersForThisUserTbl') IS NOT NULL
		DROP TABLE #getUsersForThisUserTbl
	IF OBJECT_ID('tempdb.dbo.#getUserGroupsForThisUserTbl') IS NOT NULL
		DROP TABLE #getUserGroupsForThisUserTbl
	IF OBJECT_ID('tempdb.dbo.#getUserExtGroupsForThisUserTbl') IS NOT NULL
		DROP TABLE #getUserExtGroupsForThisUserTbl
	create table #getUsersForThisUserTbl (userId INT)
	create table #getUserGroupsForThisUserTbl (userGrpId INT)
	create table #getUserExtGroupsForThisUserTbl (extUserGrpId INT)
IF EXISTS(SELECT * FROM #entitiesWithViewSchedCapability sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
	BEGIN
		IF @i_entityType = 0 OR @i_entityId = 0
			BEGIN
				INSERT INTO #includeOperationId
				SELECT DISTINCT E.Id AS OpId
				FROM EvGuiAuditOperation E
			END
		ELSE
			BEGIN
				INSERT INTO #includeOperationId
				SELECT DISTINCT E.Id AS OpId
				FROM EvGuiAuditOperation E
				WHERE E.EntityType = @i_entityType AND E.EntityId = @i_entityId
			END
	END
	ELSE
	BEGIN
		exec [sec_getUsersForThisUser] '#getUsersForThisUserTbl',@userId
		exec [sec_getUserGroupsForThisUser] '#getUserGroupsForThisUserTbl',@userId,0,1
		exec [sec_getUserGroupsForThisUser] '#getUserExtGroupsForThisUserTbl',@userId,0,2
		IF @i_entityType = 0 OR @i_entityId = 0
			BEGIN
				INSERT INTO #includeOperationId
				SELECT DISTINCT E.opId
				FROM (
				SELECT E.Id AS OpId
				FROM EvGuiAuditOperation E INNER JOIN #entitiesWithViewSchedCapability U
				ON E.entityType > 0
						 AND (clientGroupId = 0 OR (clientGroupId = entityId AND entityType = 28))					-- CLIENT_GROUP_ENTITY  (Common/XMLMessage/CvEntities.x)
						 AND clientId = 0
						 AND appTypeId = 0
						 AND instanceId = 0
						 AND backupsetId = 0
						 AND subClientId = 0
						 AND (mediaAgentId = 0 OR (mediaAgentId = entityId AND entityType = 11))					-- 2048
						 AND (libraryId = 0 OR (libraryId = entityId AND entityType = 9))							-- 2049
						 AND (archGroupId = 0 OR (archGroupId = entityId AND entityType = 17))						-- 2231
						 AND (vtPolicyId = 0 OR (vtPolicyId = entityId AND entityType = 21))						-- 8462
						 AND (vtcontainerId = 0 OR (vtcontainerId = entityId AND entityType = 130))					-- 8107
						 AND (vtShelfId = 0 OR (vtShelfId = entityId AND entityType = 57))							-- 8180
						 AND (reviewSetId = 0 OR (arrayId = entityId AND entityType = 9501))						-- 9501
						 AND (querySetId = 0 OR (querySetId = entityId AND entityType = 9502))						-- 9502
						 AND (downloadSetId = 0 OR (downloadSetId = entityId AND entityType = 9503))				-- 9503
						 AND (tagId = 0 OR (tagId = entityId AND entityType = 9504))								-- 9504
						 AND (legalHoldId = 0 OR (legalHoldId = entityId AND entityType = 9505))					-- 9505
						 AND (ermId = 0 OR (ermId = entityId AND entityType = 9506))								-- 9506
						 AND (cdPolicyId = 0 OR (cdPolicyId = entityId AND entityType = 9507))						-- 9507
						 AND (complianceReportId = 0 OR (complianceReportId = entityId AND entityType = 9508))		-- 9508
						 AND (taskId = 0 OR (taskId = entityId AND entityType = 35))								-- 4300 4300 SCHEDULE_POLICY_ENTITY = 35,
						 AND (workflowId=0 OR (workflowId = entityId AND entityType = 83))							-- 14033 14033
						 AND (logMonitoringPolicyId=0 OR (logMonitoringPolicyId = entityId AND entityType = 90))	-- 9646 9641
						 AND arrayId = 0
						 AND cloudId=0
						 AND userGroupId=0
						 AND providerId=0
						 AND entityId1=0
						 AND entityId2=0
						 AND entityId3=0
						 AND entityId4=0
						 AND entityId5=0
						 AND entityId6=0
						 AND entityId7=0
						 AND entityId8=0
						 AND entityId9=0
				UNION
				SELECT E.Id AS OpId
				FROM EvGuiAuditOperation E
					 INNER JOIN ( SELECT U.commcellId, ACG.clientGroupId, APP.clientId, App.instance AS instanceId, App.apptypeId, App.backupSet AS backupSetId, APP.id AS subclientId
													FROM #entitiesWithViewSchedCapability U INNER JOIN App_ClientGroupAssoc ACG
													ON U.clientGroupId <> 0 AND U.clientGroupId = ACG.clientGroupId
													   AND U.clientId = 0
													   AND appTypeId = 0
													   AND instanceId = 0
													   AND backupsetId = 0
													   AND subClientId = 0
													   AND mediaAgentId = 0
													   AND libraryId = 0
													   AND archGroupId = 0
													   AND vtPolicyId = 0
													   AND vtcontainerId = 0
													   AND vtShelfId = 0
													   AND reviewSetId = 0
													   AND querySetId = 0
													   AND downloadSetId = 0
													   AND tagId = 0
													   AND legalHoldId = 0
													   AND ermId = 0
													   AND cdPolicyId = 0
													   AND complianceReportId = 0
													   AND taskId = 0
													   AND workflowId=0
													   AND logMonitoringPolicyId=0
													   AND arrayId = 0
													   AND cloudId=0
													   AND userGroupId=0
													   AND providerId=0
													   AND entityId1=0
													   AND entityId2=0
													   AND entityId3=0
													   AND entityId4=0
													   AND entityId5=0
													   AND entityId6=0
													   AND entityId7=0
													   AND entityId8=0
													   AND entityId9=0
												INNER JOIN App_Application APP ON App.clientId = ACG.clientId
									UNION -- following case to handle pseudo clients as their id won't be present in app_application table
									SELECT U.commcellId, ACG.clientGroupId, AC.Id AS clientId, 0 AS instanceId, 0 AS apptypeId, 0 AS backupSetId, 0 AS subclientId
													FROM #entitiesWithViewSchedCapability U INNER JOIN App_ClientGroupAssoc ACG
													ON U.clientGroupId <> 0 AND U.clientGroupId = ACG.clientGroupId
													   AND U.clientId = 0
													   AND appTypeId = 0
													   AND instanceId = 0
													   AND backupsetId = 0
													   AND subClientId = 0
													   AND mediaAgentId = 0
													   AND libraryId = 0
													   AND archGroupId = 0
													   AND vtPolicyId = 0
													   AND vtcontainerId = 0
													   AND vtShelfId = 0
													   AND reviewSetId = 0
													   AND querySetId = 0
													   AND downloadSetId = 0
													   AND tagId = 0
													   AND legalHoldId = 0
													   AND ermId = 0
													   AND cdPolicyId = 0
													   AND complianceReportId = 0
													   AND taskId = 0
													   AND workflowId=0
													   AND logMonitoringPolicyId=0
													   AND arrayId = 0
													   AND cloudId=0
													   AND userGroupId=0
													   AND providerId=0
													   AND entityId1=0
													   AND entityId2=0
													   AND entityId3=0
													   AND entityId4=0
													   AND entityId5=0
													   AND entityId6=0
													   AND entityId7=0
													   AND entityId8=0
													   AND entityId9=0
												INNER JOIN (SELECT CL.* FROM App_Client CL LEFT OUTER JOIN App_Application APP ON CL.id = APP.clientId WHERE APP.clientId IS NULL ) AC
													ON AC.Id = ACG.clientId
												) U
				ON E.entityType > 0 AND ((clientId = entityId AND entityType = 3)
								OR (appTypeId = entityId AND entityType = 4)
								OR (instanceId = entityId AND entityType = 5)
								OR (backupsetId = entityId AND entityType = 6)
								OR (subClientId = entityId AND entityType = 7)
						 )
				UNION
				SELECT E.Id AS OpId
				FROM EvGuiAuditOperation E
					 INNER JOIN ( SELECT U.commcellId, APP.clientId, App.instance AS instanceId, App.apptypeId, App.backupSet AS backupSetId, APP.id AS subclientId
													FROM #entitiesWithViewSchedCapability U INNER JOIN App_Application APP
													ON U.clientGroupId = 0
													   AND (U.clientId <> 0 AND U.clientId = APP.clientId)
													   AND (U.appTypeId = 0 OR U.appTypeId = APP.appTypeId)
													   AND (U.instanceId = 0 OR U.instanceId = APP.instance)
													   AND (U.backupsetId = 0 OR U.backupsetId = APP.backupset)
													   AND (U.subClientId = 0 OR U.subClientId = APP.id)
													   AND mediaAgentId = 0
													   AND libraryId = 0
													   AND archGroupId = 0
													   AND vtPolicyId = 0
													   AND vtcontainerId = 0
													   AND vtShelfId = 0
													   AND reviewSetId = 0
													   AND querySetId = 0
													   AND downloadSetId = 0
													   AND tagId = 0
													   AND legalHoldId = 0
													   AND ermId = 0
													   AND cdPolicyId = 0
													   AND complianceReportId = 0
													   AND taskId = 0
													   AND workflowId=0
													   AND logMonitoringPolicyId=0
													   AND arrayId = 0
													   AND cloudId=0
													   AND userGroupId=0
													   AND providerId=0
													   AND entityId1=0
													   AND entityId2=0
													   AND entityId3=0
													   AND entityId4=0
													   AND entityId5=0
													   AND entityId6=0
													   AND entityId7=0
													   AND entityId8=0
													   AND entityId9=0
									UNION -- following case to handle pseudo clients as their id won't be present in app_application table
									SELECT U.commcellId, AC.Id AS clientId, 0 AS instanceId, 0 AS apptypeId, 0 AS backupSetId, 0 AS subclientId
													FROM #entitiesWithViewSchedCapability U
													INNER JOIN (SELECT CL.* FROM App_Client CL LEFT OUTER JOIN App_Application APP ON CL.id = APP.clientId WHERE APP.clientId IS NULL ) AC
													ON U.clientGroupId = 0
													   AND (U.clientId <> 0 AND U.clientId = AC.Id)
													   AND U.appTypeId = 0
													   AND U.instanceId = 0
													   AND U.backupsetId = 0
													   AND U.subClientId = 0
													   AND mediaAgentId = 0
													   AND libraryId = 0
													   AND archGroupId = 0
													   AND vtPolicyId = 0
													   AND vtcontainerId = 0
													   AND vtShelfId = 0
													   AND reviewSetId = 0
													   AND querySetId = 0
													   AND downloadSetId = 0
													   AND tagId = 0
													   AND legalHoldId = 0
													   AND ermId = 0
													   AND cdPolicyId = 0
													   AND complianceReportId = 0
													   AND taskId = 0
													   AND workflowId=0
													   AND logMonitoringPolicyId=0
													   AND arrayId = 0
													   AND cloudId=0
													   AND userGroupId=0
													   AND providerId=0
													   AND entityId1=0
													   AND entityId2=0
													   AND entityId3=0
													   AND entityId4=0
													   AND entityId5=0
													   AND entityId6=0
													   AND entityId7=0
													   AND entityId8=0
													   AND entityId9=0
												) U
				ON E.entityType > 0 AND ((clientId = entityId AND entityType = 3)
								OR (appTypeId = entityId AND entityType = 4)
								OR (instanceId = entityId AND entityType = 5)
								OR (backupsetId = entityId AND entityType = 6)
								OR (subClientId = entityId AND entityType = 7)
						 )
				UNION
				SELECT E.Id AS OpId
				FROM EvGuiAuditOperation E
					INNER JOIN #getUsersForThisUserTbl U
						ON E.entityType > 0
							AND entityType = 13 AND U.userId = E.entityId
				UNION
				SELECT E.Id AS OpId
				FROM EvGuiAuditOperation E
					INNER JOIN #getUserGroupsForThisUserTbl  U
						ON E.entityType > 0
							AND entityType = 15 AND U.userGrpId  = E.entityId
				UNION
				SELECT E.Id AS OpId
				FROM EvGuiAuditOperation E
					INNER JOIN #getUserExtGroupsForThisUserTbl  U
						ON E.entityType > 0
							AND entityType = 62 AND U.extUserGrpId = E.entityId
				UNION
				SELECT E.Id AS OpId
				FROM EvGuiAuditOperation E
					INNER JOIN @xmlOut.nodes('/TMMsg_GetTaskListResp/taskDetail') S(n)
						ON E.entityType = 35														-- SCHEDULE_POLICY_ENTITY : 35
							AND E.entityId = S.n.value('(task)[1]/@taskId','INT') AND S.n.exist('subTasks') = 1
				UNION
				SELECT E.id AS OpId FROM EvGuiAuditOperation E
INNER JOIN MMMountpath MP ON E.entityId = MP.MountPathId AND E.EntityType = 52
					 INNER JOIN #entitiesWithViewSchedCapability  U ON U.libraryId = MP.libraryId
				UNION
				SELECT E.id AS OpId FROM EvGuiAuditOperation E
INNER JOIN archGroupCopy AGC ON E.entityId = AGC.id AND E.EntityType = 18
					 INNER JOIN #entitiesWithViewSchedCapability U ON U.archGroupId = AGC.archGroupId
				UNION
				SELECT E.id AS OpId FROM EvGuiAuditOperation E
INNER JOIN archCopySIDBStore ACS ON E.entityId = ACS.SIDBStoreId AND E.EntityType = 115
					 INNER JOIN archGroupCopy AGC ON AGC.id = ACS.CopyId
					 INNER JOIN #entitiesWithViewSchedCapability U ON U.archGroupId = AGC.archGroupId
				UNION
				SELECT E.Id AS OpId
				FROM EvGuiAuditOperation E
					WHERE E.entityType <= 0
				) E
			END
		ELSE
			BEGIN
			INSERT INTO #includeOperationId
				SELECT DISTINCT E.opId
				FROM (
				SELECT E.Id AS OpId
				FROM EvGuiAuditOperation E INNER JOIN #entitiesWithViewSchedCapability U
				ON E.entityType > 0
						 AND (clientGroupId = 0 OR (clientGroupId = entityId AND entityType = 28))					-- CLIENT_GROUP_ENTITY  (Common/XMLMessage/CvEntities.x)
						 AND clientId = 0
						 AND appTypeId = 0
						 AND instanceId = 0
						 AND backupsetId = 0
						 AND subClientId = 0
						 AND (mediaAgentId = 0 OR (mediaAgentId = entityId AND entityType = 11))					-- 2048
						 AND (libraryId = 0 OR (libraryId = entityId AND entityType = 9))							-- 2049
						 AND (archGroupId = 0 OR (archGroupId = entityId AND entityType = 17))						-- 2231
						 AND (vtPolicyId = 0 OR (vtPolicyId = entityId AND entityType = 21))						-- 8462
						 AND (vtcontainerId = 0 OR (vtcontainerId = entityId AND entityType = 130))					-- 8107
						 AND (vtShelfId = 0 OR (vtShelfId = entityId AND entityType = 57))							-- 8180
						 AND (reviewSetId = 0 OR (arrayId = entityId AND entityType = 9501))						-- 9501
						 AND (querySetId = 0 OR (querySetId = entityId AND entityType = 9502))						-- 9502
						 AND (downloadSetId = 0 OR (downloadSetId = entityId AND entityType = 9503))				-- 9503
						 AND (tagId = 0 OR (tagId = entityId AND entityType = 9504))								-- 9504
						 AND (legalHoldId = 0 OR (legalHoldId = entityId AND entityType = 9505))					-- 9505
						 AND (ermId = 0 OR (ermId = entityId AND entityType = 9506))								-- 9506
						 AND (cdPolicyId = 0 OR (cdPolicyId = entityId AND entityType = 9507))						-- 9507
						 AND (complianceReportId = 0 OR (complianceReportId = entityId AND entityType = 9508))		-- 9508
						 AND (taskId = 0 OR (taskId = entityId AND entityType = 35))								-- 4300 4300 SCHEDULE_POLICY_ENTITY = 35,
						 AND (workflowId=0 OR (workflowId = entityId AND entityType = 83))							-- 14033 14033
						 AND (logMonitoringPolicyId=0 OR (logMonitoringPolicyId = entityId AND entityType = 90))	-- 9646 9641
						 AND arrayId = 0
						 AND cloudId=0
						 AND userGroupId=0
						 AND providerId=0
						 AND entityId1=0
						 AND entityId2=0
						 AND entityId3=0
						 AND entityId4=0
						 AND entityId5=0
						 AND entityId6=0
						 AND entityId7=0
						 AND entityId8=0
						 AND entityId9=0
						 AND E.EntityType = @i_entityType
						 AND E.EntityId = @i_entityId
				UNION
				SELECT E.Id AS OpId
				FROM EvGuiAuditOperation E
					 INNER JOIN ( SELECT U.commcellId, ACG.clientGroupId, APP.clientId, App.instance AS instanceId, App.apptypeId, App.backupSet AS backupSetId, APP.id AS subclientId
													FROM #entitiesWithViewSchedCapability U INNER JOIN App_ClientGroupAssoc ACG
													ON U.clientGroupId <> 0 AND U.clientGroupId = ACG.clientGroupId
													   AND U.clientId = 0
													   AND appTypeId = 0
													   AND instanceId = 0
													   AND backupsetId = 0
													   AND subClientId = 0
													   AND mediaAgentId = 0
													   AND libraryId = 0
													   AND archGroupId = 0
													   AND vtPolicyId = 0
													   AND vtcontainerId = 0
													   AND vtShelfId = 0
													   AND reviewSetId = 0
													   AND querySetId = 0
													   AND downloadSetId = 0
													   AND tagId = 0
													   AND legalHoldId = 0
													   AND ermId = 0
													   AND cdPolicyId = 0
													   AND complianceReportId = 0
													   AND taskId = 0
													   AND workflowId=0
													   AND logMonitoringPolicyId=0
													   AND arrayId = 0
													   AND cloudId=0
													   AND userGroupId=0
													   AND providerId=0
													   AND entityId1=0
													   AND entityId2=0
													   AND entityId3=0
													   AND entityId4=0
													   AND entityId5=0
													   AND entityId6=0
													   AND entityId7=0
													   AND entityId8=0
													   AND entityId9=0
												INNER JOIN App_Application APP ON App.clientId = ACG.clientId
									UNION -- following case to handle pseudo clients as their id won't be present in app_application table
									SELECT U.commcellId, ACG.clientGroupId, AC.Id AS clientId, 0 AS instanceId, 0 AS apptypeId, 0 AS backupSetId, 0 AS subclientId
													FROM #entitiesWithViewSchedCapability U INNER JOIN App_ClientGroupAssoc ACG
													ON U.clientGroupId <> 0 AND U.clientGroupId = ACG.clientGroupId
													   AND U.clientId = 0
													   AND appTypeId = 0
													   AND instanceId = 0
													   AND backupsetId = 0
													   AND subClientId = 0
													   AND mediaAgentId = 0
													   AND libraryId = 0
													   AND archGroupId = 0
													   AND vtPolicyId = 0
													   AND vtcontainerId = 0
													   AND vtShelfId = 0
													   AND reviewSetId = 0
													   AND querySetId = 0
													   AND downloadSetId = 0
													   AND tagId = 0
													   AND legalHoldId = 0
													   AND ermId = 0
													   AND cdPolicyId = 0
													   AND complianceReportId = 0
													   AND taskId = 0
													   AND workflowId=0
													   AND logMonitoringPolicyId=0
													   AND arrayId = 0
													   AND cloudId=0
													   AND userGroupId=0
													   AND providerId=0
													   AND entityId1=0
													   AND entityId2=0
													   AND entityId3=0
													   AND entityId4=0
													   AND entityId5=0
													   AND entityId6=0
													   AND entityId7=0
													   AND entityId8=0
													   AND entityId9=0
												INNER JOIN (SELECT CL.* FROM App_Client CL LEFT OUTER JOIN App_Application APP ON CL.id = APP.clientId WHERE APP.clientId IS NULL ) AC
													ON AC.Id = ACG.clientId
												) U
				ON E.entityType > 0 AND ((clientId = entityId AND entityType = 3)
								OR (appTypeId = entityId AND entityType = 4)
								OR (instanceId = entityId AND entityType = 5)
								OR (backupsetId = entityId AND entityType = 6)
								OR (subClientId = entityId AND entityType = 7)
						 )
					AND E.EntityType = @i_entityType
					AND E.EntityId = @i_entityId
				UNION
				SELECT E.Id AS OpId
				FROM EvGuiAuditOperation E
					 INNER JOIN ( SELECT U.commcellId, APP.clientId, App.instance AS instanceId, App.apptypeId, App.backupSet AS backupSetId, APP.id AS subclientId
													FROM #entitiesWithViewSchedCapability U INNER JOIN App_Application APP
													ON U.clientGroupId = 0
													   AND (U.clientId <> 0 AND U.clientId = APP.clientId)
													   AND (U.appTypeId = 0 OR U.appTypeId = APP.appTypeId)
													   AND (U.instanceId = 0 OR U.instanceId = APP.instance)
													   AND (U.backupsetId = 0 OR U.backupsetId = APP.backupset)
													   AND (U.subClientId = 0 OR U.subClientId = APP.id)
													   AND mediaAgentId = 0
													   AND libraryId = 0
													   AND archGroupId = 0
													   AND vtPolicyId = 0
													   AND vtcontainerId = 0
													   AND vtShelfId = 0
													   AND reviewSetId = 0
													   AND querySetId = 0
													   AND downloadSetId = 0
													   AND tagId = 0
													   AND legalHoldId = 0
													   AND ermId = 0
													   AND cdPolicyId = 0
													   AND complianceReportId = 0
													   AND taskId = 0
													   AND workflowId=0
													   AND logMonitoringPolicyId=0
													   AND arrayId = 0
													   AND cloudId=0
													   AND userGroupId=0
													   AND providerId=0
													   AND entityId1=0
													   AND entityId2=0
													   AND entityId3=0
													   AND entityId4=0
													   AND entityId5=0
													   AND entityId6=0
													   AND entityId7=0
													   AND entityId8=0
													   AND entityId9=0
									UNION -- following case to handle pseudo clients as their id won't be present in app_application table
									SELECT U.commcellId, AC.Id AS clientId, 0 AS instanceId, 0 AS apptypeId, 0 AS backupSetId, 0 AS subclientId
													FROM #entitiesWithViewSchedCapability U
													INNER JOIN (SELECT CL.* FROM App_Client CL LEFT OUTER JOIN App_Application APP ON CL.id = APP.clientId WHERE APP.clientId IS NULL ) AC
													ON U.clientGroupId = 0
													   AND (U.clientId <> 0 AND U.clientId = AC.Id)
													   AND U.appTypeId = 0
													   AND U.instanceId = 0
													   AND U.backupsetId = 0
													   AND U.subClientId = 0
													   AND mediaAgentId = 0
													   AND libraryId = 0
													   AND archGroupId = 0
													   AND vtPolicyId = 0
													   AND vtcontainerId = 0
													   AND vtShelfId = 0
													   AND reviewSetId = 0
													   AND querySetId = 0
													   AND downloadSetId = 0
													   AND tagId = 0
													   AND legalHoldId = 0
													   AND ermId = 0
													   AND cdPolicyId = 0
													   AND complianceReportId = 0
													   AND taskId = 0
													   AND workflowId=0
													   AND logMonitoringPolicyId=0
													   AND arrayId = 0
													   AND cloudId=0
													   AND userGroupId=0
													   AND providerId=0
													   AND entityId1=0
													   AND entityId2=0
													   AND entityId3=0
													   AND entityId4=0
													   AND entityId5=0
													   AND entityId6=0
													   AND entityId7=0
													   AND entityId8=0
													   AND entityId9=0
												) U
				ON E.entityType > 0 AND ((clientId = entityId AND entityType = 3)
								OR (appTypeId = entityId AND entityType = 4)
								OR (instanceId = entityId AND entityType = 5)
								OR (backupsetId = entityId AND entityType = 6)
								OR (subClientId = entityId AND entityType = 7)
						 )
					AND E.EntityType = @i_entityType
					AND E.EntityId = @i_entityId
				UNION
				SELECT E.Id AS OpId
				FROM EvGuiAuditOperation E
					INNER JOIN #getUsersForThisUserTbl U
						ON E.entityType > 0
							AND entityType = 13 AND U.userId = E.entityId
							AND E.EntityType = @i_entityType
							AND E.EntityId = @i_entityId
				UNION
				SELECT E.Id AS OpId
				FROM EvGuiAuditOperation E
					INNER JOIN #getUserGroupsForThisUserTbl  U
						ON E.entityType > 0
							AND entityType = 15 AND U.userGrpId  = E.entityId
							AND E.EntityType = @i_entityType
							AND E.EntityId = @i_entityId
				UNION
				SELECT E.Id AS OpId
				FROM EvGuiAuditOperation E
					INNER JOIN #getUserExtGroupsForThisUserTbl  U
						ON E.entityType > 0
							AND entityType = 62 AND U.extUserGrpId = E.entityId
							AND E.EntityType = @i_entityType
							AND E.EntityId = @i_entityId
				UNION
				SELECT E.Id AS OpId
				FROM EvGuiAuditOperation E
					INNER JOIN @xmlOut.nodes('/TMMsg_GetTaskListResp/taskDetail') S(n)
						ON E.entityType = 35														-- SCHEDULE_POLICY_ENTITY : 35
							AND E.entityId = S.n.value('(task)[1]/@taskId','INT') AND S.n.exist('subTasks') = 1
							AND E.EntityType = @i_entityType
							AND E.EntityId = @i_entityId
				UNION
				SELECT E.Id AS OpId
				FROM EvGuiAuditOperation E
					WHERE E.entityType <= 0
					AND E.EntityType = @i_entityType
					AND E.EntityId = @i_entityId
				) E
			END
	END
	IF object_ID('tempdb..#entitiesWithViewSchedCapability') IS NOT NULL
		DROP table #entitiesWithViewSchedCapability
	if (@include = 1)
	begin
		if (@s_searchString!='')
		begin
			INSERT INTO #TEGAM
			SELECT distinct E.opId
			FROM  EvGuiAuditMessage E INNER JOIN #includeOperationId O ON E.opId  = O.OpId
			WHERE messageText LIKE @s_searchString OR E.oldValue LIKE @s_searchString OR E.newValue LIKE @s_searchString
			insert into #finalResult
			select E.evMsgId,E.locId,E.commcellId,E.userId,E.timeServer,E.messageId,E.opId,E.paramId,E.auditLevel,E.entityType,E.entityId,E.oldMsgId,E.newMsgId,E.msgSpanNum,E.isList, E.listOpType , E.hierarchyLevel, E.messageText,E.oldValue,
			E.newValue
			from  EvGuiAuditMessage  E
			JOIN #TEGAM on E.opId=#TEGAM.opId
			WHERE	auditLevel <= @i_auditLevel
			and locId = @locId
			and timeServer BETWEEN @startTime AND @endTime
			and (@i_guiAuditOperationId <= 0 OR @i_guiAuditOperationId = E.opId)
			ORDER	BY E.opId desc, paramId asc
		end
		else
		begin
			insert into #finalResult
			select E.evMsgId,E.locId,E.commcellId,E.userId,E.timeServer,E.messageId,E.opId,E.paramId,E.auditLevel,E.entityType,E.entityId,E.oldMsgId,E.newMsgId,E.msgSpanNum,E.isList, E.listOpType , E.hierarchyLevel, E.messageText,E.oldValue,
			E.newValue
			 from  EvGuiAuditMessage E INNER JOIN #includeOperationId O ON E.opId  = O.OpId
			AND	E.auditLevel <= @i_auditLevel
			and E.locId = @locId
			and E.timeServer BETWEEN @startTime AND @endTime
			and (@i_guiAuditOperationId <= 0 OR @i_guiAuditOperationId = E.opId)
			ORDER	BY E.opId desc, E.paramId asc
		end
	end
	else
	begin
		DECLARE @userIdTbl TABLE (id INT)
		DECLARE	@userCount INT
		INSERT	INTO @userIdTbl
		SELECT	userId FROM OPENXML (@userIdHandle, '/TMMsg_JobOption/adminOpts/reportOption/usersList', 1)
				WITH (userId integer)
		UNION
		SELECT	userId FROM UMUserGroup
		WHERE	groupid IN (SELECT userGroupId FROM OPENXML (@userIdHandle, '/TMMsg_JobOption/adminOpts/reportOption/galaxyUserGroups', 1)
				WITH (userGroupId integer))
		UNION
		SELECT	userId FROM UMDSUserGroup
		WHERE	groupid IN (SELECT userGroupId FROM OPENXML (@userIdHandle, '/TMMsg_JobOption/adminOpts/reportOption/externalUserGroups', 1)
				WITH (userGroupId integer))
		IF (EXISTS (SELECT userId FROM OPENXML (@userIdHandle, '/TMMsg_JobOption/adminOpts/reportOption/usersList', 1) WITH (userId integer)) OR
			EXISTS (SELECT userGroupId FROM OPENXML (@userIdHandle, '/TMMsg_JobOption/adminOpts/reportOption/galaxyUserGroups', 1) WITH (userGroupId integer)) OR
			EXISTS (SELECT userGroupId FROM OPENXML (@userIdHandle, '/TMMsg_JobOption/adminOpts/reportOption/externalUserGroups', 1) WITH (userGroupId integer)))
			SET @userCount = 1
		ELSE
			SET @userCount = 0
		if (@s_searchString!='')
		begin
	    	INSERT INTO #TEGAM
			SELECT distinct E.opId
			FROM EvGuiAuditMessage E INNER JOIN #includeOperationId O ON E.opId  = O.OpId
			WHERE messageText LIKE @s_searchString OR E.oldValue LIKE @s_searchString OR E.newValue LIKE @s_searchString
			insert into #finalResult
			select E.evMsgId,E.locId,E.commcellId,E.userId,E.timeServer,E.messageId,E.opId,E.paramId,E.auditLevel,E.entityType,E.entityId,E.oldMsgId,E.newMsgId,E.msgSpanNum,E.isList, E.listOpType ,E.hierarchyLevel, E.messageText,E.oldValue,
			E.newValue
			from  EvGuiAuditMessage E INNER JOIN #includeOperationId O ON E.opId  = O.OpId
			JOIN #TEGAM on E.opId=#TEGAM.opId
		WHERE	auditLevel <= @i_auditLevel AND (userId in (SELECT id FROM @userIdTbl) OR @userCount = 0)
			and locId = @locId
			and timeServer BETWEEN @startTime AND @endTime
			and (@i_guiAuditOperationId <= 0 OR @i_guiAuditOperationId = E.opId)
			ORDER	BY E.opId desc, paramId asc
		end
		else
		begin
			insert into #finalResult
			select E.evMsgId,E.locId,E.commcellId,E.userId,E.timeServer,E.messageId,E.opId,E.paramId,E.auditLevel,E.entityType,E.entityId,E.oldMsgId,E.newMsgId,E.msgSpanNum,E.isList, E.listOpType , E.hierarchyLevel, E.messageText,E.oldValue,
			E.newValue
			 from   EvGuiAuditMessage E INNER JOIN #includeOperationId O ON E.opId  = O.OpId
			and	auditLevel <= @i_auditLevel AND (userId in (SELECT id FROM @userIdTbl) OR @userCount = 0)
			and locId = @locId
			and timeServer BETWEEN @startTime AND @endTime
			and (@i_guiAuditOperationId <= 0 OR @i_guiAuditOperationId = E.opId)
			ORDER	BY E.opId desc, paramId asc
		end
	end
	--if "end user security" is disabled
	if @endUserSecurity = 0
	begin
		select * from #finalResult
		ORDER BY opId desc, paramId asc
	end
	else
	begin
		declare @isUserAdmin int
		EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
		--if the user is admin
		if @isUserAdmin != 0
		begin
			select * from #finalResult
			ORDER BY opId desc, paramId asc
		end
		else
		begin
			IF OBJECT_ID('tempdb.dbo.#U4EndUserSecurity') IS NOT NULL
				DROP TABLE #U4EndUserSecurity
			IF OBJECT_ID('tempdb.dbo.#G4EndUserSecurity') IS NOT NULL
				DROP TABLE #G4EndUserSecurity
			create table #U4EndUserSecurity (userId INT)
			create table #G4EndUserSecurity (userGrpId INT)
			declare @umlogin varchar(max) = ''
			select @umlogin=login from umusers where id = @userid
			declare  @xmlinput XML  = '<Api_GetAllCreatedUsersAndGroupsRequest>
			  <processinginstructioninfo>
				<user userId="'+cast(@userid as varchar(max))+'" userName="'+@umlogin+'" />
				<locale _type_="66" localeId="0" />
				<formatFlags continueOnError="0" elementBased="0" filterUnInitializedFields="0" formatted="0" ignoreUnknownTags="1" skipIdToNameConversion="1" skipNameToIdConversion="0" />
			  </processinginstructioninfo>
			</Api_GetAllCreatedUsersAndGroupsRequest>'
			DECLARE @outputUG TABLE
			(
				value xml
			)
			insert into @outputUG
			exec sec_getAllCreatedUsersAndGroups @xmlinput
			insert into #U4EndUserSecurity
			SELECT distinct T.record.value('./@userId','int')
			FROM   @outputUG
			CROSS APPLY value.nodes('/Api_GetAllCreatedUsersAndGroupsResponse/users/associatedUserOrUserGroup') as T(record)
			insert into #G4EndUserSecurity
			SELECT distinct T.record.value('./@userGroupId','int')
			FROM   @outputUG
			CROSS APPLY value.nodes('/Api_GetAllCreatedUsersAndGroupsResponse/userGroups/associatedUserOrUserGroup') as T(record)
			insert into #userFilter
			select * from #U4EndUserSecurity
			union
			SELECT	A.userId FROM UMUserGroup as A
			inner join #G4EndUserSecurity as B
			on A.groupid = B.userGrpId
			union
			SELECT	A.userId FROM UMDSUserGroup as A
			inner join #G4EndUserSecurity as B
			on A.groupid = B.userGrpId
			select A.* from #finalResult as A
			inner join #userFilter as B
			on A.userId = B.userId
			ORDER BY A.opId desc, A.paramId asc
			IF OBJECT_ID('tempdb.dbo.#U4EndUserSecurity') IS NOT NULL
				DROP TABLE #U4EndUserSecurity
			IF OBJECT_ID('tempdb.dbo.#G4EndUserSecurity') IS NOT NULL
				DROP TABLE #G4EndUserSecurity
		end
	end
	IF object_ID('tempdb..#finalResult') IS NOT NULL
		DROP table #finalResult
	IF object_ID('tempdb..#userFilter') IS NOT NULL
	begin
		DROP table #userFilter
	end
	IF object_ID('tempdb..#includeOperationId') IS NOT NULL
		DROP table #includeOperationId
	IF OBJECT_ID('tempdb.dbo.#getUsersForThisUserTbl') IS NOT NULL
		DROP TABLE #getUsersForThisUserTbl
	IF OBJECT_ID('tempdb.dbo.#getUserGroupsForThisUserTbl') IS NOT NULL
		DROP TABLE #getUserGroupsForThisUserTbl
	IF OBJECT_ID('tempdb.dbo.#getUserExtGroupsForThisUserTbl') IS NOT NULL
		DROP TABLE #getUserExtGroupsForThisUserTbl
 	IF object_id('tempdb.dbo.#tempOpCount') IS NOT NULL DROP TABLE #tempOpCount
	IF object_id('tempdb.dbo.#tempOpAuditLevel') IS NOT NULL DROP TABLE #tempOpAuditLevel
    IF OBJECT_ID('tempdb.dbo.#TEGAM') IS NOT NULL DROP TABLE #TEGAM
	IF object_id('tempdb.dbo.#subTaskList') is not null
			DROP TABLE #subTaskList
GO

IF EXISTS (select * from GxQscripts where name = 'EvGuiAuditGetMsg')
	delete from GxQscripts where name = 'EvGuiAuditGetMsg'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvGuiAuditGetMsg')
	delete from GXDBVersions where aliasname = 'EvGuiAuditGetMsg'
GO

insert into GXDBVersions values(2, 'EvGuiAuditGetMsg',  '00010057000200140000', 'EvGuiAuditGetMsg', '00010057000200140000')
GO

