

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EvGuiAuditGeneric.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/EvGuiAuditGeneric.sp,v $ $Id: EvGuiAuditGeneric.sp,v 1.1.2.2 2018/03/22 00:58:15 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: EvGUIAuditGeneric <<<'

IF EXISTS (select * from sysobjects where name='EvGUIAuditGeneric')
	drop procedure EvGUIAuditGeneric
IF EXISTS (select * from GxQscripts where name='EvGUIAuditGeneric')
	delete from GxQscripts where name = 'EvGUIAuditGeneric'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvGUIAuditGeneric')
	delete from GXDBVersions where aliasname = 'EvGUIAuditGeneric'
GO
print '... Creating Procedure: EvGUIAuditGeneric'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EvGUIAuditGeneric
  @i_xml XML
AS
SET NOCOUNT ON
-- This stored procedure can be used to do GUI audits. It uses the following structures:
-- Api::SetAuditRequest
-- App::AuditEvMessageContainerXML
-- App::AuditArgumentInfoXML
-- By using these structures, the logic is designed to be generic
-- We can always use the stringArg in the AuditArgumentInfoXML structure
-- and set the type to 11 (EA_STRING) when an event message id is passed as agument
-- we can set the type to 5 (EA_EVENT_ID)
-- Declare temp variables for Gui Audit
DECLARE @operationId INTEGER
DECLARE @userId INTEGER
DECLARE @auditParam XML
DECLARE @argInfo XML
DECLARE @opEvMsgId INTEGER
DECLARE @opId INTEGER
DECLARE @dataIsEvent INTEGER
DECLARE @stringArg NVARCHAR(MAX)
DECLARE @paramMsgId INTEGER
DECLARE @longLongArg NVARCHAR(MAX)
DECLARE @paramType INTEGER
DECLARE @tmp_guiAuditParams TABLE (paramRow XML)
SET @dataIsEvent = 0
-- Retrieve operationId and userId
SET @operationId = (SELECT PARAMS.value('(@operationId)[1]', 'int') FROM @i_xml.nodes('/Api_SetAuditRequest') as AUDITREQ(PARAMS))
SET @userId = (SELECT PARAMS.value('(@userId)[1]', 'int') FROM @i_xml.nodes('/Api_SetAuditRequest') as AUDITREQ(PARAMS))
-- INSERT the GUI Operation
EXEC EvGuiAuditSetOperation @operationId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
-- Create a temp table of the Audit Params to loop through
INSERT INTO @tmp_guiAuditParams
SELECT PARAMS.query('.') FROM @i_xml.nodes('/Api_SetAuditRequest/auditXml/guiParam') AS AUDITREQ(PARAMS);
-- Loop through the params
DECLARE PARAMCURSOR CURSOR READ_ONLY
FOR
SELECT paramRow FROM @tmp_guiAuditParams
OPEN PARAMCURSOR
FETCH NEXT FROM PARAMCURSOR INTO @auditParam
WHILE @@FETCH_STATUS = 0
BEGIN
	-- If the param has one or more arguments, loop through them
	IF EXISTS (SELECT PARAMINFO.query('.') FROM @auditParam.nodes('/guiParam/ai') AS P(PARAMINFO))
	BEGIN
		DECLARE ARGCURSOR CURSOR READ_ONLY
		FOR
		SELECT PARAMINFO.query('.') FROM @auditParam.nodes('/guiParam/ai') AS P(PARAMINFO)
		-- Loop through param arguments
		OPEN ARGCURSOR
		FETCH NEXT FROM ARGCURSOR INTO @argInfo
		WHILE @@FETCH_STATUS = 0
		BEGIN
			-- Check for param type and audit
			SET @paramType = (SELECT ARGINFO.value('@type[1]', 'int') FROM @argInfo.nodes('/ai') AS ARG(ARGINFO))
IF @paramType = 15
				SET @dataIsEvent = 1
			ELSE
				SET @dataIsEvent = 0
			SET @stringArg = (SELECT ARGINFO.value('@stringArg[1]', 'nvarchar(max)') FROM @argInfo.nodes('/ai') AS ARG(ARGINFO))
			IF @stringArg IS NOT NULL
				BEGIN
				-- INSERT param argument
				EXEC EvGuiAuditSetParamData @opId, @stringArg, @dataIsEvent
				END
			FETCH NEXT FROM ARGCURSOR INTO @argInfo
		END
		CLOSE ARGCURSOR
		DEALLOCATE ARGCURSOR
	END
	-- INSERT audit param
	SET @paramMsgId = (SELECT PARAMINFO.value('@nMessageID[1]', 'int')  FROM @auditParam.nodes('/guiParam') AS P(PARAMINFO))
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
	FETCH NEXT FROM PARAMCURSOR INTO @auditParam
END
CLOSE PARAMCURSOR
DEALLOCATE PARAMCURSOR
GO

IF EXISTS (select * from GxQscripts where name = 'EvGuiAuditGeneric')
	delete from GxQscripts where name = 'EvGuiAuditGeneric'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvGuiAuditGeneric')
	delete from GXDBVersions where aliasname = 'EvGuiAuditGeneric'
GO

insert into GXDBVersions values(2, 'EvGuiAuditGeneric',  '00010001000200020000', 'EvGuiAuditGeneric', '00010001000200020000')
GO

