

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EvGetEventMsgText.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Prakash Varadharajan
--	Date:   01/20/2004
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/EvGetEventMsgText.sp,v $ $Id: EvGetEventMsgText.sp,v 1.7.208.5 2019/06/18 18:31:05 mnatarajan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='EvGetEventMsgText')
BEGIN
	print '>>> Drop Stored Procedure: EvGetEventMsgText <<<'
	drop procedure EvGetEventMsgText
END
IF EXISTS (select * from GxQscripts where name='EvGetEventMsgText')
	delete from GxQscripts where name = 'EvGetEventMsgText'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvGetEventMsgText')
	delete from GXDBVersions where aliasname = 'EvGetEventMsgText'
GO
print '... Creating Procedure: EvGetEventMsgText'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EvGetEventMsgText
  @i_MsgId integer,
  @i_LocaleId integer,
  @i_CCId integer
AS
  DECLARE @r_MsgId integer
  DECLARE @r_MsgTxt nvarchar(4000)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @EventId	integer
	SET NOCOUNT ON
	SET @r_MsgId = @i_MsgId
	DECLARE @messageType INT = 0
	SELECT @r_MsgTxt = Message
	FROM EvMsgCache WITH (NOLOCK)
	WHERE EvMsgId = @r_MsgId AND LocaleId = @i_LocaleId
	AND commCellId = @i_CCId
	IF @r_MsgTxt is null
	BEGIN
		SELECT @EventId = MessageId, @messageType = TYPE
		FROM EvMsg
		WHERE id = @r_MsgId AND commCellId = @i_CCId
		-- We dont need to generate cache entries for audit events.
		IF @messageType=2
		BEGIN
			SELECT 0, ''
			RETURN
		END
		SET @r_MsgTxt = DBO.fn_EvFormatEventMsgText( @r_MsgId, @i_LocaleId, @EventId, 1, @i_CCId)
		IF @r_MsgTxt IS NOT null
			INSERT INTO EvMsgCache(EvMsgId, LocaleId, Message,commCellId)
			SELECT  @r_MsgId, @i_LocaleId, @r_MsgTxt, @i_CCId
			 WHERE NOT EXISTS ( SELECT 1
					FROM EvMsgCache WITH (NOLOCK)
					WHERE EvMsgId = @r_MsgId AND LocaleId = @i_LocaleId
					AND commCellId = @i_CCId)
		ELSE
		BEGIN
			SET @r_MsgId = 0
			SET @r_MsgTxt = ''
		END
	END
	SELECT @r_MsgId, @r_MsgTxt
	SET NOCOUNT OFF
GO


IF EXISTS (select * from GxQscripts where name = 'EvGetEventMsgText')
	delete from GxQscripts where name = 'EvGetEventMsgText'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvGetEventMsgText')
	delete from GXDBVersions where aliasname = 'EvGetEventMsgText'
GO

insert into GXDBVersions values(2, 'EvGetEventMsgText',  '00010007020800050000', 'EvGetEventMsgText', '00010007020800050000')
GO

